/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.commonquery.upgrade;

import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.upgrade.DBConnection;
import com.kingdee.eas.base.commonquery.upgrade.IUpgrade;
import com.kingdee.eas.base.commonquery.upgrade.UpgradeConfigInfo;
import com.kingdee.util.db.SQLUtils;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UpgradeSolution {
    private static Map<String, String> queryPanelMap = new HashMap<String, String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String dbType = args[0];
        String host = args[1];
        String port = args[2];
        String dbName = args[3];
        String user = args[4];
        String password = args[5];
        String eas_home = args[6];
        UpgradeSolution.setLogFile(eas_home);
        System.out.println("---host--- = " + host);
        System.out.println("---port--- = " + port);
        System.out.println("---dbName--- = " + dbName);
        System.out.println("---dbType--- = " + dbType);
        System.out.println("---user--- = " + user);
        DBConnection dbconn = new DBConnection(dbType, host, Integer.parseInt(port), dbName, user, password);
        Connection object = dbconn.getConnection();
        if (object instanceof Connection) {
            Connection conn = object;
            try {
                UpgradeConfigInfo config = UpgradeConfigInfo.getInstance();
                Map upgradeMap = config.getUpgradeMap();
                if (upgradeMap == null) {
                    System.out.println("----upgradeMap----- = null");
                    return;
                }
                Collection values = upgradeMap.values();
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    IUpgrade iUpgrade = UpgradeSolution.getIUpgrade((String)iterator.next());
                    String sql = iUpgrade.getQuerySql();
                    ResultSet rs = UpgradeSolution.getQueryPanelRS(conn, sql);
                    UpgradeSolution.setNewQueryPanelColl(rs, iUpgrade);
                }
                UpgradeSolution.updateQueryPanel(conn);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }

    private static void setLogFile(String eas_home) throws Exception {
        FileOutputStream fileOut = new FileOutputStream(eas_home + "/admin/upgradesolution/upgradeSolution.log");
        try {
            System.setErr(new PrintStream(new BufferedOutputStream(fileOut, 128), true));
            System.setOut(new PrintStream(new BufferedOutputStream(fileOut, 128), true));
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static IUpgrade getIUpgrade(String name) {
        if (name == null || "".equals(name)) {
            return null;
        }
        System.out.println("---iupgrade -- = " + name);
        try {
            Object o = Class.forName(name).newInstance();
            if (o instanceof IUpgrade) {
                return (IUpgrade)o;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static ResultSet getQueryPanelRS(Connection conn, String querySql) {
        System.out.println("----sql----= " + querySql);
        ResultSet rs = null;
        try {
            rs = DBUtil.executeSql((Connection)conn, (String)querySql);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void setNewQueryPanelColl(ResultSet rs, IUpgrade iUpgrade) {
        if (rs == null) return;
        if (iUpgrade == null) {
            return;
        }
        int count = 0;
        int successedCount = 0;
        int ignoreCount = 0;
        int failCount = 0;
        try {
            while (rs.next()) {
                ++count;
                String id = rs.getString("FId");
                String customerParams = rs.getString("FCustomerParams");
                String filterUIClassName = rs.getString("FPanelClassName");
                String solutionName = rs.getString("FSolutionName");
                System.out.println("---begin upgrade:id is [" + id + "] solutionName is [" + solutionName + "]---");
                try {
                    CustomerParams oldParams = XMLBean.transStrToCommonCustParams(customerParams);
                    if (!iUpgrade.isNeedConvert(oldParams)) {
                        ++ignoreCount;
                        continue;
                    }
                    CustomerParams newParams = iUpgrade.getNewCustomerParam(filterUIClassName, oldParams);
                    Collection keys = newParams.getKeys();
                    Collection values = newParams.getValues();
                    if (keys.size() > 0) {
                        String newCustomerParams = XMLBean.CreateXMLStrRecursion(keys, values);
                        queryPanelMap.put(id, newCustomerParams);
                    }
                    System.out.println("---upgrade sucessfully:id is [" + id + "] solutionName is [" + solutionName + "]---");
                    ++successedCount;
                }
                catch (Exception e) {
                    System.out.println("---upgrade failed:id is [" + id + "] solutionName [" + solutionName + "]---");
                    e.printStackTrace();
                    ++failCount;
                }
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((ResultSet)rs);
                System.out.println(String.format("totalCount: %d ,sucess: %d,fail: %d ,ignore: %d", count, successedCount, failCount, ignoreCount));
                if (count == successedCount + failCount + ignoreCount) throw throwable;
                System.out.println("**********************************totalCount is wrong******");
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs);
            System.out.println(String.format("totalCount: %d ,sucess: %d,fail: %d ,ignore: %d", count, successedCount, failCount, ignoreCount));
            if (count == successedCount + failCount + ignoreCount) return;
            System.out.println("**********************************totalCount is wrong******");
            return;
        }
        SQLUtils.cleanup((ResultSet)rs);
        System.out.println(String.format("totalCount: %d ,sucess: %d,fail: %d ,ignore: %d", count, successedCount, failCount, ignoreCount));
        if (count == successedCount + failCount + ignoreCount) return;
        System.out.println("**********************************totalCount is wrong******");
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateQueryPanel(Connection conn) {
        if (queryPanelMap == null || queryPanelMap.size() == 0) {
            return;
        }
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("update t_query_queryPanel set FCustomerParams = ? where FId = ?");
            conn.setAutoCommit(false);
            Set<String> idSet = queryPanelMap.keySet();
            for (String id : idSet) {
                ps.setString(1, queryPanelMap.get(id));
                ps.setString(2, id);
                ps.addBatch();
            }
            ps.executeBatch();
            System.out.println("---------update customerParams success-----");
            conn.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        finally {
            try {
                conn.setAutoCommit(true);
                SQLUtils.cleanup((Statement)ps);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

