/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.eas.base.job.app.AbstractAdjustJobDataFacadeControllerBean;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class AdjustJobDataFacadeControllerBean
extends AbstractAdjustJobDataFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.job.app.AdjustJobDataFacadeControllerBean");
    private int defaultCount = 100;
    private int defaultDay = 30;
    private int minDay = 1;

    @Override
    protected void _adjustJobInstData(Context ctx, int day) throws BOSException {
        logger.debug((Object)"AdjustJobDataFacadeControllerBean._adjustJobInstData() start!");
        if (day < this.minDay) {
            day = this.defaultDay;
        }
        this.innerAdjustJobData(ctx, day, this.defaultCount);
        logger.debug((Object)"AdjustJobDataFacadeControllerBean._adjustJobInstData() end!");
    }

    private void innerAdjustJobData(Context ctx, int day, int batchCount) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("AdjustJobDataFacadeControllerBean.innerAdjustJobData(");
        buffer.append(day);
        buffer.append(",");
        buffer.append(batchCount);
        buffer.append(")!");
        String msg = buffer.toString();
        logger.info((Object)msg);
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            List<String> jobInstIdSet = this.getJobInstIdSet(cn, batchCount, day);
            while (jobInstIdSet != null && jobInstIdSet.size() > 0) {
                this.transferJobDataBatch(cn, jobInstIdSet);
                jobInstIdSet = this.getJobInstIdSet(cn, batchCount, day);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQLException", (Throwable)e);
        }
        finally {
            try {
                cn.close();
            }
            catch (SQLException e) {
                throw new BOSException("SQLException", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getJobInstIdSet(Connection cn, int batchCount, int day) throws SQLException {
        ArrayList<String> arrayList;
        if (cn == null) {
            throw new IllegalArgumentException();
        }
        String sql = "";
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT");
        buffer.append(" TOP " + batchCount);
        buffer.append(" FJOBINSTID");
        buffer.append(" FROM T_JOB_INST");
        buffer.append(" WHERE");
        buffer.append(" (");
        buffer.append("     (FSTATE = 'Complete')");
        buffer.append(" OR (FSTATE = 'Failed')");
        buffer.append(" OR (FSTATE = 'Missed')");
        buffer.append(" OR (FSTATE = 'Aborted')");
        buffer.append(" )");
        buffer.append(" AND (FJOBINSTID NOT IN (SELECT FJOBINSTID FROM T_JOB_INSTHST))");
        if (day > 0) {
            buffer.append(" AND (DATEDIFF(Day,FCREATEDTIME,GETDATE()) >= ?)");
        }
        if (!StringUtils.isEmpty((String)Configuration.clusterIsolation())) {
            buffer.append(" AND fcluster = ? ");
        } else {
            buffer.append(" AND fcluster is null ");
        }
        sql = buffer.toString();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = cn.prepareStatement(sql);
            if (day > 0) {
                ps.setInt(1, day);
            }
            if (!StringUtils.isEmpty((String)Configuration.clusterIsolation())) {
                ps.setString(2, Configuration.clusterIsolation());
            }
            rs = ps.executeQuery();
            ArrayList<String> jobIds = new ArrayList<String>();
            while (rs.next()) {
                String jobInstId = rs.getString("FJOBINSTID");
                if (StringUtils.isEmpty((String)jobInstId)) continue;
                jobIds.add(jobInstId);
            }
            logger.debug((Object)("\"jobIds\" is \"" + jobIds + "\"!"));
            arrayList = jobIds;
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs, (Statement)ps);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferJobDataBatch(Connection cn, List<String> jobInstIdSet) throws SQLException {
        if (jobInstIdSet == null || jobInstIdSet.size() == 0) {
            return;
        }
        PreparedStatement ps = null;
        try {
            int i;
            StringBuffer jobInstBuffer = new StringBuffer();
            for (int i2 = 0; i2 < jobInstIdSet.size(); ++i2) {
                if (i2 == 0) {
                    jobInstBuffer.append("?");
                    continue;
                }
                jobInstBuffer.append(",?");
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("insert into t_job_insthst(fjobinstid, ftitle, fuserid, forgid, fclientip, fcreatedtime, fscheduledtime, fexpiredtime, fstartedtime, fprogress, fpriorstate, fstate, fstatechangedtime,fparameters, fresult, fexception, fjobdefid, finstanceconfig, fisolationboundary, fhashCode,fholderid, fpriorJobId, ffinishtime, fcluster) select fjobinstid, ftitle, fuserid, forgid, fclientip, fcreatedtime,fscheduledtime, fexpiredtime, fstartedtime, fprogress, fpriorstate, fstate, fstatechangedtime,fparameters, fresult, fexception, fjobdefid, finstanceconfig, fisolationboundary, fhashCode,fholderid, fpriorJobId,ffinishtime, fcluster from t_job_inst ");
            buffer.append(" WHERE FJOBINSTID IN (").append(jobInstBuffer).append(")");
            String sql = buffer.toString();
            ps = cn.prepareStatement(sql);
            for (i = 0; i < jobInstIdSet.size(); ++i) {
                ps.setString(i + 1, jobInstIdSet.get(i));
            }
            ps.execute();
            buffer = new StringBuffer();
            buffer.append("DELETE T_JOB_INST");
            buffer.append(" WHERE FJOBINSTID IN (").append(jobInstBuffer).append(")");
            sql = buffer.toString();
            ps = cn.prepareStatement(sql);
            for (i = 0; i < jobInstIdSet.size(); ++i) {
                ps.setString(i + 1, jobInstIdSet.get(i));
            }
            ps.execute();
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(ps);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)ps);
    }
}

