/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.job.util;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.facade.FacadeInfo;
import com.kingdee.bos.metadata.function.FunctionObjectCollection;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.metadata.view.BriefViewTreeNode;
import com.kingdee.bos.metadata.view.BusinessObjectBriefView;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.workflow.define.ProcessType;
import com.kingdee.eas.base.job.ProcessDefCollection;
import com.kingdee.eas.base.job.ProcessDefInfo;
import com.kingdee.eas.base.job.util.EntityObject;
import com.kingdee.eas.base.job.util.FacadeMethodObject;
import com.kingdee.eas.base.job.util.FunctionObject;
import com.kingdee.eas.base.job.util.FunctionOperateObject;
import com.kingdee.eas.base.job.util.JobProcessUtil;
import com.kingdee.eas.base.job.util.JobUtils;
import com.kingdee.eas.base.job.util.PackageObject;
import com.kingdee.eas.base.job.util.ProcessDefObject;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.util.client.EASResource;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BusinessTreeUtil {
    public static final int PROCESS = 0;
    public static final int FUNCTION = 1;
    public static final int ENTITY = 2;
    public static final int FUNCTIONANDFACADE = 3;
    static final Collator collator = Collator.getInstance(Locale.CHINA);
    private int type;
    private ProcessDefCollection innerProcessDefCollection;
    private FunctionObjectCollection innerFunctionObjectCollection = null;
    private EntityObjectCollection innerEntityObjectCollection = null;
    private DefaultKingdeeTreeNode rootNode = null;
    private DefaultKingdeeTreeNode clientRootNode = null;
    private List packageList = new ArrayList();

    public BusinessTreeUtil(int destType) {
        this.type = destType;
    }

    private void addFunctionOrJobProcessChildNode(DefaultKingdeeTreeNode parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException();
        }
        if (0 == this.type) {
            if (this.innerProcessDefCollection == null) {
                this.innerProcessDefCollection = JobProcessUtil.getPDEFC(ProcessType.BACKGROUNDJOB.getName());
            }
            this.addJobProcessChildNode(parentNode, this.innerProcessDefCollection);
        } else if (1 == this.type) {
            if (this.innerFunctionObjectCollection == null) {
                this.innerFunctionObjectCollection = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunctions();
            }
            this.addFunctionChildNode(parentNode, this.innerFunctionObjectCollection);
        } else if (2 == this.type) {
            if (this.innerEntityObjectCollection == null) {
                this.innerEntityObjectCollection = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntityCollection();
            }
            this.addEntityChildNode(parentNode, this.innerEntityObjectCollection);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void addJobProcessChildNode(DefaultKingdeeTreeNode parentNode, ProcessDefCollection dstProcessDefCollection) {
        if (parentNode == null) {
            throw new IllegalArgumentException();
        }
        if (dstProcessDefCollection == null) {
            return;
        }
        Object userObject = parentNode.getUserObject();
        if (userObject instanceof PackageObject) {
            int childCount = parentNode.getChildCount();
            if (childCount > 0) {
                for (int i = 0; i <= childCount - 1; ++i) {
                    DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
                    this.addJobProcessChildNode(childNode, dstProcessDefCollection);
                }
            }
            PackageObject packageObject = (PackageObject)userObject;
            for (int i = 0; i <= dstProcessDefCollection.size() - 1; ++i) {
                ProcessDefInfo processDefInfo = dstProcessDefCollection.get(i);
                String packageName = this.matchPackage(processDefInfo.getPackageName());
                if (!packageName.equalsIgnoreCase(packageObject.getAbsoluteName())) continue;
                DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)new ProcessDefObject(processDefInfo));
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_bgaffairdefine"));
                node.setAllowsChildren(false);
                parentNode.add((MutableTreeNode)node);
            }
        }
    }

    private String matchPackage(String name) {
        if (this.packageList.size() <= 0) {
            if (0 == this.type) {
                this.initPackageList(this.clientRootNode);
            } else if (1 == this.type) {
                this.initPackageList(this.rootNode);
            } else if (2 == this.type) {
                this.initPackageList(this.rootNode);
            }
        }
        if (this.packageList.contains(name)) {
            return (String)this.packageList.get(this.packageList.indexOf(name));
        }
        if (name.indexOf(46) > 0) {
            name = name.substring(0, name.lastIndexOf(46));
            return this.matchPackage(name);
        }
        return "";
    }

    private void initPackageList(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof PackageObject) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
                this.initPackageList(childNode);
            }
            PackageObject packageObject = (PackageObject)userObject;
            this.packageList.add(packageObject.getAbsoluteName());
        }
    }

    private void addFunctionChildNode(DefaultKingdeeTreeNode parentNode, FunctionObjectCollection dstFunctionObjectCollection) {
        if (parentNode == null) {
            throw new IllegalArgumentException();
        }
        Object tempObject = parentNode.getUserObject();
        if (tempObject instanceof PackageObject) {
            int childCount = parentNode.getChildCount();
            if (childCount > 0) {
                for (int i = 0; i <= childCount - 1; ++i) {
                    DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
                    this.addFunctionChildNode(childNode, dstFunctionObjectCollection);
                }
            }
            if (dstFunctionObjectCollection != null && dstFunctionObjectCollection.size() > 0) {
                PackageObject packageObject = (PackageObject)tempObject;
                for (int i = 0; i <= dstFunctionObjectCollection.size() - 1; ++i) {
                    FunctionObjectInfo tempFOI = dstFunctionObjectCollection.get(i);
                    if ("com.kingdee.eas.base.multiapprove.client.ManualDecisionUIFunction".equals(tempFOI.getFullName()) || "com.kingdee.eas.base.multiapprove.client.MultiApproveUIFunction".equals(tempFOI.getFullName())) continue;
                    String packageName = this.matchPackage(tempFOI.getPackage());
                    if (!packageObject.getAbsoluteName().equalsIgnoreCase(packageName)) continue;
                    DefaultKingdeeTreeNode no = new DefaultKingdeeTreeNode((Object)new FunctionObject(tempFOI));
                    no.setCustomIcon(EASResource.getIcon((String)"imgTree_operationfunction"));
                    parentNode.add((MutableTreeNode)no);
                    this.addOperationNode(tempFOI, no);
                }
            }
        }
    }

    private void addEntityChildNode(DefaultKingdeeTreeNode parentNode, EntityObjectCollection dstEntityObjectCollection) {
        if (parentNode == null) {
            throw new IllegalArgumentException();
        }
        Object tempObject = parentNode.getUserObject();
        if (tempObject instanceof PackageObject) {
            int childCount = parentNode.getChildCount();
            if (childCount > 0) {
                for (int i = 0; i <= childCount - 1; ++i) {
                    DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)parentNode.getChildAt(i);
                    this.addEntityChildNode(childNode, dstEntityObjectCollection);
                }
            }
            if (dstEntityObjectCollection != null && dstEntityObjectCollection.size() > 0) {
                PackageObject packageObject = (PackageObject)tempObject;
                for (int i = 0; i <= dstEntityObjectCollection.size() - 1; ++i) {
                    EntityObjectInfo tempFOI = dstEntityObjectCollection.get(i);
                    String packageName = this.matchPackage(tempFOI.getPackage());
                    if (!packageObject.getAbsoluteName().equalsIgnoreCase(packageName)) continue;
                    DefaultKingdeeTreeNode no = new DefaultKingdeeTreeNode((Object)new EntityObject(tempFOI));
                    no.setAllowsChildren(false);
                    no.setCustomIcon(EASResource.getIcon((String)"imgTree_entity"));
                    parentNode.add((MutableTreeNode)no);
                }
            }
        }
    }

    public void addOperationNode(FunctionObjectInfo foi, DefaultKingdeeTreeNode parentNode) {
        OperationCollection oc = foi.getOperation();
        if (oc != null && oc.size() > 0) {
            for (int i = 0; i <= oc.size() - 1; ++i) {
                OperationInfo oi = oc.get(i);
                DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)new FunctionOperateObject(foi, oi));
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_operationhandle"));
                node.setAllowsChildren(false);
                parentNode.add((MutableTreeNode)node);
            }
        } else {
            parentNode.setAllowsChildren(false);
        }
    }

    private IBriefViewTreeNode getBusinessTreeView(boolean isResetBySelf) {
        IBriefViewTreeNode root = null;
        BOSObjectType[] type = new BOSObjectType[]{MetaDataTypeList.PACKAGE};
        if (isResetBySelf) {
            root = SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_packages", (BOSObjectType[])type);
        } else {
            IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            BusinessObjectBriefView businessObjectBriefView = metaDataLoader.getBusinessObjectBriefView((IMetaDataPK)new MetaDataPK("com_kingdee_eas_packages"));
            root = businessObjectBriefView.getViewRootByType(type);
        }
        return root;
    }

    private void addBusinessChildNode(DefaultKingdeeTreeNode dstParentPackageNode, TreeNode dstParentBusinessNode) {
        if (dstParentPackageNode == null || dstParentBusinessNode == null || !(dstParentBusinessNode instanceof BriefViewTreeNode)) {
            throw new IllegalArgumentException();
        }
        BriefViewTreeNode parentBusinessNode = (BriefViewTreeNode)dstParentBusinessNode;
        int childCount = parentBusinessNode.getChildCount();
        if (childCount > 0) {
            for (int i = 0; i <= childCount - 1; ++i) {
                BriefViewTreeNode businessChildNode = (BriefViewTreeNode)parentBusinessNode.getChildAt(i);
                DefaultKingdeeTreeNode packageChildNode = new DefaultKingdeeTreeNode((Object)new PackageObject((TreeNode)businessChildNode));
                dstParentPackageNode.add((MutableTreeNode)packageChildNode);
                this.addBusinessChildNode(packageChildNode, (TreeNode)businessChildNode);
            }
        }
    }

    private void initialPackageTree(KDTree destKDTree, boolean isResetBySelf) {
        if (destKDTree == null) {
            throw new IllegalArgumentException();
        }
        IBriefViewTreeNode businessTreeViewRoot = this.getBusinessTreeView(isResetBySelf);
        if (businessTreeViewRoot == null) {
            throw new UnsupportedOperationException();
        }
        TreeNode rootTreeNode = businessTreeViewRoot.getRoot();
        DefaultKingdeeTreeNode rootPackageNode = new DefaultKingdeeTreeNode((Object)new PackageObject(rootTreeNode));
        rootPackageNode.setAllowsChildren(true);
        this.addBusinessChildNode(rootPackageNode, rootTreeNode);
        KingdeeTreeModel kingdeeTreeModel = (KingdeeTreeModel)destKDTree.getModel();
        kingdeeTreeModel.setRoot((TreeNode)rootPackageNode);
        kingdeeTreeModel.setAsksAllowsChildren(true);
        destKDTree.setSelectionPath(new TreePath(rootPackageNode));
    }

    private void initialFunctionOrJobProcessTree(KDTree destKDTree, boolean isResetBySelf) {
        if (destKDTree == null) {
            throw new IllegalArgumentException();
        }
        KingdeeTreeModel kingdeeTreeModel = (KingdeeTreeModel)destKDTree.getModel();
        if (isResetBySelf) {
            this.clientRootNode = (DefaultKingdeeTreeNode)kingdeeTreeModel.getRoot();
        } else {
            this.rootNode = (DefaultKingdeeTreeNode)kingdeeTreeModel.getRoot();
        }
        if (kingdeeTreeModel.getRoot() == null) {
            throw new IllegalArgumentException();
        }
        this.addFunctionOrJobProcessChildNode((DefaultKingdeeTreeNode)kingdeeTreeModel.getRoot());
    }

    public void initialBusinessTreeView(KDTree destKDTree, boolean isResetBySelf) {
        if (destKDTree == null) {
            throw new IllegalArgumentException();
        }
        JobUtils.printTimeMillis("Begin initialPackageTree");
        this.initialPackageTree(destKDTree, isResetBySelf);
        JobUtils.printTimeMillis("initialPackageTree");
        this.initialFunctionOrJobProcessTree(destKDTree, isResetBySelf);
        JobUtils.printTimeMillis("initialFunctionOrJobProcessTree");
    }

    public void initialJobTaskTreeView(KDTree destKDTree, boolean isResetBySelf) {
        if (destKDTree == null) {
            throw new IllegalArgumentException();
        }
        this.initialJobTaskTree(destKDTree, isResetBySelf);
    }

    private void initialJobTaskTree(KDTree destKDTree, boolean isResetBySelf) {
        if (destKDTree == null) {
            throw new IllegalArgumentException();
        }
        IBriefViewTreeNode businessTreeViewRoot = this.getJobTaskTreeView(isResetBySelf);
        if (businessTreeViewRoot == null) {
            throw new UnsupportedOperationException();
        }
        TreeNode rootTreeNode = businessTreeViewRoot.getRoot();
        DefaultKingdeeTreeNode rootNode = new DefaultKingdeeTreeNode((Object)rootTreeNode);
        rootNode.setAllowsChildren(true);
        rootNode.setText(businessTreeViewRoot.getAlias());
        this.addJobTaskChildNode(rootNode, rootTreeNode);
        KingdeeTreeModel kingdeeTreeModel = (KingdeeTreeModel)destKDTree.getModel();
        kingdeeTreeModel.setRoot((TreeNode)rootNode);
        kingdeeTreeModel.setAsksAllowsChildren(true);
        destKDTree.setSelectionPath(new TreePath(rootNode));
    }

    private IBriefViewTreeNode getJobTaskTreeView(boolean isResetBySelf) {
        IBriefViewTreeNode root = null;
        BOSObjectType[] type = new BOSObjectType[]{MetaDataTypeList.FUNCTION, MetaDataTypeList.FACADE};
        if (isResetBySelf) {
            try {
                root = SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_function_facade", (BOSObjectType[])type);
            }
            catch (Exception e) {
                root = SubSystemUtils.getSubSystemByName((String)"com_kingdee_eas_base_function", (BOSObjectType[])type);
            }
        } else {
            BusinessObjectBriefView businessObjectBriefView;
            IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            try {
                businessObjectBriefView = metaDataLoader.getBusinessObjectBriefView((IMetaDataPK)new MetaDataPK("com_kingdee_eas_base_function_facade"));
            }
            catch (Exception e) {
                businessObjectBriefView = metaDataLoader.getBusinessObjectBriefView((IMetaDataPK)new MetaDataPK("com_kingdee_eas_base_function"));
            }
            root = businessObjectBriefView.getViewRootByType(type);
        }
        return root;
    }

    private void addJobTaskChildNode(DefaultKingdeeTreeNode rootNode, TreeNode dstParentBusinessNode) {
        if (rootNode == null || dstParentBusinessNode == null || !(dstParentBusinessNode instanceof BriefViewTreeNode)) {
            throw new IllegalArgumentException();
        }
        BriefViewTreeNode parentBusinessNode = (BriefViewTreeNode)dstParentBusinessNode;
        int childCount = parentBusinessNode.getChildCount();
        ArrayList<BriefViewTreeNode> packageList = new ArrayList<BriefViewTreeNode>();
        ArrayList otherList = new ArrayList();
        for (int i = 0; i < childCount; ++i) {
            BriefViewTreeNode businessChildNode = (BriefViewTreeNode)parentBusinessNode.getChildAt(i);
            String[] nodeInfo = null;
            if (businessChildNode.getMetaDataType().equals((Object)BOSObjectType.create((String)"pack"))) {
                packageList.add(businessChildNode);
                continue;
            }
            if (!businessChildNode.getMetaDataType().equals((Object)BOSObjectType.create((String)"func")) && !businessChildNode.getMetaDataType().equals((Object)BOSObjectType.create((String)"fade"))) continue;
            String alias = businessChildNode.getAlias();
            String fullName = businessChildNode.getFullName();
            if (alias == null) {
                alias = fullName.substring(fullName.lastIndexOf(".") + 1);
            }
            nodeInfo = new String[]{alias, businessChildNode.getMetaDataType().toString(), fullName};
            otherList.add(nodeInfo);
        }
        otherList = this.sortNodeInfoList(otherList);
        ArrayList<BriefViewTreeNode> childNodeList = new ArrayList<BriefViewTreeNode>();
        childNodeList.addAll(packageList);
        childNodeList.addAll(otherList);
        if (childNodeList.size() > 0) {
            for (int i = 0; i < childNodeList.size(); ++i) {
                DefaultKingdeeTreeNode ChildNode = null;
                Object nodeObject = childNodeList.get(i);
                if (nodeObject instanceof BriefViewTreeNode) {
                    BriefViewTreeNode businessChildNode = (BriefViewTreeNode)nodeObject;
                    ChildNode = new DefaultKingdeeTreeNode((Object)businessChildNode);
                    ChildNode.setText(businessChildNode.getAlias());
                    this.addJobTaskChildNode(ChildNode, (TreeNode)businessChildNode);
                } else if (nodeObject instanceof String[]) {
                    String[] nodeInfo = (String[])nodeObject;
                    String type = nodeInfo[1];
                    ChildNode = new DefaultKingdeeTreeNode((Object)nodeInfo);
                    ChildNode.setText(nodeInfo[0]);
                    if (type.equals("func")) {
                        ChildNode.setCustomIcon(EASResource.getIcon((String)"imgTree_operationfunction"));
                    } else if (type.equals("fade")) {
                        ChildNode.setCustomIcon(EASResource.getIcon((String)"imgTree_attribute"));
                    }
                }
                rootNode.add(ChildNode);
            }
        }
    }

    private ArrayList sortNodeInfoList(ArrayList nodes) {
        int i;
        ArrayList<String[]> list = new ArrayList<String[]>();
        HashMap[] map = new HashMap[nodes.size()];
        for (i = 0; i < nodes.size(); ++i) {
            map[i] = new HashMap();
            map[i].put("alias", ((String[])nodes.get(i))[0]);
            map[i].put("nodeInfo", nodes.get(i));
        }
        Arrays.sort(map, new Comparator(){

            public int compare(Object o1, Object o2) {
                String n1 = (String)((HashMap)o1).get("alias");
                String n2 = (String)((HashMap)o2).get("alias");
                return collator.compare(n1, n2);
            }
        });
        for (i = 0; i < map.length; ++i) {
            list.add(i, (String[])map[i].get("nodeInfo"));
        }
        return list;
    }

    public void addFacadeNode(FacadeInfo foi, DefaultKingdeeTreeNode parentNode) {
        MethodCollection mc = foi.getMethods();
        if (mc != null && mc.size() > 0) {
            for (int i = 0; i <= mc.size() - 1; ++i) {
                MethodInfo oi = mc.get(i);
                DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)new FacadeMethodObject(foi, oi));
                node.setCustomIcon(EASResource.getIcon((String)"imgTree_operationhandle"));
                node.setAllowsChildren(false);
                parentNode.add((MutableTreeNode)node);
            }
        } else {
            parentNode.setAllowsChildren(false);
        }
    }
}

