/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.DecisionItemInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ApproveResultAndDecisionUtils {
    public static final String PASS = ApproveResult.PASS.getAlias(new Locale("l2"));
    public static final String NOT_PASS = ApproveResult.NOT_PASS.getAlias(new Locale("l2"));
    public static final String ALL = "\u5168\u90e8";
    private static ArrayList approveResultList = null;

    public static List getDecisionItemList(String decisionItemsString) {
        ArrayList<DecisionItemInfo> decisionItems = new ArrayList<DecisionItemInfo>();
        if (decisionItemsString != null && decisionItemsString.trim().length() > 0) {
            String[] items = StringUtils.split((String)decisionItemsString, (String)":");
            String[] itemRows = new String[3];
            for (int i = 0; i < items.length; ++i) {
                itemRows = StringUtils.split((String)items[i], (String)";");
                DecisionItemInfo info = new DecisionItemInfo();
                int key = Integer.parseInt(itemRows[0]);
                String value = itemRows[1];
                info.setKey(key);
                info.setValue(value);
                if (itemRows.length == 2) {
                    ApproveResultAndDecisionUtils.addDecisionItemForALL(decisionItems, key, value, "");
                    continue;
                }
                if (itemRows.length == 3) {
                    if (ALL.equals(itemRows[2])) {
                        ApproveResultAndDecisionUtils.addDecisionItemForALL(decisionItems, key, value, "");
                        continue;
                    }
                    info.setType(itemRows[2]);
                    info.setAssocicateLine("");
                    decisionItems.add(info);
                    continue;
                }
                String assoLine = itemRows[3].trim();
                if (ALL.equals(itemRows[2])) {
                    ApproveResultAndDecisionUtils.addDecisionItemForALL(decisionItems, key, value, assoLine);
                    continue;
                }
                info.setType(itemRows[2]);
                info.setAssocicateLine(itemRows[3].trim());
                decisionItems.add(info);
            }
        }
        return decisionItems;
    }

    private static void addDecisionItemForALL(List list, int key, String value, String assoLine) {
        DecisionItemInfo info = new DecisionItemInfo();
        info.setKey(key);
        info.setValue(value);
        info.setType(PASS);
        info.setAssocicateLine(assoLine);
        list.add(info);
        info = new DecisionItemInfo();
        info.setKey(key);
        info.setValue(value);
        info.setType(NOT_PASS);
        info.setAssocicateLine(assoLine);
        list.add(info);
    }

    public static ArrayList getApproveResultList(String decisionItemsString) {
        List decisionItemlist = ApproveResultAndDecisionUtils.getDecisionItemList(decisionItemsString);
        ArrayList<String> approveResultList = new ArrayList<String>();
        if (decisionItemlist == null || decisionItemlist.size() <= 0) {
            approveResultList.add(PASS);
            approveResultList.add(NOT_PASS);
        } else {
            DecisionItemInfo info = null;
            for (int i = 0; i < decisionItemlist.size(); ++i) {
                info = (DecisionItemInfo)decisionItemlist.get(i);
                if (approveResultList.contains(info.getType())) continue;
                approveResultList.add(info.getType());
            }
            if (!ApproveResultAndDecisionUtils.checkHasExtendedApproveResult(approveResultList)) {
                approveResultList.clear();
                approveResultList.add(PASS);
                approveResultList.add(NOT_PASS);
            }
        }
        return approveResultList;
    }

    private static boolean checkHasExtendedApproveResult(ArrayList list) {
        boolean flag = false;
        for (int i = 0; i < list.size(); ++i) {
            String approveResultStr = (String)list.get(i);
            if (PASS.equals(approveResultStr) || NOT_PASS.equals(approveResultStr) || ALL.equals(approveResultStr)) continue;
            return true;
        }
        return flag;
    }

    public static String getApproveResultValue(Context ctx, String approveResult) {
        if (StringUtils.isEmpty((String)approveResult)) {
            return null;
        }
        String resultValue = "";
        if (approveResultList == null) {
            IEnactmentService service = null;
            try {
                service = ctx == null ? EnactmentServiceFactory.createRemoteEnactService() : EnactmentServiceFactory.createEnactService((Context)ctx);
            }
            catch (BOSException e) {
                return null;
            }
            approveResultList = service.getApproveResult();
        }
        for (int i = 0; i < approveResultList.size(); ++i) {
            Map map = (Map)approveResultList.get(i);
            if (!approveResult.equals(map.get("alias"))) continue;
            resultValue = (String)map.get("value");
            break;
        }
        return resultValue;
    }

    public static String getApproveAliasbyValue(String value) {
        String alias = ApproveResult.getEnum(value).getAlias();
        return alias;
    }

    public static List getFilerDecisionItemListByApproveResult(String decisionItemsString, String approveResult) {
        List decisionItems = ApproveResultAndDecisionUtils.getDecisionItemList(decisionItemsString);
        ArrayList<DecisionItemInfo> filteList = new ArrayList<DecisionItemInfo>();
        if (StringUtils.isEmpty((String)approveResult)) {
            return filteList;
        }
        for (int i = 0; i < decisionItems.size(); ++i) {
            DecisionItemInfo item = (DecisionItemInfo)decisionItems.get(i);
            if (!approveResult.equalsIgnoreCase(item.getType().trim())) continue;
            filteList.add(item);
        }
        return filteList;
    }
}

