/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import org.apache.log4j.Logger;

public class SignatureUtils {
    private static Logger logger = Logger.getLogger(SignatureUtils.class);
    public static String PROPERTY_NAME = "ca_CheckAndSignWhenApprove";
    public static String NONE = "CA_NONE";
    public static String SIGN_ONLY = "CA_SIGN_ONLY";
    public static String CHECK_ONLY = "CA_CHECK_ONLY";
    public static String BOTH = "CA_BOTH";
    private static Integer NONE_VALUE = new Integer(5);
    private static Integer SIGN_ONLY_VALUE = new Integer(1);
    private static Integer CHECK_ONLY_VALUE = new Integer(2);
    private static Integer BOTH_VALUE = new Integer(0);

    public static String getCATypeByProcInst(Context ctx, String procInstId) {
        String revalue = BOTH;
        try {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
            Object value = svc.getProcessContext(procInstId, PROPERTY_NAME);
            if (SIGN_ONLY_VALUE.equals(value)) {
                return SIGN_ONLY;
            }
            if (CHECK_ONLY_VALUE.equals(value)) {
                return CHECK_ONLY;
            }
            if (BOTH_VALUE.equals(value)) {
                return BOTH;
            }
            if (NONE_VALUE.equals(value)) {
                return NONE;
            }
        }
        catch (Exception e) {
            logger.error((Object)("can not load workflow Property:" + PROPERTY_NAME), (Throwable)e);
        }
        return revalue;
    }

    public static String getCATypeByAssign(Context ctx, String assignId) {
        String revalue = BOTH;
        try {
            IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
            String procInstId = svc.getAssignmentById(assignId).getProcInstId();
            return SignatureUtils.getCATypeByProcInst(ctx, procInstId);
        }
        catch (BOSException e) {
            logger.error((Object)("can not load workflow Property:" + PROPERTY_NAME));
            return revalue;
        }
    }
}

