/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.ext.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.AcceptOption;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityEvent;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.TransitionCollection;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.IWfActivity;
import com.kingdee.bos.workflow.enactment.IWfAssignment;
import com.kingdee.bos.workflow.enactment.ProcessContext;
import com.kingdee.bos.workflow.enactment.WfActivity;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.enactment.handler.AbstractActivityEventHandler;
import com.kingdee.bos.workflow.ext.ConfigLoader;
import com.kingdee.bos.workflow.metas.ApproveRuleAction;
import com.kingdee.bos.workflow.metas.ApproveRuleFactory;
import com.kingdee.bos.workflow.metas.ApproveRuleInfo;
import com.kingdee.bos.workflow.metas.IApproveRule;
import com.kingdee.bos.workflow.metas.IInvokeMethodDelegate;
import com.kingdee.bos.workflow.metas.IOption;
import com.kingdee.bos.workflow.metas.InvokeMethodDelegateFactory;
import com.kingdee.bos.workflow.metas.OptionFactory;
import com.kingdee.bos.workflow.metas.OptionInfo;
import com.kingdee.bos.workflow.metas.OptionType;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.bos.workflow.participant.IParticipantProvider;
import com.kingdee.bos.workflow.participant.Person;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.bos.workflow.store.util.ApproveRuleUtils;
import com.kingdee.bos.workflow.util.ProcessParamUtils;
import com.kingdee.bos.workflow.util.ScriptUtil;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.InputType;
import com.kingdee.eas.base.multiapprove.MultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.multiapprove.ShareTaskWebServiceConfig;
import com.kingdee.eas.base.multiapprove.ext.app.AutoAssignmentExecutor;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AutoApproveForExecutor
extends AbstractActivityEventHandler {
    private static final long serialVersionUID = -6950957563327584805L;
    private static Logger logger = Logger.getLogger(AutoApproveForExecutor.class);

    public void execute(ActivityEvent event, IWfActivity activity) throws Exception {
        this.execute(event, activity, false);
    }

    public void execute(ActivityEvent event, IWfActivity activity, boolean asyn) throws Exception {
        String priorUserId;
        String[] preActInstList;
        boolean isNode;
        if (!event.equals((Object)ActivityEvent.OnActivitiyInit)) {
            return;
        }
        if (!(activity.getDefinition() instanceof ApproveActivityDef)) {
            return;
        }
        if (activity.getInstanceInfo().getParentActInstId() != null) {
            return;
        }
        ApproveActivityDef approveActivity = (ApproveActivityDef)activity.getDefinition();
        String manualDescItems = approveActivity.getManualDecisionItems();
        String[] manualDescItemsArray = manualDescItems.split(":");
        String handlerContent = "";
        int handlerOpinion = 0;
        for (String manualDescItem : manualDescItemsArray) {
            String[] manualDesc = manualDescItem.split(";");
            if (manualDesc.length <= 2 || !"\u540c\u610f".equals(manualDesc[2])) continue;
            handlerOpinion = Integer.valueOf(manualDesc[0]);
            handlerContent = manualDesc[1];
            break;
        }
        IEnactmentService svc = EnactmentServiceProxy.getEnacementService((Context)activity.getContext());
        WfActivity act = (WfActivity)activity;
        Context ctx = act.getContext();
        WfProcess process = (WfProcess)act.getProcess();
        if (this.transBackOrKickBack(activity.getContext(), act, process)) {
            return;
        }
        List list = activity.getAssignments();
        if (list.size() == 0) {
            return;
        }
        IParticipantProvider provider = WfEngine.getEngine((Context)act.getContext()).getPariticipantProvider();
        ArrayList<Person> persons = new ArrayList<Person>();
        HashMap<Person, AssignmentInfo> personAssignMap = new HashMap<Person, AssignmentInfo>();
        String shareCenterParamMapVarableName = ShareTaskWebServiceConfig.getPropertiesValue("sharetask_webservice.properties", "createTaskProcessVarableName");
        Object obj = svc.getProcessContext(act.getProcInstId(), shareCenterParamMapVarableName);
        HashMap map = null;
        map = obj != null && obj instanceof HashMap ? (HashMap)obj : new HashMap();
        boolean isTaskCenter = map.get("isTaskCenter") != null ? (Boolean)map.get("isTaskCenter") : false;
        boolean bl = isNode = map.get("isNode") != null ? (Boolean)map.get("isNode") : false;
        if (isTaskCenter && isNode) {
            return;
        }
        if (this.approveRuleResult(svc, act)) {
            return;
        }
        if (!act.isCustomUIView() && !this.getEditState(ctx)) {
            return;
        }
        if (!this.getEditState(ctx) && !act.isCustomUIView()) {
            return;
        }
        String bizObjId = ((IWfAssignment)list.get(0)).getAssignmentInfo().getBizObjectIds();
        if (!this.lastAprroveResult(activity.getContext(), bizObjId, act)) {
            return;
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            AssignmentInfo assign = ((IWfAssignment)iter.next()).getAssignmentInfo();
            String userId = assign.getUserId();
            Person person = provider.getPersonByUserId(ctx, userId);
            persons.add(person);
            personAssignMap.put(person, assign);
        }
        ActivityDef activityDef = act.getDefinition();
        if (activityDef instanceof ApproveActivityDef && (preActInstList = act.getMeta().getPreActInstList()) != null) {
            WfEngine engine = act.getWfEngine();
            boolean allow = false;
            for (int i = 0; i < preActInstList.length; ++i) {
                ActivityDef actFrom = engine.getActivityInst(preActInstList[i]).getDefinition();
                TransitionCollection tc = actFrom.getOutgoingTransitions();
                for (int j = 0; j < tc.size(); ++j) {
                    if (!tc.get(j).getTo().getID().equals(activityDef.getID())) continue;
                    allow = true;
                    break;
                }
                if (allow) break;
            }
            if (!allow) {
                return;
            }
        }
        String language = ctx.getLocale().getLanguage();
        String agreeAuto = "";
        agreeAuto = language.equals(LocaleUtils.locale_L2.toString()) || language.equals(LocaleUtils.locale_l2.toString()) || language.equals("zh_CN".toString()) ? "\u540c\u610f\uff08\u81ea\u52a8\u5ba1\u6279\uff09" : (language.equals(LocaleUtils.locale_L3.toString()) || language.equals(LocaleUtils.locale_l3.toString()) || language.equals("zh_TW".toString()) ? "\u540c\u610f\uff08\u81ea\u52d5\u5be9\u6279\uff09" : "agree(auto approve)");
        String currentEmployeeId = null;
        Person person = act.getAutoApprovalPerson(persons);
        if (person != null) {
            try {
                AssignmentInfo assign = (AssignmentInfo)personAssignMap.get(person);
                currentEmployeeId = assign.getEmployeeId();
                String multiApproveID = act.getMultiApproveID();
                process.getProcessContext().putDataFieldValue("$AutoApproveState" + assign.getAssignmentId(), (Object)"true");
                if (this.isActAutoApprove(act)) {
                    process.getProcessContext().putDataFieldValue("$AutoApproveState" + assign.getActInstId(), (Object)"true");
                }
                multiApproveID = this.addMultiApprove(activity, handlerOpinion, svc, ctx, agreeAuto, handlerContent, assign, multiApproveID);
                if (!asyn) {
                    HashMap<String, String> boMap = new HashMap<String, String>();
                    boMap.put(multiApproveID, multiApproveID);
                    act.getWfEngine().executeAssignment(boMap, assign);
                } else {
                    AutoAssignmentExecutor executor = new AutoAssignmentExecutor(multiApproveID, assign.getAssignmentId());
                    ctx = Ctx.newShadowContext((String)act.getContext().getAIS(), (String)assign.getUserId());
                    Job job = new Job(ctx, "~\u81ea\u52a8\u5ba1\u6279(" + assign.getAssignmentId() + ")", (IJobHandler)executor, null, true, true);
                    job.setScheduledTime((Date)new Timestamp(System.currentTimeMillis() + 5000L));
                    JobServiceFactory.getLocalInstance((Context)act.getContext()).createJobInstance(job);
                }
            }
            catch (Exception e1) {
                throw new WfException((Throwable)e1);
            }
            if (personAssignMap.size() == 1 || this.isActAutoApprove(act)) {
                return;
            }
        }
        boolean autoApprove = false;
        boolean useLastApproveOpinion = false;
        ExtendedAttributeDef ead = activity.getProcess().getDefinition().getExtendedAttributes().get("autoMergeApprove");
        if (ead != null && "true".equals(ead.getValue())) {
            autoApprove = true;
            ead = activity.getProcess().getDefinition().getExtendedAttributes().get("useLastApproveOpinion");
            if (ead != null && "true".equals(ead.getValue())) {
                useLastApproveOpinion = true;
            }
        }
        if (!autoApprove) {
            return;
        }
        HashMap approved = new HashMap();
        Object lastUpdateTime = activity.getProcess().getDataField("$billLastUpdatedTime");
        Object lastUpdateAssign = activity.getProcess().getDataField("$billLastUpdatedAssignId");
        Object lastUpdatePersonId = activity.getProcess().getDataField("$autoapprovepersonid");
        ProcessInstInfo procInstInfo = activity.getProcess().getInstanceInfo();
        String lastUpdateBillParentProcInstId = this.getLastUpdateBillParentProcInstId(ctx, procInstInfo.getProcInstId());
        Object lastUpdateBillParentProcInstIdTime = svc.getProcessContext(lastUpdateBillParentProcInstId, "$billLastUpdatedTime");
        if (lastUpdateBillParentProcInstIdTime != null) {
            if (lastUpdateTime == null || ((Date)lastUpdateTime).before((Date)lastUpdateBillParentProcInstIdTime)) {
                lastUpdateTime = lastUpdateBillParentProcInstIdTime;
                lastUpdateAssign = svc.getProcessContext(lastUpdateBillParentProcInstId, "$billLastUpdatedAssignId");
                lastUpdatePersonId = svc.getProcessContext(lastUpdateBillParentProcInstId, "$autoapprovepersonid");
            } else if (lastUpdateAssign != null) {
                priorUserId = ((IWfAssignment)list.get(0)).getAssignmentInfo().getAssignInfo().getPriorPerformerID();
                approved.put(priorUserId, null);
            }
        } else if (lastUpdateTime == null) {
            ProcessInstInfo lastUpdateBillParentProcInstInfo = svc.getProcessInstInfo(lastUpdateBillParentProcInstId);
            lastUpdateTime = lastUpdateBillParentProcInstInfo.getCreatedTime();
            approved.put(lastUpdateBillParentProcInstInfo.getInitiatorId(), null);
        } else {
            priorUserId = ((IWfAssignment)list.get(0)).getAssignmentInfo().getAssignInfo().getPriorPerformerID();
            approved.put(priorUserId, null);
        }
        String billId = ((IWfAssignment)list.get(0)).getAssignmentInfo().getBizObjectIds();
        if (StringUtils.isEmpty((String)billId)) {
            return;
        }
        String[] ids = new WfUtil(activity.getContext()).getApproveAssignIds(billId);
        if (ids != null && ids.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < ids.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("'").append(ids[i]).append("'");
            }
            String sql = "select a.fpersonuserid, b.fid, b.flastupdatetime from t_wfr_assigndetail a inner join t_bas_multiapprove b on a.fassignid=b.fassignmentid where a.fbizfunction='MultiApproveUIFunction' and a.fstate=16 and b.fispass='true' and b.Ftype!=10 and a.fassignid in(" + sb + ")";
            List users = null;
            if (lastUpdateTime instanceof Date) {
                lastUpdateTime = new Timestamp(((Date)lastUpdateTime).getTime());
                if (lastUpdateAssign instanceof String) {
                    sql = sql + " and (b.flastupdatetime>? or a.fassignid=?) order by b.flastupdatetime";
                    users = SQL.executeQuery((Context)activity.getContext(), (String)sql, (int[])new int[]{93, 12}, (Object[])new Object[]{lastUpdateTime, lastUpdateAssign});
                } else {
                    sql = sql + " and b.flastupdatetime>? order by b.flastupdatetime";
                    users = SQL.executeQuery((Context)activity.getContext(), (String)sql, (int[])new int[]{93}, (Object[])new Object[]{lastUpdateTime});
                }
            }
            if (users != null && users.size() > 0) {
                for (int i = 0; i < users.size(); ++i) {
                    approved.put((String)((Map)users.get(i)).get("fpersonuserid"), ((Map)users.get(i)).get("fid"));
                }
            }
        }
        String opinion = ConfigLoader.getConfig4Server().getString("auto.approve.opinion", billId, agreeAuto);
        int delay = ConfigLoader.getConfig4Server().getInt("auto.approve.delay", billId, "3") * 1000;
        int interval = ConfigLoader.getConfig4Server().getInt("auto.approve.interval", billId, "4") * 1000;
        boolean isEnd = false;
        Set approveUserIds = approved.keySet();
        Map extendedAttributeMap = null;
        boolean j = false;
        for (int i = 0; i < list.size(); ++i) {
            WfAssignmentState state;
            AssignmentInfo assign = ((IWfAssignment)list.get(i)).getAssignmentInfo();
            if (i == 0) {
                extendedAttributeMap = svc.getExtendedAttributesFromAssignment(assign.getAssignmentId());
            }
            if (isEnd) {
                return;
            }
            if (assign.getEmployeeId() != null && assign.getEmployeeId().equals(currentEmployeeId) || !WfAssignmentState.ACCEPTED.equals((Object)(state = assign.getState())) && !WfAssignmentState.ASSIGNED.equals((Object)state) || !approveUserIds.contains(assign.getUserId()) && !assign.getUserId().equals(lastUpdatePersonId)) continue;
            String approveId = (String)approved.get(assign.getUserId());
            process.getProcessContext().putDataFieldValue("$AutoApproveState" + assign.getAssignmentId(), (Object)"true");
            if (this.isActAutoApprove(act)) {
                process.getProcessContext().putDataFieldValue("$AutoApproveState" + assign.getActInstId(), (Object)"true");
                isEnd = true;
            }
            if (useLastApproveOpinion && approveId != null) {
                HashMap<String, String> boMap = new HashMap<String, String>();
                boMap.put(approveId, approveId);
                svc.executeAssignment(boMap, assign);
                continue;
            }
            MultiApproveInfo info = this.getMultiInfo(assign, extendedAttributeMap, handlerOpinion, handlerContent, opinion, ctx);
            ctx = Ctx.getContext((String)activity.getContext().getAIS(), (String)assign.getUserId(), null, null);
            ctx.setLocale(new Locale(language));
            new MultiApprove(ctx).submit((CoreBaseInfo)info);
        }
    }

    private boolean approveRuleResult(IEnactmentService svc, WfActivity activity) throws Exception {
        ApproveActivityDef actdef = (ApproveActivityDef)activity.getDefinition();
        String[] approveRuleIds = ApproveRuleUtils.getApproveRule((ApproveActivityDef)actdef);
        if (approveRuleIds.length > 0) {
            Context ctx = activity.getContext();
            IApproveRule iApproveRule = ApproveRuleFactory.getLocalInstance((Context)ctx);
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            WfProcess process = (WfProcess)activity.getProcess();
            String billVariable = this.getBillVarName(ctx, process);
            for (String approveRuleId : approveRuleIds) {
                boolean result;
                if (StringUtils.isEmpty((String)approveRuleId)) continue;
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("opinion");
                selector.add("number");
                selector.add("action");
                selector.add("script");
                selector.add("billBostype");
                ApproveRuleInfo approveRuleInfo = iApproveRule.getApproveRuleInfo((IObjectPK)new ObjectUuidPK(approveRuleId), selector);
                String opinion = approveRuleInfo.getOpinion();
                ApproveRuleAction action = approveRuleInfo.getAction();
                String billBostype = approveRuleInfo.getBillBostype();
                String script = approveRuleInfo.getScript();
                String number = approveRuleInfo.getNumber();
                if (StringUtils.isEmpty((String)script)) {
                    logger.error((Object)("\u5ba1\u6279\u89c4\u5219 [" + approveRuleId + "] \u5bf9\u5e94\u7684\u811a\u672c\u4e0d\u5b58\u5728"));
                    continue;
                }
                if (!StringUtils.isEmpty((String)billVariable)) {
                    EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)billBostype));
                    String entityName = entity.getName();
                    if (!billVariable.equals(entity.getName())) {
                        script = script.replaceAll(entityName, billVariable);
                    }
                }
                if (!(result = ScriptUtil.evalCondition((String)script, (ProcessContext)process.getProcessContext(), (ProcessDef)process.getDefinition()))) continue;
                if (action == ApproveRuleAction.DISAGREE) {
                    this.disagreeForApproveRule(svc, activity, opinion);
                } else {
                    if (action == ApproveRuleAction.SUSPEND) {
                        this.addSuspendOperation(ctx, process.getProcessMeta().getProcInstId());
                        throw new WfException("\u5ba1\u6279\u89c4\u5219\u6302\u8d77\uff0c\u89c4\u5219\u7f16\u7801\u4e3a [" + number + "] ");
                    }
                    if (action == ApproveRuleAction.TERMINATED) {
                        WfUtil wfUtil = new WfUtil(ctx);
                        if (!StringUtils.isEmpty((String)opinion)) {
                            wfUtil.abort(process.getId(), opinion + "\uff08\u5ba1\u6279\u89c4\u5219\uff09");
                        } else {
                            wfUtil.abort(process.getId(), "\u6ee1\u8db3\u5ba1\u6279\u89c4\u5219\u6761\u4ef6\uff0c\u6d41\u7a0b\u7ec8\u6b62");
                        }
                    } else if (action == ApproveRuleAction.NOTAUTOAPPROVE) {
                        // empty if block
                    }
                }
                return true;
            }
        }
        return false;
    }

    private void addSuspendOperation(Context ctx, String procinstId) {
        try {
            IInvokeMethodDelegate delegate = InvokeMethodDelegateFactory.getLocalInstance((Context)ctx);
            delegate.invokeRequiresNew("com.kingdee.eas.base.multiapprove.ext.app.AutoApproveForExecutor", (Object)this, "saveSuspendOperation", new Class[]{Context.class, String.class}, new Object[]{ctx, procinstId});
        }
        catch (Throwable e) {
            logger.error((Object)("addSuspendOperationInNewTransaction catch ex:" + e.getMessage()), e);
        }
    }

    public void saveSuspendOperation(Context ctx, String procinstId) throws BOSException, EASBizException {
        String result = "\u6302\u8d77\u6d41\u7a0b";
        if ("l1".equals(ctx.getLocale().getLanguage())) {
            result = " suspend a process ";
        } else if ("l3".equals(ctx.getLocale().getLanguage())) {
            result = "\u639b\u8d77\u6d41\u7a0b";
        }
        String opinion = "\u6ee1\u8db3\u5ba1\u6279\u89c4\u5219\u6761\u4ef6\uff0c\u6d41\u7a0b\u6302\u8d77";
        IOption Wfoption = OptionFactory.getLocalInstance((Context)ctx);
        OptionInfo opinfo = new OptionInfo();
        opinfo.setOption(opinion);
        opinfo.setType(OptionType.SUSPEND);
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-00000000000013B7DE7F"));
        opinfo.setCreator(userInfo);
        opinfo.setCreateTime(this.getTimeADD());
        opinfo.setResult(result);
        opinfo.setProcinstID(BOSUuid.read((String)procinstId));
        Wfoption.addnew(opinfo);
    }

    private String getBillVarName(Context ctx, WfProcess process) throws WfException {
        ProcessContext processContext = process.getProcessContext();
        BOSObjectType[] bostypes = WfEngine.getEngine((Context)ctx).getCacheManager().getRelatedEntityTypes(process.getProcessMeta().getProcDefId());
        String billVariable = null;
        if (bostypes != null && bostypes.length > 0) {
            String procedefBillBostype = bostypes[0].toString();
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)procedefBillBostype));
            billVariable = entity.getName();
            Map data = processContext.getDataCopy();
            if (!data.containsKey(billVariable)) {
                for (Object key : data.keySet()) {
                    IObjectValue billValue;
                    String bostype;
                    Object value = data.get(key);
                    if (!(value instanceof IObjectValue) || !procedefBillBostype.equals(bostype = (billValue = (IObjectValue)value).getBOSType().toString())) continue;
                    billVariable = key.toString();
                    break;
                }
            }
        }
        return billVariable;
    }

    private void disagreeForApproveRule(IEnactmentService svc, WfActivity activity, String opinion) throws Exception {
        Context ctx = activity.getContext();
        List list = activity.getAssignments();
        int handlerOpinion = 1;
        ApproveActivityDef approveActivity = (ApproveActivityDef)activity.getDefinition();
        String manualDescItems = approveActivity.getManualDecisionItems();
        String[] manualDescItemsArray = manualDescItems.split(":");
        String handlerContent = "";
        for (String manualDescItem : manualDescItemsArray) {
            String[] manualDesc = manualDescItem.split(";");
            if (manualDesc.length <= 2 || !"\u4e0d\u540c\u610f".equals(manualDesc[2])) continue;
            handlerOpinion = Integer.valueOf(manualDesc[0]);
            handlerContent = manualDesc[1];
            break;
        }
        String language = ctx.getLocale().getLanguage();
        String disagreeOpinon = StringUtils.isEmpty((String)opinion) ? ("l2".equals(language) ? "\u4e0d\u540c\u610f\uff08\u5ba1\u6279\u89c4\u5219\uff09" : ("l3".equals(language) ? "\u4e0d\u540c\u610f\uff08\u5be9\u6279\u898f\u5247\uff09" : "disagree(approve rule)")) : ("l2".equals(language) ? opinion + "\uff08\u5ba1\u6279\u89c4\u5219\uff09" : ("l3".equals(language) ? opinion + "\uff08\u5be9\u6279\u898f\u5247\uff09" : opinion + "(approve rule)"));
        Map extendedAttributeMap = null;
        for (int i = 0; i < list.size(); ++i) {
            AssignmentInfo assign = ((IWfAssignment)list.get(i)).getAssignmentInfo();
            if (i == 0) {
                extendedAttributeMap = svc.getExtendedAttributesFromAssignment(assign.getAssignmentId());
            }
            MultiApproveInfo info = this.getMultiInfo(assign, extendedAttributeMap, handlerOpinion, handlerContent, disagreeOpinon, ctx);
            info.setIsPass(ApproveResult.NOT_PASS);
            Context ctx2 = Ctx.getContext((String)ctx.getAIS(), (String)assign.getUserId(), null, null);
            ctx.setLocale(new Locale(language));
            MultiApproveFactory.getLocalInstance(ctx2).submit((CoreBaseInfo)info);
            if (this.isActAutoApprove(activity)) break;
        }
    }

    private MultiApproveInfo getMultiInfo(AssignmentInfo assign, Map extendedAttributeMap, int handlerOpinion, String handlerContent, String opinion, Context ctx) throws WfException {
        boolean IsMailNotifyNext = false;
        boolean IsMobelNotifyNext = false;
        if ("true".equalsIgnoreCase((String)extendedAttributeMap.get("isSendMail"))) {
            IsMailNotifyNext = true;
        }
        if ("true".equalsIgnoreCase((String)extendedAttributeMap.get("isSendSMS"))) {
            IsMobelNotifyNext = true;
        }
        MultiApproveInfo info = new MultiApproveInfo();
        info.setAssignment(assign.getAssignmentId());
        info.setBillId(BOSUuid.read((String)assign.getBizObjectIds()));
        info.setExtendedProperty("businuessObjectId", assign.getBizObjectIds());
        info.setExtendedProperty("assignmentID", assign.getAssignmentId());
        info.setExtendedProperty("isAddNew", "isAddNew");
        info.setIsMailNotifyNext(IsMailNotifyNext);
        info.setIsMobelNotifyNext(IsMobelNotifyNext);
        info.setOpinion(opinion);
        info.setIsPass(ApproveResult.PASS);
        info.setHandlerOpinion(handlerOpinion);
        info.setHandlerContent(handlerContent);
        info.setStatus(MultiApproveStatusEnum.SUBMIT);
        info.setInputType(InputType.AUTO);
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)assign.getUserId()));
        info.setCreator(userInfo);
        info.setLastUpdateUser(userInfo);
        Timestamp createtime = this.getTimeADD();
        info.setCreateTime(createtime);
        String esignature = this.getEsignature(ctx, assign);
        if (!StringUtils.isEmpty((String)esignature)) {
            info.setEsignatureId(esignature);
        }
        return info;
    }

    private String getEsignature(Context ctx, AssignmentInfo assign) {
        boolean isEsignature = ProcessParamUtils.isSatisfyThisParam((Context)ctx, (String)assign.getProcDefId(), (String)"esignature");
        String esignature = null;
        if (isEsignature) {
            String personid = assign.getEmployeeId();
            if (personid == null) {
                personid = assign.getUserId();
            }
            String sql = "select fid from T_WFR_ESIGNATURE where fpersonid = ? and fenable='0' order by ftime desc";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{personid});
                if (rs.next()) {
                    esignature = rs.getString("fid");
                }
            }
            catch (Exception e) {
                logger.error((Object)"\u81ea\u52a8\u5ba1\u6279\u83b7\u53d6\u7535\u5b50\u7b7e\u540d\u62a5\u9519", (Throwable)e);
            }
        }
        return esignature;
    }

    private String addMultiApprove(IWfActivity activity, int handlerOpinion, IEnactmentService svc, Context ctx, String agreeAuto, String handlerContent, AssignmentInfo assign, String multiApproveID) throws WfException, BOSException, EASBizException {
        String opinion = ConfigLoader.getConfig4Server().getString("auto.approve.opinion", assign.getBizObjectIds(), agreeAuto);
        Map extendedAttributeMap = svc.getExtendedAttributesFromAssignment(assign.getAssignmentId());
        MultiApproveInfo info = this.getMultiInfo(assign, extendedAttributeMap, handlerOpinion, handlerContent, opinion, ctx);
        info.setOpinion(opinion + this.handleResponsible(assign, ctx));
        ExtendedAttributeDef ead = activity.getProcess().getDefinition().getExtendedAttributes().get("useLastApproveOpinion");
        if (ead == null || ead != null && "false".equals(ead.getValue())) {
            multiApproveID = new MultiApprove(ctx).addnew((CoreBaseInfo)info).toString();
            this.saveOperation(ctx, info, assign);
        }
        return multiApproveID;
    }

    public void saveOperation(Context ctx, MultiApproveInfo tMultiApproveInfo, AssignmentInfo assign) throws BOSException {
        try {
            IOption Wfoption = OptionFactory.getLocalInstance((Context)ctx);
            OptionInfo opinfo = new OptionInfo();
            opinfo.setOption(tMultiApproveInfo.getOpinion());
            opinfo.setBillID(tMultiApproveInfo.getBillId());
            opinfo.setType(OptionType.MULTIAPPROVE);
            opinfo.setPersonID(BOSUuid.read((String)assign.getUserId()));
            opinfo.setNextHandlerPersonID(null);
            opinfo.setAssignmentID(BOSUuid.read((String)tMultiApproveInfo.getAssignment()));
            opinfo.setNextAssignid(null);
            opinfo.setCurrentAcinstID(BOSUuid.read((String)assign.getActInstId()));
            opinfo.setActinstID(null);
            opinfo.setResult(tMultiApproveInfo.getIsPass().getAlias() + "," + tMultiApproveInfo.getHandlerContent());
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)assign.getUserId()));
            opinfo.setCreator(userInfo);
            opinfo.setCreateTime(this.getTimeADD());
            opinfo.setProcinstID(BOSUuid.read((String)assign.getProcInstId()));
            Wfoption.addnew(opinfo);
        }
        catch (Exception e) {
            throw new BOSException();
        }
    }

    private Timestamp getTimeADD() {
        return new Timestamp(System.currentTimeMillis());
    }

    private boolean getEditState(Context cxt) {
        boolean flagInfo = false;
        String result = "";
        try {
            result = ParamManager.getParamValue((Context)cxt, null, (String)"IgnoreEditState");
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u5f02\u5e38,\u5f02\u5e38\u53c2\u6570key\u4e3a\uff1aIgnoreEditState");
        }
        if (null != result && result.equalsIgnoreCase("true")) {
            flagInfo = true;
        }
        return flagInfo;
    }

    private boolean transBackOrKickBack(Context ctx, WfActivity act, WfProcess process) throws BOSException {
        boolean transBack = process.getProcessContext().getDataFieldValue("$TransBack-" + act.getId()) != null;
        return transBack || this.kickbackFromOthers(ctx, act.getId());
    }

    private boolean kickbackFromOthers(Context ctx, String factinstid) throws BOSException {
        String query = "select count(*) as total from t_bas_option where factinstid = ? and ftype=0";
        ArrayList ret = SQL.executeQuery((Context)ctx, (String)query, (int[])new int[]{12}, (Object[])new Object[]{factinstid});
        Map item = (Map)ret.get(0);
        int total = Integer.parseInt(item.get("total").toString());
        return total > 0;
    }

    private boolean isActAutoApprove(WfActivity act) throws WfException {
        boolean a = !act.enableCountersign();
        boolean b = true;
        ActivityDef def = act.getDefinition();
        if (def instanceof ApproveActivityDef) {
            b = ((ApproveActivityDef)def).getAcceptOption() == AcceptOption.ONE;
        }
        return a && b;
    }

    private boolean lastAprroveResult(Context ctx, String billId, WfActivity act) throws BOSException {
        String query = "select top 1 fbizfunction from t_wfr_assigndetail where fbizobjid=? and fprocinstid=? order by flaststatetime desc";
        ArrayList ret = SQL.executeQuery((Context)ctx, (String)query, (int[])new int[]{12, 12}, (Object[])new Object[]{billId, act.getProcInstId()});
        if (ret.size() == 0) {
            return true;
        }
        Map item = (Map)ret.get(0);
        if (item.get("fbizfunction") == null) {
            return true;
        }
        if (!"MultiApproveUIFunction".equals(item.get("fbizfunction").toString())) {
            return true;
        }
        query = "select top 1 fispass from t_bas_multiapprove a INNER JOIN t_wfr_assigndetail b on a.FASSIGNMENTID = b.FASSIGNID where b.fbizfunction='MultiApproveUIFunction' and a.FBILLID =? and b.FPROCINSTID =? order by a.FLASTUPDATETIME desc";
        ret = SQL.executeQuery((Context)ctx, (String)query, (int[])new int[]{12, 12}, (Object[])new Object[]{billId, act.getProcInstId()});
        if (ret.size() == 0) {
            return true;
        }
        item = (Map)ret.get(0);
        return Boolean.valueOf(item.get("fispass").toString());
    }

    private String handleResponsible(AssignmentInfo assign, Context ctx) throws BOSException {
        String opinion = "";
        Locale locale = ctx.getLocale();
        String agentName = assign.getEmployeeName(locale);
        String agentId = assign.getEmployeeId();
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        while (assign.getSourceAssignId() != null) {
            assign = service.getAssignmentById(assign.getSourceAssignId());
        }
        String personId = assign.getEmployeeId();
        if (personId != null) {
            try {
                PersonCollection pc = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection("where id='" + personId + "'");
                if (pc.size() > 0 && !personId.equals(agentId)) {
                    String responsibleName = pc.get(0).getName(ctx.getLocale());
                    opinion = "l1".equalsIgnoreCase(locale.getLanguage()) ? "(" + agentName + " agent for " + responsibleName + ")" : "(" + agentName + " \u4ee3\u7406 " + responsibleName + ")";
                }
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return opinion;
    }

    private String getLastUpdateBillParentProcInstId(Context ctx, String procInstId) throws Exception {
        String parentProcInstId;
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)ctx);
        Object lastUpdateTime = svc.getProcessContext(procInstId, "$billLastUpdatedTime");
        if (lastUpdateTime == null && !StringUtils.isEmpty((String)(parentProcInstId = svc.getProcessInstInfo(procInstId).getParentProcInstId()))) {
            procInstId = this.getLastUpdateBillParentProcInstId(ctx, parentProcInstId);
        }
        return procInstId;
    }
}

