/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.ext.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.returns.Delay;
import com.kingdee.bos.service.job.returns.Destroy;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import java.util.HashMap;

public class AutoAssignmentExecutor
implements IJobHandler {
    private static final long serialVersionUID = 5413576441927881145L;
    private String approveId;
    private String assignmentId;

    public AutoAssignmentExecutor(String approveId, String assignmentId) {
        this.approveId = approveId;
        this.assignmentId = assignmentId;
    }

    public Object execute(Job job) throws Exception {
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)job.getContext());
        AssignmentInfo info = svc.getAssignmentById(this.assignmentId);
        WfAssignmentState state = info.getState();
        if (WfAssignmentState.ACCEPTED.equals((Object)state) || WfAssignmentState.ASSIGNED.equals((Object)state)) {
            try {
                HashMap<String, String> boMap = new HashMap<String, String>();
                boMap.put(this.approveId, this.approveId);
                svc.executeAssignment(boMap, info);
            }
            catch (AlreadyInProcessQueueException e) {
                return new Delay((long)RND.nextInt(1000) + 300L);
            }
        }
        return Destroy.instance();
    }
}

