/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.multiapprove.ext.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActualParameterCollection;
import com.kingdee.bos.workflow.define.ActualParameterDef;
import com.kingdee.bos.workflow.define.DataFieldDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeCollection;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.WfProcess;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.eas.base.multiapprove.ApproveResult;
import com.kingdee.eas.base.multiapprove.DecisionItemInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveStatusEnum;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.PermissionUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class FastApproveUtil {
    private Context ctx;
    private AssignmentInfo assign;
    private WfEngine engine;
    private ProcessDef procDef;
    private ApproveActivityDef actDef;

    public FastApproveUtil(Context ctx) {
        this.ctx = ctx;
    }

    public String[] getAssignDesc(String dataCenter, String assignId, String isAgree, String decision) throws Exception {
        ActualParameterCollection aParams;
        this.init(dataCenter, assignId);
        if (!WfAssignmentState.ASSIGNED.equals((Object)this.assign.getState()) && !WfAssignmentState.ACCEPTED.equals((Object)this.assign.getState())) {
            throw new RuntimeException("\u5ba1\u6279\u5df2\u7ecf\u5b8c\u6210\uff0c\u4e0d\u80fd\u91cd\u590d\u5ba1\u6279\uff01");
        }
        String[] desc = new String[3];
        desc[0] = this.assign.getSubject(this.ctx.getLocale());
        boolean agree = "true".equals(isAgree);
        String decisionText = this.getDecisionText(decision, agree);
        if ("\u65e0".equals(decisionText)) {
            decisionText = null;
        }
        desc[1] = (agree ? "\u540c\u610f" : "\u4e0d\u540c\u610f") + (decisionText == null ? "" : "," + decisionText);
        String opinion = "";
        if (agree && (aParams = this.actDef.getActualParameters()) != null) {
            for (int i = 0; i < aParams.size(); ++i) {
                DataFieldDef dfDef;
                ActualParameterDef param = aParams.get(i);
                String name = param.getDataFieldName((ActivityDef)this.actDef);
                if (name == null || !name.startsWith("defaultOpinion") || (dfDef = this.procDef.getDataFieldDef(param.getExpr())) == null) continue;
                opinion = dfDef.getInitValue();
                break;
            }
        }
        desc[2] = opinion;
        return desc;
    }

    private String getDecisionText(String decision, boolean agree) {
        String decisionStrings = this.getDecisionStrings(this.actDef);
        List items = FastApproveUtil.getDecisionItemList(decisionStrings);
        String decisionText = this.getDecisionText(agree, decision, items);
        return decisionText;
    }

    private void init(String dataCenter, String assignId) throws WfException {
        if (dataCenter.length() == 0 || assignId.length() == 0) {
            throw new RuntimeException("\u975e\u6cd5\u53c2\u6570!");
        }
        this.ctx = Ctx.newShadowContext((String)dataCenter);
        this.engine = WfEngine.getEngine((Context)this.ctx);
        this.assign = this.engine.getAssignment(assignId).getMeta();
        this.procDef = this.engine.getProcessDef(this.assign.getProcDefHashValue());
        this.actDef = (ApproveActivityDef)this.procDef.getActivityDef(this.assign.getActDefId());
        WfProcess proc = this.engine.getProcessInst(this.assign.getProcInstId());
        if (WfAssignmentState.NOT_ASSIGNED.equals((Object)this.assign.getState())) {
            throw new RuntimeException("\u4efb\u52a1\u5c1a\u672a\u5206\u914d\uff0c\u4e0d\u80fd\u5ba1\u6279\uff01");
        }
        if (WfAssignmentState.COMPLETED.equals((Object)this.assign.getState())) {
            throw new RuntimeException("\u4efb\u52a1\u5df2\u7ecf\u5b8c\u6210\uff0c\u4e0d\u80fd\u91cd\u590d\u5ba1\u6279\uff01");
        }
        if (WfAssignmentState.REJECTED.equals((Object)this.assign.getState())) {
            throw new RuntimeException("\u4efb\u52a1\u5df2\u7ecf\u88ab\u62d2\u7edd\uff0c\u4e0d\u80fd\u5ba1\u6279\uff01");
        }
        if (WfAssignmentState.CANCELED.equals((Object)this.assign.getState())) {
            throw new RuntimeException("\u4efb\u52a1\u5df2\u64a4\u6d88\uff0c\u4e0d\u80fd\u5ba1\u6279\uff01");
        }
        if (!proc.state().equals("open.running")) {
            throw new RuntimeException("\u6d41\u7a0b\u72b6\u6001(" + proc.state() + ")\u4e0d\u662f\u6267\u884c\u4e2d\uff0c\u4e0d\u80fd\u5ba1\u6279\uff01");
        }
    }

    public String approve(String dataCenter, String assignId, String isAgree, String decision, String opinion, String password) throws Exception {
        this.init(dataCenter, assignId);
        this.ctx.setCaller((IObjectPK)new ObjectUuidPK(this.assign.getUserId()));
        UserInfo user = UserFactory.getLocalInstance((Context)this.ctx).getUserByID(this.ctx.getCaller());
        this.ctx.put((Object)"UserInfo", (Object)user);
        password = PermissionUtil.encrypt((String)this.assign.getUserId(), (String)password);
        if (!password.equals(user.getPassword())) {
            throw new RuntimeException("\u5bc6\u7801\u4e0d\u6b63\u786e\uff01");
        }
        boolean agree = "true".equals(isAgree);
        String decisionText = this.getDecisionText(decision, agree);
        if (decisionText == null) {
            decisionText = " ";
        }
        int decisionKey = Integer.parseInt(decision);
        MultiApproveInfo info = new MultiApproveInfo();
        info.setAssignment(assignId);
        info.setBillId(BOSUuid.read((String)this.assign.getBizObjectIds()));
        info.setExtendedProperty("businuessObjectId", this.assign.getBizObjectIds());
        info.setExtendedProperty("assignmentID", assignId);
        info.setExtendedProperty("isAddNew", "isAddNew");
        info.setIsMailNotifyNext(false);
        info.setIsMobelNotifyNext(false);
        info.setOpinion(opinion, this.ctx.getLocale());
        info.setIsPass(agree ? ApproveResult.PASS : ApproveResult.NOT_PASS);
        info.setHandlerOpinion(decisionKey);
        info.setHandlerContent(decisionText);
        info.setStatus(MultiApproveStatusEnum.SUBMIT);
        MultiApproveFactory.getLocalInstance(this.ctx).submit((CoreBaseInfo)info);
        return "OK";
    }

    private String getDecisionText(boolean isAgree, String decision, List items) {
        String decisionText = null;
        String type = null;
        int key = Integer.parseInt(decision);
        for (int i = 0; i < items.size(); ++i) {
            DecisionItemInfo item = (DecisionItemInfo)items.get(i);
            if (item.getKey() != key) continue;
            decisionText = item.getValue();
            type = item.getType();
            break;
        }
        if (decisionText == null && items.size() > 0) {
            throw new IllegalArgumentException("\u975e\u6cd5\u53c2\u6570\uff01\u51b3\u7b56\u9879{" + decision + "}\u4e0d\u5b58\u5728\uff01");
        }
        if (isAgree && "\u4e0d\u540c\u610f".equals(type) || !isAgree && "\u540c\u610f".equals(type)) {
            throw new IllegalArgumentException("\u975e\u6cd5\u53c2\u6570\uff01\u51b3\u7b56\u9879{" + decision + "}\u4e0e\u7ed3\u8bba{" + type + "}\u4e0d\u5339\u914d\uff01");
        }
        return decisionText;
    }

    private String getDecisionStrings(ApproveActivityDef actDef) {
        String decisions = actDef.getManualDecisionItems(this.ctx.getLocale());
        if (StringUtils.isEmpty((String)decisions)) {
            decisions = actDef.getManualDecisionItems();
        }
        ExtendedAttributeCollection eac = actDef.getActivityHeader().getExtendedAttributes();
        ExtendedAttributeDef ead = null;
        if (StringUtils.isEmpty((String)decisions)) {
            ead = eac.get("manualDecisionItems");
            decisions = ead != null ? ead.getValue() : null;
        }
        return decisions;
    }

    public static List getDecisionItemList(String decisionItemsString) {
        ArrayList<DecisionItemInfo> decisionItems = new ArrayList<DecisionItemInfo>();
        if (decisionItemsString != null && decisionItemsString.trim().length() > 0) {
            String[] items = StringUtils.split((String)decisionItemsString, (String)":");
            String[] itemRows = new String[3];
            for (int i = 0; i < items.length; ++i) {
                itemRows = StringUtils.split((String)items[i], (String)";");
                DecisionItemInfo info = new DecisionItemInfo();
                info.setKey(Integer.parseInt(itemRows[0]));
                info.setValue(itemRows[1]);
                if (itemRows.length == 2) {
                    info.setType("\u5168\u90e8");
                    info.setAssocicateLine("");
                } else if (itemRows.length == 3) {
                    info.setAssocicateLine("");
                    info.setType(itemRows[2]);
                } else {
                    info.setType(itemRows[2]);
                    info.setAssocicateLine(itemRows[3].trim());
                }
                decisionItems.add(info);
            }
        }
        return decisionItems;
    }
}

