/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.risk.ClazzType;
import com.kingdee.eas.base.risk.ExecClassRegistryInfo;
import com.kingdee.eas.base.risk.RiskException;
import com.kingdee.eas.base.risk.RiskModelCollection;
import com.kingdee.eas.base.risk.RiskModelFactory;
import com.kingdee.eas.base.risk.app.AbstractExecClassRegistryControllerBean;
import com.kingdee.eas.base.risk.service.common.ClazzUtils;
import com.kingdee.eas.common.EASBizException;
import org.apache.log4j.Logger;

public class ExecClassRegistryControllerBean
extends AbstractExecClassRegistryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.risk.app.ExecClassRegistryControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ExecClassRegistryInfo info = (ExecClassRegistryInfo)model;
        String classPath = info.getClassPath();
        ClazzType clazzType = info.getClazzType();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("classPath", (Object)classPath, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("clazzType", (Object)clazzType, CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filterInfo)) {
            throw new RiskException(RiskException.EXECCLASSEXIST);
        }
        ClazzUtils.checkClazz(classPath);
        return super._submit(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ExecClassRegistryInfo info = (ExecClassRegistryInfo)model;
        String classPath = info.getClassPath();
        ClazzType clazzType = info.getClazzType();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("classPath", (Object)classPath, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("clazzType", (Object)clazzType, CompareType.EQUALS));
        if (info.getId() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this._exists(ctx, filterInfo)) {
            throw new RiskException(RiskException.EXECCLASSEXIST);
        }
        ClazzUtils.checkClazz(classPath);
        return super._save(ctx, (IObjectValue)info);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ExecClassRegistryInfo info = this.getExecClassRegistryInfo(ctx, pk);
        String classPath = info.getClassPath();
        ClazzType clazzType = info.getClazzType();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        entityViewInfo.setSelector(selectorItemCollection);
        FilterInfo filterInfo = new FilterInfo();
        if (ClazzType.ConditClazz.equals((Object)clazzType)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("conditClazz", (Object)classPath, CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("ruleClazz", (Object)classPath, CompareType.EQUALS));
        }
        entityViewInfo.setFilter(filterInfo);
        RiskModelCollection riskModelCollection = RiskModelFactory.getLocalInstance(ctx).getRiskModelCollection(entityViewInfo);
        if (riskModelCollection.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < riskModelCollection.size(); ++i) {
                sb.append(riskModelCollection.get(i).getNumber()).append(",");
            }
            throw new RiskException(RiskException.CLAZZ_REF, new Object[]{classPath, sb.substring(0, sb.length() - 1)});
        }
        super._delete(ctx, pk);
    }
}

