/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.risk.AM;
import com.kingdee.eas.base.risk.BillTypeCollection;
import com.kingdee.eas.base.risk.BillTypeFactory;
import com.kingdee.eas.base.risk.BillTypeInfo;
import com.kingdee.eas.base.risk.ControlMode;
import com.kingdee.eas.base.risk.DesignInvokeFactory;
import com.kingdee.eas.base.risk.FactorsFilterEntryCollection;
import com.kingdee.eas.base.risk.FactorsFilterEntryInfo;
import com.kingdee.eas.base.risk.ModelConditEntryCollection;
import com.kingdee.eas.base.risk.ModelConditEntryInfo;
import com.kingdee.eas.base.risk.ModelFieldEntryCollection;
import com.kingdee.eas.base.risk.ModelFieldEntryInfo;
import com.kingdee.eas.base.risk.ModelRuleEntryCollection;
import com.kingdee.eas.base.risk.ModelRuleEntryInfo;
import com.kingdee.eas.base.risk.ModelRuleType;
import com.kingdee.eas.base.risk.PageUIModelCollection;
import com.kingdee.eas.base.risk.PageUIModelFactory;
import com.kingdee.eas.base.risk.PageUIModelInfo;
import com.kingdee.eas.base.risk.ParamEntryCollection;
import com.kingdee.eas.base.risk.RiskDesignerCollection;
import com.kingdee.eas.base.risk.RiskDesignerFactory;
import com.kingdee.eas.base.risk.RiskDesignerInfo;
import com.kingdee.eas.base.risk.RiskErrLogFactory;
import com.kingdee.eas.base.risk.RiskErrParamFactory;
import com.kingdee.eas.base.risk.RiskException;
import com.kingdee.eas.base.risk.RiskExecDataFactory;
import com.kingdee.eas.base.risk.RiskInvokeFactory;
import com.kingdee.eas.base.risk.RiskModelCollection;
import com.kingdee.eas.base.risk.RiskModelFactory;
import com.kingdee.eas.base.risk.RiskModelInfo;
import com.kingdee.eas.base.risk.RiskRecordFactory;
import com.kingdee.eas.base.risk.app.AbstractRiskExecuteFacadeControllerBean;
import com.kingdee.eas.base.risk.app.paySafe.OASrcBillFilterCollection;
import com.kingdee.eas.base.risk.app.paySafe.OASrcBillFilterInfo;
import com.kingdee.eas.base.risk.app.paySafe.OATargetBillFilterCollection;
import com.kingdee.eas.base.risk.app.paySafe.OATargetBillFilterInfo;
import com.kingdee.eas.base.risk.app.paySafe.OverAmountInfo;
import com.kingdee.eas.base.risk.app.paySafe.RBShowFieldEntryCollection;
import com.kingdee.eas.base.risk.app.paySafe.RBTargetBillFilterCollection;
import com.kingdee.eas.base.risk.app.paySafe.RBTargetBillFilterInfo;
import com.kingdee.eas.base.risk.app.paySafe.RepeatBillEntryCollection;
import com.kingdee.eas.base.risk.app.paySafe.RepeatBillInfo;
import com.kingdee.eas.base.risk.service.common.ArgsProcess;
import com.kingdee.eas.base.risk.service.common.FieldMatchUtil;
import com.kingdee.eas.base.risk.service.common.SqlCheck;
import com.kingdee.eas.base.risk.service.pojo.DataSnapshot;
import com.kingdee.eas.base.risk.service.pojo.RiskParam;
import com.kingdee.eas.base.risk.service.wfEngine.CtxSign;
import com.kingdee.eas.base.risk.tools.commTools.H;
import com.kingdee.eas.base.risk.tools.dataset.IDataAssembler;
import com.kingdee.eas.base.risk.tools.org.OrgUtils;
import com.kingdee.eas.base.risk.tools.sqlTools.SqlFormatUtils;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RiskExecuteFacadeControllerBean
extends AbstractRiskExecuteFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.risk.app.RiskExecuteFacadeControllerBean");

    protected List<RiskModelInfo> getRiskItems(Context ctx, RiskParam riskParam, Set<String> controlSet) throws BOSException, EASBizException {
        String billId = riskParam.getBillId();
        BOSObjectType type = null;
        String mainBizOrgId = null;
        if (AM.MO.equals((Object)riskParam.getAm())) {
            type = riskParam.getModel().getBOSType();
            mainBizOrgId = this.getMainBizOrgByModel(ctx, riskParam.getModel(), type);
        } else {
            ObjectUuidPK uuidPK = new ObjectUuidPK(billId);
            type = uuidPK.getObjectType();
            mainBizOrgId = this.getMainBizOrgByBillId(ctx, billId, type);
        }
        if (StringUtils.isEmpty((CharSequence)mainBizOrgId)) {
            throw new RiskException(new NumericExceptionSubItem("00", "mainBizOrgId is empty"));
        }
        riskParam.getParams().put("__$$billMainOrgId", mainBizOrgId);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("targetBillType.billBosType", (Object)type.toString()));
        Set<String> idSet = this.getRiskModelIdSet(ctx, type.toString(), mainBizOrgId, riskParam);
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("controlModel", controlSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection selector = this.getRiskItemSelectors();
        viewInfo.setSelector(selector);
        RiskModelCollection modelCollection = RiskModelFactory.getLocalInstance(ctx).getRiskModelCollection(viewInfo);
        this.filterRiskModelsBySrcBilltype(ctx, modelCollection, billId, riskParam);
        ArrayList<RiskModelInfo> list = new ArrayList<RiskModelInfo>(modelCollection.size());
        for (int i = 0; i < modelCollection.size(); ++i) {
            list.add(modelCollection.get(i));
        }
        return list;
    }

    private void filterRiskModelsBySrcBilltype(Context ctx, RiskModelCollection modelCollection, String billId, RiskParam riskParam) throws BOSException {
        block15: {
            try {
                RiskModelInfo riskModelInfo;
                boolean needSelectUpper = false;
                for (int i = 0; i < modelCollection.size(); ++i) {
                    String ruleClazz;
                    RiskModelInfo riskModelInfo2 = modelCollection.get(i);
                    if (!riskModelInfo2.getRuleType().equals((Object)ModelRuleType.Clazz) || !"com.kingdee.eas.base.risk.service.paySafe.AvoidExcess".equals(ruleClazz = riskModelInfo2.getRuleClazz()) && !"com.kingdee.eas.base.risk.service.paySafe.CheckRepeatBill".equals(ruleClazz) || riskModelInfo2.getRepeatBill() == null && riskModelInfo2.getOverAmount() == null) continue;
                    needSelectUpper = true;
                    break;
                }
                if (!needSelectUpper) break block15;
                String sql = "SELECT FSRCENTITYID,FDESTENTITYID  FROM t_bot_relation where FDESTOBJECTID = ?";
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{billId});
                String srcBosType = "";
                String tarBosType = "";
                try {
                    if (rowSet.next()) {
                        srcBosType = rowSet.getString(1);
                        tarBosType = rowSet.getString(2);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
                if (StringUtils.isBlank((CharSequence)srcBosType)) {
                    IObjectValue model = riskParam.getModel();
                    String botrelation = model.getExtendedProperty("botrelation");
                    BOTRelationCollection relColl = (BOTRelationCollection)JSONUtils.convertJsonToObject((Context)ctx, (String)botrelation, BOTRelationCollection.class);
                    HashSet<String> srcBillids = new HashSet<String>();
                    for (int i = 0; i < relColl.size(); ++i) {
                        BOTRelationInfo info = relColl.get(i);
                        if (info == null) continue;
                        String srcEntityID = info.getSrcEntityID();
                        if (StringUtils.isNotBlank((CharSequence)srcEntityID) && StringUtils.isBlank((CharSequence)srcBosType)) {
                            srcBosType = srcEntityID;
                            tarBosType = info.getDestEntityID();
                        }
                        srcBillids.add(info.getSrcObjectID());
                    }
                    riskParam.getModel().put("riskSrcBillIds", srcBillids);
                }
                if (StringUtils.isNotBlank((CharSequence)srcBosType)) {
                    for (int i = 0; i < modelCollection.size(); ++i) {
                        String tar;
                        String src;
                        riskModelInfo = modelCollection.get(i);
                        if (riskModelInfo.getOverAmount() != null && "com.kingdee.eas.base.risk.service.paySafe.AvoidExcess".equals(riskModelInfo.getRuleClazz())) {
                            src = riskModelInfo.getOverAmount().getSrcBill().getBillBosType();
                            tar = riskModelInfo.getOverAmount().getTargetBill().getBillBosType();
                            if (!srcBosType.equals(src) || !tarBosType.equals(tar)) {
                                modelCollection.remove(riskModelInfo);
                                --i;
                                continue;
                            }
                        }
                        if (riskModelInfo.getRepeatBill() == null || !"com.kingdee.eas.base.risk.service.paySafe.CheckRepeatBill".equals(riskModelInfo.getRuleClazz())) continue;
                        src = riskModelInfo.getRepeatBill().getSrcBill().getBillBosType();
                        tar = riskModelInfo.getRepeatBill().getTargetBill().getBillBosType();
                        if (srcBosType.equals(src) && tarBosType.equals(tar)) continue;
                        modelCollection.remove(riskModelInfo);
                        --i;
                    }
                } else {
                    for (int i = 0; i < modelCollection.size(); ++i) {
                        riskModelInfo = modelCollection.get(i);
                        if (riskModelInfo.getOverAmount() == null && riskModelInfo.getRepeatBill() == null) continue;
                        modelCollection.remove(riskModelInfo);
                        --i;
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)"skip filter riskmodels", (Throwable)e);
            }
        }
    }

    protected String getMainBizOrgField(Context ctx, BOSObjectType type) throws BOSException {
        BillTypeCollection billtypeColl = BillTypeFactory.getLocalInstance(ctx).getBillTypeCollection("where billBosType = '" + type.toString() + "'");
        if (billtypeColl == null || billtypeColl.size() == 0) {
            return null;
        }
        return billtypeColl.get(0).getMainBizOrg();
    }

    protected Set<String> getRiskModelIdSet(Context ctx, String billBosType, String mainBizOrgId, RiskParam riskParam) throws EASBizException, BOSException {
        RiskModelInfo info = new RiskModelInfo();
        info.getOrgCtrl();
        BillTypeInfo billTypeInfo = this.getBillType(ctx, billBosType);
        OrgTreeCollection coll = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeCollection("where type = " + billTypeInfo.getOrgType().getValue());
        String orgTypeId = "";
        if (coll.size() > 0) {
            OrgTreeInfo orgTreeInfo = coll.get(0);
            orgTypeId = orgTreeInfo.getId().toString();
        }
        HashSet<String> parentOrgIds = new HashSet<String>();
        this.getParentsByOrgType(ctx, parentOrgIds, mainBizOrgId, orgTypeId);
        parentOrgIds.add(mainBizOrgId);
        return this.getOrgCtrl(ctx, billBosType, parentOrgIds, riskParam);
    }

    protected BillTypeInfo getBillType(Context ctx, String billBosType) throws BOSException, RiskException {
        BillTypeCollection billColl = BillTypeFactory.getLocalInstance(ctx).getBillTypeCollection(" where billBosType = '" + billBosType + "'");
        if (billColl == null || billColl.size() == 0) {
            throw new RiskException(RiskException.EXCEPTIONRISK, new Object[]{"\u6839\u636e\u5355\u636ebostype\u83b7\u53d6\u98ce\u63a7billtype\u4e3a\u7a7a"});
        }
        return billColl.get(0);
    }

    protected Set<String> getOrgCtrl(Context ctx, String billBosType, Set<String> parentOrgIds, RiskParam riskParam) throws RiskException {
        IRowSet rowSet;
        ArrayList<String> orders = new ArrayList<String>();
        HashSet<String> returnSet = new HashSet<String>();
        HashSet<String> idSet = new HashSet<String>();
        StringBuilder builder = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        builder.append("(");
        Iterator<String> iterator = parentOrgIds.iterator();
        while (iterator.hasNext()) {
            builder.append("'").append(iterator.next()).append("',");
        }
        builder.setLength(builder.length() - 1);
        builder.append(")");
        StringBuffer buffer = new StringBuffer(500);
        try {
            List pointRiskModelIds;
            buffer.append(" select rm.fid from T_RIS_RISKMODEL rm ");
            buffer.append(" inner join T_RIS_ModelOrg mo on mo.friskmodelid = rm.fid ");
            buffer.append(" inner join T_RIS_DesignerEntry de on de.fparentid = rm.fid  ");
            buffer.append(" inner join T_RIS_BILLTYPE bt on bt.fid = rm.FTARGETBILLTYPEID ");
            buffer.append(" inner join T_RIS_RiskDesigner rd on de.fdesignerId = rd.fid ");
            buffer.append(" where mo.forgid in ").append((CharSequence)builder);
            buffer.append(" and bt.FBosType = ? ");
            HashSet<String> designerIds = new HashSet<String>();
            List<RiskDesignerInfo> designerList = riskParam.getDesignerList();
            for (int i = 0; i < designerList.size(); ++i) {
                designerIds.add(designerList.get(i).getId().toString());
            }
            buffer.append(" and rd.fid in " + SqlFormatUtils.set2Sql(designerIds));
            if (riskParam.getParams().get("__$$pointRiskModelIds") != null && (pointRiskModelIds = (List)riskParam.getParams().get("__$$pointRiskModelIds")) != null && pointRiskModelIds.size() > 0) {
                buffer.append(" and rm.fid in " + SqlFormatUtils.list2Sql(pointRiskModelIds));
            }
            rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])new Object[]{billBosType});
            while (rowSet.next()) {
                idSet.add(rowSet.getString(1));
            }
        }
        catch (Exception e) {
            String err = "sql:" + buffer.toString() + ";params:[parentOrgIds:" + builder + ";billBosType:" + billBosType + "]";
            logger.error((Object)err);
            logger.error((Object)e, (Throwable)e);
            throw new RiskException(RiskException.GETRISKMODELIDERROR, new Object[]{err});
        }
        if (idSet.size() > 0) {
            StringBuffer orderBf = new StringBuffer(300);
            orderBf.append(" select FOrders,FRiskModelId from T_RIS_ModelShow where FRiskModelId in ");
            String set2Sql = SqlFormatUtils.set2Sql(idSet);
            orderBf.append(set2Sql);
            orderBf.append(" and FOrgId in ").append((CharSequence)builder);
            orderBf.append(" and FStatus = 'enable' ");
            try {
                rowSet = DbUtil.executeQuery((Context)ctx, (String)orderBf.toString());
                while (rowSet.next()) {
                    String modelId = rowSet.getString("FRiskModelId");
                    returnSet.add(modelId);
                    orders.add(modelId);
                }
            }
            catch (Exception e) {
                String err = "sql:" + orderBf.toString() + ";params:[parentOrgIds:" + parentOrgIds + ";set2Sql:" + set2Sql + "]";
                logger.error((Object)err);
                logger.error((Object)e, (Throwable)e);
                throw new RiskException(RiskException.GETRISKMODELIDERROR, new Object[]{err});
            }
        }
        riskParam.getParams().put("__$$riskModelOrders", orders);
        return returnSet;
    }

    protected void getParentsByOrgType(Context ctx, Set<String> parents, String orgId, String orgTypeId) {
        OrgUtils.getParentsByOrgType(ctx, parents, orgId, orgTypeId);
    }

    protected SelectorItemCollection getRiskItemSelectors() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("checkGroup.*");
        selector.add("riskLevel.*");
        selector.add("targetBillType.*");
        selector.add("riskFactors.*");
        selector.add("riskFactors.billType.*");
        selector.add("riskFactors.factorsRuleEntry.*");
        selector.add("riskFactors.factorsFieldEntry.*");
        selector.add("riskFactors.factorsFieldEntry.fixedValue.*");
        selector.add("modelConditEntry.*");
        selector.add("filterEntry.*");
        selector.add("modelFieldEntry.*");
        selector.add("modelRuleEntry.*");
        selector.add("modelRuleEntry.filterEntry.*");
        selector.add("apiConfig.*");
        selector.add("apiConfig.apiParam.*");
        selector.add("modelApiParamEntry.*");
        selector.add("modelApiParamEntry.apiParam.*");
        selector.add("designerEntry.*");
        selector.add("modelOtherEntry.*");
        selector.add("overAmount.*");
        selector.add("overAmount.srcBill.*");
        selector.add("overAmount.srcFilter.*");
        selector.add("overAmount.targetFilter.*");
        selector.add("repeatBill.*");
        selector.add("repeatBill.srcBill.*");
        selector.add("repeatBill.entry.*");
        selector.add("repeatBill.targetFilter.*");
        selector.add("repeatBill.showFiledEntry.*");
        return selector;
    }

    protected String getMainBizOrgByBillId(Context ctx, String billId, BOSObjectType type) throws BOSException {
        String mainBizOrgField = this.getMainBizOrgField(ctx, type);
        if (StringUtils.isEmpty((CharSequence)mainBizOrgField)) {
            return null;
        }
        SelectorItemCollection billSelectors = new SelectorItemCollection();
        billSelectors.add("id");
        billSelectors.add(mainBizOrgField);
        IObjectValue value = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(type, H.PK(billId), billSelectors);
        if (value == null) {
            logger.error((Object)"getMainBizOrgByBillId value is null");
            return null;
        }
        Object mainBizOrgObj = value.get(mainBizOrgField);
        if (mainBizOrgObj instanceof IObjectValue) {
            return ((IObjectValue)mainBizOrgObj).get("id").toString();
        }
        if (mainBizOrgObj != null) {
            return mainBizOrgObj.toString();
        }
        logger.error((Object)"getMainBizOrgByBillId mainBizOrgObj is null");
        return null;
    }

    protected String getMainBizOrgByModel(Context ctx, IObjectValue model, BOSObjectType type) throws BOSException {
        BillTypeCollection billtypeColl = BillTypeFactory.getLocalInstance(ctx).getBillTypeCollection("where billBosType = '" + type.toString() + "'");
        String mainBizOrgField = billtypeColl.get(0).getMainBizOrg();
        Object mainBizOrgObj = model.get(mainBizOrgField);
        if (mainBizOrgObj instanceof IObjectValue) {
            return ((IObjectValue)mainBizOrgObj).get("id").toString();
        }
        return mainBizOrgObj.toString();
    }

    protected List getWeakRiskItems(Context ctx, RiskParam riskParam) throws BOSException, EASBizException {
        HashSet<String> controlSet = new HashSet<String>();
        controlSet.add(ControlMode.billOper.getValue());
        return this.getRiskItems(ctx, riskParam, controlSet);
    }

    protected List getPoTipsRiskItems(Context ctx, RiskParam riskParam) throws BOSException, EASBizException {
        HashSet<String> controlSet = new HashSet<String>();
        controlSet.add(ControlMode.poTips.getValue());
        return this.getRiskItems(ctx, riskParam, controlSet);
    }

    protected List getForcedRiskItems(Context ctx, RiskParam riskParam) throws BOSException, EASBizException {
        HashSet<String> controlSet = new HashSet<String>();
        controlSet.add(ControlMode.funControl.getValue());
        return this.getRiskItems(ctx, riskParam, controlSet);
    }

    protected List getRobotRiskItems(Context ctx, RiskParam riskParam) throws BOSException, EASBizException {
        HashSet<String> controlSet = new HashSet<String>();
        controlSet.add(ControlMode.robot.getValue());
        return this.getRiskItems(ctx, riskParam, controlSet);
    }

    protected void putDefaultProps(Context ctx, IObjectValue objectValue, BOSObjectType bosObjectType, String billId, Set<String> fieldSet) {
    }

    protected void putOtherProps(Context ctx, IObjectValue objectValue, BOSObjectType bosObjectType, String billId, Set<String> fieldSet) {
    }

    protected void addDefaultSelectField(Context ctx, List riskItems, BOSObjectType bosObjectType, String billId, Set<String> fieldSet) {
        fieldSet.add("id");
        fieldSet.add("number");
        fieldSet.add("creator.id");
    }

    protected SelectorItemCollection getSelectorItem(Context ctx, Set<String> fieldSet) {
        SelectorItemCollection sic = new SelectorItemCollection();
        for (String field : fieldSet) {
            sic.add(new SelectorItemInfo(field, field.replaceAll("\\.", "_")));
        }
        return sic;
    }

    protected void getOtherFields(Context ctx, List riskItems, String billId, Map params, Set<String> fieldSet) {
    }

    @Override
    protected List _getRiskItems(Context ctx, RiskParam riskParam, ControlMode controlMode) throws BOSException, EASBizException {
        if (ControlMode.poTips.equals((Object)controlMode)) {
            return this.getPoTipsRiskItems(ctx, riskParam);
        }
        if (ControlMode.billOper.equals((Object)controlMode)) {
            return this.getWeakRiskItems(ctx, riskParam);
        }
        if (ControlMode.robot.equals((Object)controlMode)) {
            return this.getRobotRiskItems(ctx, riskParam);
        }
        return this.getForcedRiskItems(ctx, riskParam);
    }

    @Override
    protected void _idToModel(Context ctx, List riskItems, RiskParam riskParam) throws BOSException, EASBizException {
        if (AM.MO.equals((Object)riskParam.getAm())) {
            return;
        }
        String billId = riskParam.getBillId();
        BOSObjectType bosObjectType = BOSUuid.getBOSObjectType((String)billId, (boolean)true);
        HashSet<String> fieldSet = new HashSet<String>();
        this.addDefaultSelectField(ctx, riskItems, bosObjectType, billId, fieldSet);
        for (int i = 0; i < riskItems.size(); ++i) {
            RiskModelInfo modelInfo = (RiskModelInfo)riskItems.get(i);
            ModelFieldEntryCollection modelFieldEntry = modelInfo.getModelFieldEntry();
            for (int j = 0; j < modelFieldEntry.size(); ++j) {
                ModelFieldEntryInfo modelFieldEntryInfo = modelFieldEntry.get(j);
                String fieldNumber = modelFieldEntryInfo.getFieldName();
                if (!StringUtils.isNotEmpty((CharSequence)fieldNumber)) continue;
                fieldSet.addAll(FieldMatchUtil.getFieldList(ctx, fieldNumber));
            }
            ModelConditEntryCollection modelConditEntry = modelInfo.getModelConditEntry();
            for (int j = 0; j < modelConditEntry.size(); ++j) {
                ModelConditEntryInfo conditEntryInfo = modelConditEntry.get(j);
                String compareField = conditEntryInfo.getCompareField();
                fieldSet.addAll(FieldMatchUtil.getFieldList(ctx, compareField));
                String compareValue = conditEntryInfo.getCompareValue();
                fieldSet.addAll(FieldMatchUtil.getFieldList(ctx, compareValue));
            }
            ModelRuleEntryCollection modelRuleEntry = modelInfo.getModelRuleEntry();
            for (int j = 0; j < modelRuleEntry.size(); ++j) {
                ModelRuleEntryInfo ruleEntryInfo = modelRuleEntry.get(j);
                String compareField = ruleEntryInfo.getCompareField();
                fieldSet.addAll(FieldMatchUtil.getFieldList(ctx, compareField));
                if (!modelInfo.isCompareInOrder()) continue;
                String compareValue = ruleEntryInfo.getCompareValue();
                fieldSet.addAll(FieldMatchUtil.getFieldList(ctx, compareValue));
            }
            FactorsFilterEntryCollection filterEntry = modelInfo.getFilterEntry();
            for (int j = 0; j < filterEntry.size(); ++j) {
                FactorsFilterEntryInfo filterEntryInfo = filterEntry.get(j);
                String compareField = filterEntryInfo.getCompareValue();
                fieldSet.addAll(FieldMatchUtil.getFieldList(ctx, compareField));
            }
            if (modelInfo.getOverAmount() != null) {
                OverAmountInfo overAmount = modelInfo.getOverAmount();
                fieldSet.addAll(FieldMatchUtil.getFieldList(ctx, overAmount.getSrcAF()));
                fieldSet.addAll(FieldMatchUtil.getFieldList(ctx, overAmount.getTargetAF()));
                OASrcBillFilterCollection srcFilter = overAmount.getSrcFilter();
                for (int j = 0; j < srcFilter.size(); ++j) {
                    OASrcBillFilterInfo info = srcFilter.get(j);
                    fieldSet.addAll(FieldMatchUtil.getFieldList(ctx, info.getCompareField()));
                    fieldSet.addAll(FieldMatchUtil.getFieldList(ctx, info.getCompareValue()));
                }
                OATargetBillFilterCollection targetFilter = overAmount.getTargetFilter();
                for (int j = 0; j < targetFilter.size(); ++j) {
                    OATargetBillFilterInfo info = targetFilter.get(j);
                    fieldSet.addAll(FieldMatchUtil.getFieldList(ctx, info.getCompareField()));
                    fieldSet.addAll(FieldMatchUtil.getFieldList(ctx, info.getCompareValue()));
                }
            }
            if (modelInfo.getRepeatBill() == null) continue;
            RepeatBillInfo repeatBill = modelInfo.getRepeatBill();
            RepeatBillEntryCollection entry = repeatBill.getEntry();
            for (int j = 0; j < entry.size(); ++j) {
                fieldSet.addAll(FieldMatchUtil.getFieldList(ctx, entry.get(j).getField()));
            }
            RBShowFieldEntryCollection showFiledEntry = repeatBill.getShowFiledEntry();
            for (int j = 0; j < showFiledEntry.size(); ++j) {
                fieldSet.addAll(FieldMatchUtil.getFieldList(ctx, showFiledEntry.get(j).getField()));
            }
            RBTargetBillFilterCollection targetFilter = repeatBill.getTargetFilter();
            for (int j = 0; j < targetFilter.size(); ++j) {
                RBTargetBillFilterInfo info = targetFilter.get(j);
                fieldSet.addAll(FieldMatchUtil.getFieldList(ctx, info.getCompareField()));
                fieldSet.addAll(FieldMatchUtil.getFieldList(ctx, info.getCompareValue()));
            }
        }
        this.getOtherFields(ctx, riskItems, billId, riskParam.getParams(), fieldSet);
        SelectorItemCollection sic = this.getSelectorItem(ctx, fieldSet);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)billId));
        view.setFilter(filter);
        view.setSelector(sic);
        Object disablePermissionForKScript = ctx.get((Object)"disablePermissionForKScript");
        ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
        IObjectCollection coll = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(bosObjectType, view);
        if (coll == null || coll.size() != 1) {
            throw new RiskException(RiskException.HASNORISKMODEL);
        }
        IObjectValue objectValue = coll.getObject(0);
        this.putDefaultProps(ctx, objectValue, bosObjectType, billId, fieldSet);
        this.putOtherProps(ctx, objectValue, bosObjectType, billId, fieldSet);
        riskParam.setModel(objectValue);
    }

    @Override
    protected List _getDesignersByUipk(Context ctx, String uipk) throws BOSException, EASBizException {
        StringBuilder builder = new StringBuilder(300);
        builder.append(" select rd.fid from t_Ris_RiskDesigner rd ");
        builder.append(" inner join t_ris_pageEntry pe on rd.fid = pe.fparentId ");
        builder.append(" where pe.FPageUIPK = ? ");
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.toString(), (Object[])new Object[]{uipk});
        try {
            while (rowSet.next()) {
                idSet.add(rowSet.getString("fid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e, (Throwable)e);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(this.buildBesignerSelector(ctx));
        RiskDesignerCollection coll = RiskDesignerFactory.getLocalInstance(ctx).getRiskDesignerCollection(viewInfo);
        return this.getCollList(ctx, coll);
    }

    protected PageUIModelInfo uipkTpageModel(Context ctx, String uipk) throws BOSException {
        PageUIModelCollection modelCollection = PageUIModelFactory.getLocalInstance(ctx).getPageUIModelCollection(" where number = '" + uipk + "' or  number = '" + uipk + "_eascard'  ");
        if (modelCollection != null && modelCollection.size() > 0) {
            return modelCollection.get(0);
        }
        logger.error((Object)"uipkTpageModel getUI is null or size=0 ");
        return null;
    }

    protected List getCollList(Context ctx, RiskDesignerCollection coll) {
        ArrayList<RiskDesignerInfo> list = new ArrayList<RiskDesignerInfo>(coll.size());
        for (int i = 0; i < coll.size(); ++i) {
            list.add(coll.get(i));
        }
        if (list.size() == 0 || list.size() > 1) {
            logger.error((Object)("RiskDesigner size error;size is:" + list.size()));
        }
        return list;
    }

    @Override
    protected List _getDesignersByMethod(Context ctx, BOSObjectType metaBosType, String methodName, Object[] args) throws BOSException, EASBizException {
        args = ArgsProcess.removeArgsContext(ctx, args);
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("metaBostype", (Object)metaBosType.toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("methodName", (Object)methodName, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("controlModel", (Object)"ROBOT", CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(this.buildBesignerSelector(ctx));
        RiskDesignerCollection coll = RiskDesignerFactory.getLocalInstance(ctx).getRiskDesignerCollection(viewInfo);
        ArrayList<RiskDesignerInfo> list = new ArrayList<RiskDesignerInfo>();
        block2: for (int i = 0; i < coll.size(); ++i) {
            RiskDesignerInfo riskDesignerInfo = coll.get(i);
            ParamEntryCollection paramEntry = riskDesignerInfo.getParamEntry();
            if (paramEntry == null || paramEntry.isEmpty()) {
                list.add(riskDesignerInfo);
                continue;
            }
            if (paramEntry.size() != args.length) continue;
            for (int j = 0; j < paramEntry.size(); ++j) {
                String paramType = paramEntry.get(j).getParamType();
                if (!StringUtils.isNotEmpty((CharSequence)paramType)) continue;
                try {
                    Class<?> clazz = Class.forName(paramType);
                    if (!clazz.isAssignableFrom(args[j].getClass())) continue block2;
                    if (j != paramEntry.size() - 1) continue;
                    list.add(riskDesignerInfo);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)e, (Throwable)e);
                    continue block2;
                }
            }
        }
        return list;
    }

    @Override
    protected List _getDesignersByMethodPK(Context ctx, BOSObjectType bosType, IMetaDataPK methodPK, Object[] args) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("metaBostype", (Object)bosType.toString(), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("methodPK", (Object)methodPK, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("controlModel", (Object)"FUNCONTROL", CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(this.buildBesignerSelector(ctx));
        RiskDesignerCollection coll = RiskDesignerFactory.getLocalInstance(ctx).getRiskDesignerCollection(viewInfo);
        return this.getCollList(ctx, coll);
    }

    protected SelectorItemCollection buildBesignerSelector(Context ctx) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("pageEntry.*");
        selector.add("paramEntry.*");
        return selector;
    }

    @Override
    protected List _getDesignersByUipkAction(Context ctx, String uipk, String action) throws BOSException, EASBizException {
        StringBuilder builder = new StringBuilder(300);
        builder.append(" select rd.fid from t_Ris_RiskDesigner rd ");
        builder.append(" inner join t_ris_pageEntry pe on rd.fid = pe.fparentId ");
        builder.append("  inner join T_RIS_ActionEntry ae on rd.fid = ae.FDesignerId and pe.fid = ae.FPageEntryId ");
        builder.append(" where pe.FPageUIPK = ?  and ae.FactionNumber = ? ");
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> idSet = new HashSet<String>();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)builder.toString(), (Object[])new Object[]{uipk, action});
        try {
            while (rowSet.next()) {
                idSet.add(rowSet.getString("fid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e, (Throwable)e);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(this.buildBesignerSelector(ctx));
        RiskDesignerCollection coll = RiskDesignerFactory.getLocalInstance(ctx).getRiskDesignerCollection(viewInfo);
        return this.getCollList(ctx, coll);
    }

    @Override
    protected void _persistDataSnapshot(Context ctx, RiskParam riskParam) throws BOSException, EASBizException {
        DataSnapshot dataSnapshot = riskParam.getDataSnapshot();
        RiskInvokeFactory.getLocalInstance(ctx).addnew(dataSnapshot.getInvokeInfo());
        RiskRecordFactory.getLocalInstance(ctx).addnewBatchData(dataSnapshot.getRiskRecordInfoColl());
        RiskErrLogFactory.getLocalInstance(ctx).addnewBatchData(dataSnapshot.getRiskErrLogInfoColl());
        RiskErrParamFactory.getLocalInstance(ctx).addnewBatchData(dataSnapshot.getRiskErrParamInfoColl());
        RiskExecDataFactory.getLocalInstance(ctx).addnewBatchData(dataSnapshot.getRiskExecrDataInfoColl());
        DesignInvokeFactory.getLocalInstance(ctx).addnewBatchData(dataSnapshot.getDesignInvokeColl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _executeSqlAlwaysRollback(Context ctx, String sql, Object[] params, IDataAssembler assembler) throws BOSException, EASBizException {
        try {
            List<Map<String, Object>> dataList;
            SqlCheck.checkSQLValid(ctx, sql);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            List<Map<String, Object>> list = dataList = assembler.packageData(rowSet);
            return list;
        }
        finally {
            this.setRollbackOnly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectPK _saveBizData2DB(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        ReflectiveOperationException ex = null;
        try {
            ctx.put((Object)"$$EAS_RISK_SAVE$$", (Object)CtxSign.Value.TRUE);
            BOSObjectType bosType = model.getBOSType();
            Object bizInterface = this.getLocBizInterface(ctx, bosType);
            Method bizMethod = bizInterface.getClass().getMethod("save", CoreBaseInfo.class);
            Object invoke = bizMethod.invoke(bizInterface, model);
            if (invoke != null) {
                IObjectPK iObjectPK = (IObjectPK)invoke;
                return iObjectPK;
            }
        }
        catch (ClassNotFoundException e) {
            ex = e;
            logger.error((Object)e, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            ex = e;
            logger.error((Object)e, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            ex = e;
            logger.error((Object)e, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            ex = e;
            logger.error((Object)e, (Throwable)e);
        }
        finally {
            ctx.put((Object)"$$EAS_RISK_SAVE$$", (Object)CtxSign.Value.FALSE);
        }
        throw new EASBizException(new NumericExceptionSubItem("00", "\u4e1a\u52a1\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u98ce\u63a7\u5c1d\u8bd5\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\u5931\u8d25"), (Throwable)ex);
    }

    protected Object getLocBizInterface(Context ctx, BOSObjectType bosType) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
        String bussImplFactory = entityInfo.getBusinessImplFactory();
        Class<?> factoryClass = Class.forName(bussImplFactory);
        Method instanceMethod = factoryClass.getMethod("getLocalInstance", Context.class);
        Object bizInterface = instanceMethod.invoke(null, ctx);
        return bizInterface;
    }

    @Override
    protected boolean _saveBizData2DBBatch(Context ctx, List bizModelList) throws BOSException, EASBizException {
        if (bizModelList == null || bizModelList.size() == 0) {
            return false;
        }
        CoreBaseCollection coreBaseColl = new CoreBaseCollection();
        for (int i = 0; i < bizModelList.size(); ++i) {
            coreBaseColl.add((CoreBaseInfo)bizModelList.get(i));
        }
        ReflectiveOperationException ex = null;
        try {
            BOSObjectType bosType = ((CoreBaseInfo)bizModelList.get(0)).getBOSType();
            Object bizInterface = this.getLocBizInterface(ctx, bosType);
            Method bizMethod = bizInterface.getClass().getMethod("saveBatchData", Context.class, CoreBaseCollection.class);
            Object invoke = bizMethod.invoke(bizInterface, ctx, coreBaseColl);
            if (invoke != null) {
                IObjectPK[] pks = (IObjectPK[])invoke;
                for (int i = 0; i < pks.length; ++i) {
                    ((CoreBaseInfo)bizModelList.get(i)).setId(BOSUuid.read((String)pks[i].toString()));
                }
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            ex = e;
            logger.error((Object)e, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            ex = e;
            logger.error((Object)e, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            ex = e;
            logger.error((Object)e, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            ex = e;
            logger.error((Object)e, (Throwable)e);
        }
        throw new EASBizException(new NumericExceptionSubItem("00", "\u4e1a\u52a1\u6570\u636e\u672a\u4fdd\u5b58\uff0c\u98ce\u63a7\u5c1d\u8bd5\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\u5931\u8d25"), (Throwable)ex);
    }
}

