/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.risk.service.pojo;

import com.kingdee.eas.base.risk.RiskException;
import com.kingdee.eas.base.risk.service.common.ScriptEngineUtil;
import com.kingdee.eas.base.risk.service.pojo.Expression;
import java.util.List;
import org.apache.log4j.Logger;

public class Calculation {
    private static Logger logger = Logger.getLogger(Calculation.class);
    private List<Expression> list;

    public Calculation(List<Expression> list) {
        this.list = list;
    }

    public Calculation() {
    }

    public List<Expression> getList() {
        return this.list;
    }

    public Calculation setList(List<Expression> list) {
        this.list = list;
        return this;
    }

    public static Calculation builder() {
        return new Calculation();
    }

    public boolean getCalculationResult() throws RiskException {
        if (this.list == null || this.list.isEmpty()) {
            return true;
        }
        if (this.list.size() == 1) {
            return this.list.get(0).isCalcdValue();
        }
        StringBuffer buffer = new StringBuffer(200);
        for (int i = 0; i < this.list.size() - 1; ++i) {
            Expression expression = this.list.get(i);
            buffer.append(expression.getLeftBracket()).append(expression.isCalcdValue()).append(expression.getRightBracket()).append(expression.getLogic());
        }
        Expression expression = this.list.get(this.list.size() - 1);
        buffer.append(expression.getLeftBracket()).append(expression.isCalcdValue()).append(expression.getRightBracket());
        try {
            Object engineResult = ScriptEngineUtil.getEngineResult(buffer.toString());
            return Boolean.parseBoolean(engineResult.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RiskException(RiskException.EXCEPTIONRISK);
        }
    }
}

