/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.rpa.app.rpaSrv;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.base.rpa.util.WebUtil;
import com.kingdee.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class YsqRpaServer {
    private static final String tokenApiUrl = "/oapi/v1/token";
    public static final String PATH_ACCESSTOKEN = "result.access_token";
    private static final String processApiUrl = "/oapi/v1/process";
    private static String addScheduleApiUrl = "/oapi/v1/schedule/add";
    private static String saveJob = "/oapi/v1/job/savejob";
    private static String robotApiUrl = "/oapi/v1/robot";
    private static String paramsApiUrl = "/oapi/v1/process/params";
    public static final String RT_CODE = "code";
    public static final String SUCESS = "0";
    public static final String RT_MSG = "msg";
    public static final String PATH_TOTAL = "result.total";
    public static final String PATH_ITEMS = "result.items";
    public static final String PROCCODE = "procCode";
    public static final String PROCNAME = "procName";
    public static final String PROCDESC = "procDesc";
    public static final String PARAM_RESULT = "result";
    public static final String PARAM_NAME = "Name";
    public static final String PARAM_TYPE = "Type";
    public static final String PARAM_VALUE = "Value";
    public static final String PARAM_DESC = "Desc";
    private static final SimpleDateFormat SDF = new SimpleDateFormat("ss mm HH dd MM ? yyyy");

    public static void main(String[] args) throws Exception {
        System.out.println(YsqRpaServer.testSaveJob());
    }

    public static String testGetProcesses() throws Exception {
        String ysqToken = YsqRpaServer.getYsqToken("https://127.0.0.1", "ad7e4f2b-c207-41f1-9445-a5c978d0357b", "28349292-d844-4348-9bb8-771c78a5dc92");
        String ysqProcesses = YsqRpaServer.getYsqProcesses("https://127.0.0.1", ysqToken);
        return ysqProcesses;
    }

    public static String testGetGetRobtos() throws Exception {
        String ysqToken = YsqRpaServer.getYsqToken("https://127.0.0.1", "ad7e4f2b-c207-41f1-9445-a5c978d0357b", "28349292-d844-4348-9bb8-771c78a5dc92");
        String robots = YsqRpaServer.getYsqRobots("https://127.0.0.1", ysqToken);
        return robots;
    }

    public static String testStartProcessSchedule() throws Exception {
        String ysqToken = YsqRpaServer.getYsqToken("https://127.0.0.1", "ad7e4f2b-c207-41f1-9445-a5c978d0357b", "28349292-d844-4348-9bb8-771c78a5dc92");
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        params.put("schName", "AddNew3_Customer" + new Date().getTime());
        params.put(PROCCODE, "AddNew3_Customer");
        params.put("scheduleExpre", YsqRpaServer.scheduleExpre(1));
        params.put("execRobotsNo", "easUser2");
        params.put("schParam", "[{'Name':'gv_1','Value':'gv_pikav','Type':'string'},{'Name':'gv_2','Value':'gv_pikav','Type':'string'}]");
        params.put("procVer", "1.2");
        String ysqProcesses = YsqRpaServer.addProcessSchedule("https://127.0.0.1", ysqToken, params);
        return ysqProcesses;
    }

    public static String testSaveJob() throws Exception {
        String ysqToken = YsqRpaServer.getYsqToken("https://127.0.0.1", "ad7e4f2b-c207-41f1-9445-a5c978d0357b", "28349292-d844-4348-9bb8-771c78a5dc92");
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        String ysqProcesses = YsqRpaServer.saveJob("https://127.0.0.1", ysqToken, params);
        return ysqProcesses;
    }

    public static String testGetProcessParams() throws Exception {
        String ysqToken = YsqRpaServer.getYsqToken("https://127.0.0.1", "ad7e4f2b-c207-41f1-9445-a5c978d0357b", "28349292-d844-4348-9bb8-771c78a5dc92");
        String result = YsqRpaServer.getProcessParams("https://127.0.0.1", ysqToken, "NewEasTest", "1.0.1.0");
        return result;
    }

    public static String getYsqToken(String baseUrl, String accessKey, String secretKey) throws Exception {
        String url = baseUrl + tokenApiUrl + "?accessKey=" + accessKey + "&secretKey=" + secretKey;
        String result = WebUtil.sendGetRequest(url, null, null, null);
        JSONObject resultJson = (JSONObject)JSON.parse((String)result);
        return resultJson.getJSONObject(PARAM_RESULT).getString("access_token");
    }

    public static String testServerAccess(String baseUrl, String accessKey, String secretKey) throws Exception {
        String url = baseUrl + tokenApiUrl + "?accessKey=" + accessKey + "&secretKey=" + secretKey;
        String result = WebUtil.sendGetRequest(url, null, null, null);
        return result;
    }

    public static String getProcessParams(String baseUrl, String accesstoken, String procCode, String procVer) throws Exception {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        params.put(PROCCODE, procCode);
        if (!StringUtils.isEmpty((String)procVer)) {
            params.put("procVer", procVer);
        }
        String[] sing = YsqRpaServer.buildSing(accesstoken, params);
        String signature = null;
        String timestamp = null;
        if (sing.length > 0) {
            signature = sing[1];
            timestamp = sing[0];
        }
        String response = WebUtil.sendPostRequestByParams1(signature, timestamp, accesstoken, baseUrl + paramsApiUrl, params);
        return response;
    }

    public static String addProcessSchedule(String baseUrl, String accessKey, String secretKey, TreeMap<String, Object> ScheduleParams) throws Exception {
        String ysqToken = YsqRpaServer.getYsqToken(baseUrl, accessKey, secretKey);
        String response = YsqRpaServer.addProcessSchedule(baseUrl, ysqToken, ScheduleParams);
        return response;
    }

    public static String addProcessSchedule(String baseUrl, String accesstoken, TreeMap<String, Object> ScheduleParams) throws Exception {
        String[] sing = YsqRpaServer.buildSing(accesstoken, ScheduleParams);
        String signature = null;
        String timestamp = null;
        if (sing.length > 0) {
            signature = sing[1];
            timestamp = sing[0];
        }
        String response = WebUtil.sendPostRequestByParams1(signature, timestamp, accesstoken, baseUrl + addScheduleApiUrl, ScheduleParams);
        return response;
    }

    public static String getYsqProcesses(String baseUrl, String accesstoken) throws Exception {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        String[] sing = YsqRpaServer.buildSing(accesstoken, params);
        String signature = null;
        String timestamp = null;
        if (sing.length > 0) {
            signature = sing[1];
            timestamp = sing[0];
        }
        String response = WebUtil.sendGetRequest(baseUrl + processApiUrl, accesstoken, timestamp, signature);
        return response;
    }

    public static String getYsqRobots(String baseUrl, String accesstoken) throws Exception {
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        String[] sing = YsqRpaServer.buildSing(accesstoken, params);
        String signature = null;
        String timestamp = null;
        if (sing.length > 0) {
            signature = sing[1];
            timestamp = sing[0];
        }
        String response = WebUtil.sendGetRequest(baseUrl + robotApiUrl, accesstoken, timestamp, signature);
        return response;
    }

    public static String saveJob(String baseUrl, String accesstoken, TreeMap<String, Object> params) throws Exception {
        String oapiJobAddVo = "{\r\n\t\"procCode\": \"TestReqBill001\",\r\n\t\"procVer\": \"1.0\",\r\n\t\"robotId\": \"511A6F9DACB5877867BC7D9DEAF94A11\"\r\n}";
        params.put("oapiJobAddVo", oapiJobAddVo);
        String[] sing = YsqRpaServer.buildSing(accesstoken, params);
        String signature = null;
        String timestamp = null;
        if (sing.length > 0) {
            signature = sing[1];
            timestamp = sing[0];
        }
        String response = WebUtil.sendPostRequestByParams1(signature, timestamp, accesstoken, baseUrl + saveJob, params);
        return response;
    }

    private static String specialUrlEncode(String url) throws UnsupportedEncodingException {
        return URLEncoder.encode(url, "UTF8").replace("+", "%20").replace("*", "%2A").replace("~", "%7E");
    }

    private static String buildQueryString(SortedMap<String, Object> parameters) {
        if (!parameters.isEmpty()) {
            Iterator<String> it = parameters.keySet().iterator();
            StringBuilder queryString = new StringBuilder();
            while (it.hasNext()) {
                String name = it.next();
                queryString.append("&").append(name).append('=').append(parameters.get(name));
            }
            return queryString.substring(1);
        }
        return "";
    }

    public static String[] buildSing(String accesstoken, TreeMap<String, Object> params) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(YsqRpaServer.buildQueryString(params));
        if (sb.length() > 0) {
            sb.append("&");
        }
        long c = Calendar.getInstance().getTimeInMillis();
        sb.append("timestamp=").append(c);
        System.out.println("timestamp=" + c);
        System.out.println("\u6e90\u4e32:" + sb.toString());
        String splice = YsqRpaServer.specialUrlEncode(sb.toString());
        System.out.println("splice:::: " + splice);
        String key256 = accesstoken;
        splice = YsqRpaServer.HMACSHA256StrByKey(splice, key256);
        System.out.println("splice hmac:::: " + splice);
        String signature = Base64.encodeBase64String((byte[])splice.getBytes("UTF-8"));
        signature = signature.replaceAll("\r|\n", "");
        System.out.println("signature:" + signature);
        String[] str = new String[]{String.valueOf(c), signature};
        return str;
    }

    public static String HMACSHA256StrByKey(String data, String key) throws Exception {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder();
        byte[] var6 = array;
        int var7 = array.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            byte item = var6[var8];
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    public static String scheduleExpre(int delayMillSeconds) {
        Date date = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(14, delayMillSeconds);
        date = c.getTime();
        return SDF.format(date);
    }

    public static String defaultScheduleExpre() {
        return YsqRpaServer.scheduleExpre(1);
    }
}

