/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.report.demo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.report.demo.app.SummaryUnit;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CollectionReportUtils {
    public static final Log log = LogFactory.getLog(CollectionReportUtils.class);
    public static final String SQL_QUERY_ORG_ADMIN = "select FID,FParentID,FName_L2,FName_L3,FLevel,FNumber from T_ORG_Admin order by FLEVEL";
    public static final String TABLE_ORG_ADMIN_FID = "FID";
    public static final String TABLE_ORG_ADMIN_FParentID = "FParentID";
    public static final String TABLE_ORG_ADMIN_FName_L2 = "FName_L2";
    public static final String TABLE_ORG_ADMIN_FLevel = "FLevel";
    public static final String TABLE_ORG_ADMIN_FNumber = "FNumber";

    public static ResultSet getAdminOrg(Context ctx) throws BOSException {
        return DbUtil.executeQuery((Context)ctx, (String)SQL_QUERY_ORG_ADMIN);
    }

    public static List getOrgAdminSummaryUnits(String orgId, Context ctx) throws BOSException, SQLException {
        ArrayList<Object> retList = new ArrayList<Object>();
        SummaryUnit retUnit = null;
        ResultSet orgRS = CollectionReportUtils.getAdminOrg(ctx);
        HashMap<String, SummaryUnit> adminOrg = new HashMap<String, SummaryUnit>();
        while (orgRS.next()) {
            String id = orgRS.getString(TABLE_ORG_ADMIN_FID);
            String pid = orgRS.getString(TABLE_ORG_ADMIN_FParentID);
            String name = orgRS.getString(TABLE_ORG_ADMIN_FName_L2);
            int level = orgRS.getInt(TABLE_ORG_ADMIN_FLevel);
            String number = orgRS.getString(TABLE_ORG_ADMIN_FNumber);
            SummaryUnit oneUnit = new SummaryUnit(id, pid, name);
            oneUnit.setAttribute("level", new Integer(level));
            oneUnit.setAttribute("number", number);
            if (level == 1) {
                oneUnit.setRoot(true);
                oneUnit.setParent(null);
            } else {
                SummaryUnit parent = (SummaryUnit)adminOrg.get(pid);
                if (parent != null) {
                    oneUnit.setParent(parent);
                    parent.addChild(oneUnit);
                }
            }
            if (id.equals(orgId)) {
                retUnit = oneUnit;
            }
            adminOrg.put(id, oneUnit);
        }
        if (retUnit == null && log.isErrorEnabled()) {
            log.error((Object)("\u83b7\u53d6\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5b58\u5728:" + orgId));
        }
        retList.add(retUnit);
        retList.add(adminOrg);
        return retList;
    }

    public static String getChildUnitIds(SummaryUnit oneUnit) {
        StringBuffer sb = new StringBuffer();
        if (oneUnit != null) {
            sb.append("'" + oneUnit.getId() + "'");
            List child = oneUnit.getChild();
            for (int i = 0; i < child.size(); ++i) {
                SummaryUnit oneChildUnit = (SummaryUnit)child.get(i);
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(CollectionReportUtils.getChildUnitIds(oneChildUnit));
            }
        }
        return sb.toString();
    }
}

