/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormCacheService.ORMValueCacheService;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.usermonitor.NotAllowRepeatLoginUserInfo;
import com.kingdee.eas.base.usermonitor.app.AbstractNotAllowRepeatLoginUserControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class NotAllowRepeatLoginUserControllerBean
extends AbstractNotAllowRepeatLoginUserControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.usermonitor.app.NotAllowRepeatLoginUserControllerBean");
    private static final String DISALLOW_USER_REPEAT_LOGIN = "disallowUserRepeatLoginByDefault";

    @Override
    protected boolean _isAllowRepeatLogin(Context ctx, String userId) throws BOSException, EASBizException {
        boolean allowRepeatLogin = true;
        String sql = "select fid from T_UM_NotAllowRepeatLoginUser where FUserIdid = '" + userId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rowSet.next()) {
                allowRepeatLogin = false;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"NotAllowRepeatLoginUserControllerBean _existsUser SQLException!");
            throw new BOSException(e.getMessage());
        }
        boolean disallowRepeatLoginByDefault = this.isDisallowRepeatLoginByDefault(ctx);
        if (disallowRepeatLoginByDefault) {
            allowRepeatLogin = !allowRepeatLogin;
        }
        return allowRepeatLogin;
    }

    @Override
    protected void _saveNotAllowRepeatLoginUser(Context ctx, UserCollection userCollection) throws BOSException, EASBizException {
        Connection cn = null;
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_saveNotAllowRepeatLoginUser", (BOSObjectType)new NotAllowRepeatLoginUserInfo().getBOSType(), null, (String)Arrays.toString((Object[])userCollection.toArray()), (String)"usermonitor_notallow_repeat_addnew");
        try {
            cn = this.getConnection(ctx);
            IORMappingDAO dao = this.getDAO(ctx, cn);
            for (int i = 0; i < userCollection.size(); ++i) {
                NotAllowRepeatLoginUserInfo notAllowRepeatLoginUserInfo = new NotAllowRepeatLoginUserInfo();
                notAllowRepeatLoginUserInfo.setUserId(userCollection.get(i));
                dao.addNewBatch((IObjectValue)notAllowRepeatLoginUserInfo);
                if ((i + 1) % 100 != 0) continue;
                dao.executeBatch();
            }
            dao.executeBatch();
            this.paramControl();
        }
        catch (DataAccessException dae) {
            logger.error((Object)("dao.executeBatch exception:" + (Object)((Object)dae)));
            throw new BOSException((Throwable)dae);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        ORMValueCacheService.getInstance().discardQuery(ctx, this.getBOSType());
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    @Override
    protected void _deleteUserForNotAllow(Context ctx, String userIdList) throws BOSException, EASBizException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("fuseridid", (Object)userIdList, CompareType.INCLUDE));
            String strDel = filterInfo.toSql();
            StringBuffer sql = new StringBuffer();
            sql.append("delete from T_UM_NotAllowRepeatLoginUser where ").append(strDel);
            SQLUtils.execute((Connection)cn, (String)sql.toString());
            this.paramControl();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        ORMValueCacheService.getInstance().discardQuery(ctx, this.getBOSType());
    }

    @Override
    protected boolean _isDisallowRepeatLoginByDefault(Context ctx) throws BOSException {
        try {
            String disallowValue = ParamManager.getParamValue((Context)ctx, null, (String)DISALLOW_USER_REPEAT_LOGIN);
            boolean disallow = Boolean.parseBoolean(disallowValue);
            return disallow;
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _updateIsDisallowRepeatLoginByDefault(Context ctx, boolean disallow) throws BOSException {
        try {
            ParamManager.updateParamByNumber((Context)ctx, (String)DISALLOW_USER_REPEAT_LOGIN, (String)String.valueOf(disallow));
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void paramControl() throws BOSException, EASBizException {
        String className = "com.kingdee.eas.base.uiframe.app.LoginParamCacheServerUtil";
        try {
            Class<?> c = Class.forName(className);
            Method staticMethod = c.getDeclaredMethod("updateLastUpdateTime", new Class[0]);
            staticMethod.invoke(c, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (NoSuchMethodException ne) {
            logger.error((Object)"", (Throwable)ne);
        }
        catch (InvocationTargetException ie) {
            logger.error((Object)"", (Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            logger.error((Object)"", (Throwable)iae);
        }
    }
}

