/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.framework.ejb.EJBUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.SerializableByteArrayInputStream;
import com.kingdee.util.db.SQLUtils;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Set;
import org.apache.log4j.Logger;

public class StatusDBUtil {
    private static Logger logger = Logger.getLogger(StatusDBUtil.class);
    private static final String DEFAULT_DRIVER_CLASS = "com.kingdee.bos.sql.shell.Driver";

    public static IRowSet executeQueryNoTx(String sql) throws BOSException {
        return StatusDBUtil.executeWithReturn(sql, null);
    }

    public static IRowSet executeQueryNoTx(String sql, Object[] params) throws BOSException {
        return StatusDBUtil.executeWithReturn(sql, params);
    }

    public static IRowSet executeQuery(String sql) throws BOSException {
        return StatusDBUtil.executeWithReturn(sql, null);
    }

    public static IRowSet executeQuery(String sql, Object[] params) throws BOSException {
        return StatusDBUtil.executeWithReturn(sql, params);
    }

    public static void execute(String sql) throws BOSException {
        StatusDBUtil.executeWithNoReturn(sql, null);
    }

    public static void execute(String sql, Object[] params) throws BOSException {
        StatusDBUtil.executeWithNoReturn(sql, params);
    }

    private static IRowSet executeWithReturn(String sql, Object[] params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = StatusDBUtil.createConnectionDirect();
            ps = conn.prepareStatement(sql);
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                if (params != null && params.length > 0) {
                    StringBuffer sb = new StringBuffer("");
                    for (int i = 0; i < params.length; ++i) {
                        sb.append("param ").append(i).append(" is:").append(params[i]);
                    }
                    logger.error((Object)("444 sql is:" + sql + " param is:" + sb.toString()), (Throwable)exc);
                }
                throw new BOSException("Sql4 execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }

    public static void executeWithNoReturn(String sql, Object[] params) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = StatusDBUtil.createConnectionDirect();
            ps = conn.prepareStatement(sql);
            if (params != null && params.length > 0) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, params[i]);
                }
            }
            ps.execute();
        }
        catch (Exception exc) {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < params.length; ++i) {
                sb.append("param ").append(i).append(" is:").append(params[i]);
            }
            logger.error((Object)("222 sql is:" + sql + " param is:" + sb.toString()), (Throwable)exc);
            throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
        }
    }

    private static Connection createConnectionDirect() throws BOSException {
        Connection con = null;
        Set dataSourceAISs = EJBFactory.getQueryDataSources();
        Hashtable htDataSourceEJBUtils = EJBFactory.getQueryDSCache();
        if (dataSourceAISs == null || dataSourceAISs.size() < 0) {
            throw new BOSException("\u65e0\u6cd5\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\uff0c\u65e0\u6cd5\u521b\u5efa\u8fde\u63a5\uff01");
        }
        for (String dataSourceAIS : dataSourceAISs) {
            EJBUtils ejbUtil = (EJBUtils)htDataSourceEJBUtils.get(dataSourceAIS);
            try {
                con = ejbUtil.getConnection();
            }
            catch (SQLException e) {
                logger.error((Object)("LicenseUseManager.loadDataFromLicense:dealLicenseRegistUserbyDatasources error.ctx.getAis=" + dataSourceAIS));
            }
        }
        return con;
    }

    public static void prepareVarcharParam(PreparedStatement stmt, int index, String param) throws SQLException {
        byte[] value = param.getBytes();
        stmt.setAsciiStream(index, (InputStream)new SerializableByteArrayInputStream(value), value.length);
    }
}

