/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.weibo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.weibo.WeiboBillConfigInfo;
import com.kingdee.eas.base.weibo.WeiboBindPersonInfo;
import com.kingdee.eas.base.weibo.app.PersonRegisterInfo;
import com.kingdee.eas.base.weibo.app.WeiboAccessInfo;
import com.kingdee.eas.base.weibo.app.WeiboGlobal;
import com.kingdee.eas.base.weibo.app.WeiboPreCreateUserInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class WeiboAppDAO {
    private static final String WEIBO_DOMAIN_KEY = "weibo_domain";
    private static final String WEIBO_ENABLE_KEY = "weibo_enable";
    private static final String WEIBO_APPKEY_KEY = "weibo_app_key";
    private static final String WEIBO_APPSECRET_KEY = "weibo_app_secret";
    private static final String WEIBO_SYSTEM_TYPE = "weibo_system_type";
    private static final String WEIBO_FORMAL_URL = "weibo_formal_url";
    private static final String WEIBO_TEST_URL = "weibo_test_url";

    private static String getWeiboConfigValue(Context ctx, String key) throws BOSException, SQLException {
        String sql = "select fparamvalue v from t_bas_weiboconfig where fparamkey = ?";
        Object[] param = new Object[]{key};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        if (rs.next()) {
            return rs.getString("v");
        }
        return null;
    }

    protected static String getWeiboDomain(Context ctx) throws BOSException, SQLException {
        return WeiboAppDAO.getWeiboConfigValue(ctx, WEIBO_DOMAIN_KEY);
    }

    protected static String getWeiboEnable(Context ctx) throws BOSException, SQLException {
        return WeiboAppDAO.getWeiboConfigValue(ctx, WEIBO_ENABLE_KEY);
    }

    protected static String getWeiboFormalUrl(Context ctx) throws BOSException, SQLException {
        return WeiboAppDAO.getWeiboConfigValue(ctx, WEIBO_FORMAL_URL);
    }

    protected static String getWeiboTestUrl(Context ctx) throws BOSException, SQLException {
        return WeiboAppDAO.getWeiboConfigValue(ctx, WEIBO_TEST_URL);
    }

    protected static String getWeiboSystemType(Context ctx) throws BOSException, SQLException {
        return WeiboAppDAO.getWeiboConfigValue(ctx, WEIBO_SYSTEM_TYPE);
    }

    protected static String getAppKey(Context ctx) throws BOSException, SQLException {
        return WeiboAppDAO.getWeiboConfigValue(ctx, WEIBO_APPKEY_KEY);
    }

    protected static String getAppSecret(Context ctx) throws BOSException, SQLException {
        return WeiboAppDAO.getWeiboConfigValue(ctx, WEIBO_APPSECRET_KEY);
    }

    protected static WeiboAccessInfo getAccessInfo(Context ctx, String personId) throws SQLException, BOSException {
        if (StringUtils.isEmpty((String)personId)) {
            return new WeiboAccessInfo();
        }
        IRowSet rs = WeiboAppDAO.getWeiboRowSet(ctx, personId);
        if (rs.next()) {
            return new WeiboAccessInfo(rs.getString("e"), rs.getString("t"), rs.getString("s"));
        }
        return new WeiboAccessInfo();
    }

    private static IRowSet getWeiboRowSet(Context ctx, String personId) throws BOSException {
        String sql = "select fpersonid pid, femail e, ftoken t, ftokensecret s from t_bas_weibo where fpersonid = ? and fstatus = 1";
        Object[] params = new Object[]{personId};
        return DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
    }

    protected static void updateDomain(Context ctx, String value) throws BOSException {
        WeiboAppDAO.updateConfigValue(ctx, WEIBO_DOMAIN_KEY, value);
    }

    protected static void updateEnable(Context ctx, String value) throws BOSException {
        WeiboAppDAO.updateConfigValue(ctx, WEIBO_ENABLE_KEY, value);
    }

    protected static void updateWeiboSystem(Context ctx, String systemType, String testUrl) throws BOSException {
        WeiboAppDAO.updateConfigValue(ctx, WEIBO_SYSTEM_TYPE, systemType);
        WeiboAppDAO.updateConfigValue(ctx, WEIBO_TEST_URL, testUrl);
    }

    private static void updateConfigValue(Context ctx, String key, String value) throws BOSException {
        String sql = "update t_bas_weiboconfig set fparamvalue = ? where fparamkey = ?";
        Object[] param = new Object[]{value, key};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
    }

    protected static void registerMapping(Context ctx, String email, String personId, String weiboId) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into t_bas_weibo (fid, fcreatetime, fcreator, fpersonId, femail, fweibouserid, fstatus)");
        sb.append(" values(?, ?, ?, ?, ?, ?, 1)");
        String user = ctx.getCaller().toString();
        Object[] params = new Object[]{Uuid.randomUUID().toString(), WeiboAppDAO.getCurrentTimeStr(), user, personId, email, weiboId};
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
    }

    protected static void bindMapping(Context ctx, String email, String personId, String weiboId, String token, String tokenSecret) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into t_bas_weibo (fid, fcreatetime, fcreator, fpersonId, femail, fweibouserid, ftoken, ftokensecret, fstatus)");
        sb.append(" values(?, ?, ?, ?, ?, ?, ?, ?, 1)");
        String user = ctx.getCaller().toString();
        Object[] params = new Object[]{Uuid.randomUUID().toString(), WeiboAppDAO.getCurrentTimeStr(), user, personId, email, weiboId, token, tokenSecret};
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
        String sql = "delete from t_bas_weibo where femail = ? and ftoken is null";
        Object[] paramDel = new Object[]{email};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])paramDel);
    }

    protected static void bindMappingWithToken(Context ctx, String email, String personId, String weiboId, String token, String tokenSecret) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("insert into t_bas_weibo (fid, fcreatetime, fcreator, fpersonId, femail, fweibouserid, ftoken, ftokensecret, fstatus)");
        sb.append(" values(?, ?, ?, ?, ?, ?, ?, ?, 1)");
        String user = ctx.getCaller().toString();
        Object[] params = new Object[]{Uuid.randomUUID().toString(), WeiboAppDAO.getCurrentTimeStr(), user, personId, email, weiboId, token, tokenSecret};
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
    }

    private static Timestamp getCurrentTimeStr() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataStr = format.format(new Date());
        return Timestamp.valueOf(dataStr);
    }

    protected static PersonRegisterInfo getPeronInfoByUserId(Context ctx, String userId) throws BOSException, SQLException {
        String sql = "select p.fid id, p.femail email,  p.fname_" + ctx.getLocale() + " name from t_bd_person p, t_pm_user u where p.fid = u.fpersonid and u.fid = ?";
        Object[] params = new Object[]{userId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        PersonRegisterInfo info = null;
        if (rs.next()) {
            info = new PersonRegisterInfo();
            info.setPersonId(rs.getString("id"));
            info.setName(rs.getString("name"));
            info.setEmail(rs.getString("email"));
        }
        return info;
    }

    protected static String getUserNameByWeiboId(Context ctx, String weiboId) throws BOSException, SQLException {
        String sql = "select a.fnumber number from t_pm_user a,t_bas_weibo b where a.fid=b.fcreator and b.fweibouserId = ?";
        Object[] params = new Object[]{weiboId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        String userName = null;
        if (rs.next()) {
            userName = rs.getString("number");
        }
        return userName;
    }

    protected static PersonRegisterInfo getPeronInfoByPersonId(Context ctx, String personId) throws BOSException, SQLException {
        String sql = "select p.fid id, p.femail email,p.fname_" + ctx.getLocale() + " name from t_bd_person p where p.fid=?";
        Object[] params = new Object[]{personId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        PersonRegisterInfo info = null;
        if (rs.next()) {
            info = new PersonRegisterInfo();
            info.setPersonId(rs.getString("id"));
            info.setName(rs.getString("name"));
            info.setEmail(rs.getString("email"));
        }
        return info;
    }

    protected static String getWeiboEmailsByUserIds(Context ctx, String userIds) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer("select w.femail email from t_bas_weibo w join t_pm_user u on w.fpersonid  = u.fpersonid where w.fstatus = 1 and u.fid in (");
        sql.append("'").append(userIds.replaceAll(",", "','")).append("')");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuffer emails = new StringBuffer();
        while (rs.next()) {
            emails.append(rs.getString("email")).append(",");
        }
        if (emails.length() > 0) {
            return emails.substring(0, emails.length() - 1);
        }
        return null;
    }

    protected static String[] getWeiboInfoByUserId(Context ctx, String userId) throws BOSException, SQLException {
        String sql = "select w.femail email, w.fweibouserid weiboid from t_bas_weibo w join t_pm_user u on w.fpersonid  = u.fpersonid where w.fstatus = 1 and u.fid = ?";
        return WeiboAppDAO.getWeiboFieldInfo(ctx, sql, userId);
    }

    private static String[] getWeiboFieldInfo(Context ctx, String sql, String param) throws SQLException, BOSException {
        Object[] params = new Object[]{param};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        String[] ids = new String[2];
        if (rs.next()) {
            ids[0] = rs.getString("weiboid");
            ids[1] = rs.getString("email");
        }
        return ids;
    }

    protected static String[] getWeiboInfoByPersonId(Context ctx, String personId) throws BOSException, SQLException {
        String sql = "select femail email, fweibouserid weiboid from t_bas_weibo where fpersonid = ? and fstatus = 1";
        return WeiboAppDAO.getWeiboFieldInfo(ctx, sql, personId);
    }

    protected static WeiboPreCreateUserInfo getWeiboPreCreateUserInfo(Context ctx, String personId) throws BOSException, SQLException {
        Locale locale = ctx.getLocale();
        StringBuilder sql = new StringBuilder();
        sql.append("select p.fname_").append(locale);
        sql.append(" job, a.fname_").append(locale);
        sql.append(" department from T_ORG_Positionmember pm");
        sql.append(" inner join T_ORG_Position p  on p.fid = pm.fpositionid ");
        sql.append(" inner join  T_ORG_Admin a on a.fid =  p.fadminorgunitid");
        sql.append(" where pm.fpersonid = ? and pm.fisprimary = 1");
        Object[] params = new Object[]{personId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        return WeiboAppDAO.createWeiboPreCreateUserInfo(rs);
    }

    private static WeiboPreCreateUserInfo createWeiboPreCreateUserInfo(IRowSet rs) throws SQLException {
        WeiboPreCreateUserInfo info = null;
        if (rs.next()) {
            info = new WeiboPreCreateUserInfo();
            info.setJobTitle(rs.getString("job"));
            info.setDepartment(rs.getString("department"));
        }
        return info;
    }

    protected static String[] getWeiboAdminToken(Context ctx) throws BOSException, SQLException {
        String sql = "select top 1 femail e, ftoken t, ftokensecret s from t_bas_weibo where fstatus = 1 and (fpersonid is null or fpersonid = '') and ftoken is not null order by fcreatetime asc";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String[] ids = new String[3];
        if (rs.next()) {
            ids[0] = rs.getString("e");
            ids[1] = rs.getString("t");
            ids[2] = rs.getString("s");
        }
        return ids;
    }

    protected static Set getWeiboBillConfig(Context ctx) throws BOSException, SQLException {
        String sql = "select fbostype b from t_bas_weibobillconfig";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<String> weiboBillSet = new HashSet<String>();
        while (rs.next()) {
            weiboBillSet.add(rs.getString("b"));
        }
        System.out.println("weiboBillSet:" + weiboBillSet);
        return weiboBillSet;
    }

    protected static void addWeiboBillConfig(Context ctx, String bosType, String desc) throws BOSException, SQLException {
        String sql = "insert into t_bas_weibobillconfig (fid, fcreatetime, fcreator, fbostype, fdescription) values(?, ?, ?, ?, ?)";
        Object[] params = new Object[]{Uuid.randomUUID().toString(), WeiboAppDAO.getCurrentTimeStr(), ctx.getCaller().toString(), bosType, desc};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        WeiboGlobal.resetAndGetWeiboBillSet(ctx);
    }

    protected static void deleteWeiboBillConfig(Context ctx, String configId) throws BOSException, SQLException {
        String sql = "delete from t_bas_weibobillconfig where fid = ?";
        Object[] params = new Object[]{configId};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        WeiboGlobal.resetAndGetWeiboBillSet(ctx);
    }

    protected static int countWeiboBillConfig(Context ctx) throws BOSException, SQLException {
        String sql = "select count(fid) c from t_bas_weibobillconfig";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            return rs.getInt("c");
        }
        return 0;
    }

    protected static List getWeiboBillConfigList(Context ctx, int start, int size) throws BOSException, SQLException {
        String sql = "select fid id, fbostype type, fdescription descs from t_bas_weibobillconfig order by fcreatetime desc";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (int)start, (int)size);
        return WeiboAppDAO.createBillConfigList(rs);
    }

    private static List createBillConfigList(IRowSet rs) throws SQLException {
        ArrayList<WeiboBillConfigInfo> billList = new ArrayList<WeiboBillConfigInfo>();
        boolean a = false;
        while (rs.next()) {
            billList.add(new WeiboBillConfigInfo(rs.getString("id"), rs.getString("type"), rs.getString("descs")));
        }
        return billList;
    }

    protected static int countWeiboBindPerson(Context ctx) throws BOSException, SQLException {
        String sql = "select count(fid) c from t_bas_weibo where fstatus = 1 ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            return rs.getInt("c");
        }
        return 0;
    }

    protected static List<WeiboBindPersonInfo> getWeiboBindPersonList(Context ctx, int start, int size) throws BOSException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select w.fid id, p.fname_").append(ctx.getLocale()).append(" name, w.femail email, w.ftoken token");
        sql.append(" from t_bas_weibo w");
        sql.append(" left join t_bd_person p on w.fpersonid = p.fid");
        sql.append(" where w.fstatus = 1 order by w.fcreatetime desc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (int)start, (int)size);
        return WeiboAppDAO.createBindPersonList(rs);
    }

    private static List<WeiboBindPersonInfo> createBindPersonList(IRowSet rs) throws SQLException {
        ArrayList<WeiboBindPersonInfo> personList = new ArrayList<WeiboBindPersonInfo>();
        WeiboBindPersonInfo info = null;
        while (rs.next()) {
            info = new WeiboBindPersonInfo();
            info.setId(rs.getString("id"));
            info.setName(StringUtils.cnulls((String)rs.getString("name")));
            info.setEmail(rs.getString("email"));
            info.setVerified(!StringUtils.isEmpty((String)rs.getString("token")));
            personList.add(info);
        }
        return personList;
    }

    protected static IRowSet getUnCreatedPersonSet(Context ctx, String domain, int size) throws BOSException {
        String locale = ctx.getLocale().toString();
        StringBuilder sql = new StringBuilder();
        sql.append("select top ").append(size).append(" k.fid personId, k.fname_").append(locale);
        sql.append(" as personName, k.femail as email, p.fname_").append(locale);
        sql.append(" as position, a.fname_").append(locale);
        sql.append(" as org");
        sql.append(" from (select bp.fid, bp.femail, bp.fname_").append(locale);
        sql.append(" from t_bd_person bp,T_HR_BDEmployeeType et where bp.FEmployeeTypeID=et.fid and et.finservice='1' and bp.femail like '%@").append(domain).append("'");
        sql.append(" and bp.fid not in (select fpersonid  from t_bas_weibo where fpersonid is not null)) as k");
        sql.append(" left join T_ORG_Positionmember pm on pm.fpersonid = k.fid ");
        sql.append(" left join T_ORG_Position p  on p.fid = pm.fpositionid");
        sql.append(" left join  T_ORG_Admin a on a.fid =  p.fadminorgunitid");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    protected static int getUnCreatedPersonSetCount(Context ctx, String domain) throws BOSException, SQLException {
        String locale = ctx.getLocale().toString();
        StringBuilder sql = new StringBuilder();
        sql.append("select count(*) c");
        sql.append(" from (select fid, femail, fname_").append(locale);
        sql.append(" from t_bd_person where femail like '%@").append(domain).append("'");
        sql.append(" and fid not in (select fpersonid  from t_bas_weibo where fpersonid is not null)) as k");
        sql.append(" left join T_ORG_Positionmember pm on pm.fpersonid = k.fid ");
        sql.append(" left join T_ORG_Position p  on p.fid = pm.fpositionid");
        sql.append(" left join  T_ORG_Admin a on a.fid =  p.fadminorgunitid");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            return rs.getInt("c");
        }
        return 0;
    }

    protected static void deleteBindMapping(Context ctx, String personId) throws BOSException {
        String sql = "update t_bas_weibo set fstatus = 10  where fpersonid = ?";
        Object[] paramDel = new Object[]{personId};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])paramDel);
    }
}

