/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.weibo.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.weibo.app.WeiboAppDAO;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WeiboGlobal {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.weibo.app.WeiboGlobal");
    private static Map<String, String> domainMap = new HashMap<String, String>();
    private static Map<String, String> enableMap = new HashMap<String, String>();
    private static Map<String, String> weiboSystemTypeMap = new HashMap<String, String>();
    private static Map<String, String> weiboUrlMap = new HashMap<String, String>();
    private static String appKey = "";
    private static String appSecret = "";
    private static Map<String, Set<String>> weiboBillSetMap = new HashMap<String, Set<String>>();

    protected static void updateDomain(Context ctx, String domain) {
        try {
            WeiboAppDAO.updateDomain(ctx, domain);
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        domainMap.put(ctx.getAIS(), domain);
    }

    protected static void updateEnable(Context ctx, String enable) {
        try {
            WeiboAppDAO.updateEnable(ctx, enable);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        enableMap.put(ctx.getAIS(), enable);
    }

    protected static void updateWeiboSystem(Context ctx, String systemType, String testUrl) {
        try {
            WeiboAppDAO.updateWeiboSystem(ctx, systemType, testUrl);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        weiboSystemTypeMap.put(ctx.getAIS(), systemType);
        weiboUrlMap.put(ctx.getAIS(), null);
        String weiboUrl = WeiboGlobal.getWeiboUrl(ctx);
    }

    public static String getDomain(Context ctx) {
        String domain = domainMap.get(ctx.getAIS());
        if (StringUtils.isEmpty((String)domain)) {
            try {
                domain = WeiboAppDAO.getWeiboDomain(ctx);
                domainMap.put(ctx.getAIS(), domain);
            }
            catch (SQLException e) {
                logger.error((Object)"\u83b7\u53d6\u5fae\u535a\u7ed1\u5b9a\u57df\u540dsql\u51fa\u9519", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"\u83b7\u53d6\u5fae\u535a\u7ed1\u5b9a\u57df\u540dbos\u51fa\u9519", (Throwable)e);
            }
        }
        return domain;
    }

    public static String getEnable(Context ctx) {
        String enable = enableMap.get(ctx.getAIS());
        if (StringUtils.isEmpty((String)enable)) {
            try {
                enable = WeiboAppDAO.getWeiboEnable(ctx);
                enableMap.put(ctx.getAIS(), enable);
            }
            catch (SQLException e) {
                logger.error((Object)"\u83b7\u53d6\u5fae\u535a\u662f\u5426\u5f00\u901asql\u51fa\u9519", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"\u83b7\u53d6\u5fae\u535a\u662f\u5426\u5f00\u901abos\u51fa\u9519", (Throwable)e);
            }
        }
        return enable;
    }

    public static String getWeiboUrl(Context ctx) {
        String weiboUrl = weiboUrlMap.get(ctx.getAIS());
        if (StringUtils.isEmpty((String)weiboUrl)) {
            try {
                String weiboSystemType = WeiboGlobal.getWeiboSystemType(ctx);
                weiboUrl = "1".equals(weiboSystemType) ? WeiboAppDAO.getWeiboFormalUrl(ctx) : WeiboAppDAO.getWeiboTestUrl(ctx);
                weiboUrlMap.put(ctx.getAIS(), weiboUrl);
            }
            catch (SQLException e) {
                logger.error((Object)"\u83b7\u53d6\u5fae\u535a\u662f\u5426\u5f00\u901asql\u51fa\u9519", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"\u83b7\u53d6\u5fae\u535a\u662f\u5426\u5f00\u901abos\u51fa\u9519", (Throwable)e);
            }
        }
        return weiboUrl;
    }

    public static String getWeiboSystemType(Context ctx) {
        String weiboSystemType = weiboSystemTypeMap.get(ctx.getAIS());
        if (StringUtils.isEmpty((String)weiboSystemType)) {
            try {
                weiboSystemType = WeiboAppDAO.getWeiboSystemType(ctx);
                weiboSystemTypeMap.put(ctx.getAIS(), weiboSystemType);
            }
            catch (SQLException e) {
                logger.error((Object)"\u83b7\u53d6\u5fae\u535a\u662f\u5426\u5f00\u901asql\u51fa\u9519", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"\u83b7\u53d6\u5fae\u535a\u662f\u5426\u5f00\u901abos\u51fa\u9519", (Throwable)e);
            }
        }
        return weiboSystemType;
    }

    public static String getAppKey(Context ctx) {
        if (StringUtils.isEmpty((String)appKey)) {
            try {
                appKey = StringUtils.cnulls((String)WeiboAppDAO.getAppKey(ctx));
            }
            catch (SQLException e) {
                logger.error((Object)"\u83b7\u53d6\u5fae\u535aEAS\u5e94\u7528KEY\u503csql\u51fa\u9519", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"\u83b7\u53d6\u5fae\u535aEAS\u5e94\u7528KEY\u503cbos\u51fa\u9519", (Throwable)e);
            }
        }
        return appKey;
    }

    public static String getAppSecret(Context ctx) {
        if (StringUtils.isEmpty((String)appSecret)) {
            try {
                appSecret = StringUtils.cnulls((String)WeiboAppDAO.getAppSecret(ctx));
            }
            catch (SQLException e) {
                logger.error((Object)"\u83b7\u53d6\u5fae\u535aEAS\u5e94\u7528Secret\u503csql\u51fa\u9519", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"\u83b7\u53d6\u5fae\u535aEAS\u5e94\u7528Secret\u503cbos\u51fa\u9519", (Throwable)e);
            }
        }
        return appSecret;
    }

    public static Set<String> getWeiboBillSet(Context ctx) {
        Set weiboBillSet = weiboBillSetMap.get(ctx.getAIS());
        if (weiboBillSet == null) {
            try {
                weiboBillSet = WeiboAppDAO.getWeiboBillConfig(ctx);
                weiboBillSetMap.put(ctx.getAIS(), weiboBillSet);
            }
            catch (SQLException e) {
                logger.error((Object)"\u83b7\u53d6\u5fae\u535a\u5355\u636e\u914d\u7f6e\u96c6\u5408sql\u51fa\u9519", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"\u83b7\u53d6\u5fae\u535a\u5355\u636e\u914d\u7f6e\u96c6\u5408bos\u51fa\u9519", (Throwable)e);
            }
        }
        return weiboBillSet;
    }

    protected static void resetAndGetWeiboBillSet(Context ctx) {
        weiboBillSetMap.put(ctx.getAIS(), null);
        WeiboGlobal.getWeiboBillSet(ctx);
    }
}

