/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.weibo.wfevent;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.define.ActivityCollection;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ActivityEvent;
import com.kingdee.bos.workflow.define.ActivityType;
import com.kingdee.bos.workflow.define.StartActivityDef;
import com.kingdee.bos.workflow.define.extended.ApproveActivityDef;
import com.kingdee.bos.workflow.enactment.IWfActivity;
import com.kingdee.bos.workflow.enactment.IWfProcess;
import com.kingdee.bos.workflow.enactment.WfAssignment;
import com.kingdee.bos.workflow.enactment.handler.IActivityEventHandler;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.base.weibo.util.WeiboBizUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import weibo4j.Feed;

public class WeiBoWfActivityEventHandler
implements IActivityEventHandler {
    private static Logger log = Logger.getLogger((String)"com.kingdee.eas.base.weibo.wfevent.WeiBoWfActivityEventHandler");

    public void execute(ActivityEvent event, IWfActivity activity) throws Exception {
        try {
            Method method = WeiBoWfActivityEventHandler.class.getMethod("execute2", ActivityEvent.class, IWfActivity.class);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)this);
            txInvoker.invoke(method, new Object[]{event, activity}, 3);
        }
        catch (Throwable ex) {
            log.error((Object)ex.getMessage(), ex);
        }
    }

    private static void sendWhenProcessCreated(Context ctx, IWfActivity activity, ActivityDef actDef) throws Exception {
        IWfProcess process = activity.getProcess();
        String[] billids = process.getBizObjIds();
        if (billids != null) {
            for (int i = 0; i < billids.length; ++i) {
                if (StringUtils.isEmpty((String)billids[i])) continue;
                String tmp = WeiBoWfActivityEventHandler.getBindEmailByPersonId(ctx, process.getInstanceInfo().getInitiatorId());
                String userEmail = "";
                if (!StringUtils.isEmpty((String)tmp)) {
                    userEmail = userEmail + "<" + tmp + ">";
                }
                String content = userEmail + " \u542f\u52a8\u4e86\u6d41\u7a0b";
                WeiBoWfActivityEventHandler.postBillFeedMsg(ctx, billids[i], "", "ProcessInstanceCreated", content);
            }
        }
    }

    private static void sendWhenApproveCompleted(Context ctx, IWfActivity activity, ActivityDef actDef) throws Exception {
        List assigns = activity.getAssignments();
        HashMap<String, AssignmentInfo> assignsMap = new HashMap<String, AssignmentInfo>();
        String userNames = "";
        String userEmail = "";
        String userID = null;
        String billId = null;
        LinkedList<String> assignIdList = new LinkedList<String>();
        for (WfAssignment assign : assigns) {
            if (!WfAssignmentState.COMPLETED.equals((Object)assign.state())) continue;
            AssignmentInfo assignInfo = assign.getAssignmentInfo();
            assignIdList.add(assignInfo.getAssignmentId());
            assignsMap.put(assignInfo.getAssignmentId(), assignInfo);
        }
        log.info((Object)("WeiBoWfActivityEventHandler sendWhenApproveCompleted " + activity.getInstanceInfo().getActInstId() + " " + activity.getInstanceInfo().getActDefName(new Locale("l2")) + " assignIdList " + assignIdList.size()));
        if (assignIdList.size() == 0) {
            return;
        }
        StringBuffer oql = new StringBuffer();
        oql.append("where (assignment='").append(assignIdList.get(0)).append("')");
        int len = assignIdList.size();
        for (int i = 1; i < len; ++i) {
            oql.append(" OR (assignment='").append(assignIdList.get(i)).append("')");
        }
        IMultiApprove iMultiApprove = MultiApproveFactory.getLocalInstance((Context)ctx);
        MultiApproveCollection collection = iMultiApprove.getMultiApproveCollection(oql.toString());
        String actDefName = actDef.getName(new Locale("l2"));
        log.info((Object)("WeiBoWfActivityEventHandler sendWhenApproveCompleted " + activity.getInstanceInfo().getActInstId() + " " + activity.getInstanceInfo().getActDefName(new Locale("l2")) + " approve collection " + collection.size()));
        int len2 = collection.size();
        for (int i = 0; i < len2; ++i) {
            MultiApproveInfo approve = collection.get(i);
            AssignmentInfo assign = (AssignmentInfo)assignsMap.get(approve.getAssignment());
            userID = assign.getUserId();
            billId = assign.getBizObjectIds();
            WeiBoWfActivityEventHandler.subscribeBillFeed(ctx, billId, userID);
            String tmp = WeiBoWfActivityEventHandler.getBindEmailByPersonId(ctx, "" + assign.getEmployeeId());
            userEmail = "<" + tmp + ">";
            Feed feed = WeiBoWfActivityEventHandler.getStreamFeedDetail(ctx, billId);
            String content = userEmail + " \u5bf9\u672c\u5355\u636e\u8fdb\u884c\u4e86 " + actDefName + "\uff1a";
            String approveResult = "" + approve.getIsPass().getAlias(new Locale("l2"));
            String approveOpinion = approve.getOpinion(new Locale("l2"));
            if (approveOpinion == null) {
                approveOpinion = "";
            }
            if (approveResult.equals(approveOpinion)) {
                content = content + approveResult + "\u3002";
            } else {
                content = content + approveResult + "\u3002";
                content = content + approveOpinion;
            }
            WeiBoWfActivityEventHandler.postBillFeedMsg(ctx, billId, "", actDefName, content);
        }
    }

    private static void sendWhenManPowerCompleted(Context ctx, IWfActivity activity, ActivityDef actDef) throws Exception {
        List assigns = activity.getAssignments();
        String userNames = "";
        String userEmail = "";
        String userID = null;
        String billId = null;
        for (WfAssignment assign : assigns) {
            AssignmentInfo assignInfo;
            if (!WfAssignmentState.COMPLETED.equals((Object)assign.state()) || (assignInfo = assign.getAssignmentInfo()) == null) continue;
            if (userNames.length() > 0) {
                userNames = userNames + ",";
            }
            if (userEmail.length() > 0) {
                userEmail = userEmail + ",";
            }
            userNames = userNames + assignInfo.getUserName(new Locale("l2"));
            String tmp = WeiBoWfActivityEventHandler.getBindEmailByPersonId(ctx, assignInfo.getEmployeeId());
            if (!StringUtils.isEmpty((String)tmp)) {
                userEmail = userEmail + "<" + tmp + ">";
            }
            userID = assignInfo.getUserId();
            billId = assignInfo.getBizObjectIds();
            if (StringUtils.isEmpty((String)userID) || StringUtils.isEmpty((String)billId)) continue;
            WeiBoWfActivityEventHandler.subscribeBillFeed(ctx, billId, userID);
        }
        if (!StringUtils.isEmpty(userID) && !StringUtils.isEmpty(billId)) {
            String content = userEmail + " \u5bf9\u672c\u5355\u636e\u8fdb\u884c\u4e86 " + actDef.getName(new Locale("l2"));
            WeiBoWfActivityEventHandler.postBillFeedMsg(ctx, billId, "", actDef.getName(new Locale("l2")), content);
        }
    }

    private static void sendWhenProcessCompleted(Context ctx, IWfActivity activity, ActivityDef actDef) throws Exception {
        IWfProcess process = activity.getProcess();
        String[] billids = process.getBizObjIds();
        if (billids != null) {
            for (int i = 0; i < billids.length; ++i) {
                if (StringUtils.isEmpty((String)billids[i])) continue;
                String content = "\u672c\u5355\u636e\u7684\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f";
                WeiBoWfActivityEventHandler.postBillFeedMsg(ctx, billids[i], "", "ProcessInstanceCompleted", content);
                WeiBoWfActivityEventHandler.updateBillFeedState(ctx, billids[i], "\u5df2\u5b8c\u6210");
            }
        }
    }

    private static Feed getStreamFeedDetail(Context ctx, String billId) {
        try {
            return WeiboBizUtil.getStreamFeedDetail(ctx, billId, "1");
        }
        catch (Throwable ex) {
            log.error((Object)ex.getMessage(), ex);
            return null;
        }
    }

    private static String getBindEmailByPersonId(Context ctx, String personId) {
        try {
            return WeiboBizUtil.getBindEmailByPersonId(ctx, personId);
        }
        catch (Throwable ex) {
            log.error((Object)ex.getMessage(), ex);
            return "";
        }
    }

    private static void subscribeBillFeed(Context ctx, String billId, String userIds) {
    }

    private static void postBillFeedMsg(Context ctx, String billId, String userId, String verb, String content) {
        log.info((Object)(" WeiBoWfActivityEventHandler postBillFeedMsg " + billId + " " + userId + " " + verb + " " + content));
        try {
            WeiboBizUtil.postBillFeedMsg(ctx, billId, userId, verb, content);
        }
        catch (Throwable ex) {
            log.error((Object)ex.getMessage(), ex);
        }
    }

    private static void updateBillFeedState(Context ctx, String billId, String state) {
        log.info((Object)(" WeiBoWfActivityEventHandler postBillFeedMsg " + billId + " " + state));
        try {
            WeiboBizUtil.updateBillFeedState(ctx, billId, state);
        }
        catch (Throwable ex) {
            log.error((Object)ex.getMessage(), ex);
        }
    }

    public static void execute2(ActivityEvent event, IWfActivity activity) throws Exception {
        try {
            ActivityDef actDef;
            Context ctx = activity.getContext();
            if (!WeiboBizUtil.isWeiboEnable(ctx)) {
                return;
            }
            if (ActivityEvent.OnActivityComplete.equals((Object)event) && (actDef = activity.getDefinition()) != null && ActivityType.MANPOWER.equals((Object)actDef.getType())) {
                ActivityCollection actCol = actDef.getPreviousActivities();
                boolean isStart = false;
                if (actCol != null && activity.getProcess().getInstanceInfo().getParentActInstId() == null && activity.getProcess().getActivities().size() <= 2) {
                    for (ActivityDef tmpActDef : actCol) {
                        if (!(tmpActDef instanceof StartActivityDef)) continue;
                        isStart = true;
                        break;
                    }
                }
                if (!isStart) {
                    if (actDef instanceof ApproveActivityDef) {
                        WeiBoWfActivityEventHandler.sendWhenApproveCompleted(ctx, activity, actDef);
                    } else {
                        WeiBoWfActivityEventHandler.sendWhenManPowerCompleted(ctx, activity, actDef);
                    }
                }
            }
        }
        catch (Throwable ex) {
            log.error((Object)ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBillNumber(Context ctx, BOSUuid id) throws BOSException, SQLException {
        String string;
        Object bak = ctx.get((Object)"disablePermissionForKScript");
        IORMappingDAO dao = null;
        IObjectValue model = null;
        Connection cn = null;
        try {
            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
            ObjectUuidPK pk = new ObjectUuidPK(id);
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add("id");
            sc.add("number");
            cn = EJBFactory.getConnection((Context)ctx);
            dao = ORMappingDAO.getInstance((BOSObjectType)pk.getObjectType(), (Context)ctx, (Connection)cn);
            model = dao.getValue((IObjectPK)pk, sc, true);
            string = "" + model.get("number");
        }
        catch (Throwable throwable) {
            ctx.put((Object)"disablePermissionForKScript", bak);
            SQLUtils.cleanup(cn);
            throw throwable;
        }
        ctx.put((Object)"disablePermissionForKScript", bak);
        SQLUtils.cleanup((Connection)cn);
        return string;
    }
}

