/*
 * Decompiled with CFR 0.152.
 */
package weibo4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import weibo4j.WeiboException;
import weibo4j.WeiboResponse;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;

public class Picture
extends WeiboResponse
implements Serializable {
    private static final long serialVersionUID = 3746736775845364985L;
    public String thumbnail_pic;
    public String bmiddle_pic;
    public String original_pic;
    public String contentType;
    public String fileId;
    public String fileName;

    Picture(JSONObject json) throws WeiboException {
        try {
            this.bmiddle_pic = json.getString("bmiddle_pic");
            this.original_pic = json.getString("original_pic");
            this.thumbnail_pic = json.getString("thumbnail_pic");
        }
        catch (JSONException je) {
            throw new WeiboException(je.getMessage() + ":" + json.toString(), je);
        }
    }

    public static List<Picture> constructList(JSONArray picturesJsonList) throws WeiboException, JSONException {
        if (picturesJsonList != null) {
            int size = picturesJsonList.length();
            ArrayList<Picture> pics = new ArrayList<Picture>(size);
            for (int i = 0; i < size; ++i) {
                JSONObject json = picturesJsonList.getJSONObject(i);
                String _contentType = json.getString("contentType");
                if (_contentType == null || !_contentType.startsWith("image")) continue;
                pics.add(new Picture(picturesJsonList.getJSONObject(i)));
            }
            return pics;
        }
        return null;
    }
}

