/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.ShareTaskWebServiceConfig;
import com.kingdee.bos.workflow.WSContext;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.BillImageMapInfo;
import com.kingdee.eas.base.wssc.ConfigInfo;
import com.kingdee.eas.base.wssc.IBillImageMap;
import com.kingdee.eas.base.wssc.app.trd.webservice.WebServiceConfig;
import com.kingdee.eas.base.wssc.synImage.ImageStateSynFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.service.base.util.StringUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.log4j.Logger;

public class WSSCUtils {
    private static Logger logger = Logger.getLogger((String)WSSCUtils.class.getName());
    public static final String DPLOY_TYPE_INDEPENDENT = "1";
    public static final String DELETE_SSCLOGHST_SQL = "delete from T_wfr_sscloghst where fbillid = ? ";
    public static final String DELETE_SSCLOG_SQL = "delete from t_wfr_ssclog where fbillid = ? ";
    public static final StringBuffer DELETE_IHTENTRY_SQL = new StringBuffer().append("delete from t_wsc_imagehandletaskentry where fparentidid in (").append("select fid from t_wsc_imagehandletask where fbillid = ? ").append(")");
    public static final String DELETE_IHT_SQL = "delete from t_wsc_imagehandletask where fbillid = ? ";
    public static final String DELETE_BILLIMAGEMAP_SQL = "delete from t_wsc_billimagemap where fbillid = ? ";
    public static final String VALUE_WSC_CONFIG = "select fvalue from t_wsc_config where fname = ? ";
    public static final String INSERT_WSC_CONFIG = "INSERT INTO t_wsc_config(fid,fname,fvalue) VALUES (?,?,?)";
    public static final String UPDATE_WSC_CONFIG = "UPDATE t_wsc_config set fvalue=? where fname = ?";

    public static boolean isWebService(Context ctx, String sscNumber) throws BOSException {
        return DPLOY_TYPE_INDEPENDENT.equals(WSSCUtils.getDeployType(ctx, sscNumber));
    }

    public static String getDeployType(Context ctx, String sscNumber) throws BOSException {
        String re = "";
        try {
            re = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "deployType");
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return re;
    }

    @Deprecated
    public static WSContext loginEAS() throws BOSException {
        String cfgFileName = "sharetask_webservice.properties";
        String easLoginURL = WebServiceConfig.getPropertiesValue("eas.login.wsdl");
        String easLoginUser = WebServiceConfig.getPropertiesValue("userName");
        String easLoginPassword = WebServiceConfig.getPropertiesValue("password");
        String slnName = WebServiceConfig.getPropertiesValue("slnName");
        String easLoginDatacenter = WebServiceConfig.getPropertiesValue("dcName");
        String easLoginDbtype = WebServiceConfig.getPropertiesValue("dbType");
        String easLoginLanguage = WebServiceConfig.getPropertiesValue("language");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", easLoginUser);
        map.put("password", easLoginPassword);
        map.put("slnName", slnName);
        map.put("dcName", easLoginDatacenter);
        map.put("language ", easLoginLanguage);
        map.put("dbType", easLoginDbtype);
        JSONMap json = new JSONMap(map);
        String param = json.toString();
        WSContext result = new WSContext();
        try {
            Service s = new Service();
            Call call = (Call)s.createCall();
            call.setOperationName("login");
            call.setTargetEndpointAddress(easLoginURL);
            call.setReturnType(new QName("urn:client", "WSContext"));
            call.setReturnClass(WSContext.class);
            call.setReturnQName(new QName("", "loginReturn"));
            result = (WSContext)call.invoke(new Object[]{easLoginUser, easLoginPassword, slnName, easLoginDatacenter, easLoginLanguage, Integer.valueOf(easLoginDbtype)});
            result.setCall(call);
        }
        catch (Exception e) {
            logger.error((Object)("invoke createShareTask webservice error! serviceUrl:[" + easLoginURL + "]  OperationName:[login]  param:[" + param + "]"), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static WSContext loginEAS(Context ctx, String sscNumber) throws BOSException {
        if (StringUtils.isEmpty((String)sscNumber)) {
            sscNumber = "EAS";
        }
        String cfgFileName = "sharetask_webservice.properties";
        String easLoginURL = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "eas.login.wsdl");
        String easLoginUser = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "userName");
        String easLoginPassword = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "password");
        String slnName = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "slnName");
        String easLoginDatacenter = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "dcName");
        String easLoginDbtype = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "dbType");
        String easLoginLanguage = WebServiceConfig.getPropertiesValue(ctx, sscNumber, "language");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", easLoginUser);
        map.put("password", easLoginPassword);
        map.put("slnName", slnName);
        map.put("dcName", easLoginDatacenter);
        map.put("language ", easLoginLanguage);
        map.put("dbType", easLoginDbtype);
        JSONMap json = new JSONMap(map);
        String param = json.toString();
        WSContext result = new WSContext();
        try {
            Service s = new Service();
            Call call = (Call)s.createCall();
            call.setOperationName("login");
            call.setMaintainSession(true);
            call.setTargetEndpointAddress(easLoginURL);
            call.setReturnType(new QName("urn:client", "WSContext"));
            call.setReturnClass(WSContext.class);
            call.setReturnQName(new QName("", "loginReturn"));
            result = (WSContext)call.invoke(new Object[]{easLoginUser, easLoginPassword, slnName, easLoginDatacenter, easLoginLanguage, Integer.valueOf(easLoginDbtype)});
            result.setCall(call);
        }
        catch (Exception e) {
            logger.error((Object)("invoke createShareTask webservice error! serviceUrl:[" + easLoginURL.toString() + "]  OperationName:[login]  param:[" + param + "]"), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static void deleteWSSCAndWFRDataByBillID(Context ctx, String billID) throws BOSException {
        WSSCUtils.synImageStateTrigger(ctx, billID);
        DbUtil.execute((Context)ctx, (String)DELETE_SSCLOGHST_SQL, (Object[])new Object[]{billID});
        DbUtil.execute((Context)ctx, (String)DELETE_SSCLOG_SQL, (Object[])new Object[]{billID});
        DbUtil.execute((Context)ctx, (String)DELETE_IHTENTRY_SQL.toString(), (Object[])new Object[]{billID});
        DbUtil.execute((Context)ctx, (String)DELETE_IHT_SQL, (Object[])new Object[]{billID});
        DbUtil.execute((Context)ctx, (String)DELETE_BILLIMAGEMAP_SQL, (Object[])new Object[]{billID});
    }

    private static void synImageStateTrigger(Context ctx, String billID) throws BOSException {
        logger.error((Object)("enter the sys delete,billid=" + billID));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)billID));
        BillImageMapInfo billImageMapInfo = null;
        IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance(ctx);
        BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
        if (billImageMapCollection == null || billImageMapCollection.size() == 0) {
            String msg = " billID: " + billID + " not exist.";
            logger.error((Object)("eas\u5f71\u50cf\u5355\u636e\u6620\u5c04\u8868\u4fe1\u606f\u5df2\u4e0d\u5b58\u5728" + msg));
        } else {
            billImageMapInfo = billImageMapCollection.get(0);
            String extendBillID = billImageMapInfo.getExtendBillID();
            if (!StringUtils.isEmpty((String)extendBillID)) {
                ImageStateSynFactory.getHelperInstance(ctx, billImageMapInfo.getExtendName()).synImageStateTriggerDelete(ctx, extendBillID);
            }
        }
    }

    public static void deleteWSSCOnlyByBillID(Context ctx, String billID) throws BOSException {
        DbUtil.execute((Context)ctx, (String)DELETE_IHTENTRY_SQL.toString(), (Object[])new Object[]{billID});
        DbUtil.execute((Context)ctx, (String)DELETE_IHT_SQL, (Object[])new Object[]{billID});
        DbUtil.execute((Context)ctx, (String)DELETE_BILLIMAGEMAP_SQL, (Object[])new Object[]{billID});
    }

    public static String getSSCNumberByImageNb(Context ctx, String imageNb) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("where imageNumber = '").append(imageNb).append("'");
        try {
            BillImageMapCollection collection = BillImageMapFactory.getLocalInstance(ctx).getBillImageMapCollection(sb.toString());
            if (null != collection && collection.size() > 0) {
                BillImageMapInfo billImage = collection.get(0);
                return WSSCUtils.getSSCNumberByBillId(ctx, billImage.getBillID());
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return "EAS";
        }
        return "EAS";
    }

    private static String getProcInstId(Context ctx, String billId) {
        ProcessInstInfo instInfo = null;
        try {
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
            ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(billId);
            logger.error((Object)("procInsts.length:" + procInsts.length));
            if (procInsts.length == 0) {
                return null;
            }
            ProcessInstInfo lastUpdateProIns = procInsts[0];
            int n = procInsts.length;
            for (int i = 0; i < n; ++i) {
                logger.error((Object)("procInsts[i].getCode():" + procInsts[i].getCode() + ";procInsts[i].getStat():" + procInsts[i].getState()));
                if (lastUpdateProIns.getLastStateTime().getTime() <= procInsts[i].getLastStateTime().getTime()) {
                    lastUpdateProIns = procInsts[i];
                }
                if (!"open.running".equals(procInsts[i].getState()) && !"open.not_running.suspended".equals(procInsts[i].getState())) continue;
                instInfo = procInsts[i];
                return instInfo.getProcInstId();
            }
            return lastUpdateProIns.getProcInstId();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getSSCNumber(Context ctx, String procInstId) {
        try {
            EnactmentServiceProxy service = new EnactmentServiceProxy(ctx);
            String shareCenterParamMapVarableName = ShareTaskWebServiceConfig.getPropertiesValue((String)"sharetask_webservice.properties", (String)"createTaskProcessVarableName");
            logger.info((Object)("com.kingdee.bos.workflow.AssignReadListenerExt  deployType: shareCenterParamMapVarableName:" + shareCenterParamMapVarableName));
            Object obj = service.getProcessContext(procInstId, shareCenterParamMapVarableName);
            if (null == obj) {
                return "EAS";
            }
            HashMap map = (HashMap)obj;
            return (String)map.get("sscNumber");
        }
        catch (Exception e) {
            logger.error((Object)e);
            return "EAS";
        }
    }

    public static String getSSCNumberByBillId(Context ctx, String billId) {
        try {
            String procInstId = WSSCUtils.getProcInstId(ctx, billId);
            if (null != procInstId) {
                return WSSCUtils.getSSCNumber(ctx, procInstId);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return "EAS";
    }

    public static String getConfigValue(Context ctx, String key) {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)VALUE_WSC_CONFIG, (Object[])new Object[]{key});
            if (rs.next()) {
                return rs.getString("fvalue");
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)key, (Throwable)e);
        }
        return null;
    }

    public static void insertConfig(Context ctx, String key, String value) {
        try {
            DbUtil.execute((Context)ctx, (String)INSERT_WSC_CONFIG, (Object[])new Object[]{BOSUuid.create((BOSObjectType)new ConfigInfo().getBOSType()), key, value});
        }
        catch (BOSException e) {
            logger.error((Object)(key + ":" + value), (Throwable)e);
        }
    }

    public static void updateConfig(Context ctx, String key, String value) {
        try {
            DbUtil.execute((Context)ctx, (String)UPDATE_WSC_CONFIG, (Object[])new Object[]{key, value});
        }
        catch (BOSException e) {
            logger.error((Object)(key + ":" + value), (Throwable)e);
        }
    }

    public static boolean isDKWSImageUrlRescan(Context ctx) {
        String value = WSSCUtils.getConfigValue(ctx, "DKWS_VIEWIMAGE_RESCAN");
        if (StringUtils.isEmpty((String)value)) {
            WSSCUtils.insertConfig(ctx, "DKWS_VIEWIMAGE_RESCAN", DPLOY_TYPE_INDEPENDENT);
            return true;
        }
        return DPLOY_TYPE_INDEPENDENT.equalsIgnoreCase(value);
    }

    public static String getViewUserName(Context ctx) {
        String viewUserName = ctx.getUserName();
        if (StringUtils.isEmpty((String)viewUserName)) {
            try {
                viewUserName = UserFactory.getLocalInstance((Context)ctx).getUserByID(ctx.getCaller()).getNumber();
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return viewUserName;
    }
}

