/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.imageNew.util;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public class HttpPostUtil {
    private static Logger logger = Logger.getLogger(HttpPostUtil.class);

    public static String postInterface(String url, String params, boolean outPutLog) throws Exception {
        if (outPutLog) {
            logger.error((Object)("url[" + url + "]--params[" + params + "]"));
        } else {
            logger.debug((Object)("url[" + url + "]--params[" + params + "]"));
        }
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-Type", "application/json");
        String charSet = "UTF-8";
        StringEntity entity = new StringEntity(params, charSet);
        entity.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
        entity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
            StatusLine status = response.getStatusLine();
            int state = status.getStatusCode();
            if (outPutLog) {
                logger.error((Object)("response--state:" + state));
            } else {
                logger.debug((Object)("response--state:" + state));
            }
            HttpEntity responseEntity = response.getEntity();
            String jsonString = EntityUtils.toString((HttpEntity)responseEntity);
            if (outPutLog) {
                logger.error((Object)("response--jsonString:" + jsonString));
            } else {
                logger.debug((Object)("response--jsonString:" + jsonString));
            }
            if (state == 404) {
                throw new Exception("URL:" + url + ";HttpStatusCode:" + status.toString());
            }
            String string = jsonString;
            return string;
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
            try {
                httpclient.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    public static String postInterface(String url, Map<String, String> params, File fileContent, String fileParamName, Boolean outPutLog) throws Exception {
        if (outPutLog.booleanValue()) {
            logger.error((Object)("url[" + url + "]--params[" + params + "]"));
        } else {
            logger.debug((Object)("url[" + url + "]--params[" + params + "]"));
        }
        if (fileContent == null) {
            return HttpPostUtil.postInterface(url, params.toString(), outPutLog);
        }
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            Charset charset = Charset.forName("UTF-8");
            httpClient = HttpClientBuilder.create().build();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("accept", "*/*");
            MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.STRICT, null, charset);
            Iterator<Map.Entry<String, String>> iterator = params.entrySet().iterator();
            multipartEntity.addPart(fileParamName, (ContentBody)new FileBody(fileContent));
            while (iterator.hasNext()) {
                Map.Entry<String, String> param = iterator.next();
                multipartEntity.addPart(param.getKey(), (ContentBody)new StringBody(param.getValue(), charset));
            }
            httpPost.setEntity((HttpEntity)multipartEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            StatusLine status = response.getStatusLine();
            int state = status.getStatusCode();
            if (outPutLog.booleanValue()) {
                logger.error((Object)("response--state:" + state));
            } else {
                logger.debug((Object)("response--state:" + state));
            }
            HttpEntity responseEntity = response.getEntity();
            String jsonString = EntityUtils.toString((HttpEntity)responseEntity);
            if (outPutLog.booleanValue()) {
                logger.error((Object)("response--jsonString:" + jsonString));
            } else {
                logger.debug((Object)("response--jsonString:" + jsonString));
            }
            if (state == 404) {
                throw new Exception("URL:" + url + ";HttpStatusCode:" + status.toString());
            }
            String string = jsonString;
            return string;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
            try {
                httpClient.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }
}

