/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class PermissionOrgUtil {
    private static Logger logger = Logger.getLogger(PermissionOrgUtil.class);

    public static Set<String> getHasPermissionOrg(Context ctx, String pmUserId, String permissionNumber) throws EASBizException, BOSException {
        return PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(pmUserId), OrgType.Company, null, permissionNumber);
    }

    public static FullOrgUnitCollection getHasPermissionBizOrg(Context ctx, String pmUserId, String permissionNumber) throws EASBizException, BOSException {
        EntityViewInfo entryView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("unit.isCompanyOrgUnit", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("unit.partFI.IsBizUnit", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("unit.partFI.IsSealUp", (Object)false));
        entryView.setFilter(filter);
        return PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg((IObjectPK)new ObjectUuidPK(pmUserId), OrgType.Company, null, permissionNumber, entryView);
    }

    public static Set<String> getHasPermissionSCOrg(Context ctx, String pmUserId, String permissionNumber) throws EASBizException, BOSException {
        return PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(pmUserId), OrgType.ShareCenterOrgType, null, permissionNumber);
    }

    public static String getCompanyOrgIDByShareCenterID(Context ctx, String shareCenterID) throws BOSException, EASBizException {
        String sql = "select FTOUNITID from T_ORG_UNITRELATION where FTYPERELATIONID = ? and FFROMUNITID = ?";
        String orgID = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{"hZewdKNBa73gUzA/qMBwPw/p+LU=", shareCenterID});
            if (rs.next()) {
                orgID = rs.getString(1);
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u67e5\u8be2shareCenterID:" + shareCenterID + "\u5bf9\u5e94\u7684\u884c\u653f\u7ec4\u7ec7\u59d4\u6258\u51fa\u73b0\u5f02\u5e38,\u5c06\u8fd4\u56de\u7a7a.ctx.getAIS():" + ctx.getAIS()), (Throwable)e);
        }
        return orgID;
    }

    public static boolean hasPermission(Context ctx, String shareCenterId, String permissionName) throws EASBizException, BOSException {
        return PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(ctx.getCaller().toString()), (IObjectPK)new ObjectUuidPK(shareCenterId), permissionName);
    }
}

