/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.basesync.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.xtsync.trdsync.SyncHighItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncServiceFactory;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncServiceFactoryHelper;
import com.kingdee.eas.base.xtsync.trdsync.basesync.app.AbstractBaseSyncFacadeControllerBean;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.BaseSyncHelperImpFactory;
import com.kingdee.eas.base.xtsync.xtutil.EasXtCommonUtils;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.PageResult;
import com.kingdee.eas.base.xtsync.xtutil.PrivacyProtectUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class BaseSyncFacadeControllerBean
extends AbstractBaseSyncFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.trdsync.basesync.app.BaseSyncFacadeControllerBean");

    @Override
    protected String _sync(Context ctx, int type, String syncItemType) throws BOSException, EASBizException {
        if (syncItemType.equalsIgnoreCase("check")) {
            String privacyType = "";
            switch (type) {
                case 0: {
                    privacyType = "wx";
                    break;
                }
                case 1: {
                    privacyType = "dd";
                    break;
                }
                case 2: {
                    privacyType = "wl";
                }
            }
            if (!StringUtils.isEmpty((CharSequence)privacyType)) {
                PrivacyProtectUtil.checkPrivacyBefore(ctx, privacyType);
            }
            String sql = "insert into t_bs_synchtime (fid,fsynchtime,ftype) select newbosid('F4AF4F04'),now()," + type;
            EasXtSyncUtil.execute(ctx, sql);
            return "true";
        }
        return SyncServiceFactory.getInstance(ctx, type, syncItemType).sync(syncItemType);
    }

    @Override
    protected Map _getConfig(Context ctx, String type) throws BOSException, EASBizException {
        Map config = BaseSyncHelperImpFactory.getInstance(ctx, Integer.parseInt(type)).getConfig();
        return config;
    }

    @Override
    protected String _getSyncLogs(Context ctx, String condition, int type, String highItemType) throws BOSException, EASBizException {
        SyncContext syncCtx = SyncServiceFactoryHelper.getSyncServiceFactoryHelper(type).getSyncContextByType(SyncHighItemType.getEnum(highItemType), type);
        syncCtx.setCtx(ctx);
        return BaseSyncHelperImpFactory.getInstance(ctx, type).getSyncLogs(syncCtx, condition);
    }

    @Override
    protected String _getAllSyncRecordsCount(Context ctx, String syncTimeId, int type) throws BOSException, EASBizException {
        SyncContext syncCtx = new SyncContext();
        syncCtx.setCtx(ctx);
        syncCtx.setFSyncTimeID(syncTimeId);
        Map result = BaseSyncHelperImpFactory.getInstance(ctx, type).getSyncRecordMap(syncCtx);
        return JSONObject.fromObject((Object)result).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _getSyncRecords(Context ctx, String condition) throws BOSException, EASBizException {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        int page = o.getIntValue("page");
        int rowCount = o.getIntValue("rowCount");
        int type = o.getIntValue("type");
        String sql = "select fid, fsynchtime from t_bs_synchtime WHERE FTYPE = " + type;
        IRowSet rsCount = EasXtSyncUtil.executeQuery(ctx, "select count(0) from (" + sql + ") synctime");
        sql = sql + "order by fsynchtime desc";
        IRowSet rs = EasXtSyncUtil.executeQuery(ctx, sql, (page - 1) * rowCount, rowCount);
        ArrayList list = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        int index = 1;
        int total = 0;
        try {
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            while (rs.next()) {
                map = new HashMap();
                Timestamp synchtime = rs.getTimestamp("fsynchtime");
                map.put("index", index);
                map.put("id", rs.getString("fid"));
                map.put("synchtime", EasXtCommonUtils.formLongTimeString(synchtime));
                map.put("btnmore", "<a href='javascript:void(0);' class='btn-more' onclick=''>\u5c55\u5f00\u8be6\u60c5</a>");
                list.add(map);
                ++index;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rsCount != null) {
                try {
                    rsCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, list);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    @Override
    protected String _getAllSyncLogs(Context ctx, String condition, int type) throws BOSException, EASBizException {
        com.alibaba.fastjson.JSONObject param = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String subAction = param.getString("subAction");
        SyncHighItemType highItemType = null;
        if ("viewOrgLog".equalsIgnoreCase(subAction) || "viewXtOrg".equalsIgnoreCase(subAction)) {
            highItemType = SyncHighItemType.Dept;
        } else if ("viewPersonLog".equalsIgnoreCase(subAction) || "viewXtUser".equalsIgnoreCase(subAction)) {
            highItemType = SyncHighItemType.Person;
        } else if ("viewDeptLeaderLog".equalsIgnoreCase(subAction)) {
            highItemType = SyncHighItemType.DeptLeader;
        } else if ("viewPartJobLog".equalsIgnoreCase(subAction)) {
            highItemType = SyncHighItemType.PartJob;
        } else if ("viewRelationsLog".equalsIgnoreCase(subAction)) {
            highItemType = SyncHighItemType.Relations;
        }
        if (highItemType == null) {
            return null;
        }
        SyncContext syncCtx = SyncServiceFactoryHelper.getSyncServiceFactoryHelper(type).getSyncContextByType(highItemType, type);
        syncCtx.setCtx(ctx);
        if ("viewXtOrg".equalsIgnoreCase(subAction)) {
            return BaseSyncHelperImpFactory.getInstance(ctx, type).getAllXtOrg(syncCtx, condition);
        }
        if ("viewXtUser".equalsIgnoreCase(subAction)) {
            return BaseSyncHelperImpFactory.getInstance(ctx, type).getAllXtUser(syncCtx, condition);
        }
        param.put("highItemType", (Object)highItemType.getValue());
        return BaseSyncHelperImpFactory.getInstance(ctx, type).getAllSyncLogs(syncCtx, param.toString());
    }

    @Override
    protected String _exportFilterData(Context ctx, String condition, int type) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String _getAllEasDatas(Context ctx, String condition, int type, String highType) throws BOSException {
        com.alibaba.fastjson.JSONObject param = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        SyncHighItemType hiType = null;
        if (highType.equalsIgnoreCase("Person")) {
            hiType = SyncHighItemType.Person;
        } else if (highType.equalsIgnoreCase("Dept")) {
            hiType = SyncHighItemType.Dept;
        } else if (highType.equalsIgnoreCase("DeptLeader")) {
            hiType = SyncHighItemType.DeptLeader;
        } else if (highType.equalsIgnoreCase("PartJob")) {
            hiType = SyncHighItemType.PartJob;
        } else if (highType.equalsIgnoreCase("Relations")) {
            hiType = SyncHighItemType.Relations;
        }
        if (hiType == null) {
            return null;
        }
        SyncContext syncCtx = SyncServiceFactoryHelper.getSyncServiceFactoryHelper(type).getSyncContextByType(hiType, type);
        syncCtx.setCtx(ctx);
        param.put("highItemType", (Object)hiType.getValue());
        return BaseSyncHelperImpFactory.getInstance(ctx, type).getAllEasDatas(syncCtx, param);
    }

    @Override
    protected boolean _handDownloadXtData(Context ctx, int type) throws BOSException, EASBizException {
        BaseSyncHelperImpFactory.getInstance(ctx, type).getConfig();
        SyncServiceFactory.getInstance(ctx, type, "DeptSyncBefore").sync("DeptSyncBefore");
        SyncServiceFactory.getInstance(ctx, type, "DeptSyncBefore").dataBind();
        SyncServiceFactory.getInstance(ctx, type, "PersonSyncBefore").sync("PersonSyncBefore");
        SyncServiceFactory.getInstance(ctx, type, "PersonSyncBefore").dataBind();
        if (type == 1) {
            return true;
        }
        SyncServiceFactory.getInstance(ctx, type, "DeptLeaderSyncBefore").sync("DeptLeaderSyncBefore");
        SyncServiceFactory.getInstance(ctx, type, "PartJobSyncBefore").sync("PartJobSyncBefore");
        return true;
    }

    @Override
    protected void _autoSync(Context ctx) throws BOSException {
    }
}

