/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.wlsync.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.xtsync.trdsync.SyncHighItemType;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.AbstactBaseSyncHelper;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncLogUtils;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.WLSyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncConfigUtil;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WLSyncHelper
extends AbstactBaseSyncHelper {
    private Context ctx = null;
    private static Map<String, Map> config = new HashMap<String, Map>();
    private static Map<String, JSONObject> hwConfig = new HashMap<String, JSONObject>();

    public WLSyncHelper(Context ctx) {
        this.ctx = ctx;
    }

    public WLSyncHelper() {
    }

    @Override
    protected String getBaseSql(SyncHighItemType highItemType) throws BOSException {
        String sql = null;
        if (SyncHighItemType.Dept.equals((Object)highItemType)) {
            sql = WLSyncConfigUtil.getInstance().getValue("getDeptSyncLog");
        } else if (SyncHighItemType.Person.equals((Object)highItemType)) {
            sql = WLSyncConfigUtil.getInstance().getValue("getPersonSyncLog");
        } else if (SyncHighItemType.PartJob.equals((Object)highItemType)) {
            sql = WLSyncConfigUtil.getInstance().getValue("getPartSyncLog");
        } else if (SyncHighItemType.DeptLeader.equals((Object)highItemType)) {
            sql = WLSyncConfigUtil.getInstance().getValue("getOrgLeaderSyncLog");
        }
        return sql;
    }

    @Override
    protected Map getSyncLogColBase(String syncType) {
        String[] baseCol = null;
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(syncType);
        if (baseType != null) {
            String syncTypeValue = baseType.getValue();
            if (SyncItemType.UpdateOrgName.equals((Object)baseType)) {
                baseCol = new String[]{"fid", "foldorglongname", "forglongname", "ferrormsg"};
                HashMap<String, Object> syncLogMap = new HashMap<String, Object>();
                syncLogMap.put("syncLogCol", baseCol);
                syncLogMap.put("syncTypeValue", syncTypeValue);
                return syncLogMap;
            }
            if (SyncItemType.UpdatePersonName.equals((Object)baseType)) {
                baseCol = new String[]{"fid", "fpersonname", "ferrormsg"};
                HashMap<String, Object> syncLogMap = new HashMap<String, Object>();
                syncLogMap.put("syncLogCol", baseCol);
                syncLogMap.put("syncTypeValue", syncTypeValue);
                return syncLogMap;
            }
            if (SyncItemType.AddNewPerson.equals((Object)baseType)) {
                baseCol = new String[]{"fid", "fpersonname", "fcell", "femail", "forglongname", "fposition", "fgender", "faddress", "finservice", "ferrormsg", "fisbindsucc"};
                HashMap<String, Object> syncLogMap = new HashMap<String, Object>();
                syncLogMap.put("syncLogCol", baseCol);
                syncLogMap.put("syncTypeValue", syncTypeValue);
                return syncLogMap;
            }
            return super.getSyncLogColBase(syncType);
        }
        WLSyncItemType WLSyncType = WLSyncUtil.getWLSyncEnum(syncType);
        String syncValue = WLSyncType.getValue();
        switch (Integer.parseInt(syncValue)) {
            case 100: {
                baseCol = new String[]{"fid", "fpersonname", "fcell", "forglongname", "fjobtitles", "ferrormsg"};
                break;
            }
            case 101: {
                baseCol = new String[]{"fid", "forgname", "forglongname", "fpersonnames", "ferrormsg"};
            }
        }
        HashMap<String, Object> syncLogMap = new HashMap<String, Object>();
        syncLogMap.put("syncLogCol", baseCol);
        syncLogMap.put("syncTypeValue", syncValue);
        return syncLogMap;
    }

    @Override
    protected Map getExportColName(SyncContext syncCtx, String syncType, String subAction) {
        if ("viewOrgLog".equalsIgnoreCase(subAction)) {
            return this.getAllSyncLogColBase(syncType, subAction);
        }
        if ("viewPersonLog".equalsIgnoreCase(subAction)) {
            return this.getAllSyncLogColBase(syncType, subAction);
        }
        if ("viewDeptLeaderLog".equalsIgnoreCase(subAction)) {
            return this.getAllSyncLogColBase("BatchUpdateDeptLeader", subAction);
        }
        if ("viewPartJobLog".equalsIgnoreCase(subAction)) {
            return this.getAllSyncLogColBase("BatchUpdatePersonPartJob", subAction);
        }
        return null;
    }

    @Override
    protected Map getAllSyncLogColBase(String syncType, String subAction) {
        String[] baseCol = null;
        String syncValue = null;
        WLSyncItemType WLSyncType = WLSyncUtil.getWLSyncEnum(syncType);
        if (WLSyncType != null) {
            syncValue = WLSyncType.getValue();
            switch (Integer.parseInt(syncValue)) {
                case 100: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "forglongname", "fjobtitles", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 101: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "forgname", "forglongname", "fpersonnames", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                }
            }
        } else {
            return super.getAllSyncLogColBase(syncType, subAction);
        }
        HashMap<String, Object> syncLogMap = new HashMap<String, Object>();
        syncLogMap.put("syncLogCol", baseCol);
        syncLogMap.put("syncTypeValue", syncValue);
        return syncLogMap;
    }

    @Override
    public Map getConfig() {
        HashMap<String, String> config = new HashMap<String, String>();
        String sql = "SELECT TOP 1 FSettingMsg FROM T_BS_SYNCSAVESETTING WHERE FTYPE = 2 ORDER BY FCreateTime DESC ";
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            if (iRowSet != null && iRowSet.next()) {
                String settingMsg = iRowSet.getString("FSettingMsg");
                if (StringUtils.isEmpty((String)settingMsg)) {
                    config.put("mCloud", "https://open.welink.huaweicloud.com");
                } else {
                    String[] str = settingMsg.split(";");
                    for (int i = 0; i < str.length; ++i) {
                        String[] val = str[i].split("&&");
                        String configKey = val[0];
                        String configValue = "0";
                        if (val.length > 1) {
                            configValue = val[1];
                        }
                        config.put(configKey, configValue);
                    }
                }
            } else {
                config.put("mCloud", "https://open.welink.huaweicloud.com");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return config;
    }

    public static Map getConfig(Context ctx) {
        if (config.get(ctx.getAIS()) != null) {
            return config.get(ctx.getAIS());
        }
        HashMap<String, String> config0 = new HashMap<String, String>();
        String sql = "SELECT TOP 1 FSettingMsg FROM T_BS_SYNCSAVESETTING WHERE FTYPE = 2 ORDER BY FCreateTime DESC ";
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (iRowSet != null && iRowSet.next()) {
                String settingMsg = iRowSet.getString("FSettingMsg");
                if (StringUtils.isEmpty((String)settingMsg)) {
                    config0.put("mCloud", "https://open.welink.huaweicloud.com");
                } else {
                    String[] str = settingMsg.split(";");
                    for (int i = 0; i < str.length; ++i) {
                        String[] val = str[i].split("&&");
                        String configKey = val[0];
                        String configValue = "0";
                        if (val.length > 1) {
                            configValue = val[1];
                        }
                        config0.put(configKey, configValue);
                    }
                }
            } else {
                config0.put("mCloud", "https://open.welink.huaweicloud.com");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return config0;
    }

    public boolean saveConfig(Context ctx, Map map, boolean isInit) {
        hwConfig.remove(ctx.getAIS());
        config.remove(ctx.getAIS());
        boolean flag = false;
        if (map == null) {
            return flag;
        }
        if (ctx != null) {
            StringBuffer setting = new StringBuffer();
            map.put("dbCode", ctx.getAIS());
            boolean sFlag = false;
            String secret = "";
            for (Object key : map.keySet()) {
                if ("secret".equalsIgnoreCase(key.toString()) && StringUtils.isEmpty((String)((String)map.get(key)))) {
                    Map config2 = WLSyncHelper.getConfig(ctx);
                    secret = config2.get("secret").toString();
                    setting.append(key.toString() + "&&" + secret + ";");
                    sFlag = true;
                    continue;
                }
                setting.append(key.toString() + "&&" + map.get(key) + ";");
            }
            String detailLogMsg = this.getDetailLogMsg(map, WLSyncHelper.getConfig(ctx));
            detailLogMsg = "\u540c\u6b65\u5de5\u5177(WeLink)-\u4fee\u6539\u540c\u6b65\u53c2\u6570: \r\n" + detailLogMsg;
            String companyId = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
            IObjectPK beginLog = LogUtil.beginLog((Context)ctx, (String)"\u540c\u6b65\u5de5\u5177(WeLink)-\u4fee\u6539\u540c\u6b65\u53c2\u6570", (BOSObjectType)new BOSObjectType("F4AF4F04"), (IObjectPK)ctx.getCaller(), (String)detailLogMsg, (String)"XTSync_Operate", (String)companyId);
            if (null != beginLog) {
                String sql = "update T_LOG_App set FENTITYALIAS_L2 = '\u540c\u6b65\u5de5\u5177' where fid = '" + beginLog.toString() + "'";
                try {
                    DbUtil.execute((Context)ctx, (String)sql);
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            this.saveSetting(ctx, setting.toString());
            LogUtil.afterLog((Context)ctx, (IObjectPK)beginLog);
            flag = true;
            if (sFlag) {
                map.put("secret", secret);
            }
            config.put(ctx.getAIS(), map);
        }
        return true;
    }

    public static JSONObject getHWConfig(Context ctx) {
        if (hwConfig.get(ctx.getAIS()) == null) {
            JSONObject config = new JSONObject();
            Map config2 = WLSyncHelper.getConfig(ctx);
            config.put("hwid", config2.get("hwid"));
            config.put("hwappkey", config2.get("hwappkey"));
            hwConfig.put(ctx.getAIS(), config);
        }
        return hwConfig.get(ctx.getAIS());
    }

    private void saveSetting(Context ctx, String setting) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_BS_SYNCSAVESETTING(FID,FSettingMsg,FType,FCreateTime) values(?,?,?,?)");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(BOSUuid.create((String)"F4AF4F04").toString());
        param.add(setting);
        param.add(2);
        param.add(new Timestamp(new Date().getTime()));
        params.add(param.toArray());
        try {
            DbUtil.executeBatch((Context)ctx, (String)sql.toString(), params);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map getSyncRecordMap(SyncContext syncCtx) throws BOSException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String[] syncTypeOName = new String[]{"UpdateOrgName", "AddNewOrg", "MoveOrg", "DeleteOrg", "SetOrgWeights"};
        String[] syncTypeOValue = new String[]{"3", "1", "4", "2", "5"};
        syncCtx.setLogTableName("T_WL_SYNCDEPTLOG");
        for (int i = 0; i < syncTypeOName.length; ++i) {
            map.put(syncTypeOName[i], SyncLogUtils.getSyncLogCount(syncCtx, syncTypeOValue[i], syncCtx.getFSyncTimeID(), null, true));
            map.put(syncTypeOName[i] + "1", SyncLogUtils.getSyncLogCount(syncCtx, syncTypeOValue[i], syncCtx.getFSyncTimeID(), null, false));
        }
        String[] syncTypePName = new String[]{"UpdatePersonCell", "UpdatePersonEmail", "UpdatePersonOrg", "UpdatePersonName", "UpdatePersonGender", "UpdatePersonPosition", "UpdatePersonTelephone", "UpdatePersonAddress", "UpdatePersonNumber", "UpdatePersonWeights", "UpdatePersonCustom", "DeletePerson", "AddNewPerson"};
        String[] syncTypePValue = new String[]{"15", "13", "9", "11", "16", "10", "14", "12", "17", "19", "21", "7", "6"};
        syncCtx.setLogTableName("T_WL_SYNCPERSONLOG");
        for (int i = 0; i < syncTypePName.length; ++i) {
            map.put(syncTypePName[i], SyncLogUtils.getSyncLogCount(syncCtx, syncTypePValue[i], syncCtx.getFSyncTimeID(), null, true));
            map.put(syncTypePName[i] + "1", SyncLogUtils.getSyncLogCount(syncCtx, syncTypePValue[i], syncCtx.getFSyncTimeID(), null, false));
        }
        String[] syncTypePartName = new String[]{"BatchUpdatePersonPartJob"};
        String[] syncTypePartValue = new String[]{"100"};
        syncCtx.setLogTableName("T_WL_SYNCPARTLOG");
        for (int i = 0; i < syncTypePartName.length; ++i) {
            map.put(syncTypePartName[i], SyncLogUtils.getSyncLogCount(syncCtx, syncTypePartValue[i], syncCtx.getFSyncTimeID(), null, true));
            map.put(syncTypePartName[i] + "1", SyncLogUtils.getSyncLogCount(syncCtx, syncTypePartValue[i], syncCtx.getFSyncTimeID(), null, false));
        }
        String[] syncTypeLeaderName = new String[]{"BatchUpdateDeptLeader"};
        String[] syncTypeLeaderValue = new String[]{"101"};
        syncCtx.setLogTableName("T_WL_SYNCORGLEADERLOG");
        for (int i = 0; i < syncTypeLeaderName.length; ++i) {
            map.put(syncTypeLeaderName[i], SyncLogUtils.getSyncLogCount(syncCtx, syncTypeLeaderValue[i], syncCtx.getFSyncTimeID(), null, true));
            map.put(syncTypeLeaderName[i] + "1", SyncLogUtils.getSyncLogCount(syncCtx, syncTypeLeaderValue[i], syncCtx.getFSyncTimeID(), null, false));
        }
        return map;
    }

    @Override
    public String[] getFilterColName(SyncHighItemType highItemType, boolean isAll) {
        String[] filterColName = null;
        if (SyncHighItemType.Dept.equals((Object)highItemType)) {
            filterColName = new String[]{"forglongname", "foldorglongname"};
            return filterColName;
        }
        if (SyncHighItemType.Person.equals((Object)highItemType)) {
            filterColName = new String[]{"fpersonname", "fcell", "femail", "forglongname", "fposition", "ftelephone", "faddress"};
            return filterColName;
        }
        if (SyncHighItemType.PartJob.equals((Object)highItemType)) {
            filterColName = new String[]{"fpersonname", "fcell", "forglongname", "fjobtitles"};
            return filterColName;
        }
        if (SyncHighItemType.DeptLeader.equals((Object)highItemType)) {
            filterColName = new String[]{"fname", "forglongname", "fpersonnames"};
            return filterColName;
        }
        return null;
    }

    @Override
    protected String buildFilterSql(String[] filterColName, String filter, SyncHighItemType highItemType) {
        StringBuilder sql = new StringBuilder();
        if (SyncHighItemType.PartJob.equals((Object)highItemType) || SyncHighItemType.DeptLeader.equals((Object)highItemType)) {
            sql.append(" AND (umap." + filterColName[0] + " like '%" + filter + "%'");
            for (int i = 1; i < filterColName.length; ++i) {
                if ("FPERSONNAME".equalsIgnoreCase(filterColName[i]) || "FCELL".equalsIgnoreCase(filterColName[i]) || "FORGLONGNAME".equalsIgnoreCase(filterColName[i])) {
                    sql.append(" or umap." + filterColName[i] + " like '%" + filter + "%'");
                    continue;
                }
                sql.append(" or log." + filterColName[i] + " like '%" + filter + "%'");
            }
            sql.append(")");
        } else if (SyncHighItemType.DeptLeader.equals((Object)highItemType)) {
            sql.append(" AND (org." + filterColName[0] + " like '%" + filter + "%'");
            sql.append(" or org." + filterColName[1] + " like '%" + filter + "%'");
            sql.append(" or log." + filterColName[2] + " like '%" + filter + "%'");
            sql.append(")");
        } else {
            sql.append(" AND (log." + filterColName[0] + " like '%" + filter + "%'");
            for (int i = 1; i < filterColName.length; ++i) {
                sql.append(" OR log." + filterColName[i] + " like '%" + filter + "%'");
            }
            sql.append(")");
        }
        return sql.toString();
    }

    @Override
    protected String getXtOrgLeaderSql(Context ctx, String orgLongName) throws BOSException {
        String selectSql = "SELECT top 1 FUSERIDS FROM T_WL_ORGLEADER leader inner join T_WL_ORG org on leader.fwlorgid = org.fwlorgid WHERE org.forglongname = ?";
        if (orgLongName.indexOf("_") > 0) {
            orgLongName = orgLongName.substring(orgLongName.indexOf("_") + 1);
            orgLongName = orgLongName.replaceAll("_", "\\\\");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new String[]{orgLongName});
        StringBuilder sql = new StringBuilder("SELECT distinct u.fpersonname leaderName FROM T_WL_USER u WHERE 1=2");
        if (rs.size() < 1) {
            return sql.toString();
        }
        try {
            sql.append(" or u.fuserid in(");
            while (rs.next()) {
                JSONArray parseArray = JSONArray.parseArray((String)rs.getString("FUSERIDS"));
                for (int i = 0; i < parseArray.size(); ++i) {
                    sql.append("'" + parseArray.getString(i) + "',");
                }
                sql.deleteCharAt(sql.length() - 1);
                sql.append(")");
            }
            return sql.toString();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return sql.toString();
        }
    }

    @Override
    protected String getPersonPartJobTiltle(String xtIdOrCell) throws BOSException {
        String sql = "SELECT top 1 forgids FROM T_WL_PART WHERE FUSERID = ?";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new String[]{xtIdOrCell});
        try {
            if (rs.next()) {
                List orgids = JSONArray.parseArray((String)rs.getString("forgids"), String.class);
                StringBuilder sql1 = new StringBuilder("SELECT forgLongName orglongname FROM T_WL_org where fWLorgid in(");
                for (int i = 0; i < orgids.size(); ++i) {
                    sql1.append("'" + (String)orgids.get(i) + "',");
                }
                sql1.deleteCharAt(sql1.length() - 1);
                sql1.append(")");
                return sql1.toString();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String sql2 = "SELECT 1 FROM T_WL_PART WHERE 1=2";
        return sql2;
    }

    @Override
    protected String getXtOrgFormOrgMap() throws BOSException {
        return WLSyncConfigUtil.getInstance().getValue("getXtOrgFromOrgMap");
    }

    @Override
    protected Map<String, Object> buildTableData(Context ctx, SyncHighItemType highItemType, String[] baseCol, IRowSet rs) throws BOSException {
        return super.buildTableData(ctx, highItemType, baseCol, rs);
    }

    @Override
    protected String getSyncTypeAlias(String type) throws BOSException {
        SyncItemType enum1 = SyncItemType.getEnum(type);
        if (enum1 != null) {
            return super.getSyncTypeAlias(type);
        }
        return WLSyncItemType.getEnum(type).getAlias();
    }

    @Override
    public String getTableName(String type) {
        if ("USER_NOSYNC_TABLE".equals(type)) {
            return "T_WL_NOSYNCPERSON";
        }
        if ("ORG_NOSYNC_TABLE".equals(type)) {
            return "T_WL_NOSYNCORG";
        }
        if ("USER_SYNC_TABLE".equals(type)) {
            return "T_WL_USER";
        }
        if ("ORG_SYNC_TABLE".equals(type)) {
            return "T_WL_ORG";
        }
        if ("USER_MAPPING_TABLE".equals(type)) {
            return "T_PM_EASWLUSERMAP";
        }
        return null;
    }

    public static void cleasCache() {
        hwConfig.clear();
    }

    @Override
    protected String getXTPersonStatus(String status) {
        status = "1".equals(status) ? "\u672a\u5f00\u6237" : ("3".equals(status) ? "\u5728\u804c" : "\u79bb\u804c");
        return status;
    }
}

