/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.xtutil;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.EncryptUtils;
import com.kingdee.eas.base.xtsync.xtutil.RSAUtils;
import com.kingdee.eas.base.xtsync.xtutil.StringUtil;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class XtCommunicateUtil {
    private static Logger logger = Logger.getLogger(XtCommunicateUtil.class);
    private static Map keys = null;
    private static XtCommunicateUtil instance = null;
    private static Context ctx = null;
    private static String eid = null;
    private static String cloudUrl = null;
    private static String keyPath = System.getProperty("eas.properties.dir");
    private static String OPENACCESS_URL = null;
    private static String GETATTIME_URL = null;
    private static String GETATTIMECELLUPDATE_URL = null;
    private static String GETALLPERSON_URL = null;
    private static String ADDNEWPERSONS_URL = null;
    private static String ADDNEWPERSONS_URL_NEW = null;
    private static String UPDATEPERSONS_URL = null;
    private static String UPDATEPERSONSCELL_URL = null;
    private static String UPDATEPERSONSEMAIL_URL = null;
    private static String UPDATEPERSONSTATUS_URL = null;
    private static String UPDATEPERSONDEPT_URL = null;
    private static String DELETEPERSONDEPT_URL = null;
    private static String ADDDEPT_URL = null;
    private static String MOVEDEPT_URL = null;
    private static String DELETEDEPT_URL = null;
    private static String UPDATEORGWEIGHTS_URL = null;
    private static String UPDATEDEPT_URL = null;
    private static String DELETEDEPTWITHID_URL = null;
    private static String UPDATEDEPTWITHID_URL = null;
    private static String GETALLORG_URL = null;
    private static String GETALLORGNEW_URL = null;
    private static String GETORGBYLONGNUMBER_URL = null;
    private static String GETALLORGLEADER_URL = null;
    private static String BATCHSETORGLEADER_URL = null;
    private static String BATCHDELETEORGLEADER_URL = null;
    private static String BATCHSETORGLEADER_URL_NEW = null;
    private static String BATCHDELETEORGLEADER_URL_NEW = null;
    private static String BATCHSETPARTJOB_URL = null;
    private static String BATCHDELETEPARTJOB_URL = null;
    private static String GETALLPARTJOB_URL = null;
    private static String BATCHSETRELATIONS_URL = null;
    private static String BATCHDELETERELATIONS_URL = null;
    private static String GETALLRELATIONS_URL = null;
    private static String BATCHDELETERELATIONS_URL_ALL = null;
    private static String BATCHDELETEPARTJOB_URL_ALL = null;
    private static String BATCHDELETEORGLEADER_URL_ALL = null;
    private static boolean isNewEncryptEnable = false;

    public static XtCommunicateUtil getInstance(Context _ctx) {
        if (instance == null) {
            instance = new XtCommunicateUtil();
        }
        ctx = _ctx;
        eid = EasXtSyncUtil.getInstance(ctx).getEid();
        cloudUrl = EasXtSyncUtil.getInstance(ctx).getCloud();
        if (!isNewEncryptEnable) {
            try {
                Cipher rsa = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                rsa.init(1, XtCommunicateUtil.getKey(eid));
                isNewEncryptEnable = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        XtCommunicateUtil.initUrl();
        return instance;
    }

    private static void initUrl() {
        OPENACCESS_URL = cloudUrl + "/openaccess";
        GETATTIME_URL = OPENACCESS_URL + "/input/person/getAtTime";
        GETATTIMECELLUPDATE_URL = OPENACCESS_URL + "/input/person/getPersonChangePhone";
        GETALLPERSON_URL = OPENACCESS_URL + "/input/person/getall";
        ADDNEWPERSONS_URL = OPENACCESS_URL + "/input/person/add";
        ADDNEWPERSONS_URL_NEW = OPENACCESS_URL + "/input/person/addNew";
        UPDATEPERSONS_URL = OPENACCESS_URL + "/input/person/updateInfo";
        UPDATEPERSONSTATUS_URL = OPENACCESS_URL + "/input/person/updateStatus";
        UPDATEPERSONSCELL_URL = OPENACCESS_URL + "/input/person/updatePhone";
        UPDATEPERSONSEMAIL_URL = OPENACCESS_URL + "/input/person/updateEmailUnbound";
        UPDATEPERSONDEPT_URL = OPENACCESS_URL + "/input/person/updateDept";
        DELETEPERSONDEPT_URL = OPENACCESS_URL + "/input/person/delete";
        ADDDEPT_URL = OPENACCESS_URL + "/input/dept/add";
        MOVEDEPT_URL = OPENACCESS_URL + "/input/dept/moveOrg";
        GETORGBYLONGNUMBER_URL = OPENACCESS_URL + "/input/dept/get";
        DELETEDEPT_URL = OPENACCESS_URL + "/input/dept/delete";
        UPDATEORGWEIGHTS_URL = OPENACCESS_URL + "/input/dept/updateWeightsById";
        UPDATEDEPT_URL = OPENACCESS_URL + "/input/dept/update";
        DELETEDEPTWITHID_URL = OPENACCESS_URL + "/input/dept/deleteById";
        UPDATEDEPTWITHID_URL = OPENACCESS_URL + "/input/dept/updateById";
        GETALLORG_URL = OPENACCESS_URL + "/input/dept/getall";
        GETALLORGNEW_URL = OPENACCESS_URL + "/input/dept/getAllByPage";
        GETALLORGLEADER_URL = OPENACCESS_URL + "/input/company/queryOrgAdmins";
        BATCHSETORGLEADER_URL = OPENACCESS_URL + "/input/company/setOrgAdmins";
        BATCHDELETEORGLEADER_URL = OPENACCESS_URL + "/input/company/deleteOrgAdmins";
        BATCHSETORGLEADER_URL_NEW = OPENACCESS_URL + "/input/company/setOrgAdminsById";
        BATCHDELETEORGLEADER_URL_NEW = OPENACCESS_URL + "/input/company/deleteOrgAdminsById";
        BATCHSETPARTJOB_URL = OPENACCESS_URL + "/input/company/addPartTimeJobs";
        BATCHDELETEPARTJOB_URL = OPENACCESS_URL + "/input/company/deletePartTimeJobs";
        GETALLPARTJOB_URL = OPENACCESS_URL + "/input/company/queryPartTimeJobs";
        BATCHSETRELATIONS_URL = OPENACCESS_URL + "/input/company/addRelations";
        BATCHDELETERELATIONS_URL = OPENACCESS_URL + "/input/company/deleteRelations";
        GETALLRELATIONS_URL = OPENACCESS_URL + "/input/company/queryRelations";
        BATCHDELETERELATIONS_URL_ALL = OPENACCESS_URL + "/input/relationship/deleteAllRelation";
        BATCHDELETEPARTJOB_URL_ALL = OPENACCESS_URL + "/input/relationship/deleteAllPartTimeJobs";
        BATCHDELETEORGLEADER_URL_ALL = OPENACCESS_URL + "/input/relationship/deleteOrgAdmins";
    }

    public JSONObject getDataAfterCheckTime(String lastCheckTime, int start, int length) throws Exception {
        JSONObject dataJSON = new JSONObject();
        dataJSON.put("eid", (Object)eid);
        dataJSON.put("time", (Object)lastCheckTime);
        dataJSON.put("begin", (Object)start);
        dataJSON.put("count", (Object)length);
        JSONObject response = XtCommunicateUtil.getResponseByForm(GETATTIME_URL, XtCommunicateUtil.buildRequestData(eid, dataJSON));
        return response;
    }

    public JSONObject getCellUpdateAfterCheckTime(String lastCheckTime, int start, int length) throws Exception {
        JSONObject dataJSON = new JSONObject();
        dataJSON.put("eid", (Object)eid);
        dataJSON.put("time", (Object)lastCheckTime);
        dataJSON.put("begin", (Object)start);
        dataJSON.put("count", (Object)length);
        JSONObject response = XtCommunicateUtil.getResponseByForm(GETATTIMECELLUPDATE_URL, XtCommunicateUtil.buildRequestData(eid, dataJSON));
        return response;
    }

    public JSONObject getAllPersonInfo(int start, int length) throws Exception {
        JSONObject dataJSON = new JSONObject();
        dataJSON.put("eid", (Object)eid);
        dataJSON.put("begin", (Object)start);
        dataJSON.put("count", (Object)length);
        JSONObject response = XtCommunicateUtil.getResponseByForm(GETALLPERSON_URL, XtCommunicateUtil.buildRequestData(eid, dataJSON));
        return response;
    }

    public JSONObject getAllOrgLeader(int start, int length) throws Exception {
        JSONObject dataJSON = new JSONObject();
        dataJSON.put("begin", (Object)start);
        dataJSON.put("count", (Object)length);
        JSONObject response = XtCommunicateUtil.getResponseByForm(GETALLORGLEADER_URL, XtCommunicateUtil.buildRequestData(eid, dataJSON));
        return response;
    }

    private static JSONObject getResponseByForm(String url, String jsonBody) throws Exception {
        logger.error((Object)("*******1\t\u8c03\u7528\u4e91\u4e4b\u5bb6\u63a5\u53e3\uff1a" + url));
        FilterOutputStream ds = null;
        InputStream in = null;
        BufferedReader reader = null;
        int maxRetryTimes = 5;
        StringBuilder sb = new StringBuilder("\u7cfb\u7edf\u5f02\u5e38");
        try {
            for (int retryCount = 0; retryCount < maxRetryTimes; ++retryCount) {
                try {
                    long time1 = System.currentTimeMillis();
                    logger.error((Object)("*******2\t\u5f00\u59cb\u5efa\u7acb\u8fde\u63a5\uff1a" + url));
                    URL sendUrl = new URL(url);
                    HttpURLConnection conn = (HttpURLConnection)sendUrl.openConnection();
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                    conn.setUseCaches(false);
                    conn.setConnectTimeout(30000);
                    conn.setReadTimeout(60000);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("connection", "Keep-Alive");
                    conn.setRequestProperty("Charsert", "UTF-8");
                    conn.setRequestProperty("content-type", "application/x-www-form-urlencoded");
                    conn.setInstanceFollowRedirects(false);
                    conn.connect();
                    long time2 = System.currentTimeMillis();
                    logger.error((Object)("*******3\t\u6210\u529f\u5efa\u7acb\u8fde\u63a5\u8017\u65f6\uff1a" + (time2 - time1) + "\u6beb\u79d2"));
                    ds = new DataOutputStream(conn.getOutputStream());
                    String content = "";
                    JSONObject jsonObject = JSONObject.parseObject((String)jsonBody);
                    long time3 = System.currentTimeMillis();
                    logger.error((Object)("*******4\t\u4ece\u4e91\u4e4b\u5bb6\u83b7\u53d6\u54cd\u5e94\u6570\u636e\u8017\u65f6\uff1a" + (time3 - time2) + "\u6beb\u79d2"));
                    for (Map.Entry entry : jsonObject.entrySet()) {
                        content = content + (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8") + "&";
                    }
                    content = content + "1=1";
                    long time4 = System.currentTimeMillis();
                    logger.error((Object)("*******\u5305\u4f53\u6570\u636e\uff1a****" + content + "***"));
                    logger.error((Object)("*******5\t\u7ec4\u88c5\u4e91\u4e4b\u5bb6\u83b7\u53d6\u54cd\u5e94\u6570\u636e\u8017\u65f6\uff1a" + (time4 - time3) + "\u6beb\u79d2"));
                    ((DataOutputStream)ds).writeBytes(content);
                    ((DataOutputStream)ds).flush();
                    ds.close();
                    in = conn.getInputStream();
                    long time5 = System.currentTimeMillis();
                    logger.error((Object)("*******6\t\u4e91\u4e4b\u5bb6\u6570\u636e\u52a0\u8f7d\u5230\u5185\u5b58\u4e2d\u8017\u65f6\uff1a" + (time5 - time4) + "\u6beb\u79d2"));
                    sb = new StringBuilder();
                    reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        sb.append(line).append("\n");
                    }
                    long time6 = System.currentTimeMillis();
                    logger.error((Object)("*******7\t\u8f6c\u6210\u6587\u4ef6\u5b57\u7b26\u8017\u65f6\uff1a" + (time6 - time5) + "\u6beb\u79d2"));
                    conn.disconnect();
                    long time7 = System.currentTimeMillis();
                    logger.error((Object)("*******8\t\u5173\u95ed\u8fde\u63a5\u8017\u65f6\uff1a" + (time7 - time6) + "\u6beb\u79d2"));
                    break;
                }
                catch (IOException e) {
                    logger.error((Object)("***** \u8bf7\u6c42\u5730\u5740 " + url + "\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u5f02\u5e38, \u51c6\u5907\u91cd\u8bd5  ***** "));
                    logger.error((Object)e);
                    e.printStackTrace();
                    Thread.sleep(2000L);
                    continue;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("***** \u8bf7\u6c42\u5730\u5740 " + url + "\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u5f02\u5e38  ***** "));
            logger.error((Object)e);
            throw e;
        }
        finally {
            if (ds != null) {
                try {
                    ds.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.parseObject((String)new String(sb.toString().getBytes("UTF-8"), "UTF-8"));
    }

    private static String buildRequestData(String eid, JSONObject dataJSON) throws UnsupportedEncodingException, Exception {
        Key key = XtCommunicateUtil.getKey(eid);
        String data = null;
        if (isNewEncryptEnable) {
            data = new String(Base64.encodeBase64((byte[])EncryptUtils.encryptLarger(dataJSON.toString().getBytes("UTF-8"), key)), "UTF-8");
            String string = UUID.randomUUID().toString();
        } else {
            data = new String(Base64.encodeBase64((byte[])RSAUtils.encryptLarger(dataJSON.toString().getBytes("UTF-8"), key)), "UTF-8");
        }
        if (data == null) {
            throw new Exception("encryptLarger error\uff01");
        }
        String nonce = UUID.randomUUID().toString();
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("eid", (Object)eid);
        jsonBody.put("data", (Object)data);
        jsonBody.put("nonce", (Object)nonce);
        return jsonBody.toString();
    }

    private static String buildRequestData(String eid, JSONArray dataJSON) throws UnsupportedEncodingException, Exception {
        Key key = XtCommunicateUtil.getKey(eid);
        String data = null;
        if (isNewEncryptEnable) {
            data = new String(Base64.encodeBase64((byte[])EncryptUtils.encryptLarger(dataJSON.toString().getBytes("UTF-8"), key)), "UTF-8");
            String string = UUID.randomUUID().toString();
        } else {
            data = new String(Base64.encodeBase64((byte[])RSAUtils.encryptLarger(dataJSON.toString().getBytes("UTF-8"), key)), "UTF-8");
        }
        if (data == null) {
            throw new Exception("encryptLarger error\uff01");
        }
        String nonce = UUID.randomUUID().toString();
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("eid", (Object)eid);
        jsonBody.put("data", (Object)data);
        jsonBody.put("nonce", (Object)nonce);
        return jsonBody.toString();
    }

    public JSONObject syncAddNewOrgInfo(JSONArray orgs) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            dataJSON.put("departments", (Object)orgs);
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(ADDDEPT_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncMoveOrgInfo(JSONArray orgs) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            dataJSON.put("orgId", (Object)((JSONObject)orgs.get(0)).getString("orgId"));
            dataJSON.put("moveToOrgId", (Object)((JSONObject)orgs.get(0)).getString("moveToOrgId"));
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(MOVEDEPT_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncUpdateOrgWeights(JSONArray orgs) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            dataJSON.put("departments", (Object)orgs);
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            logger.error((Object)"*****************syncUpdateOrgWeights\u5305\u4f53\uff1a**********************");
            JSONObject response = XtCommunicateUtil.getResponseByForm(UPDATEORGWEIGHTS_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncDeleteOrgInfo(JSONArray orgs) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            dataJSON.put("departments", (Object)orgs);
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(DELETEDEPT_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncDeleteOrgInfoNew(JSONArray orgs) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            dataJSON.put("departments", (Object)orgs);
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(DELETEDEPTWITHID_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncUpdateOrgName(JSONArray orgs) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            dataJSON.put("departments", (Object)orgs);
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(UPDATEDEPT_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncUpdateOrgNameNew(JSONArray orgs) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            dataJSON.put("departments", (Object)orgs);
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(UPDATEDEPTWITHID_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncAddNewPersonInfo(JSONArray persons) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            dataJSON.put("persons", (Object)persons);
            dataJSON.put("productKey", (Object)"EAS");
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(ADDNEWPERSONS_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncAddNewPersonInfoNew(JSONArray persons) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            dataJSON.put("persons", (Object)persons);
            dataJSON.put("productKey", (Object)"EAS");
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(ADDNEWPERSONS_URL_NEW, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static JSONObject updatePersonStatus(JSONArray persons) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            dataJSON.put("persons", (Object)persons);
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(UPDATEPERSONSTATUS_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject deletePersonStatus(JSONArray persons) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            dataJSON.put("openIds", (Object)persons);
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(DELETEPERSONDEPT_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncUpdatePersonInfo(JSONArray persons) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            dataJSON.put("persons", (Object)persons);
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(UPDATEPERSONS_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncUpdatePersonCell(JSONArray persons) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            dataJSON.put("persons", (Object)persons);
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(UPDATEPERSONSCELL_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncUpdatePersonEmail(JSONArray persons) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            dataJSON.put("persons", (Object)persons);
            dataJSON.put("productKey", (Object)("EAS-" + ctx.getAIS()));
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(UPDATEPERSONSEMAIL_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncUpdateUserOrgInfo(JSONArray persons) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            dataJSON.put("persons", (Object)persons);
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(UPDATEPERSONDEPT_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncBatchSetOrgLeader(JSONArray datas) throws BOSException {
        try {
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, datas);
            JSONObject response = XtCommunicateUtil.getResponseByForm(BATCHSETORGLEADER_URL_NEW, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncBatchDeleteOrgLeader(JSONArray datas) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("list", (Object)datas);
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(BATCHDELETEORGLEADER_URL_NEW, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncBatchDeleteAllOrgLeader() throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("deleteAll", (Object)true);
            dataJSON.put("list", (Object)new JSONArray());
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(BATCHDELETEORGLEADER_URL_ALL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncBatchDeleteAllPartJob() throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("deleteAll", (Object)true);
            dataJSON.put("list", (Object)new JSONArray());
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(BATCHDELETEPARTJOB_URL_ALL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncBatchDeleteAllRelations() throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("deleteAll", (Object)true);
            dataJSON.put("list", (Object)new JSONArray());
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(BATCHDELETERELATIONS_URL_ALL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncBatchSetPartJob(JSONArray datas) throws BOSException {
        try {
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, datas);
            JSONObject response = XtCommunicateUtil.getResponseByForm(BATCHSETPARTJOB_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncBatchDeletePartJob(JSONArray datas) throws BOSException {
        try {
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, datas);
            JSONObject response = XtCommunicateUtil.getResponseByForm(BATCHDELETEPARTJOB_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncBatchSetRelations(JSONArray datas) throws BOSException {
        try {
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, datas);
            JSONObject response = XtCommunicateUtil.getResponseByForm(BATCHSETRELATIONS_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject syncBatchDeleteRelations(JSONArray datas) throws BOSException {
        try {
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, datas);
            JSONObject response = XtCommunicateUtil.getResponseByForm(BATCHDELETERELATIONS_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void clearKey() {
        if (keys != null) {
            keys.clear();
        }
    }

    public void resetURL() {
        OPENACCESS_URL = cloudUrl + "/openaccess";
        GETATTIME_URL = OPENACCESS_URL + "/input/person/getAtTime";
        ADDNEWPERSONS_URL = OPENACCESS_URL + "/input/person/add";
        UPDATEPERSONS_URL = OPENACCESS_URL + "/input/person/updateInfo";
        UPDATEPERSONSTATUS_URL = OPENACCESS_URL + "/input/person/updateStatus";
        UPDATEPERSONDEPT_URL = OPENACCESS_URL + "/input/person/updateDept";
        ADDDEPT_URL = OPENACCESS_URL + "/input/dept/add";
    }

    public Key getKeyByEid(String eid) throws Exception {
        return XtCommunicateUtil.getKey(eid);
    }

    private static Key getKey(String eid) throws Exception {
        Key tmpKey = null;
        if (keys != null) {
            tmpKey = (Key)keys.get(ctx.getAIS() + eid);
        }
        if (tmpKey != null) {
            return tmpKey;
        }
        if (!StringUtil.fileNameCheck(eid)) {
            throw new Exception("\u4f01\u4e1aEID\u5305\u542b\u975e\u6cd5\u5b57\u7b26,\u8bf7\u4fee\u6539");
        }
        String filePath = keyPath + File.separator + ctx.getAIS() + "____" + eid + ".key";
        File file = new File(filePath);
        if (!file.exists()) {
            throw new Exception("\u627e\u4e0d\u5230\u4e91\u4e4b\u5bb6\u4f01\u4e1aEID (" + eid + ")\u5bf9\u5e94\u7684" + ctx.getAIS() + "____" + eid + ".key\u6587\u4ef6\uff0c\u8bf7\u5148\u5230\u53c2\u6570\u8bbe\u7f6e\u9875\u9762\u914d\u7f6e");
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(filePath);
            byte[] bytes = new byte[((InputStream)in).available()];
            ((InputStream)in).read(bytes);
            tmpKey = EncryptUtils.restorePrivateKey(bytes);
            if (keys == null) {
                keys = new HashMap();
            }
            keys.put(ctx.getAIS() + eid, tmpKey);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
        return tmpKey;
    }

    public static boolean saveStringKeyToFile(String eid, String key) throws Exception {
        boolean flag = false;
        if (StringUtil.isEmpty(eid) || StringUtil.isEmpty(key)) {
            return flag;
        }
        String filePath = keyPath + File.separator + ctx.getAIS() + "____" + eid + ".key";
        File file = new File(filePath);
        byte[] bytes = RSAUtils.decodeBase64(key);
        FileUtils.writeByteArrayToFile((File)file, (byte[])bytes);
        flag = true;
        return flag;
    }

    public JSONObject getAllOrg() throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(GETALLORG_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject getAllOrgNew(int start, int length) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            dataJSON.put("begin", (Object)start);
            dataJSON.put("count", (Object)length);
            JSONObject response = XtCommunicateUtil.getResponseByForm(GETALLORGNEW_URL, XtCommunicateUtil.buildRequestData(eid, dataJSON));
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject getOrgByLongNumber(JSONArray orgLongNumber) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("eid", (Object)eid);
            dataJSON.put("array", (Object)orgLongNumber);
            dataJSON.put("type", (Object)1);
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(GETORGBYLONGNUMBER_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject getAllPartJob(int start, int length) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("begin", (Object)start);
            dataJSON.put("count", (Object)length);
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(GETALLPARTJOB_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public JSONObject getAllRelations(int start, int length) throws BOSException {
        try {
            JSONObject dataJSON = new JSONObject();
            dataJSON.put("relationType", (Object)"LEADER");
            dataJSON.put("begin", (Object)start);
            dataJSON.put("count", (Object)length);
            String jsonBody = XtCommunicateUtil.buildRequestData(eid, dataJSON);
            JSONObject response = XtCommunicateUtil.getResponseByForm(GETALLRELATIONS_URL, jsonBody);
            return response;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }
}

