/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile;

import com.tool.classfile.ByteCodeReader;
import com.tool.classfile.ByteCodeWriter;
import com.tool.classfile.ClassRef;
import com.tool.classfile.CodeException;
import com.tool.classfile.Const;
import com.tool.classfile.FieldRef;
import com.tool.classfile.InterfaceMethodRef;
import com.tool.classfile.MemberRef;
import com.tool.classfile.MethodRef;
import com.tool.classfile.NameAndType;
import com.tool.classfile.Reference;
import com.tool.classfile.Utf8;
import com.tool.classfile.opc;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;

public class ConstantPool {
    private Hashtable indexs = new Hashtable();
    public final Vector refs = new Vector();

    public ConstantPool() {
    }

    public ConstantPool(ByteCodeReader in) {
        this.init(in);
    }

    public Reference get(int index) {
        if (index == 0) {
            return null;
        }
        return (Reference)this.refs.elementAt(index - 1);
    }

    public int get(Reference ref) {
        if (ref == null) {
            return 0;
        }
        if (ref instanceof Const && ((Const)ref).value == null) {
            return 0;
        }
        Integer idx = (Integer)this.indexs.get(ref);
        if (idx != null) {
            return idx;
        }
        if (ref instanceof ClassRef) {
            this.get(new Utf8(((ClassRef)ref).className));
        } else if (ref instanceof MemberRef) {
            MemberRef member = (MemberRef)ref;
            this.getClass(member.className);
            this.get(new NameAndType(member.name, member.descriptor));
        } else if (ref instanceof NameAndType) {
            NameAndType nat = (NameAndType)ref;
            this.get(new Utf8(nat.name));
            this.get(new Utf8(nat.descriptor));
        } else if (ref.tag == 8) {
            Const c = (Const)ref;
            this.get(new Utf8((String)c.value));
        }
        int index = this.refs.size() + 1;
        idx = new Integer(index);
        this.indexs.put(ref, idx);
        this.refs.addElement(ref);
        if (ref.tag == 5 || ref.tag == 6) {
            this.refs.addElement(Reference.nullReference);
        }
        return index;
    }

    public int getClass(String className) {
        if (className == null) {
            return 0;
        }
        return this.get(new ClassRef(className));
    }

    public String getClass(int index) {
        if (index == 0) {
            return null;
        }
        return ((ClassRef)this.get((int)index)).className;
    }

    public String getString(int index) {
        if (index == 0) {
            return null;
        }
        return ((Utf8)this.get((int)index)).value;
    }

    public int getString(String s) {
        if (s == null) {
            return 0;
        }
        return this.get(new Utf8(s));
    }

    public void write(ByteCodeWriter out) {
        out.writeu2(this.refs.size() + 1);
        int i = 0;
        while (i < this.refs.size()) {
            Reference ref = (Reference)this.refs.elementAt(i);
            if (ref.tag != 0) {
                out.writeu1(ref.tag);
                switch (ref.tag) {
                    case 7: {
                        ClassRef cr = (ClassRef)ref;
                        out.writeu2(this.getString(cr.className));
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        MemberRef mr = (MemberRef)ref;
                        out.writeu2(this.getClass(mr.className));
                        out.writeu2(this.get(new NameAndType(mr.name, mr.descriptor)));
                        break;
                    }
                    case 8: {
                        Const sr = (Const)ref;
                        out.writeu2(this.getString(sr.stringValue()));
                        break;
                    }
                    case 1: {
                        Utf8 ur = (Utf8)ref;
                        byte[] sbytes = Utf8.toUtf8(ur.value);
                        out.writeu2(sbytes.length);
                        out.write(sbytes);
                        break;
                    }
                    case 6: {
                        Const dr = (Const)ref;
                        out.writeDouble(dr.doubleValue());
                        break;
                    }
                    case 4: {
                        Const fr = (Const)ref;
                        out.writeFloat(fr.floatValue());
                        break;
                    }
                    case 3: {
                        Const ir = (Const)ref;
                        out.writeInt(ir.intValue());
                        break;
                    }
                    case 5: {
                        Const lr = (Const)ref;
                        out.writeLong(lr.longValue());
                        break;
                    }
                    case 12: {
                        NameAndType nr = (NameAndType)ref;
                        out.writeu2(this.getString(nr.name));
                        out.writeu2(this.getString(nr.descriptor));
                        break;
                    }
                }
            }
            ++i;
        }
    }

    private void init(ByteCodeReader in) {
        Vector<Object> temp = new Vector<Object>();
        int size = in.readu2();
        int i = 1;
        while (i < size) {
            int tag = in.readu1();
            switch (tag) {
                case 7: 
                case 8: {
                    temp.addElement(new Delay(tag, in.readu2(), 0));
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    temp.addElement(new Delay(tag, in.readu2(), in.readu2()));
                    break;
                }
                case 1: {
                    byte[] sbytes = in.readBytes(in.readu2());
                    temp.addElement(new Utf8(Utf8.parseUtf8(sbytes)));
                    break;
                }
                case 6: {
                    temp.addElement(new Const(in.readDouble()));
                    temp.addElement(Reference.nullReference);
                    ++i;
                    break;
                }
                case 4: {
                    temp.addElement(new Const(in.readFloat()));
                    break;
                }
                case 3: {
                    temp.addElement(new Const(in.readInt()));
                    break;
                }
                case 5: {
                    temp.addElement(new Const(in.readLong()));
                    temp.addElement(Reference.nullReference);
                    ++i;
                    break;
                }
                default: {
                    throw new CodeException("unknown constant tag='" + tag + "'");
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < temp.size()) {
            Reference ref = this.initDelay(temp, i2);
            this.refs.addElement(ref);
            this.indexs.put(ref, new Integer(i2 + 1));
            ++i2;
        }
    }

    private String getInitString(Vector temp, int index) {
        return ((Utf8)temp.elementAt((int)index)).value;
    }

    private Reference initDelay(Vector temp, int i) {
        Object x = temp.elementAt(i);
        if (!(x instanceof Delay)) {
            return (Reference)x;
        }
        Delay delay = (Delay)x;
        switch (delay.tag) {
            case 7: {
                return new ClassRef(this.getInitString(temp, delay.index1 - 1));
            }
            case 8: {
                return new Const(this.getInitString(temp, delay.index1 - 1));
            }
            case 9: 
            case 10: 
            case 11: {
                ClassRef clsref = (ClassRef)this.initDelay(temp, delay.index1 - 1);
                NameAndType nat = (NameAndType)this.initDelay(temp, delay.index2 - 1);
                if (delay.tag == 9) {
                    return new FieldRef(clsref.className, nat.name, nat.descriptor);
                }
                if (delay.tag == 10) {
                    return new MethodRef(clsref.className, nat.name, nat.descriptor);
                }
                return new InterfaceMethodRef(clsref.className, nat.name, nat.descriptor);
            }
            case 12: {
                String name = this.getInitString(temp, delay.index1 - 1);
                String type = this.getInitString(temp, delay.index2 - 1);
                return new NameAndType(name, type);
            }
        }
        throw new CodeException();
    }

    public void dump(PrintWriter out) throws IOException {
        int i = 0;
        while (i < this.refs.size()) {
            Reference ref = (Reference)this.refs.elementAt(i);
            if (ref.tag != 0) {
                System.out.println("#" + (i + 1) + "\t" + opc.constant_type[ref.tag] + "\t" + ref);
            }
            ++i;
        }
    }

    private class Delay {
        int tag;
        int index1;
        int index2;

        Delay(int _tag, int _index1, int _index2) {
            this.tag = _tag;
            this.index1 = _index1;
            this.index2 = _index2;
        }
    }
}

