/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile.binary;

import com.tool.classfile.ByteCodeReader;
import com.tool.classfile.ByteCodeWriter;
import com.tool.classfile.ConstantPool;
import com.tool.classfile.binary.AttributeInfo;
import com.tool.classfile.binary.CodeAttribute;
import com.tool.classfile.binary.ConstantAttribute;
import com.tool.classfile.binary.LineNumberAttribute;
import com.tool.classfile.binary.LocalVariableAttribute;

public class Attribute {
    public int name_index;
    public byte[] info;
    public AttributeInfo special = null;

    public Attribute(ByteCodeReader in) {
        this.name_index = in.readu2();
        int len = in.readu4();
        this.info = new byte[len];
        this.info = in.readBytes(len);
    }

    public Attribute(int _name_index, byte[] _info) {
        this.name_index = _name_index;
        this.info = _info;
    }

    public AttributeInfo createSpecial(String name) {
        if (name.equals("Code")) {
            this.special = new CodeAttribute(this.info);
        } else if (name.equals("LineNumberTable")) {
            this.special = new LineNumberAttribute(this.info);
        } else if (name.equals("LocalVariableTable")) {
            this.special = new LocalVariableAttribute(this.info);
        } else if (name.equals("ConstantValue")) {
            this.special = new ConstantAttribute("ConstantValue", this.info);
        } else if (name.equals("SourceFile")) {
            this.special = new ConstantAttribute("SourceFile", this.info);
        } else if (name.equals("SourceDir")) {
            this.special = new ConstantAttribute("SourceDir", this.info);
        }
        return this.special;
    }

    public static Attribute booleanAttribute(ConstantPool pool, String name) {
        return new Attribute(pool.getString(name), new byte[0]);
    }

    public static Attribute constantAttribute(ConstantPool pool, String name, String value) {
        ByteCodeWriter out = new ByteCodeWriter();
        out.writeu2(pool.getString(value));
        return new Attribute(pool.getString(name), out.toByteArray());
    }
}

