/*
 * Decompiled with CFR 0.152.
 */
package com.tool.classfile.pcodes;

import com.tool.classfile.CodeException;
import com.tool.classfile.sc;
import java.util.Vector;

public class OperandStack {
    public int max_stack = 0;
    private int current_stack = 0;
    public Vector stack = new Vector();

    public Object checkPoint() {
        Save s = new Save();
        s.current_stack = this.current_stack;
        int i = 0;
        while (i < this.stack.size()) {
            s.stack.addElement(this.stack.elementAt(i));
            ++i;
        }
        return s;
    }

    public void reverse(Object p) {
        Save s = (Save)p;
        this.current_stack = s.current_stack;
        this.stack = s.stack;
    }

    public void push(String type) {
        this.stack.addElement(type);
        ++this.current_stack;
        if (sc.isCategory2(type)) {
            ++this.current_stack;
        }
        if (this.max_stack < this.current_stack) {
            this.max_stack = this.current_stack;
        }
    }

    public boolean isEmpty() {
        return this.stack.size() == 0;
    }

    public int size() {
        return this.stack.size();
    }

    public void clear() {
        this.stack.removeAllElements();
    }

    private void validNoEmpty() {
        CodeException.assertThat(!this.isEmpty(), "stack is empty");
    }

    public String get(int offset) {
        CodeException.assertThat(this.stack.size() > offset);
        return (String)this.stack.elementAt(this.stack.size() - 1 - offset);
    }

    public String current() {
        this.validNoEmpty();
        return (String)this.stack.elementAt(this.stack.size() - 1);
    }

    public String pop() {
        return this.pop(null);
    }

    public String pop(String requiredType) {
        this.validNoEmpty();
        int index = this.stack.size() - 1;
        String type = (String)this.stack.elementAt(index);
        this.stack.removeElementAt(index);
        if (requiredType != null) {
            sc.checkType(type, requiredType);
        }
        --this.current_stack;
        if (sc.isCategory2(type)) {
            --this.current_stack;
        }
        return type;
    }

    public void pop1(String type) {
        this.pop(type);
    }

    public void pop2(String type1, String type2) {
        this.pop(type2);
        this.pop(type1);
    }

    public void pop3(String type1, String type2, String type3) {
        this.pop(type3);
        this.pop(type2);
        this.pop(type1);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        int i = 0;
        while (i < this.stack.size()) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(sc.javaType((String)this.stack.elementAt(i)));
            ++i;
        }
        sb.append(")");
        return sb.toString();
    }

    private class Save {
        int current_stack;
        Vector stack = new Vector();

        private Save() {
        }
    }
}

