/*
 * Decompiled with CFR 0.152.
 */
package com.tool.simplecode;

import com.tool.classfile.SourceWriter;
import com.tool.classfile.pcodes.CodesBlock;
import com.tool.classfile.pcodes.Instruction;
import com.tool.classfile.pcodes.Label;
import com.tool.classfile.sc;
import com.tool.simplecode.BuildEnv;
import com.tool.simplecode.Unit;
import com.tool.simplecode.Variable;
import java.io.IOException;
import java.util.Vector;

public class Block
extends Unit {
    Vector units = new Vector();
    Vector variables = new Vector();
    private CodesBlock parent_codesblock;

    public Block() {
        super(-2);
    }

    public void append(Unit unit) {
        this.units.addElement(Unit.toUnit(unit));
    }

    public void append(Label label) {
        this.units.addElement(label);
    }

    public void append(Instruction instr) {
        this.units.addElement(instr);
    }

    public Variable declareVariable(String name, String type) {
        Variable var = new Variable(name, type);
        this.variables.addElement(var);
        return var;
    }

    void genUnitSources(BuildEnv env) throws IOException {
        int i = 0;
        while (i < this.units.size()) {
            Unit unit = (Unit)this.units.elementAt(i);
            if (unit.level == -2) {
                this.genVariables(env);
            }
            unit.buildSource(env, -1);
            if (unit.level != -2) {
                env.out.writeLine();
            }
            ++i;
        }
    }

    void genUnitCodes(BuildEnv env) throws IOException {
        int i = 0;
        while (i < this.units.size()) {
            Unit unit = (Unit)this.units.elementAt(i);
            unit.buildCodes(env, "V");
            ++i;
        }
    }

    void genVariables(BuildEnv env) throws IOException {
        int i = 0;
        while (i < this.variables.size()) {
            Variable var = (Variable)this.variables.elementAt(i);
            if (var.name != null && !var.declared) {
                var.declared = true;
                env.out.writeLine(sc.javaType(var.type) + " " + var.name + ";");
            }
            ++i;
        }
    }

    protected void genSource(BuildEnv env) throws IOException {
        env.out.writeLine("{");
        this.genStatements(env);
        env.out.writeLine("}");
    }

    void genStatements(BuildEnv env) throws IOException {
        SourceWriter out = new SourceWriter(env.out);
        SourceWriter out0 = env.out;
        env.out = out;
        this.genUnitSources(env);
        env.out = out0;
    }

    protected String genCodes(BuildEnv env, String requiredType) throws IOException {
        this.genUnitCodes(env);
        return "V";
    }

    protected void enter(BuildEnv env) throws IOException {
        CodesBlock block = new CodesBlock(env.codes);
        this.parent_codesblock = env.current_block;
        this.parent_codesblock.appendBlock(block);
        env.current_block = block;
        int i = 0;
        while (i < this.variables.size()) {
            Variable var = (Variable)this.variables.elementAt(i);
            var.var = block.declareVariable(var.name, var.type);
            ++i;
        }
    }

    protected void leave(BuildEnv env) throws IOException {
        env.current_block = this.parent_codesblock;
    }
}

