/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.autoupdater.util;

import com.twmacinta.util.MD5;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class OddsJARUtil {
    private static Logger logger = Logger.getLogger(OddsJARUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean generatoOddsJAR(String oldJarFileName, String newJarFileName, String oddsJarFileName) {
        ZipOutputStream zout = null;
        ZipInputStream jarInputStream = null;
        try {
            Map md5Map = OddsJARUtil.getJarFileMD5Map(oldJarFileName);
            ArrayList<String> oddsList = new ArrayList<String>();
            File file = new File(newJarFileName);
            FileInputStream JarFileName = new FileInputStream(file);
            jarInputStream = new JarInputStream(JarFileName);
            JarEntry entry = null;
            ArrayList<String> entryNameList = new ArrayList<String>();
            while ((entry = ((JarInputStream)jarInputStream).getNextJarEntry()) != null) {
                String entryName = entry.getName();
                String md5 = OddsJARUtil.getEntryMD5(entry, (JarInputStream)jarInputStream);
                Object oldMd5 = md5Map.get(entryName);
                if (oldMd5 != null && oldMd5.toString().trim().length() > 0) {
                    entryNameList.add(entryName);
                }
                if (oldMd5 != null && oldMd5.equals(md5)) continue;
                oddsList.add(entryName);
            }
            if (md5Map.size() > entryNameList.size()) {
                OddsJARUtil.logInfo("\u90e8\u5206\u5728\u65e7\u5305\u4e2d\u7684\u6587\u4ef6\u5728\u65b0\u5305\u4e2d\u4e0d\u5b58\u5728\u3002");
                Iterator it = md5Map.keySet().iterator();
                while (it != null && it.hasNext()) {
                    Object key = it.next();
                    if (entryNameList.contains(key)) continue;
                    OddsJARUtil.logInfo(key.toString());
                }
                boolean key = false;
                return key;
            }
            if (oddsList == null && oddsList.size() == 0) {
                boolean it = true;
                return it;
            }
            File oddsJarFile = new File(oddsJarFileName);
            if (!oddsJarFile.getParentFile().exists()) {
                oddsJarFile.getParentFile().mkdirs();
            }
            FileOutputStream fout = new FileOutputStream(oddsJarFile);
            Manifest manifest = ((JarInputStream)jarInputStream).getManifest();
            if (manifest == null) {
                manifest = new Manifest();
            }
            zout = new JarOutputStream((OutputStream)fout, manifest);
            byte[] buffer = new byte[1024];
            int read = 0;
            OddsJARUtil.logInfo("\u751f\u6210\u5dee\u5f02\u5305" + newJarFileName);
            file = new File(newJarFileName);
            JarFileName = new FileInputStream(file);
            jarInputStream = new JarInputStream(JarFileName);
            while ((entry = ((JarInputStream)jarInputStream).getNextJarEntry()) != null) {
                String entryName = entry.getName();
                if (!oddsList.contains(entryName)) continue;
                ((JarOutputStream)zout).putNextEntry(entry);
                while ((read = jarInputStream.read(buffer)) != -1) {
                    zout.write(buffer, 0, read);
                }
                zout.closeEntry();
            }
            if (zout != null) {
                zout.close();
            }
            if (jarInputStream != null) {
                jarInputStream.close();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (jarInputStream != null) {
                    jarInputStream.close();
                }
                if (zout != null) {
                    zout.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergeOddsJAR(String oldJarFileName, String oddsJarFileName, String newJarFileName) {
        OddsJARUtil.logInfo("mergeOddsJAR oldJarFileName: " + oldJarFileName + " , oddsJarFileName: " + oddsJarFileName + " , newJarFileName: " + newJarFileName);
        ZipOutputStream zout = null;
        FileOutputStream fout = null;
        ZipInputStream oddsJarFileJarInputStream = null;
        InputStream oddsJarFileInputStream = null;
        try {
            List oddsEntryNameList = OddsJARUtil.getJarFileEntryNameList(oddsJarFileName);
            File oldJarFile = new File(oldJarFileName);
            if (!oldJarFile.exists()) {
                logger.error((Object)"\u65e7JAR\u5305\u4e0d\u5b58\u5728\uff01");
                return;
            }
            FileInputStream oldJarFileInputStream = new FileInputStream(oldJarFile);
            JarInputStream oldJarFileJarInputStream = new JarInputStream(oldJarFileInputStream);
            File oddsJarFile = new File(oddsJarFileName);
            if (!oddsJarFile.exists()) {
                logger.error((Object)"\u5dee\u5f02JAR\u5305\u4e0d\u5b58\u5728\uff01");
                return;
            }
            oddsJarFileInputStream = new FileInputStream(oddsJarFile);
            oddsJarFileJarInputStream = new JarInputStream(oddsJarFileInputStream);
            fout = new FileOutputStream(newJarFileName);
            Manifest manifest = ((JarInputStream)oddsJarFileJarInputStream).getManifest();
            if (manifest == null) {
                manifest = new Manifest();
            }
            zout = new JarOutputStream((OutputStream)fout, manifest);
            byte[] buffer = new byte[1024];
            int read = 0;
            JarEntry entry = null;
            while ((entry = oldJarFileJarInputStream.getNextJarEntry()) != null) {
                String entryName = entry.getName();
                if (oddsEntryNameList.contains(entryName)) continue;
                ((JarOutputStream)zout).putNextEntry(entry);
                while ((read = oldJarFileJarInputStream.read(buffer)) != -1) {
                    zout.write(buffer, 0, read);
                }
                zout.closeEntry();
            }
            if (oldJarFileJarInputStream != null) {
                oldJarFileJarInputStream.close();
            }
            if (oldJarFileInputStream != null) {
                ((InputStream)oldJarFileInputStream).close();
            }
            entry = null;
            while ((entry = ((JarInputStream)oddsJarFileJarInputStream).getNextJarEntry()) != null) {
                ((JarOutputStream)zout).putNextEntry(entry);
                while ((read = oddsJarFileJarInputStream.read(buffer)) != -1) {
                    zout.write(buffer, 0, read);
                }
                zout.closeEntry();
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        finally {
            try {
                if (zout != null) {
                    zout.close();
                }
                if (fout != null) {
                    fout.close();
                }
                if (oddsJarFileJarInputStream != null) {
                    oddsJarFileJarInputStream.close();
                }
                if (oddsJarFileInputStream != null) {
                    oddsJarFileInputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String getMD5(File file) throws IOException {
        String tmpVersion = MD5.asHex(MD5.getHash(file));
        return tmpVersion;
    }

    public static Map getJarFileMD5Map(String fileName) {
        long timeStart = System.currentTimeMillis();
        long fileSize = 0L;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            JarEntry entry;
            File file = new File(fileName);
            FileInputStream JarFileName = new FileInputStream(file);
            JarInputStream jarInputStream = new JarInputStream(JarFileName);
            fileSize = file.length() / 1024L;
            while ((entry = jarInputStream.getNextJarEntry()) != null) {
                String entryName = entry.getName();
                String md5 = OddsJARUtil.getEntryMD5(entry, jarInputStream);
                map.put(entryName, md5);
            }
            long l = System.currentTimeMillis();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getJarFileEntryNameList(String fileName) {
        long timeStart = System.currentTimeMillis();
        long fileSize = 0L;
        ArrayList<String> entryNameList = new ArrayList<String>();
        File file = null;
        InputStream inputStream = null;
        ZipInputStream jarInputStream = null;
        try {
            JarEntry entry;
            file = new File(fileName);
            inputStream = new FileInputStream(file);
            jarInputStream = new JarInputStream(inputStream);
            fileSize = file.length() / 1024L;
            while ((entry = ((JarInputStream)jarInputStream).getNextJarEntry()) != null) {
                String entryName = entry.getName();
                entryNameList.add(entryName);
            }
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        finally {
            try {
                if (jarInputStream != null) {
                    jarInputStream.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        return entryNameList;
    }

    public static String getEntryMD5(JarEntry entry, JarInputStream jarIn) throws IOException {
        MD5 md5 = new MD5();
        int tmpLen = 1024;
        int tmpSize = 0;
        byte[] buff = null;
        while (tmpSize != -1) {
            buff = new byte[tmpLen];
            tmpSize = jarIn.read(buff, 0, tmpLen);
            if (tmpSize <= 0) continue;
            md5.Update(buff, tmpSize);
        }
        String sMd5 = MD5.asHex(md5.Final());
        return sMd5;
    }

    private static void logInfo(String msg) {
        logger.info((Object)msg);
        System.out.println(msg);
    }

    private static void logError(String msg, Throwable e) {
        logger.error((Object)msg, e);
        System.out.println(msg + e.getMessage());
    }
}

