/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.eas.base.permission.ISecurity;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.Locale;
import com.kingdee.eas.base.permission.LoginAuthorWayEnum;
import com.kingdee.eas.base.permission.OrgRangeInfo;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.SecurityCollection;
import com.kingdee.eas.base.permission.SecurityFactory;
import com.kingdee.eas.base.permission.SecurityInfo;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.permission.service.OrgRangeService;
import com.kingdee.eas.base.permission.util.ToolUtils;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.External2EasUsersFacadeFactory;
import com.kingdee.eas.cp.eip.sso.External2EasUsersMapCollection;
import com.kingdee.eas.cp.eip.sso.External2EasUsersMapFactory;
import com.kingdee.eas.cp.eip.sso.External2EasUsersMapInfo;
import com.kingdee.eas.cp.eip.sso.IExternal2EasUsersFacade;
import com.kingdee.eas.cp.eip.sso.IExternal2EasUsersMap;
import com.kingdee.eas.cp.eip.sso.ILdapMapping;
import com.kingdee.eas.cp.eip.sso.LdapMappingCollection;
import com.kingdee.eas.cp.eip.sso.LdapMappingFactory;
import com.kingdee.eas.cp.eip.sso.LdapMappingInfo;
import com.kingdee.eas.cp.eip.sso.UserSyncHandleFacadeFactory;
import com.kingdee.eas.cp.eip.sso.app.AbstractUserSyncFacadeControllerBean;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.ISyncUserInitItem;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.SyncUserItem;
import com.kingdee.eas.cp.eip.sso.user.DatasourceUtilManager;
import com.kingdee.eas.cp.eip.sso.user.IDatasourceUtil;
import com.kingdee.eas.cp.eip.sso.user.IDatasourceUtilExtend;
import com.kingdee.eas.cp.eip.sso.user.LdapUtil;
import com.kingdee.eas.cp.eip.sso.user.UserResource;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigItem;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigManager;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigParseException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class UserSyncFacadeControllerBean
extends AbstractUserSyncFacadeControllerBean {
    private static String ldapImportDN;
    private static String outsystemid;
    private static Logger logger;
    private static final String TYPELDAP = "ldap";
    private static final String TYPEDATABASE = "database";
    private static String resxType;

    @Override
    protected HashMap _runUserSync(Context ctx, String ldapResxName, boolean autoCreateUser, Object object) throws BOSException, EASBizException {
        HashMap<String, Object> importMap = null;
        UserSyncHandleFacadeFactory.getLocalInstance(ctx).initManager();
        try {
            UserSyncConfigManager.loadConfig();
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        HashMap ldapResxMap = (HashMap)UserSyncConfigManager.getUserSyncResourcesMap().clone();
        HashMap returnmap = new HashMap();
        UserResource ldapResx = (UserResource)ldapResxMap.get(ldapResxName);
        resxType = ldapResx.getResourceType();
        IDatasourceUtil dsUtil = null;
        boolean isImport = false;
        if (object != null && !StringUtils.isEmpty((String)ldapResx.getSyncImport()) && resxType.equalsIgnoreCase(TYPELDAP)) {
            try {
                dsUtil = (IDatasourceUtil)Class.forName(ldapResx.getSyncImport()).newInstance();
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            isImport = true;
            importMap = new HashMap<String, Object>();
            importMap.put("context", ctx);
            importMap.put("easid", object);
            importMap.put("ldapid", ldapResxName);
            importMap.put("syncmap", ldapResxMap);
        } else {
            dsUtil = DatasourceUtilManager.getDatasourceUtil(resxType);
        }
        if (dsUtil == null) {
            System.err.println("[Eas user sync]no user resource connect util class for " + resxType + ".");
            return null;
        }
        try {
            ISyncUserInitItem syncUserInitItem = this.getSyncClass(ldapResx);
            syncUserInitItem.before(ctx);
            dsUtil.connect(ldapResxName);
            Calendar cal = Calendar.getInstance();
            Date currentDate = cal.getTime();
            HashMap syncConfigItemsMap = ldapResx.getUserSyncConfigItemMap();
            String userSourceName = ldapResx.getResourceType() + "[" + (ldapResx.getJndiName() == null || "".equals(ldapResx.getJndiName()) ? ldapResx.getProviderURL() : ldapResx.getJndiName()) + "]";
            Iterator itemIte = syncConfigItemsMap.entrySet().iterator();
            UserSyncConfigItem syncConfigItem = null;
            String executor = "administrator";
            UserInfo executorInfo = null;
            String externalUsername = "";
            String externalName = "";
            String easUsername = "";
            String desc = "";
            String password = "";
            while (itemIte.hasNext()) {
                syncConfigItem = (UserSyncConfigItem)itemIte.next().getValue();
                executor = syncConfigItem.getExecutor();
                executorInfo = this.getUserInfo(ctx, executor);
                if (!isImport) {
                    dsUtil.executeQuery(syncConfigItem);
                } else {
                    importMap.put("UserSyncConfigItem", syncConfigItem);
                    dsUtil.executeQuery(importMap);
                }
                while (dsUtil.next()) {
                    if (!syncUserInitItem.isValidation(dsUtil)) continue;
                    SyncUserItem sytitem = syncUserInitItem.initItem(dsUtil, syncConfigItem);
                    externalUsername = sytitem.getUserNumber();
                    externalName = sytitem.getUserName();
                    if (resxType.equalsIgnoreCase(TYPEDATABASE)) {
                        outsystemid = externalUsername;
                    }
                    if (resxType.equalsIgnoreCase(TYPELDAP)) {
                        ldapImportDN = !isImport ? (((LdapUtil)dsUtil).getEntryDn() + "," + syncConfigItem.getBaseDN()).toLowerCase() : ((IDatasourceUtilExtend)dsUtil).getDN();
                        outsystemid = ldapImportDN;
                        EntityViewInfo ev = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("externalUsername", (Object)externalUsername, CompareType.EQUALS));
                        ev.setFilter(filter);
                        External2EasUsersMapCollection ldapmapcol = External2EasUsersMapFactory.getLocalInstance(ctx).getExternal2EasUsersMapCollection(ev);
                        if (ldapmapcol.size() != 0) {
                            External2EasUsersMapInfo info = ldapmapcol.get(0);
                            if (!ldapImportDN.equalsIgnoreCase(info.getFactPath()) || !externalName.equalsIgnoreCase(info.getExternalUserRealName())) {
                                ILdapMapping instance;
                                LdapMappingCollection coll;
                                info.setFactPath(ldapImportDN);
                                info.setExternalUserRealName(externalName);
                                External2EasUsersMapFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
                                if (info.getEasUserID() != null && (coll = (instance = LdapMappingFactory.getLocalInstance(ctx)).getLdapMappingCollection("where easid='" + info.getEasUserID().getId().toString() + "'")).size() > 0) {
                                    LdapMappingInfo ldapMappingInfo = coll.get(0);
                                    ldapMappingInfo.setLdapdn(ldapImportDN);
                                    instance.update((IObjectPK)new ObjectUuidPK(ldapMappingInfo.getId().toString()), (CoreBaseInfo)ldapMappingInfo);
                                }
                            }
                            syncUserInitItem.sumUserSync(returnmap, "lost");
                            logger.debug((Object)("[exist][\u7528\u6237\u540c\u6b65\u65e5\u5fd7] \u7528\u6237\u65e0\u987b\u540c\u6b65\u3002EAS\u7cfb\u7edf\u5df2\u5b58\u5728\u6b64\u7528\u6237\uff1a" + externalUsername));
                            syncUserInitItem.executeItem(ctx, sytitem);
                            continue;
                        }
                    }
                    if (StringUtils.isEmpty((String)externalUsername) || StringUtils.isEmpty((String)externalName)) continue;
                    logger.debug((Object)("[\u7528\u6237\u540c\u6b65\u65e5\u5fd7] \u4ece " + userSourceName + " \u5f97\u5230\u7528\u6237\uff1a" + externalUsername));
                    try {
                        this.createEasUserMap(ctx, easUsername, externalUsername, externalName, desc, password, executorInfo, autoCreateUser, syncConfigItem.getLanguage());
                        if (resxType.equalsIgnoreCase(TYPELDAP)) {
                            syncUserInitItem.executeItem(ctx, sytitem);
                        }
                        syncUserInitItem.sumUserSync(returnmap, "success");
                        logger.debug((Object)("[success][\u7528\u6237\u540c\u6b65\u65e5\u5fd7] \u7528\u6237\u540c\u6b65\u64cd\u4f5c\u6210\u529f\u3002\u7b2c\u4e09\u65b9\u7cfb\u7edf\u7528\u6237\uff1a" + externalUsername + "\uff0cEAS\u7528\u6237\u6620\u5c04\u540d\uff1a" + easUsername));
                    }
                    catch (Exception e) {
                        logger.debug((Object)("[fail][\u7528\u6237\u540c\u6b65\u65e5\u5fd7] \u7528\u6237\u540c\u6b65\u64cd\u4f5c\u5931\u8d25\u3002\u5f02\u5e38\u4fe1\u606f\uff1a" + e.toString()));
                        e.printStackTrace();
                        throw new EASBizException(new NumericExceptionSubItem("601", "\u4e1a\u52a1\u5f02\u5e38"), (Throwable)e);
                    }
                }
                this.setLastSyncFlag(dsUtil, currentDate, syncConfigItem);
            }
            syncUserInitItem.after(ctx);
            UserSyncConfigManager.store(ldapResxMap, "UTF-8");
        }
        catch (NamingException e) {
            logger.debug((Object)("user data source connect fails.resource name=[" + ldapResxName + "]"));
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("501", "user data source connect fails.resource name"), (Throwable)e);
        }
        catch (IOException e) {
            logger.debug((Object)"user sync config file update fails.");
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("502", "user sync config file update fails."), (Throwable)e);
        }
        catch (UserSyncConfigParseException e) {
            logger.debug((Object)"user sync config file update fails.");
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("502", "user sync config file update fails."), (Throwable)e);
        }
        catch (Exception e) {
            logger.debug((Object)"user sync config file update fails.");
            e.printStackTrace();
            throw new EASBizException(new NumericExceptionSubItem("502", "user sync config file update fails."), (Throwable)e);
        }
        finally {
            UserSyncConfigManager.init();
            dsUtil.close();
        }
        return returnmap;
    }

    private ISyncUserInitItem getSyncClass(UserResource ldapResx) throws Exception {
        String syncClass = "";
        try {
            syncClass = ldapResx.getSyncClass();
        }
        catch (RuntimeException e1) {
            syncClass = "com.kingdee.eas.cp.eip.sso.special.SyncUserIsvalidationDefaultPerson";
        }
        if (StringUtils.isEmpty((String)syncClass)) {
            syncClass = "com.kingdee.eas.cp.eip.sso.special.SyncUserIsvalidationDefaultPerson";
        }
        ISyncUserInitItem syncUserInitItem = (ISyncUserInitItem)Class.forName(syncClass).newInstance();
        return syncUserInitItem;
    }

    @Override
    protected void _createEasUserMap(Context ctx, String easUsername, String externalUsername, String externalRealName, String desc, String password, UserInfo creatorInfo, boolean autoCreateUser, String language) throws BOSException, EASBizException {
        boolean isPmUser = false;
        ILdapMapping ldapMapping = LdapMappingFactory.getLocalInstance(ctx);
        LdapMappingCollection mappingCol = null;
        IUser user = UserFactory.getLocalInstance((Context)ctx);
        UserInfo userInfo = null;
        try {
            userInfo = user.getUserInfoByNumber(externalUsername);
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        if (userInfo != null && userInfo.isIsDelete()) {
            this.callBackUser(user, userInfo);
            isPmUser = true;
        }
        External2EasUsersMapInfo mapInfo = null;
        IExternal2EasUsersMap external2EasUsersMap = External2EasUsersMapFactory.getLocalInstance(ctx);
        try {
            mapInfo = external2EasUsersMap.getExternal2EasUsersMapInfo("select * where externalUsername = '" + externalUsername + "'");
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        if (mapInfo == null) {
            this.createUserMap(ctx, userInfo, externalUsername, easUsername, externalRealName, creatorInfo, outsystemid);
        }
        if (autoCreateUser) {
            if (userInfo == null) {
                userInfo = this.createNewUser(ctx, externalUsername, externalRealName, desc, password, creatorInfo, language);
            }
            if (mapInfo == null) {
                try {
                    mapInfo = external2EasUsersMap.getExternal2EasUsersMapInfo("select * where externalUsername = '" + externalUsername + "'");
                }
                catch (Exception e) {
                    logger.info((Object)e);
                }
            }
            if (mapInfo != null && !isPmUser) {
                mapInfo.setEasUserID(userInfo);
                mapInfo.setEasUsername(userInfo.getNumber());
                mapInfo.setEasUserRealName(userInfo.getName());
                mapInfo.setSSOCreateUser(true);
                try {
                    external2EasUsersMap.update((IObjectPK)new ObjectUuidPK(mapInfo.getId().toString()), (CoreBaseInfo)mapInfo);
                    mappingCol = ldapMapping.getLdapMappingCollection("select * where easid = '" + userInfo.getId().toString() + "'");
                }
                catch (Exception e) {
                    logger.info((Object)e);
                }
                if (mappingCol != null && !mappingCol.isEmpty()) {
                    this.createMapping(ctx, userInfo.getId().toString(), mapInfo.getFactPath(), mappingCol.get(0));
                } else {
                    this.createMapping(ctx, userInfo.getId().toString(), mapInfo.getFactPath(), null);
                }
            }
        } else {
            if (userInfo == null && (userInfo = this.findUserInfoByPersonName(ctx, externalRealName)) != null && userInfo.isIsDelete()) {
                this.callBackUser(user, userInfo);
            }
            if (userInfo != null && userInfo.getId() != null) {
                try {
                    mappingCol = ldapMapping.getLdapMappingCollection("select * where easid = '" + userInfo.getId().toString() + "'");
                }
                catch (Exception e) {
                    logger.info((Object)e);
                }
                if (mappingCol != null && !mappingCol.isEmpty()) {
                    this.createMapping(ctx, userInfo.getId().toString(), outsystemid, mappingCol.get(0));
                } else {
                    this.createMapping(ctx, userInfo.getId().toString(), outsystemid, null);
                }
            }
        }
    }

    private void callBackUser(IUser user, UserInfo userInfo) throws BOSException, EASBizException {
        if (user != null && userInfo != null) {
            ArrayList<String> userIdList = new ArrayList<String>();
            userIdList.add(userInfo.getId().toString());
            user.callBackUser(userIdList);
        }
    }

    private void createUserMap(Context ctx, UserInfo easUserInfo, String externalUsername, String easUsername, String externalUserRealName, UserInfo creator, String outid) throws EASBizException, BOSException {
        External2EasUsersMapInfo usersMapInfo = null;
        ILdapMapping ldapMapping = LdapMappingFactory.getLocalInstance(ctx);
        if (easUserInfo != null) {
            IExternal2EasUsersMap external2EasUsersMap = External2EasUsersMapFactory.getLocalInstance(ctx);
            External2EasUsersMapCollection externalUserCol = external2EasUsersMap.getExternal2EasUsersMapCollection("select * where easUserID.id = '" + easUserInfo.getId().toString() + "'");
            LdapMappingCollection mappingcol = ldapMapping.getLdapMappingCollection("select * where easid = '" + easUserInfo.getId().toString() + "'");
            if (mappingcol != null && !mappingcol.isEmpty()) {
                this.createMapping(ctx, easUserInfo.getId().toString(), "", mappingcol.get(0));
                if (externalUserCol != null && externalUserCol.size() != 0) {
                    usersMapInfo = externalUserCol.get(0);
                    usersMapInfo.setExternalUsername(externalUsername);
                    usersMapInfo.setExternalUserRealName(externalUserRealName);
                    external2EasUsersMap.update((IObjectPK)new ObjectStringPK(usersMapInfo.getId().toString()), (CoreBaseInfo)usersMapInfo);
                    return;
                }
            }
        }
        this.creaeteNewUserMap(ctx, easUserInfo, externalUsername, easUsername, externalUserRealName, creator, outid);
    }

    private void creaeteNewUserMap(Context ctx, UserInfo easUserInfo, String externalUsername, String easUsername, String externalUserRealName, UserInfo creator, String outid) throws BOSException, EASBizException {
        IExternal2EasUsersMap usersMapCtrl = External2EasUsersMapFactory.getLocalInstance(ctx);
        External2EasUsersMapInfo usersMapInfo = new External2EasUsersMapInfo();
        usersMapInfo.setEasUserRealName(externalUserRealName);
        if (easUserInfo != null) {
            usersMapInfo.setEasUsername(easUserInfo.getNumber());
        }
        usersMapInfo.setEasUserID(easUserInfo);
        usersMapInfo.setExternalUsername(externalUsername);
        usersMapInfo.setExternalUserRealName(externalUserRealName);
        usersMapInfo.setCU(creator.getCU());
        usersMapInfo.setCreator(creator);
        usersMapInfo.setLastUpdateUser(creator);
        Timestamp createTime = new Timestamp(System.currentTimeMillis());
        usersMapInfo.setCreateTime(createTime);
        usersMapInfo.setLastUpdateTime(createTime);
        usersMapInfo.setSSOCreateUser(false);
        if (outid == null) {
            usersMapInfo.setFactPath("", LocaleUtils.getLocale((String)"L2"));
            usersMapInfo.setFactPath("", LocaleUtils.getLocale((String)"L3"));
        } else {
            usersMapInfo.setFactPath(STConverter.tc2sc((String)outid), LocaleUtils.getLocale((String)"L2"));
            usersMapInfo.setFactPath(STConverter.sc2tc((String)outid), LocaleUtils.getLocale((String)"L3"));
        }
        if (easUserInfo != null) {
            this.createMapping(ctx, easUserInfo.getId().toString(), outid, null);
        }
        usersMapCtrl.submit((CoreBaseInfo)usersMapInfo);
    }

    private void createMapping(Context ctx, String innerid, String outerid, LdapMappingInfo info) throws BOSException, EASBizException {
        ILdapMapping ilm = LdapMappingFactory.getLocalInstance(ctx);
        if (StringUtils.isEmpty((String)innerid) && StringUtils.isEmpty((String)outerid)) {
            return;
        }
        boolean isAddnew = true;
        if (info == null) {
            info = new LdapMappingInfo();
        } else {
            isAddnew = false;
        }
        info.setEasid(innerid);
        info.setLdapdn(STConverter.tc2sc((String)outerid), LocaleUtils.getLocale((String)"L2"));
        info.setLdapdn(STConverter.sc2tc((String)outerid), LocaleUtils.getLocale((String)"L3"));
        if (isAddnew) {
            ilm.submit((CoreBaseInfo)info);
        } else {
            ilm.update((IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
        }
    }

    private void setLastSyncFlag(IDatasourceUtil dsUtil, Date currentDate, UserSyncConfigItem syncConfigItem) {
        String lastSyncUbound = syncConfigItem.getLastSyncUbound();
        String lastSync = "";
        lastSync = lastSyncUbound == null || "".equals(lastSyncUbound) ? dsUtil.getLastSync(currentDate) : lastSyncUbound;
        syncConfigItem.setLastSync(lastSync);
        syncConfigItem.setLastSyncUbound("");
    }

    private UserInfo createNewUser(Context ctx, String username, String name, String desc, String password, UserInfo creator, String language) throws EASBizException, BOSException {
        IObjectPK userPK = null;
        UserInfo userInfo = this.createNewUserFlan();
        this.fillUsername(ctx, userInfo, username, name, desc, language);
        this.fillOrgInfo(userInfo, creator.getCU());
        String cuId = creator.getCU().getId().toString();
        SecurityCollection secs = this.getSecurities(ctx, cuId);
        SecurityInfo secInfo = null;
        if (secs.size() > 0) {
            secInfo = secs.get(0);
        } else {
            logger.debug((Object)("get securities fails.this CU[" + cuId + "] is no securities."));
        }
        try {
            this.fillPasswordInfo(userInfo, password, secInfo);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.fillCreatorInfo(userInfo, creator);
        IUser userCtrl = UserFactory.getLocalInstance((Context)ctx);
        try {
            userPK = userCtrl.addnew((CoreBaseInfo)userInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        userInfo.setId(BOSUuid.read((String)userPK.toString()));
        return userInfo;
    }

    private boolean isExistsEasUserMap(Context ctx, String externalUsername, boolean isEASUser) throws EASBizException, BOSException {
        boolean result = false;
        String easUserName = null;
        IExternal2EasUsersFacade ext2EasUserCtrl = External2EasUsersFacadeFactory.getLocalInstance(ctx);
        easUserName = ext2EasUserCtrl.getEasUsername(externalUsername, isEASUser);
        if (easUserName != null) {
            result = true;
        }
        return result;
    }

    private UserInfo createNewUserFlan() {
        UserInfo info = new UserInfo();
        Calendar endDate = Calendar.getInstance();
        endDate.set(2199, 11, 31, 0, 0, 0);
        Timestamp invalidate = new Timestamp(endDate.getTimeInMillis());
        info.setInvalidationDate(invalidate);
        info.setEffectiveDate(new Timestamp(System.currentTimeMillis()));
        info.setErrCount(0);
        info.setIsDelete(false);
        info.setIsForbidden(false);
        info.setIsLocked(false);
        info.setIsRegister(true);
        info.setDefLocale(Locale.L2);
        info.setType(UserType.OTHER);
        info.setBizAdmin(false);
        return info;
    }

    private void fillOrgInfo(UserInfo userInfo, CtrlUnitInfo cuInfo) {
        userInfo.setCU(cuInfo);
        FullOrgUnitInfo cuFullOrgUnitInfo = new FullOrgUnitInfo();
        cuFullOrgUnitInfo.setId(userInfo.getCU().getId());
        cuFullOrgUnitInfo.setNumber(userInfo.getCU().getNumber());
        cuFullOrgUnitInfo.setName(userInfo.getCU().getName());
        userInfo.setDefOrgUnit(cuFullOrgUnitInfo);
        userInfo.setAgentUser(false);
        userInfo.setLoginAuthorWay(LoginAuthorWayEnum.NORMAL);
        this.setOrgRanges(userInfo);
    }

    private void setOrgRanges(UserInfo info) {
        OrgRangeInfo orgRangeInfo = new OrgRangeInfo();
        orgRangeInfo.setOrg(info.getCU().castToFullOrgUnitInfo());
        orgRangeInfo.setType(OrgRangeType.BIZ_ORG_TYPE);
        info.getOrgRange().add(orgRangeInfo);
    }

    private void fillCreatorInfo(UserInfo info, UserInfo creator) {
        info.setCreator(creator);
        Timestamp createTime = new Timestamp(System.currentTimeMillis());
        info.setCreateTime(createTime);
        info.setLastUpdateUser(creator);
        info.setLastUpdateTime(createTime);
    }

    private void fillUsername(Context ctx, UserInfo info, String userName, String name, String desc, String language) {
        info.setNumber(userName);
        String strCN = EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"languageCN");
        String strTW = EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)"languageTW");
        if (language.equals(strCN) || language.equals(STConverter.sc2tc((String)strCN))) {
            info.setName(name, LocaleUtils.getLocale((String)"L2"));
            info.setDescription(desc, LocaleUtils.getLocale((String)"L2"));
            info.setName(STConverter.sc2tc((String)name), LocaleUtils.getLocale((String)"L3"));
            info.setDescription(STConverter.sc2tc((String)desc), LocaleUtils.getLocale((String)"L3"));
        } else if (language.equals(strTW) || language.equals(STConverter.sc2tc((String)strTW))) {
            info.setName(name, LocaleUtils.getLocale((String)"L3"));
            info.setDescription(desc, LocaleUtils.getLocale((String)"L3"));
            info.setName(STConverter.tc2sc((String)name), LocaleUtils.getLocale((String)"L2"));
            info.setDescription(STConverter.tc2sc((String)desc), LocaleUtils.getLocale((String)"L2"));
        }
    }

    private void fillPasswordInfo(UserInfo info, String password, SecurityInfo secInfo) throws Exception {
        info.setPassword(CryptoTean.encrypt((String)info.getNumber(), (String)password));
        info.setPWEffectiveDate((Date)new Timestamp(System.currentTimeMillis()));
        info.setChangedPW(true);
        info.setSecurity(secInfo);
    }

    private SecurityCollection getSecurities(Context ctx, String cuId) {
        SecurityCollection securities = null;
        try {
            StringBuffer buffer = new StringBuffer(200);
            buffer.append(" WHERE CU.id = '").append("11111111-1111-1111-1111-111111111111CCE7AED4").append("' ");
            buffer.append(" OR CU.id = '").append("00000000-0000-0000-0000-000000000000CCE7AED4").append("' ");
            buffer.append(" OR CU.id = '").append(cuId).append("' ");
            buffer.append(" ORDER BY number ");
            ISecurity iSecurity = SecurityFactory.getLocalInstance((Context)ctx);
            securities = iSecurity.getSecurityCollection(buffer.toString());
        }
        catch (BOSException e) {
            logger.debug((Object)"Get user security fails.");
            e.printStackTrace();
        }
        return securities;
    }

    private UserInfo getUserInfo(Context ctx, String username) {
        UserInfo userInfo = null;
        try {
            IUser iUser = UserFactory.getLocalInstance((Context)ctx);
            userInfo = iUser.getUser(username);
        }
        catch (BOSException e) {
            logger.debug((Object)("Get userInfo fails.number=[" + username + "]"));
            e.printStackTrace();
        }
        catch (EASBizException e) {
            logger.debug((Object)("Get userInfo fails.number=[" + username + "]"));
            e.printStackTrace();
        }
        return userInfo;
    }

    private UserInfo findUserInfoByPersonName(Context ctx, String name) throws BOSException {
        UserInfo userInfo = null;
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        PersonCollection personCol = iPerson.getPersonCollection("select * where name ='" + name + "'");
        if (personCol != null && !personCol.isEmpty()) {
            PersonInfo personInfo = personCol.get(0);
            IUser iUser = UserFactory.getLocalInstance((Context)ctx);
            UserCollection userCol = iUser.getUserCollection("select * where person.id ='" + personInfo.getId().toString() + "'");
            if (userCol != null && !userCol.isEmpty()) {
                userInfo = userCol.get(0);
            }
        }
        return userInfo;
    }

    @Override
    protected void _removeEasUserMap(Context ctx) throws BOSException, EASBizException {
        String sql = "delete from T_SSO_External2EasUsers";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _batchUpdate(Context ctx, External2EasUsersMapCollection externalCol) throws BOSException, EASBizException {
        if (externalCol == null || externalCol.isEmpty()) {
            return;
        }
        ILdapMapping ilm = LdapMappingFactory.getLocalInstance(ctx);
        IExternal2EasUsersMap iExternal = External2EasUsersMapFactory.getLocalInstance(ctx);
        boolean isDelete = true;
        int size = externalCol.size();
        for (int i = 0; i < size; ++i) {
            External2EasUsersMapInfo externalInfo = externalCol.get(i);
            UserInfo easUser = externalInfo.getEasUserID();
            if (!(easUser == null && StringUtils.isEmpty((String)externalInfo.getEasUsername()) || easUser.getNumber() == null || easUser.getName(LocaleUtils.getLocale((String)"L2")) == null)) {
                this.createMapping(ctx, easUser.getId().toString(), externalInfo.getFactPath(), null);
                isDelete = false;
                externalInfo.setEasUsername(easUser.getNumber());
                externalInfo.setEasUserRealName(easUser.getName(LocaleUtils.getLocale((String)"L2")));
                externalInfo.setEasUserID(easUser);
                iExternal.update((IObjectPK)new ObjectStringPK(externalInfo.getId().toString()), (CoreBaseInfo)externalInfo);
            }
            if (!isDelete) continue;
            externalInfo = iExternal.getExternal2EasUsersMapInfo((IObjectPK)new ObjectStringPK(externalInfo.getId().toString()));
            ilm.delete("where ldapdn = '" + externalInfo.getFactPath() + "'");
            DbUtil.execute((Context)ctx, (String)("update t_sso_external2easusers set fEasUsername = null, fEasUserRealName = null, fEasUserID = null where fid = '" + externalInfo.getId().toString() + "'"));
        }
    }

    @Override
    protected void _autoDealUser(Context ctx) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        List cuIdList = OrgRangeService.getCUOrgRange((Context)ctx, (IObjectPK)ctx.getCaller());
        filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ToolUtils.aryToStr((List)cuIdList, (boolean)false), CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)"0"));
        EntityViewInfo entiryView = new EntityViewInfo();
        entiryView.setFilter(filterInfo);
        UserCollection userCol = iUser.getUserCollection(entiryView);
        if (userCol == null || userCol.isEmpty()) {
            return;
        }
        IExternal2EasUsersMap iExternalMap = External2EasUsersMapFactory.getLocalInstance(ctx);
        ILdapMapping ilm = LdapMappingFactory.getLocalInstance(ctx);
        LdapMappingCollection mappingCol = null;
        int size = userCol.size();
        for (int i = 0; i < size; ++i) {
            UserInfo userInfo = userCol.get(i);
            String oql = "select * where externalUserName = '" + userInfo.getNumber() + "'";
            External2EasUsersMapCollection externalUserCol = iExternalMap.getExternal2EasUsersMapCollection(oql);
            if (externalUserCol == null || externalUserCol.isEmpty()) continue;
            External2EasUsersMapInfo eeInfo = externalUserCol.get(0);
            mappingCol = LdapMappingFactory.getLocalInstance(ctx).getLdapMappingCollection("select * where ldapdn = '" + eeInfo.getFactPath() + "'");
            if (mappingCol != null && !mappingCol.isEmpty() && mappingCol.size() != 0) continue;
            eeInfo.setEasUserID(userInfo);
            eeInfo.setEasUsername(userInfo.getNumber());
            eeInfo.setEasUserRealName(userInfo.getName());
            iExternalMap.update((IObjectPK)new ObjectUuidPK(eeInfo.getId().toString()), (CoreBaseInfo)eeInfo);
            mappingCol = ilm.getLdapMappingCollection("select * where easid = '" + userInfo.getId().toString() + "'");
            if (mappingCol != null && !mappingCol.isEmpty()) {
                this.createMapping(ctx, userInfo.getId().toString(), eeInfo.getFactPath(), mappingCol.get(0));
                continue;
            }
            this.createMapping(ctx, userInfo.getId().toString(), eeInfo.getFactPath(), null);
        }
    }

    @Override
    protected HashMap _runUserSync(Context ctx, String ldapResxName) throws BOSException, EASBizException {
        return this._runUserSync(ctx, ldapResxName, true, null);
    }

    @Override
    protected HashMap _runUserSync(Context ctx, String ldapResxName, boolean autoCreateUser) throws BOSException, EASBizException {
        return this._runUserSync(ctx, ldapResxName, autoCreateUser, null);
    }

    private UserInfo getUniqueEasUsername(Context ctx, String externalUsername) {
        String easUsername = externalUsername;
        boolean sn = false;
        UserInfo userInfo = this.getUserInfo(ctx, easUsername);
        if (userInfo != null) {
            return userInfo;
        }
        return null;
    }

    private String createNewUsername(String easUsername, String usernameSuffix, int sn) {
        StringBuffer newUsername = new StringBuffer(easUsername);
        if (usernameSuffix != null && !"".equals(usernameSuffix)) {
            newUsername.append(usernameSuffix);
            if (sn > 0) {
                newUsername.append(sn);
            }
        } else {
            newUsername.append(sn);
        }
        return newUsername.toString();
    }

    static {
        logger = Logger.getLogger((String)UserSyncFacadeControllerBean.class.getName());
    }
}

