/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.qrcode;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.cp.common.web.util.DataCenterManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrTokenOpenIdManager {
    private static final Logger logger = LoggerFactory.getLogger(QrTokenOpenIdManager.class);

    public static boolean applyQrCode(Context ctx, String qrcodeUrl, String token, long expireTime) {
        String uuid = UUID.randomUUID().toString();
        String sql = "INSERT INTO T_QR_QrCodeOpenIdMap(fid, fQrCodeUrl, fQrCodeToken, fQrcodeTicket, fExpireTime, fOpenId , fScanned) VALUES ( '" + uuid + "',?,?,'" + "NULL_TICKET" + "',?,'" + "NULL_OPENID" + "','0')";
        logger.info(sql);
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{qrcodeUrl, token, expireTime});
        }
        catch (BOSException e) {
            logger.error(e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean updateTicket(Context ctx, String ticket, String token) {
        String sql = "UPDATE T_QR_QrCodeOpenIdMap SET fQrCodeTicket =?, fScanned = '1' WHERE  fQrCodeToken = ?";
        logger.info(sql + "   ticket===" + ticket + "    token===" + token);
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{ticket, token});
        }
        catch (BOSException e) {
            logger.error(e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean updateTicketAndOpenId(Context ctx, String ticket, String openId, String token) {
        String sql = "UPDATE T_QR_QrCodeOpenIdMap SET fQrCodeTicket =?, fOpenId = ?,  fScanned = '1' WHERE  fQrCodeToken = ?";
        logger.info(sql + "   ticket===" + ticket + "    token===" + token);
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{ticket, openId, token});
        }
        catch (BOSException e) {
            logger.error(e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTicket(Context ctx, String qrCodeToken) {
        String sql = "SELECT FQrcodeTicket FROM T_QR_QrCodeOpenIdMap  WHERE  fQrCodeToken =?";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{qrCodeToken});
            if (rs.next()) {
                String string = rs.getString("FQrCodeTicket");
                SQLUtils.cleanup((ResultSet)rs);
                return string;
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            SQLUtils.cleanup(rs);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRightTicketByTokenAndUser(Context ctx, String token, String userNumber) {
        boolean ret;
        IRowSet rs;
        block4: {
            String sql = "select fScanned,fExpireTime from t_qr_QrCodeOpenIdMap qrcode inner join t_pm_easxtusermap umap on qrcode.fopenid = umap.fxtid inner join t_pm_user u on u.fid = umap.fuserid where u.fnumber = ? and qrcode.fQrCodeToken = ?";
            Object[] params = new Object[]{userNumber, token};
            rs = null;
            ret = false;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
                if (!rs.next()) break block4;
                String fScanned = rs.getString("fScanned");
                String fExpireTime = rs.getString("fExpireTime");
                if (!"1".equals(fScanned) || System.currentTimeMillis() >= Long.valueOf(fExpireTime)) break block4;
                ret = true;
            }
            catch (Exception e) {
                try {
                    logger.error(e.getMessage());
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserInfo(Context ctx, String openId) {
        String sql = "SELECT fuserid, fusernumber, fcell, fpersonid, fpersonname FROM T_pm_easxtusermap  where fxtid = ?";
        String userid = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{openId});
            if (rs.next()) {
                userid = rs.getString("fuserid");
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            SQLUtils.cleanup(rs);
        }
        return userid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getUserInfoMap(Context ctx, String openId) {
        String sql = "SELECT fuserid, fusernumber, fpersonname FROM T_pm_easxtusermap  where fxtid = ?";
        Hashtable<String, String> user = new Hashtable<String, String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{openId});
            if (rs.next()) {
                user.put("id", rs.getString("fuserid"));
                user.put("userNumber", rs.getString("fusernumber"));
                user.put("personName", rs.getString("fpersonname"));
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            SQLUtils.cleanup(rs);
        }
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserInfoMapByToken(Context ctx, String token) {
        String sql = "SELECT umap.fusernumber userNumber FROM T_pm_easxtusermap umap inner join t_qr_QrCodeOpenIdMap qrcode on umap.fxtid = qrcode.fopenid where qrcode.fQrCodeToken = ?";
        String userNumber = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{token});
            if (rs.next()) {
                userNumber = rs.getString("userNumber");
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        finally {
            SQLUtils.cleanup(rs);
        }
        return userNumber;
    }

    public static String tryGetOpenId(Context ctx, String token) {
        String sql = "SELECT fOpenId FROM T_QR_QrCodeOpenIdMap WHERE  fQrCodeToken = '4c3c6a35-a6c9-487d-a94b-4f8b08771cd8' and fScanned = '1'";
        String openid = "";
        if (StringUtils.isEmpty((String)openid)) {
            openid = "NULL_OPENID";
        }
        return openid;
    }

    public static final void destroy(Context ctx) {
        String sql = "delete from T_QR_QrCodeOpenIdMap where FExpireTime < " + System.currentTimeMillis();
        try {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Context getContext(String dataCenter, String language) {
        Context context = new Context();
        Context userCtx = new Context();
        Locale locale = new Locale(QrTokenOpenIdManager.transferLanguage(language));
        userCtx.setLocale(locale);
        DataCenterManager dc = new DataCenterManager(userCtx);
        ArrayList dcList = dc.getDCList();
        for (DCInfo di : dcList) {
            if (!dataCenter.equals(di.getNumber())) continue;
            context.setAIS(dataCenter);
            context.setLocale(locale);
        }
        return context;
    }

    private static String transferLanguage(String language) {
        String lg = "";
        lg = "ch".equals(language) || "L2".equals(language) || "l2".equals(language) ? "l2" : ("tw".equals(language) || "L3".equals(language) || "l3".equals(language) ? "l3" : "l1");
        return lg;
    }

    public static void destory(Context ctx, String token) {
        String sql = "delete from T_QR_QrCodeOpenIdMap where fQrCodeToken = ?";
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{token});
        }
        catch (Exception e) {
            logger.error("\u6e05\u9664 qucodetoken\u5931\u8d25   fQrCodeToken===" + token);
            e.printStackTrace();
        }
        QrTokenOpenIdManager.destroy(ctx);
    }

    public static void updateOpenId(Context ctx, String openId, String token) {
        String sql = "update t_qr_QrCodeOpenIdMap set fOpenId = ? where fQrCodeToken = ?";
        try {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{openId, token});
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0openid\u5931\u8d25   fQrCodeToken===" + token + "    openid===" + openId);
            e.printStackTrace();
        }
    }
}

