/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.util;

import com.kingdee.eas.cp.eip.sso.ldapAdapter.AbstractXML;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigParseException;
import com.kingdee.eas.cp.eip.sso.xml.INode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class EASConfigManagerUtil
extends AbstractXML {
    protected Logger logger = Logger.getLogger(EASConfigManagerUtil.class);
    private static EASConfigManagerUtil eASConfigManagerUtil = null;
    private static String fileName;
    private static final String LDAP = "ldap";
    private static final String IMPORTKEY = "importKey";
    private static final String ATTRNAME = "name";
    private static final String ATTRVALUE = "value";
    private static final String ATTRTYPE = "type";

    private EASConfigManagerUtil() {
    }

    public static EASConfigManagerUtil initLdapConfigManager(String file) {
        if (eASConfigManagerUtil == null) {
            eASConfigManagerUtil = new EASConfigManagerUtil();
        }
        fileName = file;
        return eASConfigManagerUtil;
    }

    @Override
    public void write(Object object) throws IOException {
        this.writeXML(this.initNodeString(object), fileName);
    }

    @Override
    protected String initNodeString(Object object) throws IOException {
        HashMap objectMap = (HashMap)object;
        Map.Entry entry22 = null;
        StringBuffer sb = new StringBuffer();
        for (Map.Entry entry22 : objectMap.entrySet()) {
            if (entry22 == null) continue;
            sb.append(this.initNodeOne(LDAP, this.initNameOrValue(entry22.getKey().toString(), null), "1", "SEALSIGN_OFF"));
            for (Map.Entry entry22 : ((HashMap)entry22.getValue()).entrySet()) {
                sb.append(this.initNodeOne(IMPORTKEY, this.initNameOrValue(entry22.getKey().toString(), entry22.getValue().toString()), "3", "SEALSIGN_ON"));
            }
            sb.append(this.initNodeSeal(LDAP, "1"));
        }
        return sb.toString();
    }

    @Override
    public Object readXML() throws UserSyncConfigParseException, IOException {
        HashMap<String, HashMap> ldapResourcesMap = new HashMap<String, HashMap>();
        INode[] ldapResxNodes = this.getChildNodes(this.initTree(fileName), LDAP);
        String ldapResxKey = "";
        for (int i = 0; i < ldapResxNodes.length; ++i) {
            ldapResxKey = ldapResxNodes[i].getAttribute(ATTRTYPE);
            ldapResourcesMap.put(ldapResxKey, this.buildInfo(ldapResxNodes[i]));
        }
        return ldapResourcesMap;
    }

    @Override
    protected HashMap buildInfo(INode resourceNode) throws UserSyncConfigParseException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (INode childNode = resourceNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (!IMPORTKEY.equalsIgnoreCase(childNode.getNodeName())) continue;
            map.put(childNode.getAttribute(ATTRNAME), childNode.getAttribute(ATTRVALUE));
        }
        return map;
    }

    public Map getReadXML() throws UserSyncConfigParseException, IOException {
        HashMap map = null;
        try {
            map = (HashMap)this.readXML();
        }
        catch (UserSyncConfigParseException e) {
            this.logger.info((Object)("LdapMapEASConfig is parse exception:" + e));
            throw e;
        }
        catch (IOException e) {
            this.logger.info((Object)("LdapMapEASConfig is io exception:" + e));
            throw e;
        }
        return map;
    }

    public Map getReadXMLStartRootNode(String type) throws UserSyncConfigParseException, IOException {
        HashMap map = (HashMap)this.getReadXML();
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : map.entrySet()) {
            if (!entry2.getKey().toString().equals(type)) continue;
            map = (HashMap)entry2.getValue();
            break;
        }
        return map;
    }

    public static void main(String[] args) {
        HashMap aa = null;
        try {
            aa = (HashMap)EASConfigManagerUtil.initLdapConfigManager("easImportLdapConfig.xml").getReadXML();
        }
        catch (UserSyncConfigParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Iterator it = aa.entrySet().iterator();
        Map.Entry entry2 = null;
        while (it.hasNext()) {
            entry2 = it.next();
            System.out.println("aaaaaa::" + entry2.getKey());
            for (Map.Entry entry2 : ((HashMap)entry2.getValue()).entrySet()) {
                System.out.println("111::" + entry2.getKey());
                System.out.println("222::" + entry2.getValue());
            }
            System.out.println("------------------");
        }
    }
}

