/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.STConverter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.ILdapEntry;
import com.kingdee.eas.cp.eip.sso.LdapEntryFactory;
import com.kingdee.eas.cp.eip.sso.LdapEntryInfo;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapControlInfo;
import com.kingdee.eas.cp.eip.sso.ldapAdapter.LdapEasInfo;
import com.kingdee.eas.cp.eip.sso.user.UserSyncConfigParseException;
import com.kingdee.eas.cp.eip.sso.util.LdapConfigManagerUtil;
import com.kingdee.eas.cp.eip.sso.util.LdapImportLanguageUtil;
import com.kingdee.eas.cp.eip.sso.util.LongNumberUtil;
import com.kingdee.eas.cp.eip.sso.util.ReadPropertiesUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LocaleUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class LdapImportUtil {
    public static final String LDAPLANGUAGE_PROPERTIES = "ldapLanguageType.properties";
    public static final String LDAPLANGUAGE_PRO_NAME = "languager";

    private LdapImportUtil() {
    }

    public static void initDescription(LdapEntryInfo info, Object ob) {
        String str = null;
        str = LdapImportUtil.getEasNumber(ob.toString());
        info.setDescription(STConverter.tc2sc((String)str), LocaleUtils.getLocale((String)"L2"));
        info.setDescription(STConverter.sc2tc((String)str), LocaleUtils.getLocale((String)"L3"));
    }

    public static void initException(LdapEntryInfo info, String str) {
        info.setException(STConverter.tc2sc((String)str), LocaleUtils.getLocale((String)"L2"));
        info.setException(STConverter.sc2tc((String)str), LocaleUtils.getLocale((String)"L3"));
    }

    public static void initType(LdapEntryInfo info, String str) {
        str = EASResource.getString((String)"com.kingdee.eas.cp.eip.sso.UserSyncResource", (String)str) + "(" + str + ")";
        info.setType(STConverter.tc2sc((String)str), LocaleUtils.getLocale((String)"L2"));
        info.setType(STConverter.sc2tc((String)str), LocaleUtils.getLocale((String)"L3"));
    }

    public static void initControl(LdapEntryInfo info, String str) {
        if (str.equals("add")) {
            str = "ldap\u6dfb\u52a0Entry";
        } else if (str.equals("del")) {
            str = "ldap\u5220\u9664Entry";
        } else if (str.equals("SEL")) {
            str = "ldap\u67e5\u627eEntry";
        } else if (str.equals("UPD")) {
            str = "ldap\u4fee\u6539Entry";
        }
        info.setControl(STConverter.tc2sc((String)str), LocaleUtils.getLocale((String)"L2"));
        info.setControl(STConverter.sc2tc((String)str), LocaleUtils.getLocale((String)"L3"));
    }

    public static String initDN(String addType, HashMap map, boolean isPDN) throws UserSyncConfigParseException, IOException {
        String ldapProName = null;
        String easProName = null;
        String relativelyValue = null;
        String strDn = null;
        LdapEasInfo ldapEasInfo2 = null;
        LdapControlInfo ldapControlInfo = LdapImportUtil.getLdapControlInfo(addType);
        for (LdapEasInfo ldapEasInfo2 : ldapControlInfo.getMapValue()) {
            ldapProName = ldapEasInfo2.getKeyName();
            easProName = ldapEasInfo2.getKeyValue();
            if (!ldapProName.equals(ldapControlInfo.getRelativelyName())) continue;
            try {
                Object obValue = map.get(ldapControlInfo.getEasRelativelyName());
                if (obValue == null) {
                    return null;
                }
                relativelyValue = LdapImportLanguageUtil.getInfoValue(ldapControlInfo.getEasRelativelyName(), obValue).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            strDn = LdapImportUtil.putDN(relativelyValue, ldapProName, isPDN);
            break;
        }
        return strDn + ldapControlInfo.getDn();
    }

    private static String putDN(String str, String relatively, boolean isPDN) {
        StringBuffer sb = new StringBuffer();
        List list = LongNumberUtil.longNumber2List(str);
        int num = list.size();
        if (isPDN) {
            --num;
        }
        for (int i = num - 1; i >= 0; --i) {
            sb.append(relatively);
            sb.append("=");
            sb.append(list.get(i));
            sb.append(",");
        }
        return sb.toString();
    }

    public static String getEasNumber(String str) {
        List list = LongNumberUtil.longNumber2List(str);
        return list.get(list.size() - 1).toString();
    }

    public static LdapControlInfo getLdapControlInfo(String addType) throws UserSyncConfigParseException, IOException {
        LdapControlInfo ldapControlInfo = new LdapControlInfo();
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : LdapConfigManagerUtil.init().getReadXMLStartRootNode().entrySet()) {
            if (!entry2.getKey().toString().equals(addType)) continue;
            ldapControlInfo = (LdapControlInfo)entry2.getValue();
            break;
        }
        return ldapControlInfo;
    }

    public static Object getRelativelyValue(String addType, HashMap map) throws UserSyncConfigParseException, IOException {
        LdapControlInfo ldapControlInfo = LdapImportUtil.getLdapControlInfo(addType);
        Object object = null;
        Iterator it = ldapControlInfo.getMapValue().iterator();
        LdapEasInfo ldapEasInfo = null;
        while (it.hasNext()) {
            ldapEasInfo = (LdapEasInfo)it.next();
            if (!ldapEasInfo.getKeyName().equals(ldapControlInfo.getRelativelyName())) continue;
            object = LdapImportLanguageUtil.getInfoValue(ldapEasInfo.getKeyValue(), map.get(ldapEasInfo.getKeyValue()));
        }
        return object;
    }

    public static Object getOURelativelyValue(String addType, HashMap map) throws UserSyncConfigParseException, IOException {
        LdapControlInfo ldapControlInfo = LdapImportUtil.getLdapControlInfo(addType);
        Object object = null;
        object = LdapImportLanguageUtil.getInfoValue(ldapControlInfo.getEasEntryID(), map.get(ldapControlInfo.getEasEntryID()));
        return object;
    }

    public static String getPwdKey(String addType) throws UserSyncConfigParseException, IOException {
        LdapControlInfo ldapControlInfo = LdapImportUtil.getLdapControlInfo(addType);
        return ldapControlInfo.getEasEntryPwd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initException(Context ctx, LdapEntryInfo info) {
        ILdapEntry il = null;
        try {
            il = LdapEntryFactory.getLocalInstance(ctx);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                if (info.getException() != null && info.getException().toString().length() != 0) {
                    il.submit((CoreBaseInfo)info);
                }
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getLanguageTypeStr() {
        return ReadPropertiesUtil.getLanguage(LDAPLANGUAGE_PROPERTIES, LDAPLANGUAGE_PRO_NAME).toUpperCase();
    }

    public static Locale getLanguageTypeLocale() {
        return LocaleUtils.getLocale((String)LdapImportUtil.getLanguageTypeStr());
    }
}

