/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.sso.client.oauth2.OAuth2LoginManager;
import com.kingdee.eas.base.license.CloudRegistSrvAgentFactory;
import com.kingdee.eas.base.license.ControlPolicy;
import com.kingdee.eas.base.license.EASCloudEnum;
import com.kingdee.eas.base.license.ErpUserStatusEnum;
import com.kingdee.eas.base.license.ICloudRegistSrv;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.license.file.cloudRegist.CloudRegistUserInfo;
import com.kingdee.eas.base.license.file.cloudRegist.DefaultUserEnum;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.base.uiframe.utils.SecurityValidator;
import com.kingdee.eas.cp.eip.sso.EasMultiAuthManager;
import com.kingdee.eas.cp.eip.sso.util.BASE64Util;
import com.kingdee.eas.cp.eip.sso.util.CloudActiveParamsUtil;
import com.kingdee.eas.cp.eip.sso.util.CloudParamUtil;
import com.kingdee.eas.cp.eip.sso.util.TransferUtil;
import com.kingdee.eas.cp.eip.sso.web.CustomRequestWrapper;
import com.kingdee.eas.util.BASE64Encoder;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URLEncoder;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.validation.Assertion;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserNameDecodeFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(UserNameDecodeFilter.class);
    private Map<String, String> map;
    private boolean isRsaEncrypt = false;
    private static String pubKey = null;
    private static RSAPrivateKey privateKey = null;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block37: {
            String encryptUsername = request.getParameter("enU");
            String enPassword = request.getParameter("enP");
            String enL = request.getParameter("enL");
            String enD = request.getParameter("enD");
            String userName = request.getParameter("username");
            String password = request.getParameter("password");
            if (StringUtils.isEmpty((String)userName)) {
                userName = request.getParameter("kdacccode");
            }
            if (StringUtils.isEmpty((String)password)) {
                password = request.getParameter("kdacctoken");
            }
            String language = request.getParameter("locale");
            String dataCenter = request.getParameter("dataCenter");
            HttpServletRequest resq = (HttpServletRequest)request;
            String serverPath = resq.getServletPath();
            String portalUrl = request.getParameter("service");
            this.checkService(request.getServerName(), portalUrl, response);
            if (this.isRsaEncrypt) {
                request.setAttribute("pubKey", (Object)pubKey);
            }
            String dierctUrl = null;
            dierctUrl = portalUrl.endsWith("/shr/") ? "/shr/" : "/portal/";
            if (portalUrl == null) {
                portalUrl = dierctUrl;
            }
            if (portalUrl.indexOf("jsessionid") > -1 || portalUrl.indexOf("ssoLogoutTo") > -1) {
                HttpServletResponse res = (HttpServletResponse)response;
                res.sendRedirect(dierctUrl);
            } else if (serverPath.indexOf("login") > -1) {
                if (encryptUsername != null && enPassword != null && !",72450,61067,52015".equals(encryptUsername)) {
                    try {
                        this.checkAllParams(request, response);
                        if (this.isRsaEncrypt) {
                            try {
                                encryptUsername = UserNameDecodeFilter.decrypt(encryptUsername);
                            }
                            catch (Exception e) {
                                logger.error("decode usename error,enU is[" + encryptUsername + "]", (Throwable)e);
                            }
                            try {
                                enPassword = UserNameDecodeFilter.decrypt(enPassword);
                            }
                            catch (Exception e) {
                                logger.error("decode  password error,enP is[" + enPassword + "]", (Throwable)e);
                            }
                        }
                        String originUserName = BASE64Util.decodeAsString(encryptUsername);
                        if (OAuth2LoginManager.isLoginByOAuth2((HttpServletRequest)resq) && !OAuth2LoginManager.isExcludeUser((String)originUserName)) {
                            HttpServletResponse res = (HttpServletResponse)response;
                            String redirectUri = OAuth2LoginManager.constructAuthorizationRedirectUri((HttpServletRequest)resq, (HttpServletResponse)res, (String)portalUrl);
                            res.sendRedirect(redirectUri);
                            return;
                        }
                        String orginPassword = BASE64Util.decodeAsString(enPassword);
                        String orginL = BASE64Util.decodeAsString(enL);
                        String orginD = BASE64Util.decodeAsString(enD);
                        CustomRequestWrapper newRequest = new CustomRequestWrapper(resq);
                        newRequest.addParameter("username", originUserName);
                        newRequest.addParameter("password", orginPassword);
                        newRequest.addParameter("locale", orginL);
                        newRequest.addParameter("dataCenter", orginD);
                        newRequest.addParameter("lt", BASE64Util.decodeAsString(request.getParameter("lt")));
                        newRequest.addParameter("isPureWeb", BASE64Util.decodeAsString(request.getParameter("isPureWeb")));
                        newRequest.addParameter("easSessionId", BASE64Util.decodeAsString(request.getParameter("easSessionId")));
                        newRequest.addParameter("userAuthPattern", BASE64Util.decodeAsString(request.getParameter("userAuthPattern")));
                        newRequest.addParameter("loginFlow", BASE64Util.decodeAsString(request.getParameter("loginFlow")));
                        newRequest.addParameter("clientHostIP", BASE64Util.decodeAsString(request.getParameter("clientHostIP")));
                        Context context = CloudParamUtil.getContext(orginD, orginL, originUserName);
                        context.setUserName(originUserName);
                        this.redirectToURL((ServletRequest)newRequest, response, chain, context, originUserName, orginL, orginD, dierctUrl);
                    }
                    catch (Exception e) {
                        logger.error("decryptSha1 error ===", (Throwable)e);
                    }
                } else if (userName != null && password != null) {
                    try {
                        if (UserNameDecodeFilter.checkStrValidate("username", userName, null) || UserNameDecodeFilter.checkStrValidate("password", password, null) || UserNameDecodeFilter.checkStrValidate("redirectTo", request.getParameter("redirectTo"), null)) {
                            HttpServletResponse res = (HttpServletResponse)response;
                            try {
                                res.sendRedirect("/eassso/unreg/unvalibaleParam.jsp");
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break block37;
                        }
                        Context context = CloudParamUtil.getContext(dataCenter, language, userName);
                        CustomRequestWrapper newRequest = new CustomRequestWrapper(resq);
                        newRequest.addParameter("password", password);
                        newRequest.addParameter("username", userName);
                        this.redirectToURL((ServletRequest)newRequest, response, chain, context, userName, language, dataCenter, portalUrl);
                    }
                    catch (Exception e) {
                        logger.error("sso usercode filter error ===", (Throwable)e);
                    }
                } else {
                    String userAuthPattern;
                    if (portalUrl != null && UserNameDecodeFilter.checkStrValidate("portalUrl", portalUrl, null)) {
                        HttpServletResponse res = (HttpServletResponse)response;
                        try {
                            res.sendRedirect("/eassso/unreg/unvalibaleParam.jsp");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if ((userAuthPattern = request.getParameter("userAuthPattern")) != null && !EasMultiAuthManager.validateDefaultAuthPattern(userAuthPattern)) {
                        try {
                            ((HttpServletResponse)response).sendRedirect("/eassso/unreg/unvalibaleParam.jsp");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        HttpSession session = ((HttpServletRequest)request).getSession();
                        Object privacyStatementNeed = null;
                        if (session != null) {
                            privacyStatementNeed = session.getAttribute("privacyStatementNeed");
                        }
                        if (privacyStatementNeed != null) {
                            chain.doFilter(request, response);
                        } else {
                            chain.doFilter(request, response);
                        }
                    }
                }
            } else {
                String url = request.getParameter("url");
                if (url != null && !"/portal".equals(url) && !"/easportal".equals(url)) {
                    HttpServletResponse res = (HttpServletResponse)response;
                    res.sendRedirect("/eassso/unreg/unvalibaleUrl.jsp");
                } else {
                    chain.doFilter(request, response);
                }
            }
        }
    }

    public static String decrypt(String encodeText) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        return new String(cipher.doFinal(BASE64Util.decodeAsBytes(encodeText)));
    }

    private void checkService(String serverName, String portalUrl, ServletResponse response) {
        String compareUrl;
        int lt;
        if (portalUrl == null) {
            this.sendRedirect(response, "/eassso/unreg/unvalibaleParam.jsp");
        }
        if ((lt = (compareUrl = portalUrl).indexOf("?")) > 0) {
            compareUrl = compareUrl.substring(0, lt);
        }
        if (compareUrl.contains("@") || compareUrl.contains("%40")) {
            this.sendRedirect(response, "/eassso/unreg/unvalibaleParam.jsp");
        }
        List<String> ipList = this.getIpList();
        ipList.add(serverName);
        boolean bl = false;
        for (String ip : ipList) {
            if (portalUrl.indexOf(ip) <= 0 || portalUrl.indexOf(ip) >= 16) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.sendRedirect(response, "/eassso/unreg/unvalibaleParam.jsp");
        }
    }

    private void sendRedirect(ServletResponse response, String url) {
        HttpServletResponse res = (HttpServletResponse)response;
        try {
            res.sendRedirect(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<String> getIpList() {
        ArrayList<String> ipList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> enu = NetworkInterface.getNetworkInterfaces();
            while (enu.hasMoreElements()) {
                NetworkInterface ni = enu.nextElement();
                Enumeration<InetAddress> ias = ni.getInetAddresses();
                while (ias.hasMoreElements()) {
                    InetAddress localAddress = ias.nextElement();
                    String ip = localAddress.getHostAddress();
                    if (ip == null || "127.0.0.1".equals(ip) || !CloudParamUtil.isIP(ip)) continue;
                    ipList.add(ip);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ipList;
    }

    private void checkAllParams(ServletRequest request, ServletResponse response) {
        Map paramMap = request.getParameterMap();
        for (Map.Entry entry : paramMap.entrySet()) {
            Object ov = entry.getValue();
            String[] value = new String[1];
            if (ov instanceof String[]) {
                value = (String[])ov;
            } else {
                value[0] = ov.toString();
            }
            if (value[0] == null) continue;
            String checkValue = value[0];
            String decodeCheckValue = null;
            if (this.needDecodeParams((String)entry.getKey()) != null) {
                if (this.isRsaEncrypt && ("enP".equals(entry.getKey()) || "password".equals(entry.getKey()) || "enU".equals(entry.getKey()) || "username".equals(entry.getKey()))) {
                    try {
                        value[0] = UserNameDecodeFilter.decrypt(value[0]);
                        decodeCheckValue = BASE64Util.decodeAsString(value[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        decodeCheckValue = checkValue;
                    }
                } else {
                    decodeCheckValue = BASE64Util.decodeAsString(value[0]);
                }
            }
            if (!UserNameDecodeFilter.checkStrValidate((String)entry.getKey(), checkValue, decodeCheckValue)) continue;
            HttpServletResponse res = (HttpServletResponse)response;
            try {
                res.sendRedirect("/eassso/unreg/unvalibaleParam.jsp");
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Map<String, String> getNeedDecodeParams() {
        if (this.map == null) {
            this.map = new HashMap<String, String>();
            this.map.put("enU", "1");
            this.map.put("enP", "1");
            this.map.put("enL", "1");
            this.map.put("enD", "1");
            this.map.put("username", "1");
            this.map.put("password", "1");
            this.map.put("locale", "1");
            this.map.put("dataCenter", "1");
            this.map.put("lt", "1");
            this.map.put("isPureWeb", "1");
            this.map.put("easSessionId", "1");
            this.map.put("userAuthPattern", "1");
            this.map.put("loginFlow", "1");
            this.map.put("clientHostIP", "1");
            this.map.put("bgMode", "1");
        }
        return this.map;
    }

    private String needDecodeParams(String paramKey) {
        return this.getNeedDecodeParams().get(paramKey);
    }

    private void redirectToURL(ServletRequest request, ServletResponse response, FilterChain chain, Context context, String userName, String language, String dataCenter, String portalUrl) {
        block27: {
            try {
                HttpServletResponse resp = (HttpServletResponse)response;
                ICloudRegistSrv cloudInstance = CloudRegistSrvAgentFactory.getLocalInstance((Context)context);
                boolean isSelfUserFlag = cloudInstance.isInternalUseType();
                boolean isRegister = LicenseSrvAgentFactory.getLocalInstance((Context)context).isRegister();
                userName = CloudActiveParamsUtil.getNumberByExternalNumber(context, userName);
                if (isSelfUserFlag && isRegister) {
                    for (DefaultUserEnum def : DefaultUserEnum.values()) {
                        if (!def.name().equalsIgnoreCase(userName)) continue;
                        chain.doFilter(request, response);
                        return;
                    }
                    CloudRegistUserInfo cloudRegistUserInfo = CloudRegistSrvAgentFactory.getLocalInstance((Context)context).getCloudRegistUserInfo(context.getUserName());
                    if (cloudRegistUserInfo != null && !StringUtils.isEmpty((String)cloudRegistUserInfo.getCloudUuId())) {
                        if (request instanceof CustomRequestWrapper) {
                            this.changeSession((HttpServletRequest)((CustomRequestWrapper)request));
                        }
                        chain.doFilter(request, response);
                        return;
                    }
                    resp.sendRedirect("/eassso/unreg/reg.jsp?type=NO_CLOUND_PASSPORT&portalUrl=" + URLEncoder.encode(portalUrl, "utf-8"));
                    return;
                }
                String userAuthPattern = request.getParameter("userAuthPattern");
                JSONObject userStatus = new JSONObject();
                if ("QrCodeToken".equals(userAuthPattern)) {
                    userName = CloudActiveParamsUtil.getNumberByExternalNumber(context, userName, userAuthPattern);
                    cloudInstance.addActivedErpUser(userName);
                    userStatus.put("userStatus", (Object)ErpUserStatusEnum.SUCCESSED.toString());
                } else {
                    if ("KingdeeCloud".equalsIgnoreCase(userAuthPattern)) {
                        userName = CloudActiveParamsUtil.getNumberByExternalNumber(context, userName, userAuthPattern);
                    }
                    userStatus = this.checkUserStatus(context, userName);
                }
                if ("NOT_ACTIVATED".equals(userStatus.get("userStatus"))) {
                    com.alibaba.fastjson.JSONObject cloudStatu = null;
                    boolean isCanGetCloudStatu = true;
                    try {
                        cloudStatu = EasCloud.getUserCloudActiveStatu((Context)context, (String)userName);
                    }
                    catch (Exception e1) {
                        isCanGetCloudStatu = false;
                        logger.error("get statu from cloud occur IOException", (Throwable)e1);
                    }
                    if (!isCanGetCloudStatu) {
                        String pwdTip = this.getPwdTip(context, userName);
                        resp.sendRedirect("/eassso/unreg/reg.jsp?type=NOT_ACTIVATED&needChangePwd=" + userStatus.get("needChangePwd") + "&regType=" + userStatus.get("regType") + "&authCode=" + userStatus.get("authCode") + "&userNumber=" + URLEncoder.encode(userName, "utf-8") + "&language=" + language + "&dataCenter=" + URLEncoder.encode(dataCenter, "utf-8") + "&portalUrl=" + URLEncoder.encode(portalUrl, "utf-8") + "&pwdTips=" + URLEncoder.encode(pwdTip, "utf-8"));
                    } else {
                        boolean isCloudActive = false;
                        if (cloudStatu != null && cloudStatu.getIntValue("errcode") == 0) {
                            boolean bl = isCloudActive = cloudStatu.getJSONObject("data").getIntValue("active_status") == 1;
                        }
                        if (!isCloudActive) {
                            String pwdTip = this.getPwdTip(context, userName);
                            resp.sendRedirect("/eassso/unreg/newReg.jsp?type=NOT_ACTIVATED&needChangePwd=" + userStatus.get("needChangePwd") + "&regType=" + userStatus.get("regType") + "&authCode=" + userStatus.get("authCode") + "&userNumber=" + URLEncoder.encode(userName, "utf-8") + "&language=" + language + "&dataCenter=" + URLEncoder.encode(dataCenter, "utf-8") + "&portalUrl=" + URLEncoder.encode(portalUrl, "utf-8") + "&pwdTips=" + URLEncoder.encode(pwdTip, "utf-8"));
                        } else {
                            if (ControlPolicy.isBySubscriptionRegOnline((Context)context)) {
                                StringBuilder permSql = new StringBuilder();
                                permSql.append("SELECT FID USERCOUNT,FCELL,FEMAIL FROM T_PM_USER WHERE LOWER(FNUMBER)=?");
                                IRowSet rs = DbUtil.executeQuery((Context)context, (String)permSql.toString(), (Object[])new Object[]{userName.toLowerCase()});
                                if (rs.next()) {
                                    cloudInstance.addActivedErpUser(userName, rs.getString("FCELL"), rs.getString("FEMAIL"));
                                }
                            } else {
                                cloudInstance.addActivedErpUser(userName);
                            }
                            if (userStatus.getBoolean("needChangePwd")) {
                                String pwdTip = this.getPwdTip(context, userName);
                                resp.sendRedirect("/eassso/unreg/reg.jsp?type=NOT_ACTIVATED&needChangePwd=" + userStatus.get("needChangePwd") + "&regType=" + userStatus.get("regType") + "&authCode=" + userStatus.get("authCode") + "&userNumber=" + URLEncoder.encode(userName, "utf-8") + "&language=" + language + "&dataCenter=" + URLEncoder.encode(dataCenter, "utf-8") + "&portalUrl=" + URLEncoder.encode(portalUrl, "utf-8") + "&pwdTips=" + URLEncoder.encode(pwdTip, "utf-8"));
                            } else {
                                chain.doFilter(request, response);
                            }
                        }
                    }
                    break block27;
                }
                if ("NO_CLOUND_PASSPORT".equals(userStatus.get("userStatus"))) {
                    resp.sendRedirect("/eassso/unreg/reg.jsp?type=NO_CLOUND_PASSPORT&portalUrl=" + URLEncoder.encode(portalUrl, "utf-8"));
                } else if ("NOT_ENABLED".equals(userStatus.get("userStatus"))) {
                    resp.sendRedirect("/eassso/unreg/reg.jsp?type=NOT_ENABLED&portalUrl=" + URLEncoder.encode(portalUrl, "utf-8"));
                } else {
                    if (request instanceof CustomRequestWrapper) {
                        this.changeSession((HttpServletRequest)((CustomRequestWrapper)request));
                    }
                    chain.doFilter(request, response);
                }
            }
            catch (Exception e) {
                logger.error("sso usercode filter error ===", (Throwable)e);
            }
        }
    }

    private void changeSession(HttpServletRequest newRequest) {
        Assertion assertion;
        HttpSession session = newRequest.getSession();
        Assertion assertion2 = assertion = session != null ? (Assertion)session.getAttribute("_const_cas_assertion_") : null;
        if (assertion != null && assertion.getPrincipal() != null && assertion.getPrincipal().getName() != null) {
            return;
        }
        Enumeration enu = session.getAttributeNames();
        HashMap<String, Object> oldSession = new HashMap<String, Object>();
        while (enu.hasMoreElements()) {
            String sessionKey = enu.nextElement().toString();
            oldSession.put(sessionKey, session.getAttribute(sessionKey));
        }
        try {
            session.invalidate();
            session = newRequest.getSession();
            for (Map.Entry entry : oldSession.entrySet()) {
                session.setAttribute((String)entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            logger.info("changeSession error ===", (Throwable)e);
        }
    }

    private String deCodeStr(String enCodeStr) {
        String[] enCodeArray;
        String str = "";
        for (String s : enCodeArray = enCodeStr.split(",")) {
            if (s == null || s.length() <= 0) continue;
            str = str + TransferUtil.asiicToString(Integer.parseInt(s, 8));
        }
        return str;
    }

    private JSONObject checkUserStatus(Context context, String userName) {
        JSONObject obj = new JSONObject();
        boolean checkStatus = false;
        boolean needChangePwd = false;
        try {
            StringBuilder permSql = new StringBuilder();
            permSql.append("SELECT FID USERCOUNT,FCELL,FEMAIL FROM T_PM_USER WHERE LOWER(FNUMBER)=?");
            IRowSet rs = DbUtil.executeQuery((Context)context, (String)permSql.toString(), (Object[])new Object[]{userName.toLowerCase()});
            if (rs != null && rs.size() > 0) {
                while (rs.next()) {
                    ErpUserStatusEnum userStatus;
                    String userId = rs.getString("USERCOUNT");
                    if (userId == null) continue;
                    String authCode = "333";
                    ICloudRegistSrv cloudInstance = CloudRegistSrvAgentFactory.getLocalInstance((Context)context);
                    EASCloudEnum licenseType = LicenseSrvAgentFactory.getLocalInstance((Context)context).getRemoteEASCloudVersion();
                    if (EASCloudEnum.CLOUD_PUBLIC.equals((Object)licenseType) || EASCloudEnum.CLOUD_PUBLIC_SIMPLE.equals((Object)licenseType)) {
                        userStatus = cloudInstance.getErpUserStatus(userName, rs.getString("FCELL"), rs.getString("FEMAIL"));
                    } else if (EASCloudEnum.CLOUD_HYBRID.equals((Object)licenseType) || EASCloudEnum.CLOUD_HYBRID_SIMPLE.equals((Object)licenseType)) {
                        userStatus = cloudInstance.getErpUserStatus(userName, rs.getString("FCELL"), rs.getString("FEMAIL"));
                        if (ErpUserStatusEnum.SUCCESSED.equals((Object)userStatus)) {
                            CloudRegistSrvAgentFactory.getLocalInstance((Context)context).addActivedErpUser(userName);
                        }
                        if (ErpUserStatusEnum.NOT_ACTIVATED.equals((Object)userStatus)) {
                            userStatus = cloudInstance.getErpUserStatus(userName);
                        }
                    } else {
                        userStatus = cloudInstance.getErpUserStatus(userName);
                    }
                    String regType = "phone";
                    if ("SUCCESSED".equals(userStatus.toString())) {
                        checkStatus = true;
                    } else if ("NOT_ACTIVATED".equals(userStatus.toString())) {
                        String authPattern;
                        UserInfo userInfo = UserFactory.getLocalInstance((Context)context).getUserInfo((IObjectPK)new ObjectUuidPK(userId));
                        if (userInfo != null && "BaseDB".equals(authPattern = CloudActiveParamsUtil.getAuthPattern()) && this.checkPasswordPolicy(userInfo)) {
                            needChangePwd = true;
                        }
                        authCode = cloudInstance.getErpUserActiveCode(userName);
                        Map<String, String> paramMap = CloudParamUtil.getCloudParams(context);
                        String phoneNum = paramMap.get("wholePhone");
                        logger.error("UserNameDecodeFilter == paramMap.get('wholePhone') === " + paramMap.get("mixPhone"));
                        if (phoneNum == null) {
                            phoneNum = "";
                        }
                        if (phoneNum.indexOf("@") > -1) {
                            regType = "email";
                        }
                    }
                    obj.put("authCode", (Object)authCode);
                    obj.put("regType", (Object)regType);
                    obj.put("userStatus", (Object)userStatus.toString());
                    obj.put("needChangePwd", needChangePwd);
                }
            } else {
                obj.put("userStatus", (Object)"NO_ERP_USER");
            }
            obj.put("success", checkStatus);
        }
        catch (Exception e) {
            logger.error("UserNameDecodeFilter == checkUserStatus === ", (Throwable)e);
        }
        return obj;
    }

    public static boolean checkStrValidate(String paramKey, String str, String decodeCheckValue) {
        if ("username".equals(paramKey) || "password".equals(paramKey)) {
            return false;
        }
        boolean result = false;
        if (str != null && str.length() > 0) {
            if (decodeCheckValue == null) {
                decodeCheckValue = "1";
            }
            if (paramKey != null && (paramKey.equalsIgnoreCase("dbtype") || paramKey.equalsIgnoreCase("datacenter") || paramKey.equalsIgnoreCase("locale") || paramKey.equalsIgnoreCase("selectdatacenter") || paramKey.equalsIgnoreCase("bgmode")) && !(result = UserNameDecodeFilter.checkSpecialParam(str))) {
                result = UserNameDecodeFilter.checkSpecialParam(decodeCheckValue);
            }
            if (str.indexOf("'") > -1 || str.indexOf("%27") > -1 || str.indexOf("(") > -1 || str.indexOf("%28") > -1 || decodeCheckValue.indexOf("'") > -1 || decodeCheckValue.indexOf("%27") > -1 || decodeCheckValue.indexOf("(") > -1 || decodeCheckValue.indexOf("%28") > -1 || str.indexOf("../") > -1 || str.indexOf("WEB-INF") > -1 || str.indexOf("./") > -1) {
                result = true;
            }
        }
        return result;
    }

    private static boolean checkSpecialParam(String str) {
        boolean result = false;
        if (str != null && str.length() > 0 && (str.indexOf(".") > -1 || str.indexOf("%2f") > -1 || str.indexOf("%2F") > -1 || str.indexOf("/") > -1) || str.indexOf("%2B") > -1 || str.indexOf("%2b") > -1 || str.indexOf("+") > -1) {
            result = true;
        }
        return result;
    }

    private String getPwdTip(Context context, String number) {
        String pwdTip = "";
        try {
            Class<?> cls = Class.forName("com.kingdee.eas.base.permission.helper.SecurityValidatorHelper");
            Object obj = cls.newInstance();
            Method setConextMethod = cls.getMethod("getPwdTip", Context.class, String.class);
            Object obj_pwdTip = setConextMethod.invoke(obj, context, number);
            pwdTip = String.valueOf(obj_pwdTip);
        }
        catch (ClassNotFoundException e) {
            logger.error("UserNameDecodeFilter 1 getPwdTip \u6839\u636eEAS\u5b9e\u9645\u7684\u7528\u6237\u540d\u5f97\u5230\uff0c\u5bc6\u7801\u7b56\u7565\u4fe1\u606f:", (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error("UserNameDecodeFilter 2 getPwdTip \u6839\u636eEAS\u5b9e\u9645\u7684\u7528\u6237\u540d\u5f97\u5230\uff0c\u5bc6\u7801\u7b56\u7565\u4fe1\u606f:", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("UserNameDecodeFilter 3 getPwdTip \u6839\u636eEAS\u5b9e\u9645\u7684\u7528\u6237\u540d\u5f97\u5230\uff0c\u5bc6\u7801\u7b56\u7565\u4fe1\u606f:", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error("UserNameDecodeFilter 4 getPwdTip \u6839\u636eEAS\u5b9e\u9645\u7684\u7528\u6237\u540d\u5f97\u5230\uff0c\u5bc6\u7801\u7b56\u7565\u4fe1\u606f:", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error("UserNameDecodeFilter 5 getPwdTip \u6839\u636eEAS\u5b9e\u9645\u7684\u7528\u6237\u540d\u5f97\u5230\uff0c\u5bc6\u7801\u7b56\u7565\u4fe1\u606f:", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error("UserNameDecodeFilter 6 getPwdTip \u6839\u636eEAS\u5b9e\u9645\u7684\u7528\u6237\u540d\u5f97\u5230\uff0c\u5bc6\u7801\u7b56\u7565\u4fe1\u606f:", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error("UserNameDecodeFilter 7 getPwdTip \u6839\u636eEAS\u5b9e\u9645\u7684\u7528\u6237\u540d\u5f97\u5230\uff0c\u5bc6\u7801\u7b56\u7565\u4fe1\u606f:", (Throwable)e);
        }
        return pwdTip;
    }

    private boolean checkPasswordPolicy(UserInfo userInfo) {
        UserInfo userInfoCopy = (UserInfo)userInfo.clone();
        userInfoCopy.setPassword("");
        return SecurityValidator.isRequireChangePassword((UserInfo)userInfoCopy);
    }

    public static String getPubKey() {
        return pubKey;
    }

    public void init(FilterConfig fConfig) throws ServletException {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(2048);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            privateKey = (RSAPrivateKey)keyPair.getPrivate();
            pubKey = new BASE64Encoder().encode(publicKey.getEncoded());
            this.isRsaEncrypt = true;
        }
        catch (Throwable e) {
            logger.error("sso init rsa key failed", e);
        }
    }

    public void destroy() {
    }
}

