/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui;

import com.kingdee.bos.ctrl.analysis.AnalysisException;
import com.kingdee.bos.ctrl.analysis.cubemodel.CubeModelResource;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.CubeModelDataProvider;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.model.Column;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.model.Table;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.WizardContext;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.AbstractWizardStep;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.Dim_PC_SelectColumn;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.Dim_Std_CreateLevel;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.Dim_Time_SelectColumnAndHieType;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import java.awt.Dimension;
import javax.swing.JComponent;

public class Dim_SelectTable
extends AbstractWizardStep {
    boolean isStandard = false;
    boolean isTime = false;
    boolean isParentChild = false;
    private String oldTableName;
    CubeModelDataProvider dataProvider;
    WizardDialog.StepsManager manager;

    public Dim_SelectTable(WizardContext context) {
        super(context);
        this.dataProvider = (CubeModelDataProvider)context.get("DataProvider");
    }

    @Override
    public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
        super.intoThisStep(prevStep, isOppose);
        if (!isOppose) {
            if (this.context.get("DimensionType").equals("standard")) {
                this.isStandard = true;
            } else if (this.context.get("DimensionType").equals("time")) {
                this.isTime = true;
            } else {
                this.isParentChild = true;
            }
        } else {
            Table table = (Table)this.context.get("DimensionTable");
            this.oldTableName = table.getName();
        }
    }

    public IWizardStep outThisStep(boolean isOppose) {
        if (!isOppose) {
            Table table = this.getSelectedTable();
            if (table == null) {
                this.alert(CubeModelResource.getString(CubeModelResource.class, (String)"PleaseSelectDimTable"));
                return this;
            }
            Table factTable = (Table)this.context.get("FactTable");
            if (table.equals(factTable)) {
                this.alert(CubeModelResource.getString(CubeModelResource.class, (String)"DimFactTableCantSame"));
                return this;
            }
            if (this.isTime) {
                int count = table.getColumnCount();
                boolean found = false;
                for (int i = 0; i < count; ++i) {
                    Column column = table.getColumn(i);
                    if (column.getDataType() != DataType.DATETIME) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.alert(CubeModelResource.getString(CubeModelResource.class, (String)"TableNoTimeColumn"));
                    return this;
                }
            }
            this.context.put("DimensionTable", table);
            if (this.oldNextStep != null && table.getName().equals(this.oldTableName)) {
                return null;
            }
            if (this.isStandard) {
                return new Dim_Std_CreateLevel(this.context);
            }
            if (this.isTime) {
                return new Dim_Time_SelectColumnAndHieType(this.context);
            }
            return new Dim_PC_SelectColumn(this.context);
        }
        return null;
    }

    @Override
    public void initStep(WizardDialog.StepsManager manager) {
        super.initStep(manager);
        this.manager = manager;
        JComponent component = this.dataProvider.getDataSelectComponent();
        component.setMinimumSize(new Dimension(80, 60));
        this.add(component, this.layout(CubeModelResource.getString(CubeModelResource.class, (String)"SelectDimensionTable"), CubeModelResource.getString(CubeModelResource.class, (String)"SelectDimTableDesc")));
    }

    private Table getSelectedTable() {
        String id = this.dataProvider.getSelectedNodeID();
        if (id == null) {
            return null;
        }
        try {
            return this.dataProvider.queryTableModel(id);
        }
        catch (AnalysisException e) {
            return null;
        }
    }
}

