/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.olapconnection;

import com.kingdee.bos.ctrl.analysis.report.ReportResource;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.ConnectionInfoWrapper;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.IConnectStringParser;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.OlapConnectConstants;
import com.kingdee.bos.ctrl.analysis.report.olapconnection.OlapConnectionException;
import java.util.Locale;

public class ConnectStringParser
implements OlapConnectConstants,
IConnectStringParser {
    private String provider;
    private String url;

    @Override
    public ConnectionInfoWrapper parse(String connectString) throws OlapConnectionException {
        if (connectString == null) {
            throw new NullPointerException();
        }
        String connectString2 = connectString.trim();
        String lower = connectString2.toLowerCase(Locale.ENGLISH);
        if (!lower.startsWith("provider=")) {
            throw new OlapConnectionException("Olap" + ReportResource.getString(ReportResource.class, (String)"mustBeginWith") + "\"provider=\"" + ReportResource.getString(ReportResource.class, (String)"begin"));
        }
        int index = lower.indexOf("url=");
        if (index < 0) {
            throw new OlapConnectionException("Olap" + ReportResource.getString(ReportResource.class, (String)"mustInclude") + "\"url=\"" + ReportResource.getString(ReportResource.class, (String)"information"));
        }
        this.provider = connectString2.substring("provider=".length());
        int index2 = this.provider.indexOf(";");
        if (index2 < 0) {
            throw new OlapConnectionException("Olap" + ReportResource.getString(ReportResource.class, (String)"mustBeginWith") + "\";\"" + ReportResource.getString(ReportResource.class, (String)"seperate") + "\"provider" + ReportResource.getString(ReportResource.class, (String)"informationand") + "url" + ReportResource.getString(ReportResource.class, (String)"information"));
        }
        this.provider = this.provider.substring(0, index2).trim();
        if (this.provider.length() == 0) {
            throw new OlapConnectionException("Olap" + ReportResource.getString(ReportResource.class, (String)"connString") + "provider" + ReportResource.getString(ReportResource.class, (String)"informatNotNull"));
        }
        this.url = connectString2.substring(index + "url=".length());
        this.url = this.url.trim();
        if (this.url.length() == 0) {
            throw new OlapConnectionException("Olap" + ReportResource.getString(ReportResource.class, (String)"connString") + "url" + ReportResource.getString(ReportResource.class, (String)"informatNotNull"));
        }
        int type = -1;
        if ("kdolap".equalsIgnoreCase(this.provider)) {
            type = 0;
        } else if ("msolap_xmla".equalsIgnoreCase(this.provider)) {
            type = 1;
        } else if ("msolap_oledb".equalsIgnoreCase(this.provider)) {
            type = 2;
        } else {
            throw new OlapConnectionException(ReportResource.getString(ReportResource.class, (String)"conString2") + connectString + ReportResource.getString(ReportResource.class, (String)"in") + this.provider + ReportResource.getString(ReportResource.class, (String)"unknowType"));
        }
        return new ConnectionInfoWrapper(type, this.url);
    }
}

