/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.chart;

import com.kingdee.bos.ctrl.analysis.olap.AxisMembersHelper;
import com.kingdee.bos.ctrl.analysis.olap.Cell;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.MemberTree;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.web.chart.ChartDataModel;
import com.kingdee.bos.ctrl.analysis.web.chart.ChartModel;
import com.kingdee.bos.ctrl.analysis.web.chart.IMemberFilter;
import com.kingdee.bos.ctrl.analysis.web.chart.RadarChartConfig;
import com.kingdee.bos.ctrl.analysis.web.chart.TopInfo;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.freechart.data.category.CategoryDataset;
import com.kingdee.bos.ctrl.freechart.data.category.DefaultCategoryDataset;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChartDataSet {
    private Hierarchy[] rowHierarchies;
    private Hierarchy[] columnHierarchies;
    private List rowPositions;
    private List columnPositions;
    private int rowCount;
    private int columnCount;
    private Number[][] values;
    private ChartModel chartModel;

    public ChartDataSet(ChartModel chartModel) throws OlapException, BIReportException {
        this.chartModel = chartModel;
        if (chartModel.getDataModel() != null) {
            this.buildWithDataModel();
        } else {
            this.buildNormal();
        }
    }

    private void buildNormal() throws OlapException {
        OlapModel olapModel = this.chartModel.getOlapModel();
        this.rowPositions = olapModel.getResult().getRowAxis().getPositions();
        this.columnPositions = olapModel.getResult().getColumnAxis().getPositions();
        this.rowHierarchies = olapModel.getResult().getRowAxis().getHierarchies();
        this.columnHierarchies = olapModel.getResult().getColumnAxis().getHierarchies();
        this.rowCount = this.rowPositions.size();
        this.columnCount = this.columnPositions.size();
        this.values = new Number[this.rowCount][this.columnCount];
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < this.columnCount; ++j) {
                Number v;
                this.values[i][j] = v = this.getNumberValue(olapModel.getResult().getCell(j, i));
            }
        }
    }

    private void buildWithDataModel() throws OlapException, BIReportException {
        ChartDataModel dataModel = this.chartModel.getDataModel();
        OlapModel olapModel = this.chartModel.getOlapModel();
        this.rowHierarchies = olapModel.getResult().getRowAxis().getHierarchies();
        this.columnHierarchies = olapModel.getResult().getColumnAxis().getHierarchies();
        Member[] memberIncludes = dataModel.getMemberIncludes();
        HashMap mapIncludes = new HashMap();
        if (memberIncludes != null) {
            for (int i = 0; i < memberIncludes.length; ++i) {
                this.setMembers(mapIncludes, memberIncludes[i]);
            }
        }
        Member[] memberExcludes = dataModel.getMemberExcludes();
        HashMap mapExcludes = new HashMap();
        if (memberExcludes != null) {
            for (int i = 0; i < memberExcludes.length; ++i) {
                this.setMembers(mapExcludes, memberExcludes[i]);
            }
        }
        IMemberFilter[] memberFilters = dataModel.getMemberFilters();
        HashMap mapFilters = new HashMap();
        if (memberFilters != null) {
            for (int i = 0; i < memberFilters.length; ++i) {
                this.setMemberFilters(mapFilters, memberFilters[i]);
            }
        }
        this.rowPositions = new ArrayList();
        ArrayList rowPositionIndexes = new ArrayList();
        this.columnPositions = new ArrayList();
        ArrayList columnPositionIndexes = new ArrayList();
        this.collectPositions(olapModel, mapExcludes, mapIncludes, mapFilters, olapModel.getResult().getRowAxis().getPositions(), this.rowPositions, rowPositionIndexes);
        this.collectPositions(olapModel, mapExcludes, mapIncludes, mapFilters, olapModel.getResult().getColumnAxis().getPositions(), this.columnPositions, columnPositionIndexes);
        this.rowCount = this.rowPositions.size();
        this.columnCount = this.columnPositions.size();
        this.values = new Number[this.rowCount][this.columnCount];
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < this.columnCount; ++j) {
                Number v;
                int column = (Integer)columnPositionIndexes.get(j);
                int row = (Integer)rowPositionIndexes.get(i);
                this.values[i][j] = v = this.getNumberValue(olapModel.getResult().getCell(column, row));
            }
        }
    }

    private void collectPositions(OlapModel olapModel, Map mapExcludes, Map mapIncludes, Map mapFilters, List originPositions, List targetPositions, List targetPositionIndexes) {
        int rowIndex = 0;
        for (Position pos : originPositions) {
            Member[] ms = pos.getMembers();
            boolean ok = true;
            for (int i = 0; i < ms.length; ++i) {
                List excludeList = (List)mapExcludes.get(ms[i].getHierarchy());
                List includeList = (List)mapIncludes.get(ms[i].getHierarchy());
                List filterList = (List)mapFilters.get(ms[i].getDimension());
                if (excludeList != null && excludeList.contains(ms[i])) {
                    ok = false;
                } else if (includeList != null && !includeList.contains(ms[i])) {
                    ok = false;
                } else if (filterList != null) {
                    for (IMemberFilter mf : filterList) {
                        if (mf.filter(olapModel, ms[i])) continue;
                        ok = false;
                    }
                }
                if (!ok) break;
            }
            if (ok) {
                targetPositions.add(pos);
                targetPositionIndexes.add(new Integer(rowIndex));
            }
            ++rowIndex;
        }
    }

    private void setMemberFilters(HashMap map, IMemberFilter mf) {
        ArrayList<IMemberFilter> list = (ArrayList<IMemberFilter>)map.get(mf.getDimension());
        if (list == null) {
            list = new ArrayList<IMemberFilter>();
            map.put(mf.getDimension(), list);
        }
        list.add(mf);
    }

    private void setMembers(HashMap map, Member member) {
        ArrayList<Member> list = (ArrayList<Member>)map.get(member.getHierarchy());
        if (list == null) {
            list = new ArrayList<Member>();
            map.put(member.getHierarchy(), list);
        }
        list.add(member);
    }

    public CategoryDataset buildDataset() throws OlapException, BIReportException {
        Position rp;
        List list;
        int i;
        OlapModel olapModel = this.chartModel.getOlapModel();
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        MemberTree myTree = (MemberTree)olapModel.getExtension("memberTree");
        HashMap rowKeyCache = new HashMap();
        Hierarchy[] rowhs = this.rowHierarchies;
        Hierarchy[] columnhs = this.columnHierarchies;
        ArrayList<String> onlyOneMemberHs_row = new ArrayList<String>();
        ArrayList<String> onlyOneMemberHs_column = new ArrayList<String>();
        AxisMembersHelper amh = (AxisMembersHelper)olapModel.getExtension("axisMembersHelper");
        for (i = 0; i < rowhs.length; ++i) {
            list = amh.findVisibleMembers(rowhs[i]);
            if (list.size() >= 2) continue;
            onlyOneMemberHs_row.add(rowhs[i].getUniqueName());
        }
        for (i = 0; i < columnhs.length; ++i) {
            list = amh.findVisibleMembers(columnhs[i]);
            if (list.size() >= 2) continue;
            onlyOneMemberHs_column.add(columnhs[i].getUniqueName());
        }
        if (this.columnCount == 1) {
            onlyOneMemberHs_column.clear();
        }
        int rowCount = this.rowCount;
        boolean topN = false;
        boolean other = false;
        ChartDataModel dataModel = this.chartModel.getDataModel();
        if (dataModel != null && dataModel.getTopN() != null) {
            topN = true;
            if (dataModel.getTopN().value > 0 && dataModel.getTopN().value < rowCount) {
                other = dataModel.getTopN().other;
                rowCount = dataModel.getTopN().value;
                if (other) {
                    ++rowCount;
                }
            }
        }
        RadarChartConfig radarConfig = this.chartModel.component.getRadarConfig();
        boolean radarConfigEnable = radarConfig.isEnable();
        List validIndexList = radarConfig.getValidIndexList();
        block2: for (int i2 = 0; i2 < this.columnCount; ++i2) {
            if (radarConfigEnable && validIndexList != null && !validIndexList.contains(i2 + "")) continue;
            Position p = (Position)this.columnPositions.get(i2);
            Member[] colMembers = p.getMembers();
            String label = this.buildName(myTree, colMembers, onlyOneMemberHs_column);
            if (rowCount == 1) {
                onlyOneMemberHs_row.clear();
            }
            for (int k = 0; k < rowCount; ++k) {
                if (topN && other && k == rowCount - 1) {
                    double otherValue = 0.0;
                    for (int m = k; m < this.rowCount; ++m) {
                        if (this.values[m][i2] == null) continue;
                        otherValue += this.values[m][i2].doubleValue();
                    }
                    dataset.addValue(otherValue, (Comparable)((Object)label.toString()), (Comparable)((Object)"\u5176\u5b83"));
                    continue block2;
                }
                Object key = rowKeyCache.get(k + "");
                if (key == null) {
                    rp = (Position)this.rowPositions.get(k);
                    Member[] rowMembers = rp.getMembers();
                    key = this.buildName(myTree, rowMembers, onlyOneMemberHs_row);
                    rowKeyCache.put(k + "", key);
                }
                dataset.addValue(this.values[k][i2], (Comparable)((Object)label.toString()), (Comparable)((Object)key.toString()));
            }
        }
        if (radarConfigEnable) {
            int i3;
            String[] radarTargetSelfDefValues = radarConfig.getRadarTargetSelfDefValues();
            String[] radarMinSelfDefValues = radarConfig.getRadarMinSelfDefValues();
            int radarTargetColumnIndex = radarConfig.getRadarTargetColumnIndex();
            int radarMinColumnIndex = radarConfig.getRadarMinColumnIndex();
            if (radarTargetSelfDefValues != null) {
                for (i3 = 0; !(i3 >= rowCount || topN && other && i3 == rowCount - 1); ++i3) {
                    Object key = rowKeyCache.get(i3 + "");
                    if (key == null) {
                        rp = (Position)this.rowPositions.get(i3);
                        Member[] rowMembers = rp.getMembers();
                        key = this.buildName(myTree, rowMembers, onlyOneMemberHs_row);
                    }
                    dataset.addValue((Number)new BigDecimal(radarTargetSelfDefValues[i3]), (Comparable)((Object)"\u81ea\u5b9a\u4e49\u6807\u51c6\u503c"), (Comparable)((Object)(key + "")));
                }
            }
            if (radarMinSelfDefValues != null) {
                for (i3 = 0; !(i3 >= rowCount || topN && other && i3 == rowCount - 1); ++i3) {
                    Object key = rowKeyCache.get(i3 + "");
                    if (key == null) {
                        rp = (Position)this.rowPositions.get(i3);
                        Member[] rowMembers = rp.getMembers();
                        key = this.buildName(myTree, rowMembers, onlyOneMemberHs_row);
                    }
                    dataset.addValue((Number)new BigDecimal(radarMinSelfDefValues[i3]), (Comparable)((Object)"\u81ea\u5b9a\u4e49\u6700\u5dee\u503c"), (Comparable)((Object)(key + "")));
                }
            }
            if (radarTargetSelfDefValues != null && radarMinSelfDefValues != null && radarTargetColumnIndex > radarMinColumnIndex) {
                radarTargetColumnIndex ^= radarMinColumnIndex;
                radarMinColumnIndex = radarTargetColumnIndex ^ radarMinColumnIndex;
                radarTargetColumnIndex ^= radarMinColumnIndex;
            }
        }
        return dataset;
    }

    private Number getNumberValue(Cell cell) {
        Object value = cell.getValue();
        Number number = null;
        try {
            number = (Number)value;
        }
        catch (Exception e) {
            number = null;
        }
        return number;
    }

    private String buildName(MemberTree myTree, Member[] members, List onlyOneMemberHs) {
        int len = members.length;
        String retValue = null;
        HashMap levelMap = new HashMap();
        HashMap hierarchyMap = new HashMap();
        if (len == 1) {
            return members[0].getLabel();
        }
        for (int j = members.length - 1; j >= 0; --j) {
            Member member = members[j];
            if (onlyOneMemberHs.contains(member.getHierarchy().getUniqueName())) continue;
            retValue = retValue != null ? member.getLabel() + "," + retValue : member.getLabel();
        }
        return retValue;
    }

    public Hierarchy[] getRowHierarchies() {
        return this.rowHierarchies;
    }

    public Hierarchy[] getColumnHierarchies() {
        return this.columnHierarchies;
    }

    public List getRowPositions() {
        return this.rowPositions;
    }

    public List getColumnPositions() {
        return this.columnPositions;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Member[] getMemberContext(int column, int row) throws BIReportException {
        ChartDataModel dataModel = this.chartModel.getDataModel();
        if (dataModel != null && dataModel.getTopN() != null) {
            TopInfo top = dataModel.getTopN();
            if (top.other && top.value > 0 && top.value < this.rowCount && row == top.value) {
                return null;
            }
        }
        Member[] rowms = ((Position)this.rowPositions.get(row)).getMembers();
        Member[] colms = ((Position)this.columnPositions.get(column)).getMembers();
        Member[] ret = new Member[rowms.length + colms.length];
        System.arraycopy(rowms, 0, ret, 0, rowms.length);
        System.arraycopy(colms, 0, ret, rowms.length, colms.length);
        return ret;
    }
}

