/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.permission;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.web.permission.BIPermission;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BIPermission_EAS
implements BIPermission {
    private Context ctx;
    private IPermission iPermission;
    private IObjectPK userPK;
    private IObjectPK orgPK;
    private Map mapPermission = new HashMap();
    private Map mapDataPermission = new HashMap();
    private Logger log = CommonLogger.getLogger(this.getClass());

    public BIPermission_EAS(Context ctx) throws BIReportException {
        this(ctx, true);
    }

    public BIPermission_EAS(Context ctx, boolean isWeb) throws BIReportException {
        this.ctx = ctx;
        if (ctx != null) {
            try {
                this.iPermission = isWeb ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)ctx);
            }
            catch (BOSException e) {
                throw new BIReportException("\u65e0\u6cd5\u83b7\u53d6EAS\u7684\u6743\u9650,\u539f\u56e0:" + e.getMessage());
            }
            this.userPK = new ObjectStringPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            this.orgPK = new ObjectStringPK(ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString());
        }
    }

    @Override
    public boolean hasPermission(String permissionItemName) throws BIReportException {
        String perKey = permissionItemName;
        if (this.mapPermission.containsKey(perKey)) {
            return (Boolean)this.mapPermission.get(perKey);
        }
        if (this.ctx == null) {
            this.mapPermission.put(perKey, new Boolean(true));
            return true;
        }
        try {
            boolean ret = this.iPermission.hasFunctionPermission(this.userPK, this.orgPK, permissionItemName);
            this.mapPermission.put(perKey, new Boolean(ret));
            return ret;
        }
        catch (EASBizException e) {
            this.log.info((Object)("\u65e0\u6cd5\u83b7\u53d6" + permissionItemName + "\u6743\u9650,\u539f\u56e0:" + e.getMessage()));
            return false;
        }
        catch (BOSException e) {
            this.log.info((Object)("\u65e0\u6cd5\u83b7\u53d6" + permissionItemName + "\u6743\u9650,\u539f\u56e0:" + e.getMessage()));
            return false;
        }
    }

    private boolean hasDataPermission(String permissionItemName, String itemID, IObjectPK userPK, IObjectPK orgPK) throws BIReportException {
        if (this.ctx == null) {
            return true;
        }
        try {
            if (itemID == null) {
                return false;
            }
            ObjectUuidPK pk = new ObjectUuidPK("id", BOSUuid.read((String)itemID));
            return this.iPermission.hasDataPermission(userPK, orgPK, permissionItemName, (IObjectPK)pk);
        }
        catch (EASBizException e) {
            this.log.info((Object)("\u65e0\u6cd5\u83b7\u53d6" + permissionItemName + ":" + itemID + "\u7684\u6570\u636e\u6743\u9650,\u51fa\u9519\u539f\u56e0:" + e.getMessage()));
            return false;
        }
        catch (BOSException e) {
            this.log.info((Object)("\u65e0\u6cd5\u83b7\u53d6" + permissionItemName + ":" + itemID + "\u7684\u6570\u636e\u6743\u9650,\u51fa\u9519\u539f\u56e0:" + e.getMessage()));
            return false;
        }
    }

    @Override
    public boolean hasDataPermission(String permissionItemName, String itemID) throws BIReportException {
        String perKey = this.makeKey(permissionItemName, itemID);
        if (this.mapDataPermission.containsKey(perKey)) {
            return (Boolean)this.mapDataPermission.get(perKey);
        }
        boolean b = this.hasDataPermission(permissionItemName, itemID, this.userPK, this.orgPK);
        this.mapDataPermission.put(perKey, new Boolean(b));
        return b;
    }

    private String makeKey(String str1, String str2) {
        return (str1 == null ? "" : str1) + '\u0001' + (str2 == null ? "" : str2);
    }

    @Override
    public String getDashboardPermissionRolesSQL(String dashboardID) throws BIReportException {
        String sql = "SELECT D.FROLEID,R.FNAME_L2 from T_PM_DiscretePermDashboard D, T_PM_Role R where D.FBizDataID='" + dashboardID + "' AND D.FROLEID=R.FID";
        return sql;
    }

    @Override
    public String getDashboardPermissionUsersSQL(String dashboardID) throws BIReportException {
        String sql = " SELECT D.FUSERID,U.FNUMBER,U.FNAME_L2 from T_PM_DiscretePermDashboard D, T_PM_User U where D.FBizDataID='" + dashboardID + "' AND D.FUSERID=U.FID";
        return sql;
    }

    @Override
    public String getDashboardPermissionUserOrgsSQL(String dashboardID, String userID) throws BIReportException {
        String sql = " SELECT D.FORGID,O.FNAME_L2 from T_PM_DiscretePermDashboard D, T_ORG_Admin O where D.FBizDataID='" + dashboardID + "'  AND D.FUserID='" + userID + "' AND D.FORGID=O.FID";
        return sql;
    }
}

