/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.print.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.ctrl.analysis.web.pagesetup.PageSetupUtil;
import com.kingdee.bos.ctrl.analysis.web.print.exception.PrintSetupException;
import com.kingdee.bos.ctrl.analysis.web.print.model.SetupModel;
import com.kingdee.bos.ctrl.analysis.web.print.model.ZoomScaleModel;
import java.awt.Dimension;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class PrintSetupFactory {
    public static SetupModel createSetupModel(HttpServletRequest request) throws PrintSetupException {
        SetupModel setupModel = new SetupModel();
        String paperSize = request.getParameter("paperSize");
        PrintSetupFactory.setPaperSize(paperSize, setupModel, request);
        PrintSetupFactory.setPaperMargin(setupModel, request);
        if (setupModel.getMarginLeft() + setupModel.getMarginRight() >= setupModel.getPaperWidth()) {
            throw new PrintSetupException("\u7eb8\u5f20\u6a2a\u5411\u8fb9\u8ddd\u5927\u4e8e\u9875\u5bbd\uff0c\u8bf7\u8c03\u6574\u9875\u8fb9\u8ddd!");
        }
        if (setupModel.getMarginTop() + setupModel.getMarginBottom() >= setupModel.getPaperHeight()) {
            throw new PrintSetupException("\u7eb8\u5f20\u7eb5\u5411\u8fb9\u8ddd\u5927\u4e8e\u9875\u9ad8\uff0c\u8bf7\u8c03\u6574\u9875\u8fb9\u8ddd!");
        }
        String paperOrientation = request.getParameter("isLandscape");
        if ("true".equalsIgnoreCase(paperOrientation)) {
            setupModel.setLandscape(Boolean.valueOf(paperOrientation));
            setupModel.setLandScape();
        }
        PrintSetupFactory.setHeaderFooter(setupModel, request);
        PrintSetupFactory.setPaperScale(setupModel, request);
        return setupModel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setPaperSize(String paperSize, SetupModel setupModel, HttpServletRequest request) throws PrintSetupException {
        Dimension dimPaper = null;
        if (paperSize.equalsIgnoreCase("custom")) {
            setupModel.setPaperSize("custom");
            String width = request.getParameter("paperWidth");
            String height = request.getParameter("paperHeight");
            if (width == null || height == null) throw new PrintSetupException("\u7f3a\u5c11\u81ea\u5b9a\u4e49\u7eb8\u5f20\u7684\u5bbd\u9ad8\u5b9a\u4e49!");
            try {
                int nWidth = (int)Float.parseFloat(width);
                int nHeight = Integer.parseInt(height);
                if (nWidth <= 0 || nHeight <= 0) {
                    throw new PrintSetupException("\u81ea\u5b9a\u4e49\u7eb8\u5f20\u7684\u957f\u5bbd\u5b9a\u4e49\u5fc5\u987b\u5927\u4e8e0!");
                }
                dimPaper = new Dimension(nWidth, nHeight);
            }
            catch (NumberFormatException e) {
                throw new PrintSetupException("\u7eb8\u5f20\u7684\u957f\u5bbd\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u5fc5\u987b\u4e3a\u6570\u503c!");
            }
        } else {
            setupModel.setPaperSize(paperSize);
            dimPaper = PageSetupUtil.getPaperSize(paperSize);
            if (dimPaper == null) {
                throw new PrintSetupException("unsupport paperSize name " + paperSize + "!");
            }
        }
        if (dimPaper == null) return;
        setupModel.setPaperWidth((float)dimPaper.getWidth());
        setupModel.setPaperHeight((float)dimPaper.getHeight());
    }

    private static void setPaperScale(SetupModel setupModel, HttpServletRequest request) {
        SetupModel model = PrintSetupFactory.deserialize2Model(request);
        if (null != model) {
            ZoomScaleModel scale = model.getScaleModel();
            setupModel.setScaleModel(scale);
        }
    }

    private static void setHeaderFooter(SetupModel setupModel, HttpServletRequest request) {
        SetupModel model = PrintSetupFactory.deserialize2Model(request);
        if (null != model) {
            List<String[]> headerRow = model.getListHeaderRow();
            List<String[]> footerRow = model.getListFooterRow();
            setupModel.setListHeaderRow(headerRow);
            setupModel.setListFooterRow(footerRow);
        }
    }

    private static SetupModel deserialize2Model(HttpServletRequest request) {
        String[] jsonArr = (String[])request.getParameterMap().get("json");
        if (null != jsonArr && jsonArr.length > 0) {
            String printSetting = jsonArr[0];
            SetupModel sm = (SetupModel)JSONObject.parseObject((String)printSetting, SetupModel.class);
            return sm;
        }
        return null;
    }

    private static void setPaperMargin(SetupModel setupModel, HttpServletRequest request) throws PrintSetupException {
        String paperMaginBottom;
        String paperMaginRight;
        String paperMaginTop;
        String paperMaginLeft = request.getParameter("marginLeft");
        if (paperMaginLeft != null && !paperMaginLeft.equals("")) {
            setupModel.setMarginLeft(PrintSetupFactory.parseMagin(paperMaginLeft, "\u5de6"));
        }
        if ((paperMaginTop = request.getParameter("marginTop")) != null && !paperMaginTop.equals("")) {
            setupModel.setMarginTop(PrintSetupFactory.parseMagin(paperMaginTop, "\u4e0a"));
        }
        if ((paperMaginRight = request.getParameter("marginRight")) != null && !paperMaginRight.equals("")) {
            setupModel.setMarginRight(PrintSetupFactory.parseMagin(paperMaginRight, "\u53f3"));
        }
        if ((paperMaginBottom = request.getParameter("marginBottom")) != null && !paperMaginBottom.equals("")) {
            setupModel.setMarginBottom(PrintSetupFactory.parseMagin(paperMaginBottom, "\u4e0b"));
        }
    }

    private static float parseMagin(String strMagin, String maginType) throws PrintSetupException {
        float ret = 0.0f;
        try {
            ret = Float.parseFloat(strMagin);
        }
        catch (NumberFormatException e) {
            throw new PrintSetupException("\u7eb8\u5f20\u7684" + maginType + "\u8fb9\u8ddd\u5b9a\u4e49\u683c\u5f0f\u4e0d\u5bf9\uff0c\u5fc5\u987b\u4e3a\u6570\u503c!");
        }
        if (ret < 0.0f) {
            throw new PrintSetupException("\u7eb8\u5f20\u7684" + maginType + "\u8fb9\u8ddd\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u8d1f\u6570!");
        }
        return ret;
    }
}

