/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.filter;

import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilter;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilterItem;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilterItemInput;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilterItemList;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilterItemSql;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.ValueCaptionPairList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BIReportFilterImpl
implements BIReportFilter {
    private static final long serialVersionUID = -4679229978922247076L;
    private List filterItems = new ArrayList();
    private String filterName;
    private String caption;

    public BIReportFilterImpl(Node node) {
        this.loadXMLNode(node);
    }

    private void loadXMLNode(Node node) {
        this.filterName = XmlUtil.getNodeAttribute(node, "name");
        this.caption = XmlUtil.getNodeAttribute(node, "caption");
        NodeList filterItemNodes = node.getChildNodes();
        for (int itemIndex = 0; itemIndex < filterItemNodes.getLength(); ++itemIndex) {
            Node filterItemNode = filterItemNodes.item(itemIndex);
            if (!filterItemNode.getNodeName().equalsIgnoreCase("FilterItem")) continue;
            BIReportFilterItem filterItem = null;
            String type = XmlUtil.getNodeAttribute(filterItemNode, "type");
            String strRequired = XmlUtil.getNodeAttribute(filterItemNode, "required");
            boolean required = "true".equalsIgnoreCase(strRequired);
            String dataType = XmlUtil.getNodeAttribute(filterItemNode, "dataType");
            String column = XmlUtil.getNodeAttribute(filterItemNode, "column");
            String caption = XmlUtil.getNodeAttribute(filterItemNode, "caption");
            String operator = XmlUtil.getNodeAttribute(filterItemNode, "operator");
            String defaultValue = XmlUtil.getNodeAttribute(filterItemNode, "defaultValue");
            String defaultCaption = XmlUtil.getNodeAttribute(filterItemNode, "defaultCaption");
            String strReadonly = XmlUtil.getNodeAttribute(filterItemNode, "isReadOnly");
            String rowLimit = XmlUtil.getNodeAttribute(filterItemNode, "rowLimit");
            boolean readonly = "false".equalsIgnoreCase(strReadonly);
            if (defaultValue != null && defaultValue.equals("")) {
                defaultValue = null;
            }
            String varname = XmlUtil.getNodeAttribute(filterItemNode, "varname");
            String globalParamName = XmlUtil.getNodeAttribute(filterItemNode, "globalParam");
            if ("input".equalsIgnoreCase(type)) {
                filterItem = new BIReportFilterItemInput(required, dataType, column, caption, operator, defaultValue, "", varname, globalParamName, readonly, rowLimit);
            } else if ("list".equalsIgnoreCase(type)) {
                NodeList listItems = filterItemNode.getChildNodes();
                ValueCaptionPairList vcpl = new ValueCaptionPairList();
                for (int listIndex = 0; listIndex < listItems.getLength(); ++listIndex) {
                    Node listItemNode = listItems.item(listIndex);
                    if (!listItemNode.getNodeName().equalsIgnoreCase("ListItem")) continue;
                    String c = XmlUtil.getNodeAttribute(listItemNode, "caption");
                    String v = XmlUtil.getNodeAttribute(listItemNode, "value");
                    vcpl.add(v, c);
                }
                filterItem = new BIReportFilterItemList(required, dataType, column, caption, operator, defaultValue, "", vcpl, varname, globalParamName, readonly, rowLimit);
            } else if ("sql".equalsIgnoreCase(type)) {
                NodeList sqlItems = filterItemNode.getChildNodes();
                String valueColumn = "";
                String table = "";
                String captionColumn = "";
                String parentColumn = "";
                String childColumn = "";
                String isLeafColumn = "";
                String orderBy = "";
                String orderMethod = "";
                boolean showTree = false;
                for (int sqlIndex = 0; sqlIndex < sqlItems.getLength(); ++sqlIndex) {
                    Node sqlItemNode = sqlItems.item(sqlIndex);
                    if (!sqlItemNode.getNodeName().equalsIgnoreCase("SqlInfo")) continue;
                    valueColumn = XmlUtil.getNodeAttribute(sqlItemNode, "valueColumn");
                    table = XmlUtil.getNodeAttribute(sqlItemNode, "table");
                    captionColumn = XmlUtil.getNodeAttribute(sqlItemNode, "captionColumn");
                    parentColumn = XmlUtil.getNodeAttribute(sqlItemNode, "parentColumn");
                    childColumn = XmlUtil.getNodeAttribute(sqlItemNode, "childColumn");
                    isLeafColumn = XmlUtil.getNodeAttribute(sqlItemNode, "isLeafColumn");
                    orderBy = XmlUtil.getNodeAttribute(sqlItemNode, "orderBy");
                    if (null == orderBy || "null".equalsIgnoreCase(orderBy)) {
                        orderBy = "";
                    }
                    if (null == (orderMethod = XmlUtil.getNodeAttribute(sqlItemNode, "orderMethod")) || "null".equalsIgnoreCase(orderMethod)) {
                        orderMethod = "";
                    }
                    String showTreeFlag = XmlUtil.getNodeAttribute(sqlItemNode, "showTree");
                    if (null == orderMethod || !"true".equalsIgnoreCase(showTreeFlag)) break;
                    showTree = true;
                    break;
                }
                filterItem = new BIReportFilterItemSql(required, dataType, column, caption, operator, defaultValue, defaultCaption, table, valueColumn, captionColumn, varname, parentColumn, childColumn, isLeafColumn, orderBy, orderMethod, showTree, globalParamName, readonly, rowLimit);
            }
            if (filterItem == null) continue;
            this.filterItems.add(filterItem);
        }
    }

    @Override
    public int getItemCount() {
        return this.filterItems.size();
    }

    @Override
    public BIReportFilterItem getItem(int index) {
        Iterator it = this.filterItems.iterator();
        if (index < 0 || index >= this.getItemCount()) {
            return null;
        }
        while (index > 0 && it.hasNext()) {
            it.next();
            --index;
        }
        BIReportFilterItem item = (BIReportFilterItem)it.next();
        return item;
    }

    @Override
    public List getItemList() {
        return this.filterItems;
    }

    @Override
    public String getName() {
        return this.filterName;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }
}

