/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.tree;

import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryException;
import com.kingdee.bos.ctrl.analysis.web.repository.RepositoryUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.BITreeNode;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

class BIReportTreeNode_EAS
extends DefaultKingdeeTreeNode
implements Comparable,
BITreeNode {
    private static final long serialVersionUID = 4839946779019654364L;
    private static Logger logger = CommonLogger.getLogger(BIReportTreeNode_EAS.class);
    Repository rep;
    private String path;
    private String name;
    private String ws = "RPT";
    private List tmpChildNodeList = null;

    public static BIReportTreeNode_EAS fromID(String path, Repository rep) throws BIReportException {
        BIReportTreeNode_EAS node = new BIReportTreeNode_EAS(rep, path);
        return node;
    }

    @Override
    public String getID() {
        return this.path;
    }

    public BIReportTreeNode_EAS(Repository rep, String path) {
        super(null, null);
        this.rep = rep;
        this.path = path;
        try {
            this.name = rep.getNodeNameByPath(this.ws, path);
            this.setUserObject(this.name);
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
        }
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getFullPath() {
        if (!this.isLeaf()) {
            return "";
        }
        try {
            return this.rep.getNodePropertyByPath("RPT", this.path, "reportPath");
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
            return null;
        }
    }

    @Override
    public String getPropertyValue(String propertyName) {
        try {
            return this.rep.getNodePropertyByPath2(this.ws, this.path, propertyName);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    @Override
    public int getChildCount() {
        try {
            return this.rep.getNodeChildCount(this.ws, this.path);
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
            return 0;
        }
    }

    @Override
    public TreeNode getChildAt(int index) {
        int childCount = this.getChildCount();
        if (index < 0 || index >= childCount) {
            return null;
        }
        if (this.tmpChildNodeList != null) {
            return (TreeNode)this.tmpChildNodeList.get(index);
        }
        try {
            List res_child = this.rep.getNodeChildrenPaths(this.ws, this.path);
            Iterator it = res_child.iterator();
            this.tmpChildNodeList = new ArrayList();
            while (it.hasNext()) {
                this.tmpChildNodeList.add(new BIReportTreeNode_EAS(this.rep, (String)it.next()));
            }
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
        }
        Collections.sort(this.tmpChildNodeList);
        return (TreeNode)this.tmpChildNodeList.get(index);
    }

    public int compareTo(Object o) {
        if (!(o instanceof BIReportTreeNode_EAS)) {
            return 1;
        }
        BIReportTreeNode_EAS objTo = (BIReportTreeNode_EAS)o;
        if (this.isLeaf()) {
            if (objTo.isLeaf()) {
                return this.getName().compareTo(objTo.getName());
            }
            return 1;
        }
        if (objTo.isLeaf()) {
            return -1;
        }
        return this.getName().compareTo(objTo.getName());
    }

    @Override
    public boolean isLeaf() {
        return RepositoryUtil.isThemeReport(this.rep, this.path);
    }

    @Override
    public Calendar getLastModified() {
        try {
            return this.rep.getNodeLastModified(this.ws, this.path);
        }
        catch (RepositoryException e) {
            logger.error((Object)e);
            return null;
        }
    }
}

