/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.worklist;

import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.worklist.WorklistMeta;
import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WorklistLoader {
    private static int DEFAULT_LIST_PAGE_ROWS = 10;

    public static void loadWorklist(Node node, List list) {
        NodeList listItemNodes = node.getChildNodes();
        for (int itemIndex = 0; itemIndex < listItemNodes.getLength(); ++itemIndex) {
            Node listItemNode = listItemNodes.item(itemIndex);
            if (!listItemNode.getNodeName().equalsIgnoreCase("List")) continue;
            String name = XmlUtil.getNodeAttribute(listItemNode, "name");
            String caption = XmlUtil.getNodeAttribute(listItemNode, "caption");
            String head = XmlUtil.getNodeAttribute(listItemNode, "head");
            String tail = XmlUtil.getNodeAttribute(listItemNode, "tail");
            String ds = XmlUtil.getNodeAttribute(listItemNode, "ds");
            String pageRows = XmlUtil.getNodeAttribute(listItemNode, "pageRows");
            HashMap<String, String> mapFormat = new HashMap<String, String>();
            Node listFormatNode = XmlUtil.getChildNode(listItemNode, "Fields");
            if (listFormatNode != null) {
                Node[] listFormatItemNodes = XmlUtil.getChildNodes(listFormatNode, "Field");
                for (int ii = 0; ii < listFormatItemNodes.length; ++ii) {
                    String field = XmlUtil.getNodeAttribute(listFormatItemNodes[ii], "name");
                    String value = XmlUtil.getNodeAttribute(listFormatItemNodes[ii], "formatString");
                    mapFormat.put(field.toLowerCase(), value);
                }
            }
            int nPageRows = DEFAULT_LIST_PAGE_ROWS;
            try {
                if (pageRows != null) {
                    nPageRows = Integer.parseInt(pageRows);
                }
            }
            catch (NumberFormatException ii) {
                // empty catch block
            }
            String width = XmlUtil.getNodeAttribute(listItemNode, "width");
            int nWidth = 0;
            try {
                if (width != null) {
                    nWidth = Integer.parseInt(width);
                }
            }
            catch (NumberFormatException value) {
                // empty catch block
            }
            WorklistMeta listItem = new WorklistMeta(name, caption, head, tail, ds, nPageRows, nWidth, mapFormat);
            list.add(listItem);
        }
    }
}

