/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.model.nodes;

import com.kingdee.bos.ctrl.bibench.platform.UnsupportedNodeTypeException;
import com.kingdee.bos.ctrl.bibench.platform.XContentFormatException;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.cubemodel.RDCubeModelNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.RDdsEntityNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.RDdsEtlNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.RDdsQueryNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.RDdsSqlNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.dir.RDdirCubeModelNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.dir.RDdirDataSourceNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.dir.RDdirReportNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.dir.RDdirThemeNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.report.RDNReportNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.report.RDXReportNode;

public class RDBaseNodeFactory {
    public static RDBaseNode createCatalogNode(int type, String content) throws UnsupportedNodeTypeException, XContentFormatException {
        try {
            switch (type) {
                case 1: {
                    return new RDdirDataSourceNode();
                }
                case 2: {
                    return new RDdirThemeNode();
                }
                case 3: {
                    return new RDdirReportNode();
                }
                case 4: {
                    return new RDdirCubeModelNode();
                }
                case 11: {
                    return new RDdsQueryNode(content);
                }
                case 12: {
                    return new RDdsEntityNode(content);
                }
                case 13: {
                    return new RDdsSqlNode(content);
                }
                case 14: {
                    return new RDdsEtlNode(content);
                }
                case 20: {
                    return new RDCubeModelNode(content);
                }
                case 21: {
                    return new RDXReportNode(content);
                }
                case 22: {
                    return new RDNReportNode(content);
                }
            }
        }
        catch (Exception e) {
            throw new XContentFormatException(content, e);
        }
        throw new UnsupportedNodeTypeException(type);
    }
}

