/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart;

import com.kingdee.bos.ctrl.swing.chart.ChartGroup;
import com.kingdee.bos.ctrl.swing.chart.ChartGroups;
import com.kingdee.bos.ctrl.swing.chart.Series;
import com.kingdee.bos.ctrl.swing.chart.SeriesCollection;
import java.text.DecimalFormat;
import java.util.Date;

class ChartData {
    private String[] seriesKeys;
    private String[] groupKeys;
    private double[][] values;
    private Date[][][] dates;
    private ChartGroups chartGroups;
    private SeriesCollection seriesCollection;

    public ChartData(String[] seriesKeys, String[] groupKeys, double[][] values) {
        this.normalizeData(seriesKeys, groupKeys, values);
        this.seriesCollection = this.createSeries();
        this.chartGroups = this.createGroups();
    }

    public ChartData(String[] seriesKeys, String[] groupKeys, Date[][][] dates) {
        this.normalizeData(seriesKeys, groupKeys, dates);
    }

    private void normalizeData(String[] seriesKeys, String[] groupKeys, double[][] values) {
        int i;
        if (seriesKeys == null) {
            seriesKeys = new String[]{};
        }
        if (groupKeys == null) {
            groupKeys = new String[]{};
        }
        if (values == null) {
            values = new double[0][0];
        }
        int seriesCount = 0;
        int groupsCount = 0;
        seriesCount = values.length;
        if (seriesCount > 0) {
            for (i = 0; i < seriesCount; ++i) {
                if (values[i] == null || values[i].length <= groupsCount) continue;
                groupsCount = values[i].length;
            }
        }
        if (seriesKeys.length > seriesCount) {
            seriesCount = seriesKeys.length;
        }
        if (groupKeys.length > groupsCount) {
            groupsCount = groupKeys.length;
        }
        this.seriesKeys = new String[seriesCount];
        this.groupKeys = new String[groupsCount];
        this.values = new double[seriesCount][groupsCount];
        for (i = 0; i < seriesCount; ++i) {
            this.seriesKeys[i] = i < seriesKeys.length && seriesKeys[i] != null ? seriesKeys[i] : "S" + i;
        }
        for (i = 0; i < groupsCount; ++i) {
            this.groupKeys[i] = i < groupKeys.length && groupKeys[i] != null ? groupKeys[i] : "G" + i;
        }
        for (i = 0; i < seriesCount; ++i) {
            if (i >= values.length || values[i] == null) continue;
            for (int j = 0; j < groupsCount; ++j) {
                if (j >= values[i].length) continue;
                this.values[i][j] = values[i][j];
            }
        }
    }

    private void normalizeData(String[] seriesKeys, String[] groupKeys, Date[][][] dates) {
        int i;
        if (seriesKeys == null) {
            seriesKeys = new String[]{};
        }
        if (groupKeys == null) {
            groupKeys = new String[]{};
        }
        if (dates == null) {
            dates = new Date[0][0][0];
        }
        int seriesCount = 0;
        int groupsCount = 0;
        seriesCount = dates.length;
        if (seriesCount > 0) {
            for (i = 0; i < seriesCount; ++i) {
                if (dates[i] == null || dates[i].length <= groupsCount) continue;
                groupsCount = dates[i].length;
            }
        }
        if (seriesKeys.length > seriesCount) {
            seriesCount = seriesKeys.length;
        }
        if (groupKeys.length > groupsCount) {
            groupsCount = groupKeys.length;
        }
        this.seriesKeys = new String[seriesCount];
        this.groupKeys = new String[groupsCount];
        this.dates = new Date[seriesCount][groupsCount][2];
        for (i = 0; i < seriesCount; ++i) {
            this.seriesKeys[i] = i < seriesKeys.length && seriesKeys[i] != null ? seriesKeys[i] : "S" + i;
        }
        for (i = 0; i < groupsCount; ++i) {
            this.groupKeys[i] = i < groupKeys.length && groupKeys[i] != null ? groupKeys[i] : "G" + i;
        }
        for (i = 0; i < seriesCount; ++i) {
            if (i >= dates.length || dates[i] == null) continue;
            for (int j = 0; j < groupsCount; ++j) {
                if (j >= dates[i].length) continue;
                this.dates[i][j][0] = dates[i][j][0];
                this.dates[i][j][1] = dates[i][j][1];
            }
        }
    }

    private SeriesCollection createSeries() {
        SeriesCollection coll = new SeriesCollection();
        for (int i = 0; i < this.seriesKeys.length; ++i) {
            Series series = new Series(this.seriesKeys[i], this.groupKeys, this.values[i]);
            coll.add(this.seriesKeys[i], series);
        }
        return coll;
    }

    private ChartGroups createGroups() {
        ChartGroups groups = new ChartGroups();
        for (int i = 0; i < this.groupKeys.length; ++i) {
            ChartGroup group = new ChartGroup(this.groupKeys[i], this.seriesCollection);
            groups.add(this.groupKeys[i], group);
        }
        return groups;
    }

    public SeriesCollection getSeriesCollection() {
        return this.seriesCollection;
    }

    public ChartGroups getChartGroups() {
        return this.chartGroups;
    }

    public String[] getGroupKeys() {
        return this.groupKeys;
    }

    public String[] getSeriesKeys() {
        return this.seriesKeys;
    }

    public double[][] getValues() {
        return this.values;
    }

    public Date[][][] getDates() {
        return this.dates;
    }

    public String toString() {
        int i;
        int rows = this.seriesKeys.length;
        int cols = this.groupKeys.length;
        DecimalFormat df = new DecimalFormat("0.00");
        StringBuffer sb = new StringBuffer();
        sb.append('\t');
        for (i = 0; i < cols; ++i) {
            sb.append('\t');
            sb.append(this.groupKeys[i]);
        }
        for (i = 0; i < rows; ++i) {
            sb.append('\n');
            sb.append(this.seriesKeys[i]);
            for (int j = 0; j < cols; ++j) {
                sb.append('\t');
                sb.append(df.format(this.values[i][j]));
            }
        }
        return sb.toString();
    }

    public static void main(String[] arg) {
        Object one;
        int i;
        int row = 5;
        int col = 5;
        String[] seriesKey = ChartData.createTestKeys("Series", row + 2, 2);
        String[] groupsKey = ChartData.createTestKeys("Group", col + 2, 2);
        double[][] values = ChartData.createTestValue(row, col);
        ChartData data = new ChartData(seriesKey, groupsKey, values);
        System.out.println(data);
        seriesKey = data.getSeriesKeys();
        groupsKey = data.getSeriesKeys();
        SeriesCollection series = data.getSeriesCollection();
        ChartGroups groups = data.getChartGroups();
        for (i = 0; i < series.getCount(); ++i) {
            one = series.get(i);
            System.out.println(one);
        }
        for (i = 0; i < groups.getCount(); ++i) {
            one = groups.get(i);
            System.out.println(one);
        }
    }

    public static String[] createTestKeys(String prefix, int count, int nullNum) {
        int i;
        String[] ret = new String[count];
        for (i = 0; i < count; ++i) {
            ret[i] = prefix + i;
        }
        for (i = 1; i < nullNum; ++i) {
            ret[i] = null;
        }
        return ret;
    }

    public static double[][] createTestValue(int row, int column) {
        int i;
        double[][] ret = new double[row][];
        for (i = 0; i < row; ++i) {
            ret[i] = new double[column - i % column];
        }
        for (i = 0; i < row; ++i) {
            for (int j = 0; j < ret[i].length; ++j) {
                ret[i][j] = (double)i + (double)j / 100.0;
            }
        }
        return ret;
    }
}

