/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart.panel;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDColorChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.chart.panel.AxisPropertyEditPanel;
import com.kingdee.bos.ctrl.swing.chart.panel.StrokeChooserPanel;
import com.kingdee.bos.ctrl.swing.chart.panel.StrokeSample;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ColorBar;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.ContourPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.ui.ColorBarPropertyEditPanel;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.InsetsChooserPanel;
import org.jfree.ui.InsetsTextField;
import org.jfree.ui.PaintSample;

public class PlotPropertyEditPanel
extends KDPanel
implements ActionListener {
    public static final long serialVersionUID = 1001001001L;
    private PaintSample backgroundPaintSample;
    private StrokeSample outlineStrokeSample;
    private PaintSample outlinePaintSample;
    private AxisPropertyEditPanel domainAxisPropertyPanel;
    private AxisPropertyEditPanel rangeAxisPropertyPanel;
    private ColorBarPropertyEditPanel colorBarAxisPropertyPanel;
    private StrokeSample[] availableStrokeSamples;
    private Insets plotInsets;
    private InsetsTextField insetsTextField;

    public PlotPropertyEditPanel(Plot plot) {
        this.plotInsets = plot.getInsets();
        this.backgroundPaintSample = new PaintSample(plot.getBackgroundPaint());
        this.outlineStrokeSample = new StrokeSample(plot.getOutlineStroke());
        this.outlinePaintSample = new PaintSample(plot.getOutlinePaint());
        this.setLayout(new BorderLayout());
        this.availableStrokeSamples = new StrokeSample[3];
        this.availableStrokeSamples[0] = new StrokeSample(new BasicStroke(1.0f));
        this.availableStrokeSamples[1] = new StrokeSample(new BasicStroke(2.0f));
        this.availableStrokeSamples[2] = new StrokeSample(new BasicStroke(3.0f));
        KDPanel panel = new KDPanel((LayoutManager)new BorderLayout());
        panel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), plot.getPlotType() + LanguageManager.getLangMessage((String)":", PlotPropertyEditPanel.class, (String)":")));
        KDPanel general = new KDPanel((LayoutManager)new BorderLayout());
        general.setBorder((Border)BorderFactory.createTitledBorder(LanguageManager.getLangMessage((String)"General", PlotPropertyEditPanel.class, (String)"General")));
        KDPanel interior = new KDPanel((LayoutManager)new LCBLayout(4));
        interior.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Insets", PlotPropertyEditPanel.class, (String)"Insets")));
        KDButton button = new KDButton(LanguageManager.getLangMessage((String)"Edit...", PlotPropertyEditPanel.class, (String)"Edit..."));
        button.setActionCommand("Insets");
        button.addActionListener((ActionListener)this);
        this.insetsTextField = new InsetsTextField(this.plotInsets);
        this.insetsTextField.setEnabled(false);
        interior.add((Component)this.insetsTextField);
        interior.add((Component)button);
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Outline_stroke", PlotPropertyEditPanel.class, (String)"Outline Stroke")));
        button = new KDButton(LanguageManager.getLangMessage((String)"Select...", PlotPropertyEditPanel.class, (String)"Select..."));
        button.setActionCommand("OutlineStroke");
        button.addActionListener((ActionListener)this);
        interior.add((Component)this.outlineStrokeSample);
        interior.add((Component)button);
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Outline_Paint", PlotPropertyEditPanel.class, (String)"Outline Paint")));
        button = new KDButton(LanguageManager.getLangMessage((String)"Select...", PlotPropertyEditPanel.class, (String)"Select..."));
        button.setActionCommand("OutlinePaint");
        button.addActionListener((ActionListener)this);
        interior.add((Component)this.outlinePaintSample);
        interior.add((Component)button);
        interior.add((Component)new KDLabel(LanguageManager.getLangMessage((String)"Background_paint", PlotPropertyEditPanel.class, (String)"Background Paint")));
        button = new KDButton(LanguageManager.getLangMessage((String)"Select...", PlotPropertyEditPanel.class, (String)"Select..."));
        button.setActionCommand("BackgroundPaint");
        button.addActionListener((ActionListener)this);
        interior.add((Component)this.backgroundPaintSample);
        interior.add((Component)button);
        general.add((Component)interior, (Object)"North");
        KDPanel appearance = new KDPanel((LayoutManager)new BorderLayout());
        appearance.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        appearance.add((Component)general, (Object)"North");
        KDTabbedPane tabs = new KDTabbedPane();
        tabs.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        CategoryAxis domainAxis = null;
        if (plot instanceof CategoryPlot) {
            domainAxis = ((CategoryPlot)plot).getDomainAxis();
        } else if (plot instanceof XYPlot) {
            domainAxis = ((XYPlot)plot).getDomainAxis();
        }
        this.domainAxisPropertyPanel = AxisPropertyEditPanel.getInstance((Axis)domainAxis);
        if (this.domainAxisPropertyPanel != null) {
            this.domainAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            tabs.add(LanguageManager.getLangMessage((String)"Domain_Axis", PlotPropertyEditPanel.class, (String)"Domain Axis"), (Component)((Object)this.domainAxisPropertyPanel));
        }
        ValueAxis rangeAxis = null;
        if (plot instanceof CategoryPlot) {
            rangeAxis = ((CategoryPlot)plot).getRangeAxis();
        } else if (plot instanceof XYPlot) {
            rangeAxis = ((XYPlot)plot).getRangeAxis();
        }
        this.rangeAxisPropertyPanel = AxisPropertyEditPanel.getInstance((Axis)rangeAxis);
        if (this.rangeAxisPropertyPanel != null) {
            this.rangeAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            tabs.add(LanguageManager.getLangMessage((String)"Range_Axis", PlotPropertyEditPanel.class, (String)"Range Axis"), (Component)((Object)this.rangeAxisPropertyPanel));
        }
        ColorBar colorBar = null;
        if (plot instanceof ContourPlot) {
            colorBar = ((ContourPlot)plot).getColorBar();
        }
        this.colorBarAxisPropertyPanel = ColorBarPropertyEditPanel.getInstance(colorBar);
        if (this.colorBarAxisPropertyPanel != null) {
            this.colorBarAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            tabs.add(LanguageManager.getLangMessage((String)"Color_Bar", PlotPropertyEditPanel.class, (String)"Color Bar"), (Component)this.colorBarAxisPropertyPanel);
        }
        tabs.add(LanguageManager.getLangMessage((String)"Appearance", PlotPropertyEditPanel.class, (String)"Appearance"), (Component)appearance);
        panel.add((Component)tabs);
        this.add((Component)panel);
    }

    public Insets getPlotInsets() {
        if (this.plotInsets == null) {
            this.plotInsets = new Insets(0, 0, 0, 0);
        }
        return this.plotInsets;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaintSample.getPaint();
    }

    public Stroke getOutlineStroke() {
        return this.outlineStrokeSample.getStroke();
    }

    public Paint getOutlinePaint() {
        return this.outlinePaintSample.getPaint();
    }

    public AxisPropertyEditPanel getDomainAxisPropertyEditPanel() {
        return this.domainAxisPropertyPanel;
    }

    public AxisPropertyEditPanel getRangeAxisPropertyEditPanel() {
        return this.rangeAxisPropertyPanel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("BackgroundPaint")) {
            this.attemptBackgroundPaintSelection();
        } else if (command.equals("OutlineStroke")) {
            this.attemptOutlineStrokeSelection();
        } else if (command.equals("OutlinePaint")) {
            this.attemptOutlinePaintSelection();
        } else if (command.equals("Insets")) {
            this.editInsets();
        }
    }

    private void attemptBackgroundPaintSelection() {
        Color c = KDColorChooser.showDialog((Component)((Object)this), (String)LanguageManager.getLangMessage((String)"Background_Color", PlotPropertyEditPanel.class, (String)"Background Color"), (Color)Color.blue);
        if (c != null) {
            this.backgroundPaintSample.setPaint((Paint)c);
        }
    }

    private void attemptOutlineStrokeSelection() {
        StrokeChooserPanel panel = new StrokeChooserPanel(null, this.availableStrokeSamples);
        int result = KDOptionPane.showConfirmDialog((Component)((Object)this), (Object)panel, (String)LanguageManager.getLangMessage((String)"Stroke_Selection", PlotPropertyEditPanel.class, (String)"Stroke_Selection"), (int)2, (int)-1);
        if (result == 0) {
            this.outlineStrokeSample.setStroke(panel.getSelectedStroke());
        }
    }

    private void attemptOutlinePaintSelection() {
        Color c = KDColorChooser.showDialog((Component)((Object)this), (String)LanguageManager.getLangMessage((String)"Outline_Color", PlotPropertyEditPanel.class, (String)"Outline Color"), (Color)Color.blue);
        if (c != null) {
            this.outlinePaintSample.setPaint((Paint)c);
        }
    }

    private void editInsets() {
        InsetsChooserPanel panel = new InsetsChooserPanel(this.plotInsets);
        int result = KDOptionPane.showConfirmDialog((Component)((Object)this), (Object)panel, (String)LanguageManager.getLangMessage((String)"Edit_Insets", PlotPropertyEditPanel.class, (String)"Edit Insets"), (int)2, (int)-1);
        if (result == 0) {
            this.plotInsets = panel.getInsets();
            this.insetsTextField.setInsets(this.plotInsets);
        }
    }

    public void updatePlotProperties(Plot plot) {
        CategoryPlot p;
        plot.setOutlinePaint(this.getOutlinePaint());
        plot.setOutlineStroke(this.getOutlineStroke());
        plot.setBackgroundPaint(this.getBackgroundPaint());
        plot.setInsets(this.getPlotInsets());
        if (this.domainAxisPropertyPanel != null) {
            CategoryAxis domainAxis = null;
            if (plot instanceof CategoryPlot) {
                p = (CategoryPlot)plot;
                domainAxis = p.getDomainAxis();
            } else if (plot instanceof XYPlot) {
                p = (XYPlot)plot;
                domainAxis = p.getDomainAxis();
            }
            if (domainAxis != null) {
                this.domainAxisPropertyPanel.setAxisProperties((Axis)domainAxis);
            }
        }
        if (this.rangeAxisPropertyPanel != null) {
            ValueAxis rangeAxis = null;
            if (plot instanceof CategoryPlot) {
                p = (CategoryPlot)plot;
                rangeAxis = p.getRangeAxis();
            } else if (plot instanceof XYPlot) {
                p = (XYPlot)plot;
                rangeAxis = p.getRangeAxis();
            }
            if (rangeAxis != null) {
                this.rangeAxisPropertyPanel.setAxisProperties((Axis)rangeAxis);
            }
        }
        if (this.colorBarAxisPropertyPanel != null) {
            ColorBar colorBar = null;
            if (plot instanceof ContourPlot) {
                p = (ContourPlot)plot;
                colorBar = p.getColorBar();
            }
            if (colorBar != null) {
                this.colorBarAxisPropertyPanel.setAxisProperties(colorBar);
            }
        }
    }
}

