/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart.title;

import com.kingdee.bos.ctrl.swing.KDFont;
import com.kingdee.bos.ctrl.swing.chart.title.ITitle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import org.jfree.chart.axis.Axis;

public class AxisTitle
implements ITitle {
    public static final KDFont DEFAULT_FONT = new KDFont("\u5b8b\u4f53", 0, 11);
    public static final Paint DEFAULT_PAINT = Color.black;
    private String text;
    private KDFont font = DEFAULT_FONT;
    private Paint paint = DEFAULT_PAINT;
    private Paint backgroundPaint;
    private Axis delegate;

    public AxisTitle() {
    }

    public AxisTitle(String text) {
        this(text, DEFAULT_FONT);
    }

    public AxisTitle(String text, KDFont font) {
        this(text, font, DEFAULT_PAINT);
    }

    public AxisTitle(String text, KDFont font, Paint paint) {
        this(text, font, paint, null);
    }

    public AxisTitle(String text, KDFont font, Paint paint, Paint backgroundPaint) {
        this.setText(text);
        this.setFont(font);
        this.setPaint(paint);
        this.setBackgroundPaint(backgroundPaint);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
        if (this.delegate != null) {
            this.delegate.setLabel(text);
        }
    }

    @Override
    public KDFont getFont() {
        return this.font;
    }

    @Override
    public void setFont(KDFont font) {
        this.font = font;
        this.delegate.setLabelFont((Font)font);
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void setPaint(Paint paint) {
        this.paint = paint;
        this.delegate.setLabelPaint(paint);
    }

    @Override
    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    @Override
    public void setBackgroundPaint(Paint backgroundPaint) {
        this.backgroundPaint = backgroundPaint;
    }

    public void setDelegate(Axis delegate) {
        this.delegate = delegate;
        delegate.setLabelFont((Font)this.font);
        delegate.setLabelPaint(this.paint);
    }
}

