/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart.util;

import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.XYDataset;

class ScatterDataset
extends AbstractSeriesDataset
implements XYDataset {
    static final long serialVersionUID = 100100101L;
    private Comparable[] seriesKeys;
    private Double[][] xValues;
    private Double[][] yValues;
    private int seriesCount;
    private int itemCount;

    public ScatterDataset(Comparable[] seriesKeys, double[][] data) {
        this.seriesCount = seriesKeys.length;
        if (seriesKeys.length > data.length - 1) {
            this.seriesCount = data.length - 1;
        }
        this.itemCount = data[0].length;
        this.seriesKeys = new Comparable[this.seriesCount];
        this.xValues = new Double[this.seriesCount][this.itemCount];
        this.yValues = new Double[this.seriesCount][this.itemCount];
        for (int i = 0; i < this.seriesCount; ++i) {
            this.seriesKeys[i] = seriesKeys[i];
            for (int j = 0; j < this.itemCount; ++j) {
                this.xValues[i][j] = new Double(data[0][j]);
                this.yValues[i][j] = new Double(data[i + 1][j]);
            }
        }
    }

    public Number getXValue(int series, int item) {
        return this.xValues[series][item];
    }

    public Number getYValue(int series, int item) {
        return this.yValues[series][item];
    }

    public int getSeriesCount() {
        return this.seriesCount;
    }

    public String getSeriesName(int series) {
        return this.seriesKeys[series].toString();
    }

    public int getItemCount(int series) {
        return this.itemCount;
    }
}

