/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class CtrlPropertyConfig {
    public String url;
    public Properties properties;

    public CtrlPropertyConfig(String url) {
        this.url = url;
        this.properties = this.loadProperties();
    }

    public void setPropertyFileLocation(String fileurl) {
        this.url = fileurl;
        this.properties = this.loadProperties();
    }

    public void addProperty(String key, String value) {
        this.getProperties().put(key, value);
        this.store();
    }

    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = this.loadProperties();
        }
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() {
        File configFile = GlobalLocator.getInstance().locateResourceFile(this.url);
        if (configFile != null) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(configFile);
                this.properties.store(out, "");
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    StreamUtil.closeCloseable(out);
                    throw throwable;
                }
                StreamUtil.closeCloseable((Closeable)out);
            }
            StreamUtil.closeCloseable((Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties() {
        File configFile = GlobalLocator.getInstance().locateResourceFile(this.url);
        Properties proper = null;
        FileInputStream in = null;
        if (configFile != null) {
            proper = new Properties();
            try {
                in = new FileInputStream(configFile);
                proper.load(in);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (null != in) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return proper;
    }
}

