/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common;

import com.kingdee.bos.ctrl.common.util.PathUtil;
import java.io.Serializable;

public class FullPath
implements Serializable {
    public static final String S_PATHX = ":";
    public static final char C_PATHX = ":".charAt(0);
    public static final String S_PATH = "/";
    public static final char C_PATH = '/';
    public static final String S_CATEGORY = ".";
    public static final char C_CATEGORY = ".".charAt(0);
    public static final String S_ROOT = "/";
    public static final char C_ROOT = '/';
    private String space;
    private String pathx;

    public String getCategory() {
        return FullPath.getCategory(this.pathx);
    }

    public String getSpace() {
        return this.space;
    }

    public void setSpace(String space) {
        this.space = space;
    }

    public String getPathx() {
        return this.pathx;
    }

    public void setPathx(String pathx) {
        this.pathx = pathx;
    }

    public void setPathx(String names, String category) {
        this.setPathx(names + S_CATEGORY + category);
    }

    public void setDots(String dots, String category) {
        this.setPathx(FullPath.dots2path(dots) + S_CATEGORY + category);
    }

    public String getDots() {
        return FullPath.path2dots(FullPath.cutCategory(this.pathx));
    }

    public String getName() {
        return FullPath.cutCategory(PathUtil.getLastName(this.getPathx()));
    }

    public String getText() {
        StringBuffer sb = new StringBuffer();
        sb.append(S_PATHX);
        if (this.space != null) {
            sb.append(this.space);
        }
        sb.append(S_PATHX);
        sb.append(this.pathx);
        return sb.toString();
    }

    public String toString() {
        return this.getText();
    }

    public static final FullPath parse(String s) {
        String[] as;
        if (s == null || s.length() <= 1) {
            return null;
        }
        char c = s.charAt(0);
        if (C_PATHX == c) {
            int iPath = FullPath.indexOfPath(s);
            FullPath fp = new FullPath();
            if (iPath != -1) {
                if (iPath > 1) {
                    fp.setSpace(s.substring(1, iPath));
                }
                fp.setPathx(s.substring(iPath + 1));
            } else {
                fp.setSpace(s);
            }
            return fp;
        }
        if ('/' == c) {
            FullPath fp = new FullPath();
            fp.setPathx(s);
            return fp;
        }
        if (s.startsWith("kdrs") && (as = s.split(S_PATHX)).length >= 3) {
            if ("bos.query".equals(as[1])) {
                FullPath fp = new FullPath();
                fp.setDots(as[2], "bos-query");
                return fp;
            }
            if ("bos.entity".equals(as[1])) {
                FullPath fp = new FullPath();
                fp.setDots(as[2], "bos-entity");
                return fp;
            }
        }
        return null;
    }

    public static final int indexOfPath(String s) {
        return s.indexOf(C_PATHX, 1);
    }

    public static final String joinPath(FullPath fp) {
        if (fp.getSpace() != null) {
            return fp.getSpace() + fp.getPathx();
        }
        return fp.getPathx();
    }

    public static final String dots2path(String dots) {
        return "/" + dots.replace(C_CATEGORY, '/');
    }

    public static final String path2dots(String path) {
        return path.substring(1).replace('/', C_CATEGORY);
    }

    public static final int indexOfCategory(String path) {
        if (path == null) {
            return -1;
        }
        for (int i = path.length() - 1; i >= 0; --i) {
            char c = path.charAt(i);
            if ('/' == c) {
                return -1;
            }
            if (C_CATEGORY != c) continue;
            return i;
        }
        return -1;
    }

    public static final String addCategory(String s, String category) {
        return s + S_CATEGORY + category;
    }

    public static final String getCategory(String s) {
        if (s == null) {
            return null;
        }
        int iCategory = FullPath.indexOfCategory(s);
        return iCategory != -1 ? s.substring(iCategory + 1) : null;
    }

    public static final String cutCategory(String s) {
        if (s == null) {
            return null;
        }
        int iCategory = FullPath.indexOfCategory(s);
        return iCategory != -1 ? s.substring(0, iCategory) : s;
    }

    public static final String cutCategory(String s, String category) {
        if (s == null) {
            return null;
        }
        if (category == null) {
            return s;
        }
        return s.substring(0, s.length() - category.length() - 1);
    }
}

